; $Id$
;###############################################################################
;
; NAME:
;  LAUNCH_TAS_SCAN_MAPPER
;
; PURPOSE:
;  Application launcher for spurion2 program
;
; CATEGORY:
;  DAVE, TAS
;
; AUTHOR:
;   Larry R.Kneller, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8839
;   E-mail: larry.kneller@nist.gov
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro launch_tas_scan_mapper,event,$
                 group_leader=group_leader,$
                 workDir=workDir,$
                 dataDir=dataDir,$
                 DAVETool=DAVETool,$
                 _Extra=extra

if n_elements(event) eq  0 then begin
            tas_scan_mapper,group_leader=group_leader,$
                            workDir=workDir,$
                            dataDir=dataDir,$
                            DAVETool=DAVETool,$
                            _Extra=extra
endif else begin
        thisEvent = tag_names(event,/structure_name)
        case thisEvent of
        'WIDGET_BUTTON': $
          begin
            print,'Opening TAS Scan Mapper from DAVE Classic Menu!'
            ;run_lattice,group_leader=event.top;notifyIDs = [event.id,event.top]
            tas_scan_mapper,group_leader=event.top,$
                            workDir=workDir,$
                            dataDir=dataDir,$
                            DAVETool=DAVETool,$
                            _Extra=extra
          end
        'WIDGET_TREE_SEL': $
          begin
            print,'Opening TAS Scan Mapper from DAVE Tree Menu!'
            ;run_lattice,group_leader=event.top;[event.id,event.top]
            tas_scan_mapper,group_leader=event.top,$
                            workDir=workDir,$
                            dataDir=dataDir,$
                            DAVETool=DAVETool,$
                            _Extra=extra
          end
        else:print,'Doing nothing.'
        endcase
        return
endelse
end;launch_tas_scan_mapper
