; $Id$

function ooEcho::newchirp,tauind,xind=xind,yind=yind,_Extra=extra
;
;NAME:
;        ooEcho::newchirp
;
;PURPOSE:
;       Return the echo  values.
;PARAMETERS:
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;   The echo values.
    ;;self->addTreatment,'ooEcho::chirp'

    ;THIS FUNCTION RETURNS THE ECHO DATA ('CHIRP') FOR A GIVEN
    ;FOURIER TIME
    ;

    ;CREATE 3D ARRAY OF DATA FROM THE 4D DATA SET
    s=reform(*self.emask,self.x_dim*self.y_dim,$
        self.no_of_phases,self.no_of_fourier_times)

    ssz = size(s)

    ;092705
    ;MAKE THE FOLLOWING UPDATE TO HANDLE CASES WHERE POINT_TO_UP lt POINT TO DOWN!!!
    term = self->term();min([self.point_to_down,self.point_to_up])

    ys = s[*,0:term-1,tauind]

    return,reform(ys,self.x_dim*self.y_dim,term)

end;newchirp
function ooEcho::newchirpPhases,tauind,_Extra=extra
;
;NAME:
;        ooEcho::newchirpPhases
;
;PURPOSE:
;       Return the echo x values.
;PARAMETERS:
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;   The echo x values.

    ;GET PHASE VALUES (X-VALUES) FOR A SELECTED FOURIER TIME

    term = self->term();min([self.point_to_up,self.point_to_down])

    s = (*self.phase)[*,tauind]
    s = (reform(s,self.no_of_phases))[0:term-1]

    ret = fltarr(term,self.x_dim*self.y_dim)
    for i=0,term-1 do begin
      ret[i,*] = s[i]  ;DO LOOP IN SHORT DIRECTION
    endfor;i

    return,ret

end;newchirpPhases


function ooEcho::newstartParms,k,fixed=fixed,$
                                startparms=startparms,$
                                sigma=sigma,$
                                hydrogenated=hydrogenated,$
                                noborrow=noborrow,$
                                tavestate=tavestate,$
                                _Extra=extra
;
;NAME:
;        ooEcho::newstartParms
;
;PURPOSE:
;        Get approximate starting parameters for fitting for all pixels (i.e. array operations).
;PARAMETERS:
;       i
;       j
;       k
;KEYWORDS:
;       fixed
;       startparms
;       sigma
;       hydrogenated
;RETURN VALUE:
;       the starting parameters.


    ;PRODUCE A SET OF PARAMETERS TO BEGIN FITTING
    ;FOR EACH INDIVIDUAL ECHO
    if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

    if n_elements(noborrow) eq 0 then noborrow = 0
    if n_elements(hydrogenated) eq 0 then hydrogenated = 0

    ;GET SOME INFORMATION FROM THE DATA

    x = self->chirpPhases(k)

    ;y = self->chirp(i,j,k)
    y = self->newchirp(k)
    sy= sqrt(y)

   parms = dblarr(6,self.x_dim*self.y_dim);,self.no_of_fourier_times)

  ;GET THESE 6 ITEMS WITH ARRAY OPERATIONS
    offsetstart = dblarr(self.x_dim*self.y_dim);,self.no_of_fourier_times)
    ampstart = dblarr(self.x_dim*self.y_dim);,self.no_of_fourier_times)
    phasestart = dblarr(self.x_dim*self.y_dim);,self.no_of_fourier_times)
    sigmastart = dblarr(self.x_dim*self.y_dim);,self.no_of_fourier_times)
    omegastart = dblarr(self.x_dim*self.y_dim);,self.no_of_fourier_times)
    dphasestart = dblarr(self.x_dim*self.y_dim);,self.no_of_fourier_times)



;LRK - 05/27/09
;CHECKING FOR HYDROGENATED SAMPLES.
;        dum_up = self->chirpIup(i,j,k,tavestate=tavestate);xind,yind,tauind)
;        dum_down = self->chirpIdown(i,j,k,tavestate=tavestate);xind,yind,tauind)
;        if dum_up gt dum_down then begin
;            hydrogenated = 1
;        endif else hydrogenated = 0
;
        self->newCalcChirpIupIdown,tauind = k,Iup=dum_up,Idown=dum_down,hydrogenated=hydrogenated


    ;CALCULATE AMPLITUDE STARTING POINT
    if (n_elements(fixed) gt 0) then begin
        if(fixed[1] eq 1 and n_elements(startparms) gt 0) then begin
            ampStart[*] = startparms[1]
        endif else begin
            ampstart = (*self.fitparms)[1,*,k]
        endelse
    endif else begin

        ;NEED TO ARRAY-IZE THE NEXT FUNCTION:
        ampStart = self->newchirpAmplitude(k,hydrogenated=hydrogenated)
    endelse


    if hydrogenated eq 1 then begin
        if ampstart gt 0.0 then ampstart = -1.0*ampstart
    endif

    ;CALCULATE OFFSET STARTING POINT
    if (n_elements(fixed) gt 0) then begin
        if(fixed[0] eq 1 and n_elements(startparms) gt 0) then begin
            offsetStart[*] = startparms[0]
        endif else begin
            offsetStart[*] = (*self.fitparms)[0,*,k]
        endelse
    endif else begin
        offsetStart[*] = self->newchirpOffset(k,hydrogenated=hydrogenated)
    endelse


    if noborrow eq 0 then begin
        ;SELECT A POSSIBILITY FOR THE PHASE
        if (n_elements(fixed) gt 0) then begin
            if(fixed[2] eq 1 and n_elements(startparms) gt 0) then begin
                phaseStart[*] = startparms[2]
            endif else begin
                phaseStart[*] = (*self.fitparms)[2,*,k]
            endelse
        endif else begin
            if hydrogenated eq 1 then begin
                dum = max(y,phaseStartIndex,dimension=2)
            endif else begin
                dum = min(y,phaseStartIndex,dimension=2)
            endelse
            phaseStart[*] = x[phaseStartIndex]
            ;print,'phaseStart = ',phaseStart
        endelse
    endif;noborrow

    if (n_elements(fixed) gt 0) then begin
        if(fixed[4] eq 1 and n_elements(startparms) gt 0) then begin
            omegaStart[*] = startparms[4]
        endif else begin
            omegaStart[*] = (*self.fitparms)[4,self.x_dim*j+i,k]
        endelse
    endif else begin
        omegaStart[*] = 360.0/360.0
    endelse


    if n_elements(sigma) eq 0 then begin
        if (n_elements(fixed) gt 0) then begin
            if(fixed[4] eq 1 and n_elements(startparms) gt 0) then begin
                sigmaStart[*] = startparms[3]
            endif else begin
                sigmaStart[*] = (*self.fitparms)[3,self.x_dim*j+i,k]
            endelse
        endif else begin
            sigmaStart[*] = 702.0
        endelse
    endif else begin
        sigmaStart[*] = sigma
    endelse

;    if i*j*k eq 1 then print,'sigmaStart = ',sigmaStart

    if (n_elements(fixed) gt 0) then begin
        if(fixed[5] eq 1 and n_elements(startparms) gt 0) then begin
            ;IF startparms ARE PASSED AND PARM IS FIXED USE THAT ONE
            dphaseStart[*] = startparms[5]
        endif else begin
            ;IF startparms ARE NOT PASSED AND NOT FIXED,
            ;USE CURRENT VALUE IN ARRAY
            dphaseStart[*] = (*self.fitparms)[5,self.x_dim*j+i,k]
        endelse
    endif else begin
        ;
        dphaseStart[*] = 0.0
    endelse

;    parms = [offsetStart, ampStart, phaseStart, sigmaStart, omegaStart,dphaseStart]
;    (*self.fitparms)[0:5,self.x_dim*j+i,k] = parms


  ;GET THESE 6 ITEMS WITH ARRAY OPERATIONS
    parms[0,*,*] = offsetstart
    parms[1,*,*] = ampstart
    parms[2,*,*] = phasestart
    parms[3,*,*] = sigmastart
    parms[4,*,*] = omegastart
    parms[5,*,*] = dphasestart

    return,parms
end;newstartParms

pro ooEcho::newfitall
  
  
catch, catchError
if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'NSE Reduction: Error encountered'
    eMsg = 'An error or unusual condition was encountered at ooEcho::newFitall in ooecho__newchirpiupidown.pro!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = dialog_message(/error,eMsg,title=eTitle)
    catch, /cancel
    return
endif  
  
  
  times = *self.fourierTime
  nt = self.no_of_fourier_times
  mask = *self.mask2d
  sz = size(mask)
  npix = sz[1]
  
  for k = 0,nt-1 do begin
    print,k
      if abs(times[k]*(10.0^9)) gt 0.000001 then begin
        this_mask = mask[*,k]
        x = self->chirpPhasesMasked(k)
        y = self->newchirpMasked(k)
        sy= sqrt(double(y))
        ;help,x,y,sy,this_mask

        wh = where(sy eq 0.0,count)
        if count ne 0 then sy[wh] = 1.0
        
        parms = self->newstartparms(k)

        ;help,parms


        fixed = (*self.fixed)[*,*,k]


        if n_elements(parinfo) ne 6 then begin
            parinfo = replicate({value:0.0d,$
                                 fixed:0,$
                                 limited:[1,1], $
                                 limits:[0.0d,0.0d],$
                                 parname:'',tied:''},$
                                 6)
        endif

;;ALTER THE LIMITS TO ALLOW SLIGHTLY NEGATIVE AMPLITUDES FOR
;;TRADITIONAL SAMPLES.
        if self.type eq 2 or self.type eq 3 then begin
            minamp = -30.0d - mean(y)/30.0d
        endif else begin
            minamp = 0.001;-30.0d - mean(y)/30.0d
        endelse
      
        lims = [[0.01d,10000000.0d], [minamp,1000000000.0d], [-1999.0d,2000.0d],$
                [0.01d,2000.0d], [0.001d,200000.0d], [-1999.0d,2000.0d]]
        
        hydrogenated = (*self.extensions).hydrogenated
        if hydrogenated eq 1 then begin
            temp = -1.0*lims[0,1]
            lims[0,1] = -1.0*lims[1,1]
            lims[1,1] = temp
        endif

        parinfo[*].limits = lims

  
        for i=0,npix-1 do begin
          if this_mask[i] gt 0 then begin
            start = parms[*,i]
            perror = 0.0*start
            parinfo[*].value = start
            
            this_fixed = fixed[*,i]
  
            parinfo[*].fixed = this_fixed
  
            this_y = y[i,*]
            this_sy = sy[i,*]
  
            outparms = mpfitfun('chirpFun', x, this_y, this_sy, parinfo=parinfo, perror=perror,quiet=1)
            result = [outparms,perror]
            (*self.fitparms)[*,i,k] = result 
            (*self.fitdisplaymask)[i,k] = 1         
          endif;mask[i]
        endfor;i
    endif;times not zero
  endfor;k
  self.reduced = 1

end;newfitall

function ooEcho::newchirpFitArcs,tauind,$;xind,yind,tauind,$
                                fixed=fixed,$
                                limited=limited,$
                                startparms=startparms,$
                                parmlims=parmlims,$
                                parinfo=parinfo,$
                                perror = perror,$
                                quiet = quiet,$
                                smallerr = smallerr,$
                                suppress = suppress,$
                                test = test,obj=obj,$
                                tavestate=tavestate,$
                                _Extra=extra
;
;NAME:
;        ooEcho::newchirpFitArcs
;
;PURPOSE:
;           Fit a single echo for the arcFit method.
;PARAMETERS:
;       xind    The pixel indices
;       yind
;       tauind  The Fourier time index
;KEYWORDS:
;        fixed
;        limited
;        startparms
;        parmlims
;        parinfo
;        perror
;        quiet
;        smallerr
;        suppress
;        test
;        obj    Display Object
;RETURN VALUE:
;   parms   The resulting fi parameters.

;    if n_elements(suppress) eq 0 then suppress = 0
;    if suppress eq 0 then $
;        ;self->addTreatment,'ooEcho::chirpFitArcs'


    ;FITTING FOR A SINGLE ECHO
    ;   KEYWORDS:
    ;   startparms IS A 6 ELEMENTS ARRAY OF THE INPUT STARTING PARAMETERS
    ;   fixed IS A 6 ELEMENTS ARRAY OF 1's AND 0's

    if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

    if n_elements(test) eq 0 then test = 0
    if n_elements(quiet) eq 0 then quiet = 1
    if n_elements(smallerr) eq 0 then smallerr = 0

    parms = self->newstartParms(tauind,hydrogenated=hydrogenated,tavestate=tavestate)
    ;print,hydrogenated


    if n_elements(fixed) eq 6 then begin
        for iii = 0,5 do begin
            (*self.fixed)[iii,*,tauind] = fixed[iii]
        endfor;iii
    endif



;CHANGE THE NEXT LINE TO REFLECT THE USER MASKED MASK VALUE OF -1
    x = self->chirpPhasesMasked(tauind)
    y = self->newchirpMasked(tauind)
    sy= sqrt(double(y))
help,x,y,sy

;    if ((*(self.mask2d))[yind*self.x_dim+xind,tauind] gt 0) then begin
;        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;        ;CHANGE HERE TO USE MASKED 1D ARRAYS
;        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
;
;
;        ;SET sy[] = 1 AT ZERO VALUES AND CHECK FOR smallerr FLAG
;        for ii = 0,n_elements(sy)-1 do begin
;            if sy[ii] eq 0.0 then sy[ii] = 1.0
;
;            ;ALTER EB IF THERE MAY BE A PROBLEM
;            if smallerr eq 1 then sy[ii] = 1.0 + 0.1*y[ii]
;
;        endfor;ii
;
;        ;SET STARTING PARAMETERS FOR THIS ECHO AND INITIALIZE
;        ;THE ERROR ARRAY FOR THIS SET OF PARAMETERS
;
;
;;083005
;        parms = self->startParms(xind,yind,tauind,hydrogenated=hydrogenated,tavestate=tavestate)
;
;        if n_elements(startparms) eq 6 then parms = startparms
;        perror = 0.0*parms
;
;        start = parms
;
;
;        if n_elements(parinfo) ne 6 then begin
;            parinfo = replicate({value:0.0d,$
;                                 fixed:0,$
;                                 limited:[1,1], $
;                                 limits:[0.0d,0.0d],$
;                                 parname:'',tied:''},$
;                                 6)
;        endif
;
;
;;091205
;;ALTER THE LIMITS TO ALLOW SLIGHTLY NEGATIVE AMPLITUDES FOR
;;TRADITIONAL SAMPLES.
;if self.type eq 2 or self.type eq 3 then begin
;    minamp = -30.0d - mean(y)/30.0d
;endif else begin
;    minamp = 0.001;-30.0d - mean(y)/30.0d
;endelse
;
;    lims = [[0.01d,10000000.0d], [minamp,1000000000.0d], [-1999.0d,2000.0d],$
;            [0.01d,2000.0d], [0.001d,200000.0d], [-1999.0d,2000.0d]]
;;083005
;        if hydrogenated eq 1 then begin
;            temp = -1.0*lims[0,1]
;            lims[0,1] = -1.0*lims[1,1]
;            lims[1,1] = temp
;        endif
;
;        parinfo[*].limits = lims
;        parinfo[*].value = start
;        if n_elements(fixed) ne 6 then fixed = [0,0,0,1,1,1]
;
;;110104
;fixed = (*self.fixed)[*,xind+yind*self.x_dim,tauind]
;
;
;
;        parinfo[*].fixed = fixed
;
;;        if quiet eq 0 then $
;;            print,xind,yind,tauind,'parms =',parms,'perror = ',perror
;
;      if total(fixed) ne 6 then begin
;
;;;        ;041205
;;;        ;FIT WITH PERIOD FIXED THEN FIT WITH PERIOD ALLOWED TO VARY
;;;        parinfo[4].fixed = 1
;;;        parms = mpfitfun('chirpFun', x, y, sy, parinfo=parinfo, perror=perror,quiet=quiet)
;;;        parinfo[4].fixed = fixed[4]
;;;        parinfo[*].value = parms
;;;        ;041205
;        if test eq 1 then begin
;            quiet = 0
;            print,'parinfo[*].limits'
;            print,parinfo[*].limits
;            print,'parinfo[*].value'
;            print,parinfo[*].value
;        endif
;
;        parms = mpfitfun('chirpFun', x, y, sy, parinfo=parinfo, perror=perror,quiet=1);quiet)
;
;        ;041205
;        if ((parms[4] gt 360.0/300.0) or (parms[4] lt 360.0/420.0)) and fixed[4] ne 1 then begin
;            ;FIT WITH PERIOD FIXED THEN FIT WITH PERIOD ALLOWED TO VARY
;            parinfo[*].value = start
;            parinfo[4].fixed = 1
;            parms = mpfitfun('chirpFun', x, y, sy, parinfo=parinfo, perror=perror,quiet=1);quiet)
;            parinfo[4].fixed = 0
;            parinfo[*].value = parms
;            parms = mpfitfun('chirpFun', x, y, sy, parinfo=parinfo, perror=perror,quiet=1);quiet)
;        endif
;        ;041205
;
;
;;        if quiet eq 0 then $
;;            print,xind,yind,tauind,'parms =',parms,'perror = ',perror
;        ;parms = mpfitfun('chirpFun', x, y, sy, start, perror=perror,/quiet)
;
;
;;        print,'7926 ooEcho:: chirpFitArcs'
;;        help,parms,perror
;;THIS WILL CRASH IF mpfit.pro IS NOT COMPILED.
;        ((*self.fitparms)[*,yind*self.x_dim+xind,tauind]) = [parms,perror]
;
;        parms[1] = self->checkAmp(xind,yind,tauind,tavestate=tavestate)
;
;        self->setfitdisplaymask,xind,yind,tauind,value=1
;      endif;total(fixed)
;
;
;      ;031505
;      ;
;      ;NOW DO CHECKS TO SEE IF AUTO-MASKING IS APPROPRIATE
;
;      ;1) STATISTICS   m=(moment(sy/y)) & if m[0] gt (threshold) then mask the point
;      ;                         *(self.mask2d)[yind*self.x_dim+xind,tauind] = 1
;      ;THE REASON THIS CHECK IS AFTER THE FIT IS TO ALLOW THE USER TO EXAMINE THE RESULTS
;      ;WITHOUT HAVING TO DO THE REFIT.
;      ;
;      ;
;      ;2) PERIOD       if 360.0/parms[4] gt 420.0 or 360.0/parms[4] lt 300.0 then
;      ;                         *(self.mask2d)[yind*self.x_dim+xind,tauind] = 1
;      ;
;      ;3) CHISQ        if chisq
;
;
;    endif;mask2d

    return,parms
end;newchirpFitArcs

pro ooEcho::newarcFit,fit=fit,tphase=tphase,$
                            tauind = tauind,$
                            fixed=fixed,$
                            sigma=sigma,$
                            period=period,$
                            minus360=minus360,$
                            plus360 = plus360,$
                            obj=obj,noborrow=noborrow,$
                            tavestate=tavestate,$
                            _Extra=extra
;
;NAME:
;        ooEcho::newarcFit
;
;PURPOSE:
;       Fit everything with the starting point that all phases along a constant Q arc
;       should be similar.
;PARAMETERS:
;       none
;KEYWORDS:
;       fit
;       tphase
;       tauind
;       fixed
;       sigma       Gaussian width
;       period      period
;       minus360    Switches to shift all phases by 360 and refit everything.
;       plus360
;       obj         Display obj to update during fitting.
;       noborrow    Flag to tell method not to borrow phases from neighboring times.


;SAME AS OLD ooEcho::arcFit BUT TAKING ADVANTAGE OF THE ARRAY OPERATION 
;VERSIONS OF METHODS.

    ;SAVE FITPARMS IN CASE NEXT STEP IS A MISTAKE.
    self->storeFitparms

    if n_elements(tavestate) eq 0 then tavestate=self->report_timeaverage_state() 

    if n_elements(noborrow) eq 0 then noborrow = 0

    if n_elements(fit) eq 0 then fit = 1    ;DEFAULT IS TO DO FIT.

    if n_elements(tphase) eq 0 then tphase = 1  ;DEFAULT WILL BE TO BORROW
                                                ;PHASES FROM PREVIOUS t

    if n_elements(fixed) eq 6 then begin
        for k=0,5 do begin
            (*(self.fixed))[k,*,*] = fixed[k]
        endfor;k
    endif
    if n_elements(sigma) ne 0 then begin
        self->setWidth,sigma
    endif
    if n_elements(period) ne 0 then begin
        self->setPeriod,period
    endif

    if n_elements(minus360) ne 0 then begin
        ;SHIFT ALL PHASES BY -360
        self->lower360,tauind=tauind
    endif

    if n_elements(plus360) ne 0 then begin
        self->raise360,tauind=tauind
    endif



    ;FIT FOR ALL FOURIER TIMES BY DEFAULT
    if n_elements(tauind) eq 0 then begin
        kbegin = 0
        kend = self.no_of_fourier_times-1
    endif else begin
        kbegin = tauind
        kend = tauind
    endelse

    if n_elements(obj) ne 0 then obj->draw

    ;GET THE Q-ARC INDICES FOR THE DATA.
    self->calculateIndexMatrix,mat=mat
    Seconds = SYSTIME( 1,/SECONDS )

    ;SET UP PROGRESS WINDOW.
    pbase = self->createProgress([kend,kend],$
                                kbegin=[kbegin,kbegin],$
                                title='arcFit Progress',$
                                xtitle=['t0','t1'],/stopbutton)
    prog = widget_info(pbase,/child)


    ;NOW GET STARTPARMS FOR ALL LINES
    ;AND FIT ONLY THE CENTRAL LINE.
    for k=kbegin,kend do begin
        if widget_info(prog,/valid_id) ne 0 then widget_control,prog,set_value=[k,kbegin]
        
        ;SET THE PHASES FOR THE ARCS BASED ON THE CENTRAL LINE OF DATA
        for i=0,self.x_dim-1 do begin
            jcen = self.y_dim/2
            for j=0,self.y_dim-1 do begin
                ;PROTECT IN CASE FIT WAS DONE AND WE NEED 360 DEG SHIFT.
                if self.reduced eq 0 then begin
                    start = self->startParms(i,j,k,sigma=sigma,tavestate=tavestate)
                endif else begin
                    start = ((*self.fitparms)[0:5,i+j*self.x_dim,k])
                endelse

                if j eq jcen then begin $
                    temp = $
                            self->chirpFitArcs(i,j,k,fixed=fixed,$
                                                startparms=start,/suppress,tavestate=tavestate);,/test);$
                    chsq = self->setChisq(i,j,k)
                endif
            endfor;j
        endfor;i

    endfor;k

;ADD A CONTINUITY CHECK FOR THE CENTRAL LINE HERE.

    ;1) SET t[0] CENTER LINE (  DONE ABOVE WITH NO
    ;                           LATERAL CONTINUITY CHECK )
    io = jcen*self.x_dim
    tmparr = ((*self.fitparms)[2,io:io+self.x_dim-1,kbegin])
    for i=self.x_dim/2+1,self.x_dim-1 do begin
            if (abs(tmparr[i]-tmparr[i-1]) gt 180.0) then begin
                if tmparr[i-1] le tmparr[i] then begin
                    ((*self.fitparms)[2,io+i,kbegin]) = tmparr[i]-360.0
                endif else begin
                    ((*self.fitparms)[2,io+i,kbegin]) = tmparr[i]+360.0
                endelse
            endif
            ;RESET tmparr TO REFLECT CHANGES
            tmparr = ((*self.fitparms)[2,io:io+self.x_dim-1,kbegin])
            if (abs(tmparr[i]-tmparr[i-1]) gt 180.0) then begin
                    ((*self.fitparms)[2,io+i,kbegin]) = $
                        ((*self.fitparms)[2,io+i-1,kbegin])
            endif

    ;DO THE FIT
            start = ((*self.fitparms)[0:5,io+i,kbegin])
            temp = $
                self->chirpFitArcs(i,jcen,kbegin,$
                            fixed=fixed,startparms=start,/suppress,tavestate=tavestate);$
        ;DOES temp GET ASSIGNED TO self.fitparms? - - - YES.
    endfor;i



    for j=0,self.x_dim/2-1 do begin
            i=self.x_dim/2-1-j

            if (abs(tmparr[i+1]-tmparr[i]) gt 180.0) then begin
                if tmparr[i] le tmparr[i+1] then begin
                    ((*self.fitparms)[2,io+i,kbegin]) = tmparr[i]+360.0
                endif else begin
                    ((*self.fitparms)[2,io+i,kbegin]) = tmparr[i]-360.0
                endelse
            endif
            ;RESET tmparr TO REFLECT CHANGES
            tmparr = ((*self.fitparms)[2,io:io+self.x_dim-1,kbegin])
            if (abs(tmparr[i+1]-tmparr[i]) gt 180.0) then begin
                    ((*self.fitparms)[2,io+i,kbegin]) = $
                        ((*self.fitparms)[2,io+i+1,kbegin])
            endif
            start = ((*self.fitparms)[0:5,io+i,kbegin])
            temp = $
                self->chirpFitArcs(i,jcen,kbegin,$
                                    fixed=fixed,startparms=start,/suppress,tavestate=tavestate)
    endfor;j


;CHECKING PHASES FROM ONE t TO NEXT SECTION
;SHOULD BE SUPERFLUOUS SINCE ALL PHASES ARE BORROWED
;FROM ONE t TO NEXT LATER
;
;


    ;NEXT SET ALL PHASES ON A GIVEN Q-ARC
    ;TO BE IDENTICAL (WITHIN 180deg) AND DO THE FITS IF REQUESTED

    for k=kbegin,kend do begin
        if widget_info(prog,/valid_id) ne 0 then widget_control,prog,set_value=[kend,k]

        if k eq kbegin then begin
                for i=0,self.x_dim-1 do begin
                    jcen = self.y_dim/2
                    for j=0,self.y_dim-1 do begin
                    
                        ;LRK - 05/28/09
                        ;
                        ;THIS IS WHERE I HAVE TO UPDATE FOR ARRAY OPS:

                        if j ne jcen then begin

                            phase = ((*self.fitparms)[2,j*self.x_dim+i,k])
                            if noborrow eq 0 then begin
                                phasecomp = $
                                        ((*self.fitparms)[2,jcen*self.x_dim+mat[i+j*self.x_dim],k])
                                if abs(phase - phasecomp) gt 180.0 then $
                                ((*self.fitparms)[2,j*self.x_dim+i,k]) = phasecomp
                            endif

                            if fit ne 0 then begin
                                startparms = $
                                ((*self.fitparms)[0:5,j*self.x_dim+i,k])

                                perror = 0.0*startparms

                                ;FIT THE DATA
                                temp = $
                                    self->chirpFitArcs(i,j,k,$
                                                    fixed=fixed,$
                                                    startparms=startparms,$
                                                    perror=perror,/suppress,tavestate=tavestate)


                                ;PLACE RESULT IN FITPARMS
                                ((*self.fitparms)[*,j*self.x_dim+i,k]) = $
                                                    [temp,perror]


                                ;REFIT IF PERIOD TOO BIG.  ----> NEED TO LIMIT PERIOD AT SOME POINT.
                                if temp[4] gt 1.3 or temp[4] lt 0.7 then begin
                                    startparms = $
                                    ((*self.fitparms)[0:5,j*self.x_dim+i,k])

                                    perror = 0.0*startparms
                                    ((*self.fitparms)[2,i+j*self.x_dim,k]) = startparms[2]
                                    ((*self.fitparms)[4,i+j*self.x_dim,k]) = 1.0
                                    temp = $
                                        self->chirpFitArcs(i,j,k,$
                                                        fixed=fixed,$
                                                        startparms=startparms,$
                                                        perror=perror,/suppress,tavestate=tavestate)
                                endif


                                ;CALCULATE chi-squared AND CHECK FIT
                                chsq = self->setChiSq(i,j,k)
                                if chsq gt 80.0 then begin

                                    startparms = self->newStartParmsArcFit(i,j,k,mat,tavestate=tavestate)

    ;                                print,i,j,k,'HIGH CHISQ',((*self.fitparms)[*,j*self.x_dim+i,k])
                                    dum = $
                                        self->chirpFitArcs(i,j,k,$
                                                    fixed=fixed,$
                                                    startparms=startparms,$
                                                    perror=perror,/suppress,tavestate=tavestate);,quiet=0)
                                                    ;perror=perror,/smallerr)
                                    chsq = self->setChiSq(i,j,k)

                                endif;chsq

                            endif;fit

                        endif;j ne jcen
                    endfor;j
                endfor;i
        endif else begin ;k eq kbegin

    ;BORROW PHASES FROM NEIGHBORING t - - -

                if noborrow eq 0 then begin
                    ((*self.fitparms)[2,*,k]) = ((*self.fitparms)[2,*,k-1])
                endif;noborrow

                for i=0,self.x_dim-1 do begin
                    jcen = self.y_dim/2
                    for j=0,self.y_dim-1 do begin
                            ;print,'i,j,k=',i,j,k
                            if fit ne 0 then begin
                                startparms = $
                                ((*self.fitparms)[0:5,j*self.x_dim+i,k])

                                perror = 0.0*startparms

                                ;FIT THE DATA
                                temp = $
                                    self->chirpFitArcs(i,j,k,$
                                                    fixed=fixed,$
                                                    startparms=startparms,$
                                                    perror=perror,/suppress,tavestate=tavestate)
        ;                        print,i,j,k,temp,perror
                                ;print,temp,perror

                                ;PLACE RESULT IN FITPARMS
                                ((*self.fitparms)[*,j*self.x_dim+i,k]) = $
                                                    [temp,perror]

                                chsq = self->setChiSq(i,j,k)

                                ;CHECK FIT QUALITY AND REDO AS NECESSARY
                                if chsq gt 80.0 then begin

        ;                            startparms = self->newStartParmsArcFit(i,j,k,mat)
        ;                            print,i,j,k,'HIGH CHISQ',((*self.fitparms)[*,j*self.x_dim+i,k])
                                    startparms = self->startParms(i,j,k,tavestate=tavestate)
                                    startparms[2] = ((*self.fitparms)[2,j*self.x_dim+i,k-1])
                                    dum = $
                                        self->chirpFitArcs(i,j,k,$
                                                    fixed=fixed,$
                                                    startparms=startparms,$
                                                    perror=perror,/suppress,tavestate=tavestate);,quiet=0)
                                                    ;perror=perror,/smallerr)

                                    chsq = self->setChiSq(i,j,k)

                                endif

                            endif;fit
                    endfor;j
                endfor;i

        endelse;k eq kbegin

    endfor;k


    if widget_info(pbase,/valid_id) ne 0 then widget_control,pbase,/destroy
    self.IupdownSwitch = 1
    self.reduced = 1
end;newarcFit


function ooEchoMagnetic::newgetNumberOfUpDownContributingPoints,tauind,tavestate=tavestate
to = systime(1)
;1) GET tAve state:
    if n_elements(tavestate) eq 0 then tavestate = self->report_timeaverage_state()

;print,'1',(to1=(systime(1)-to))

;2) Get masking in t direction for each pixel used
    mask1d = *self.mask1d
    mask2d = *self.mask2d

    sz1 = size(mask1d)
    sz2 = size(mask2d)

    npix = sz2[1]
    nphs = sz1[1]
    nt = sz2[2]

    npts = 0.0
;print,'2',(to2=(systime(1)-to))

    ;CREATE THE MASK FOR ALL PIXELS, PHASES AND TIMES
    arr = self->generate3DMask()
;print,'3',(to3=(systime(1)-to))

    ;SET THE TIME INDICES TO LOOP OVER BASED ON WHETHER DATA ARE TIME-AVERAGED.
    if tavestate eq 0 then begin
      t1 = tauind
      t2 = tauind
    endif else begin
      t1 = 0
      t2 = nt-1     
    endelse
;print,'4',(to4=systime(1)-to)

    ;IN MASK ARRAYS, 1 is unmasked, anything else is masked.   
    if self.magnetic eq 0 then begin
        i1 = [self.point_to_down,self.point_to_up]
        i2 = self->figureorder(i1,self.no_of_phases)
        npts = dblarr(n_elements(i1),self.x_dim*self.y_dim)
    endif else begin    ;MAGNETIC
        i1 = [ self.point_to_down_x,$
               self.point_to_up_x,$
               self.point_to_down_y,$
               self.point_to_up_y,$
               self.point_to_down_z,$
               self.point_to_up_z $
               ]
        i2 = self->figureOrder(i1,self.no_of_phases)
        npts = dblarr(n_elements(i1),self.x_dim*self.y_dim) 
    endelse;IF magnetic
;print,'5',(to5=systime(1)-to)


    sznpts = size(npts)
    if sznpts[0] eq 2 then kterm = sznpts[1] else kterm = 2 
    for k=0,kterm-1 do begin;n_elements(npts)-1 do begin
      for j=t1,t2 do begin
        for i=i1[k],i2[k] do begin;self.point_to_down,self.point_to_up-1 do begin
            npts[k,*] += arr[*,i,j]
        endfor;i
      endfor;j        
    endfor;k
;print,'6',(to6=systime(1)-to)
;print,systime(1)-to
   
    return,npts
end;newgetNumberOfUpDownContributingPoints
function ooEchoMagnetic::newgetNumberOfEchoContributingPoints,tauind,tavestate=tavestate

;1) GET tAve state:
    if n_elements(tavestate) eq 0 then tavestate = self->report_timeaverage_state()


;2) Get masking in t direction for each pixel used
    mask1d = *self.mask1d
    mask2d = *self.mask2d

    sz1 = size(mask1d)
    sz2 = size(mask2d)

    npix = sz2[1]
    nphs = sz1[1]
    nt = sz2[2]

    npts = 0.0

    ;CREATE THE MASK FOR ALL PIXELS, PHASES AND TIMES
    arr = self->generate3DMask()

    ;SET THE TIME INDICES TO LOOP OVER BASED ON WHETHER DATA ARE TIME-AVERAGED.
    if tavestate eq 0 then begin
      t1 = tauind
      t2 = tauind
    endif else begin
      t1 = 0
      t2 = nt-1     
    endelse

    ;IN MASK ARRAYS, 1 is unmasked, anything else is masked.   
    npts = dblarr(self.x_dim*self.y_dim)

    for j=t1,t2 do begin
      for i=0,self->term()-1 do begin
          npts[*] += arr[*,i,j]
      endfor;i
    endfor;j
   
    return,npts
end;newgetNumberOfEchoContributingPoints

function ooEcho::newchirpMasked,tauind,xind=xind,yind=yind,_Extra=extra
;
;NAME:
;        ooEcho::newchirpMasked
;
;PURPOSE:
;       Return the echo without the masked points.
;PARAMETERS:
;       xind
;       yind
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;       The echo without the masked points.



    s=reform(*self.emask,self.x_dim*self.y_dim,$
        self.no_of_phases,self.no_of_fourier_times)

;092705
term = self->term();min([self.point_to_up,self.point_to_down])

    ;EXTRACT SLICE ALONG PHASE DIMENSION AT SELECTED PIXEL
;    ys = reform(s[xind,yind,0:self.point_to_down-1,tauind],self.point_to_down)
    ys = reform(s[*,0:term-1,tauind],self.x_dim*self.y_dim,term)

    ysmask = 0

    ;113005
    ;NO LOOPS:
    unmasked = where((*self.mask1d)[0:term-1,tauind] gt 0,count)
    if count gt 0 then begin
        return,ys[*,unmasked]
    endif else begin
        return,ys;[0:term-1]
    endelse

end;newchirpMasked
function ooEcho::newchirpAmplitude,tauind,xind=xind,yind=yind,hydrogenated=hydrogenated,_Extra=extra
;
;NAME:
;        ooEcho::newchirpAmplitude
;
;PURPOSE:
;       Return the diffference between the flipper on (Idown) and flipper off (Iup) states.
;
;PARAMETERS:
;       xind
;       yind
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;       The difference between the flipper on and flipper off states.
;       i.e.

    ;self->addTreatment,'ooEcho::chirpAmplitude'

;091205
;WHY NOT REPLACE ALL OF NEXT BLOCK WITH THE TWO LINES THAT FOLLOW????
;;;;;    if n_elements(hydrogenated) eq 0 then hydrogenated = 0
;;;;;
;;;;;    ;GET THE DATA VALUES IN A CHIRP FOR THE FLIPPER DOWN
;;;;;    ;AND FLIPPER UP STATES.
;;;;;    ;RETURN THE DIFFERENCE OF THE AVERAGES OF THESE DATA
;;;;;
;;;;;    ;GET UP AND DOWN VALUES FOR SELECTED INDICES
;;;;;    arr = self->chirpExtrema(xind,yind,tauind)
;;;;;    ydown = arr[0] & yup = arr[1]
;;;;;
;;;;;;083105
;;;;;    amp = (ydown-yup)/2.0
;;;;;
;;;;;    if amp eq 0.0 then begin
;;;;;        ech = self->chirpMasked(xind,yind,tauind)
;;;;;        amp = (max(ech) - min(ech))/2.0
;;;;;
;;;;;    endif

;print,'091205 ooecho::chirpamplitude'
    ech = self->newchirpMasked(tauind);xind,yind,tauind)
    ;help,ech
    amp = (max(ech,dimension=2) - min(ech,dimension=2))/2.0
;    help,amp
;    amp = (max(ech) - min(ech))/2.0
    
    
    return,amp;(ydown - yup)/2.0
end;newchirpAmplitude


function ooEcho::newchirpOffset,tauind,hydrogenated = hydrogenated,_Extra=extra
;
;NAME:
;        ooEcho::newchirpOffset
;
;PURPOSE:
;           Get the offset based onthe Iup (flipper off) and Idown (flipper on) values.
;PARAMETERS:
;           tauind
;KEYWORDS:
;           hydrogenated    Flag for hydrogenated samples where spin flip scattering dominates.
;RETURN VALUE:
;       The calculated offset.

    if n_elements(hydrogenated) eq 0 then hydrogenated = 0


  ;return,mean(self->chirpMasked(xind,yind,tauind))
  ;NEW STUFF FOR ARRAY-IZING;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  s = (*self.emask)[*,*,tauind]
  s = reform(s,self.x_dim*self.y_dim,self.no_of_phases)
  s = s[*,0:self->term()-1]
  
  
;LRK - 05/22/09
;  
;NOTE: THIS NEEDS TO INCORPORATE THE 3d MASK!!!!!!   
  
  ;GET THE 1D MASK
  tmask = (*self.mask1d)[*,tauind]
  ;nt = total(tmask(0:self->term()-1))
  nt = self->newgetNumberOfEchoContributingPoints(tauind) 
  
  
  ;TOTAL ARRAY
  tarr = total(s,2)/nt

  return,tarr

end;newchirpOffset

function ooEchoMagnetic::newhelpChirpIup_downXYZ,pt,tauind;,xind,yind,tauind

        arr = [ self.point_to_up_x,$
                self.point_to_up_y,$
                self.point_to_up_z,$
                self.point_to_down_x,$
                self.point_to_down_y,$
                self.point_to_down_z $
                    ]
        steps  = arr[sort(arr)]

;    yarr = self->chirpAll(xind,yind,tauind)
;    ymask = self->getMask1D(tauind)
;    meanarr = [0.0]

;NEW STUFF FOR ARRAY-IZING;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
s = (*self.emask)[*,*,tauind]
s = reform(s,self.x_dim*self.y_dim,self.no_of_phases)

;GET THE 1D MASK
tmask = (*self.mask1d)[*,tauind]

;TOTAL ARRAY
tarr = fltarr(self.x_dim*self.y_dim)
starr = fltarr(self.x_dim*self.y_dim)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        i1 = pt
        wh = where(steps gt pt)
;print,'ooEchoMagnetic::helpChirpIup_downXYZ',wh

        if wh[0] eq -1 then begin
            i2 = self.no_of_phases-1
        endif else begin
            i2 = steps(wh[0])
        endelse

;THIS ACCOUNTS FOR THE MASKING.
        nt = 0.0
        for i=i1,i2-1 do begin
            if tmask[i] ne 0 then begin
                
                tarr += s
                starr += s
                nt += 1.0
            endif
        endfor;i
        if nt gt 0.0 then begin
          yup = tarr/nt
          syup = sqrt(starr)/nt
        endif else begin
          yup = tarr
          ;syup[*] = tarr + 1.0
          syup = tarr + 1.0
        endelse

    return,{i:yup,si:syup}
end;newhelpChirpIup_downXYZ



function ooEchoMagnetic::newthreeMplusNoverSix,tauind
;
;NAME:
;        ooEchoMagnetic::newthreeMplusNoverSix
;

;PURPOSE:
;           Return 3*(M+N) as a check to see that this is 2*(echo average)
;PARAMETERS:
;           xind
;           yind
;           tauind
;KEYWORDS:
;           none
;RETURN VALUE:
;       [3*(M+N).error bar]

;NEW STUFF FOR ARRAY-IZING;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
s = (*self.emask)[*,*,tauind]
s = reform(s,self.x_dim*self.y_dim,self.no_of_phases)

;GET THE 1D MASK
tmask = (*self.mask1d)[*,tauind]


;TOTAL ARRAY
tarr = fltarr(self.x_dim*self.y_dim)
starr = fltarr(self.x_dim*self.y_dim) + 1.0
xup = tarr
xdown = tarr
yup = tarr
ydown = tarr
zup = tarr
zdown = tarr

sxup = starr
sxdown = starr
syup = starr
sydown = starr
szup = starr
szdown = starr


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

    if self.magnetic eq 1 then begin
        arr = [ self.point_to_up_x,$
                self.point_to_up_y,$
                self.point_to_up_z,$
                self.point_to_down_x,$
                self.point_to_down_y,$
                self.point_to_down_z $
                    ]
        steps  = arr[sort(arr)]


        ret = self->newhelpChirpIup_downXYZ(self.point_to_up_x,tauind)
        xup = ret.i & sxup = ret.si

        ret = self->newhelpChirpIup_downXYZ(self.point_to_down_x,tauind)
        xdown = ret.i & sxdown = ret.si


        ret = self->newhelpChirpIup_downXYZ(self.point_to_up_y,tauind)
        yup = ret.i & syup = ret.si

        ret = self->newhelpChirpIup_downXYZ(self.point_to_down_y,tauind)
        ydown = ret.i & sydown = ret.si

        ret = self->newhelpChirpIup_downXYZ(self.point_to_up_z,tauind)
        zup = ret.i & szup = ret.si

        ret = self->newhelpChirpIup_downXYZ(self.point_to_down_z,tauind)
        zdown = ret.i & szdown = ret.si



        MplusNoverSix = (xup+xdown+yup+ydown+zup+zdown)/6.0 ;=M+N
        sMplusNoverSix = sqrt((sxup)^2.0+(sxdown)^2.0 $
                        +(syup)^2.0+(sydown)^2.0 $
                        +(szup)^2.0+(szdown)^2.0)/6.0

        result = {MplusNoverSix:MplusNoverSix,sMplusNoverSix:sMplusNoverSix}
        ;print,result
                        ;120105
                        ;THE SCALE FACTOR IS APPLIED IN ooEchoMagnetic::chirpAll
        result=result   ;*self.xyzupdownscale
        ;print,result
    endif else begin
        result = {MplusNoverSix:tarr,sMplusNoverSix:starr}
    endelse

    return,result
end;newThreeMPlusNoverSix


function ooEcho::newchirpIdown,tauind,Idown=Idown,sIdown=sIdown,_Extra=extra
;
;NAME:
;        ooEcho::newChirpIdown
;
;PURPOSE:   Calculate the Idown (F_on) values and their error bars for the whole data set at once.
;           This is meant to be used primarily for the initial read of the data. 
;           At other times this calculation gets trickier since the Iup/down values will
;           be affected by time averaging, masking, etc. (Although 1d masking is considered here.)
;
;PARAMETERS:
;       xind
;       yind
;       tauind
;KEYWORDS:
;       all  DO THE CALCULATION IN AN ARRAY BASED MODE, ESPECIALLY USEFUL FOR FIRST TIME READING FILE.
;RETURN VALUE:
;           Success



    ;GET DATA array FOR THE GIVEN FOURIER TIME
;    tauind = 0
;    s=reform(*self.emask,self.x_dim,self.y_dim,$
;        self.no_of_phases,self.no_of_fourier_times)
    s = (*self.emask)[*,*,tauind]
    s = reform(s,self.x_dim*self.y_dim,self.no_of_phases)
;    help,s


    ;GET THE 1D MASK
    tmask = (*self.mask1d)[*,tauind]
    ymask = self->getMask1D(tauind)
;    print,tmask-ymask


    ;TOTAL ARRAY
    tarr = fltarr(self.x_dim*self.y_dim)

    ;ADD THE NEXT STATEMENT TO ALLOW FOR Iup,Idown TO BE IN
    ;EITHER ORDER IN THE DATA
    i1 = self.point_to_down
    if self.point_to_down lt self.point_to_up then begin
        i2 = self.point_to_up-1
    endif else begin
        i2 = self.no_of_phases-1
    endelse
    nt = 0.0
    for i=i1,i2 do begin;self.point_to_down,self.point_to_up-1 do begin
        if tmask[i] ne 0 then begin
            ;meanarr = [meanarr,yarr[i]]
            tarr = tarr + s[*,i]
            nt += 1.0 
        endif
    endfor;i

    ;CALCULATE THE AVERAGE
    ydown = tarr/nt
    sydown = sqrt(tarr)/nt

    ;RESET ERROR BARS OF ZERO TO 1.0
    whzero = where(sydown eq 0,zcount)
    if zcount ge 1 and whzero[0] ne -1 then begin
      sydown[whzero] = 1.0
    endif
    
    (*self.Idown)[*,tauind] = ydown
    idown = ydown
    (*self.sIdown)[*,tauind] = sydown
    sidown = sydown

    return,1;ydown
end;newchirpIdown

function ooEcho::newchirpIup,iup=iup,siup=siup,tauind,_Extra=extra
;
;NAME:
;        ooEcho::newChirpIup
;
;PURPOSE:   Calculate the Iup (F_off) values and their error bars for the whole data set at once.
;           This is meant to be used primarily for the initial read of the data. 
;           At other times this calculation gets trickier since the Iup/down values will
;           be affected by time averaging, masking, etc. (Although 1d masking is considered here.)
;
;PARAMETERS:
;       xind
;       yind
;       tauind
;KEYWORDS:
;       all  DO THE CALCULATION IN AN ARRAY BASED MODE, ESPECIALLY USEFUL FOR FIRST TIME READING FILE.
;RETURN VALUE:
;           The flipper on value.

    ;GET DATA array FOR THE GIVEN FOURIER TIME
;    tauind = 0
    s = (*self.emask)[*,*,tauind]
    s = reform(s,self.x_dim*self.y_dim,self.no_of_phases)
    ;help,s

    ;GET THE 1D MASK
    tmask = (*self.mask1d)[*,tauind]

    ;TOTAL ARRAY
    tarr = fltarr(self.x_dim*self.y_dim)

    ;ADD THE NEXT STATEMENT TO ALLOW FOR Iup,Idown TO BE IN
    ;EITHER ORDER IN THE DATA
    i1 = self.point_to_up
    if self.point_to_up lt self.point_to_down then begin
        i2 = self.point_to_down-1
    endif else begin
        i2 = self.no_of_phases-1
    endelse
    nt = 0.0
    for i=i1,i2 do begin;self.point_to_down,self.point_to_up-1 do begin
        if tmask[i] ne 0 then begin
            ;meanarr = [meanarr,yarr[i]]
            tarr = tarr + s[*,i]
            nt += 1.0 
        endif
    endfor;i

    ;CALCULATE THE AVERAGE
    yup = tarr/nt
    syup = sqrt(tarr)/nt

    ;RESET ERROR BARS OF ZERO TO 1.0
    whzero = where(syup eq 0,zcount)
    if zcount ge 1 and whzero[0] ne -1 then begin
      syup[whzero] = 1.0
    endif
    
    (*self.Iup)[*,tauind] = yup
    iup = yup
    (*self.sIup)[*,tauind] = syup
    siup = syup

    return,1
end;newchirpIup

function ooEchoMagnetic::newchirpIdownmag,tauind,Idown=Idown,sIdown=sIdown,tavestate=tavestate
;
;NAME:
;        ooEchoMagnetic::newchirpIdownmag
;
;PURPOSE:   Calculate the Idown (F_on) values and their error bars and
;           store them in the
;
;PARAMETERS:
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;           The flipper on value.


;NEW STUFF FOR ARRAY-IZING;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
s = (*self.emask)[*,*,tauind]
s = reform(s,self.x_dim*self.y_dim,self.no_of_phases)

;GET THE 1D MASK
tmask = (*self.mask1d)[*,tauind]


;TOTAL ARRAY
tarr = fltarr(self.x_dim*self.y_dim)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;1) GET tAve state:
    if n_elements(tavestate) eq 0 then tavestate = self->report_timeaverage_state()
;2) Get masking in t direction for each pixel used
;    if tavestate eq 1 then begin
;      print,'ooEchoMagnetic::chirpIdown'
;      help,*self.e
;      help,*self.emask      
;    endif
  
;3) Create a t-averaged Iup value
;4) Calculate the error bars properly based on the 
;number of pixels actually used.  


    nContrib = self->newgetNumberOfUpDownContributingPoints(tauind,tavestate=tavestate)

    

    if self.magnetic eq 0 then begin
      ;THEN THIS IS CALCULATED ELSEWHERE ------ WHERE??????
    endif else begin    ;MAGNETIC

        ;print,'INSERT MAGNETIC Idown CODE HERE.'
        ;print,'PROBABLY THIS WILL JUST SET THE VALUE TO 0.0, BUT WE WILL SEE.'

        ;print,'PLACE MAGNETIC yup CODE HERE FOR ooEchoMagnetic::chirpIup'
        arr = [ self.point_to_up_x,$
                self.point_to_up_y,$
                self.point_to_up_z,$
                self.point_to_down_x,$
                self.point_to_down_y,$
                self.point_to_down_z $
                    ]
        steps  = arr[sort(arr)]

        ;print,'x_up'
        ret = self->newhelpChirpIup_downXYZ(self.point_to_up_x,tauind) ; arrayize this
        xup = ret.i & sxup = ret.si
        ;print,'x_down'
        ret = self->newhelpChirpIup_downXYZ(self.point_to_down_x,tauind)
        xdown = ret.i & sxdown = ret.si

        ;print,'y_up'
        ret = self->newhelpChirpIup_downXYZ(self.point_to_up_y,tauind)
        yup = ret.i & syup = ret.si
        ;print,'y_down'
        ret = self->newhelpChirpIup_downXYZ(self.point_to_down_y,tauind)
        ydown = ret.i & sydown = ret.si

        ;print,'z_up'
        ret = self->newhelpChirpIup_downXYZ(self.point_to_up_z,tauind)
        zup = ret.i & szup = ret.si
        ;print,'z_down'
        ret = self->newhelpChirpIup_downXYZ(self.point_to_down_z,tauind)
        zdown = ret.i & szdown = ret.si

;031708
;ADJUST ERROR BARS BASED ON THE ACTUAL NUMBER OF POINTS USED TO 
;COMPUTE THE AVERAGE VALUES 
if tavestate eq 1 then begin
  sxdown = sxdown/sqrt(nContrib[0,*])
  sxup = sxup/sqrt(nContrib[1,*])
  sydown = sydown/sqrt(nContrib[2,*])
  syup = syup/sqrt(nContrib[3,*])
  szdown = szdown/sqrt(nContrib[4,*])
  szup = szup/sqrt(nContrib[5,*])
endif



        xx = (xup-xdown)/(self.p*self.eff_bpw*(self.f+1.0))
        sxx = sqrt(sxup^2.0 + sxdown^2.0)/(self.p*self.eff_bpw*(self.f+1.0))
        yy = (yup-ydown)/(self.p*self.eff_bpw*(self.f+1.0))
        syy = sqrt(syup^2.0 + sydown^2.0)/(self.p*self.eff_bpw*(self.f+1.0))
        zz =(zup-zdown)/(self.p*self.eff_bpw*(self.f+1.0))
        szz = sqrt(szup^2.0 + szdown^2.0)/(self.p*self.eff_bpw*(self.f+1.0))

;;121405
;
        SC4 = 4.0*zz - 2.0*xx - 2.0*yy
        sSC4 = sqrt((2.0*sxx)^2.0 + (2.0*syy)^2.0 +(4.0*szz)^2.0)


        ;
        ;SINCE WE ONLY DEAL WITH Idown-Iup IN THE CALCULATIONS NORMALLY,
        ;I CAN STORE THE TOTAL MAGNETIC NORMALIZATION FACTOR IN THE
        ;Iup OR Idown VARIABLES.
        ;
        ;THE ONLY ISSUE I CAN SEE HERE IS THAT ooDisplayEcho MAY REQUIRE
        ;BOTH Idown AND Iup.
        ;
        ;

        MagInt = SC4/2.0
        sMagInt = sSC4/2.0

        ;if result lt 0.0 then result = -1.0*result
        yout = self->newchirpOffset(tauind) + MagInt/2.0  ;IN ooecho__define.pro

        syout = sMagInt/2.0


    endelse

    (*self.Idown)[*,tauind] = yout
    Idown = yout
    (*self.sIdown)[*,tauind] = syout
    sIdown = syout

    return,yout
end;newchirpIdownmag
function ooEchoMagnetic::newchirpIupmag,tauind,iup=iup,siup=siup,tavestate=tavestate
;
;NAME:
;        ooEchoMagnetic::newchirpIup
;
;PURPOSE:
;           Return the Iup (flipper off) value
;PARAMETERS:
;           xind
;           yind
;           tauind
;KEYWORDS:
;           none
;RETURN VALUE:
;       The Iup (flipper off) value at this pixel

;
;NAME:
;        ooEchoMagnetic::newchirpIdownmag
;
;PURPOSE:   Calculate the Idown (F_on) values and their error bars and
;           store them in the
;
;PARAMETERS:
;       tauind
;KEYWORDS:
;       none
;RETURN VALUE:
;           The flipper on value.


;NEW STUFF FOR ARRAY-IZING;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
s = (*self.emask)[*,*,tauind]
s = reform(s,self.x_dim*self.y_dim,self.no_of_phases)

;GET THE 1D MASK
tmask = (*self.mask1d)[*,tauind]


;TOTAL ARRAY
tarr = fltarr(self.x_dim*self.y_dim)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;1) GET tAve state:
    if n_elements(tavestate) eq 0 then tavestate = self->report_timeaverage_state()
;2) Get masking in t direction for each pixel used
;    if tavestate eq 1 then begin
;      print,'ooEchoMagnetic::chirpIdown'
;      help,*self.e
;      help,*self.emask      
;    endif
  
;3) Create a t-averaged Iup value
;4) Calculate the error bars properly based on the 
;number of pixels actually used.  


    nContrib = self->newgetNumberOfUpDownContributingPoints(tauind,tavestate=tavestate)

    

    if self.magnetic eq 0 then begin
      ;THEN THIS IS CALCULATED ELSEWHERE ------ WHERE??????
    endif else begin    ;MAGNETIC

        ;print,'INSERT MAGNETIC Idown CODE HERE.'
        ;print,'PROBABLY THIS WILL JUST SET THE VALUE TO 0.0, BUT WE WILL SEE.'

        ;print,'PLACE MAGNETIC yup CODE HERE FOR ooEchoMagnetic::chirpIup'
        arr = [ self.point_to_up_x,$
                self.point_to_up_y,$
                self.point_to_up_z,$
                self.point_to_down_x,$
                self.point_to_down_y,$
                self.point_to_down_z $
                    ]
        steps  = arr[sort(arr)]

        ;print,'x_up'
        ret = self->newhelpChirpIup_downXYZ(self.point_to_up_x,tauind) ; arrayize this
        xup = ret.i & sxup = ret.si
        ;print,'x_down'
        ret = self->newhelpChirpIup_downXYZ(self.point_to_down_x,tauind)
        xdown = ret.i & sxdown = ret.si

        ;print,'y_up'
        ret = self->newhelpChirpIup_downXYZ(self.point_to_up_y,tauind)
        yup = ret.i & syup = ret.si
        ;print,'y_down'
        ret = self->newhelpChirpIup_downXYZ(self.point_to_down_y,tauind)
        ydown = ret.i & sydown = ret.si

        ;print,'z_up'
        ret = self->newhelpChirpIup_downXYZ(self.point_to_up_z,tauind)
        zup = ret.i & szup = ret.si
        ;print,'z_down'
        ret = self->newhelpChirpIup_downXYZ(self.point_to_down_z,tauind)
        zdown = ret.i & szdown = ret.si

;031708
;ADJUST ERROR BARS BASED ON THE ACTUAL NUMBER OF POINTS USED TO 
;COMPUTE THE AVERAGE VALUES 
if tavestate eq 1 then begin
  sxdown = sxdown/sqrt(nContrib[0,*])
  sxup = sxup/sqrt(nContrib[1,*])
  sydown = sydown/sqrt(nContrib[2,*])
  syup = syup/sqrt(nContrib[3,*])
  szdown = szdown/sqrt(nContrib[4,*])
  szup = szup/sqrt(nContrib[5,*])
endif



        xx = (xup-xdown)/(self.p*self.eff_bpw*(self.f+1.0))
        sxx = sqrt(sxup^2.0 + sxdown^2.0)/(self.p*self.eff_bpw*(self.f+1.0))
        yy = (yup-ydown)/(self.p*self.eff_bpw*(self.f+1.0))
        syy = sqrt(syup^2.0 + sydown^2.0)/(self.p*self.eff_bpw*(self.f+1.0))
        zz =(zup-zdown)/(self.p*self.eff_bpw*(self.f+1.0))
        szz = sqrt(szup^2.0 + szdown^2.0)/(self.p*self.eff_bpw*(self.f+1.0))

;;121405
;
        SC4 = 4.0*zz - 2.0*xx - 2.0*yy
        sSC4 = sqrt((2.0*sxx)^2.0 + (2.0*syy)^2.0 +(4.0*szz)^2.0)


        ;
        ;SINCE WE ONLY DEAL WITH Idown-Iup IN THE CALCULATIONS NORMALLY,
        ;I CAN STORE THE TOTAL MAGNETIC NORMALIZATION FACTOR IN THE
        ;Iup OR Idown VARIABLES.
        ;
        ;THE ONLY ISSUE I CAN SEE HERE IS THAT ooDisplayEcho MAY REQUIRE
        ;BOTH Idown AND Iup.
        ;
        ;

        MagInt = SC4/2.0
        sMagInt = sSC4/2.0

        ;if result lt 0.0 then result = -1.0*result
        yout = self->newchirpOffset(tauind) - MagInt/2.0  ;IN ooecho__define.pro
        syout = sMagInt/2.0

    endelse

    (*self.Iup)[*,tauind] = yout
    iup = yout
    (*self.sIup)[*,tauind] = syout
    siup = syout
    
    return,yout
end;newchirpIupMag

;SEE ooechomagnetic__bin.pro FOR THIS METHOD.
;
;THIS MUST BE A MAGNETIC METHOD SINCE THE extensions POINTER IS NOT AVAILABLE IN THE ooEcho CLASS!!!!!! 


;
;pro ooEcho::checkAndUpdateExtensionsPtr,deepMaskFile=deepMaskFile,$    
;                                        deepMaskSwitch=deepMaskSwitch,$
;                                        parray=parray,$
;                                        farray=farray,$
;                                        eff_bpwarray=eff_bpwarray,$
;                                        xyzupdownscalearrayptr=xyzupdownscalearrayptr,$
;                                        mask1dpixels=mask1dpixels,$
;                                        tavestate=tavestate,$
;                                        _Extra=extra
;
;;
;;PURPOSE:  TO UPDATE THE EXTENSIONS POINTER TO THE CURRENT FORMAT TO ENSURE BACKWARD COMPATIBILITY.
;
;SEE ooechomagnetic__bin.pro FOR THIS METHOD.
;

pro ooEcho::newCalcChirpIupIdown,tauind = tauind,Iup=Iup,Idown=Idown,hydrogenated=hydrogenated,_Extra=extra
    ;print,'IS THE CALCULATION REALLY THIS SIMPLE???'
    ;print,'WHAT ABOUT MASKED DATA?'
    ;print,'WHAT ABOUT TIME AVERAGING?'
    ;TIME AVERAGED SETS SHOULD BE FINE SINCE THE AVERAGED DATA IS PLACED IN ALL THE UpDown VALUES.
 
    
    ;I BELIEVE THESE ARE COVERED NOW.
    ;print,'WHAT ABOUT xyzUp/Down FOR MAGNETIC SCANS? THIS DEFINITELY DOES NOT INCLUDE THAT!!!!!'
    ;print,'WHAT ABOUT deep masking?????'

catch, catchError
if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'NSE Reduction: Error encountered'
    eMsg = 'An error or unusual condition was encountered at ooEcho::newCalcChirpIupIdown!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = dialog_message(/error,eMsg,title=eTitle)
    catch, /cancel
    return
endif



    self->checkAndUpdateExtensionsPtr
    

    ;print,'deepmasking? = ',(*self.extensions).deepMaskSwitch
    ;
    ;print,'tavestate ?= ',(*self.extensions).tavestate
    tavestate = self->report_timeaverage_state()
    if n_elements(hydrogenated) eq 0 then hydrogenated = 0

;    print,''
;    print,'See ::read() in ooechomagnetic__bin.pro'
;    print,'See ::calculateIup_downVals in ooEcho__define.pro which calls ::chirpIup, ::chirpIdown ----'
;    print,'  ::chirpIup, ::chirpIdown take care of the magnetic/non-magnetic choice.  ' 
    
    
    
    ;CHECK Tave STATE FOR ONE PIXEL AND ASSUME THE BEST.
    ;NOTE: CHECK ooEchoMagnetic__bin ::checkExtensions 
    ;
    ;THE Tave state COULD EASILY BE STORED THERE!!!!!!!!
    
    if n_elements(tauind) eq 0 then begin
      for tauind = 0,self.no_of_fourier_times-1 do begin
        if self.magnetic eq 0 then begin
          duh = self->newchirpIdown(tauind,Idown=Idown,sIdown=sIdown)
          duh = self->newchirpIup(tauind,Iup=Iup,sIup=sIup)
          
          ;CHECK CENTRAL PIXEL FOR NOW FOR HYDROGENATED
          if Iup[self.x_dim/2 + (self.y_dim/2)*self.x_dim] gt Idown[self.x_dim/2 + (self.y_dim/2)*self.x_dim] then hydrogenated = 1
          (*self.extensions).hydrogenated = hydrogenated
        endif else begin
          duh = self->newchirpIdownMag(tauind,Idown=Idown,sIdown=sIdown)
          duh = self->newchirpIupMag(tauind,Iup=Iup,sIup=sIup)
        endelse
      endfor;tauind
      self.IupdownSwitch = 1  
    endif else begin
        if self.magnetic eq 0 then begin
          duh = self->newchirpIdown(tauind,Idown=Idown,sIdown=sIdown)
          duh = self->newchirpIup(tauind,Iup=Iup,sIup=sIup)

          ;CHECK CENTRAL PIXEL FOR NOW FOR HYDROGENATED
          if Iup[self.x_dim/2 + (self.y_dim/2)*self.x_dim] gt Idown[self.x_dim/2 + (self.y_dim/2)*self.x_dim] then hydrogenated = 1
          (*self.extensions).hydrogenated = hydrogenated
        endif else begin
          duh = self->newchirpIdownMag(tauind,Idown=Idown,sIdown=sIdown)
          duh = self->newchirpIupMag(tauind,Iup=Iup,sIup=sIup)
        endelse
      self.IupdownSwitch = 1  
    endelse
end;ooEcho::newCalcChirpIupIdown


