; $Id$

;LRK - 12/08/09
;
;DEFINE A NEW PROGRESS WIDGET THAT CHECKS FOR THE STOP BUTTON AND
;IS AN OBJECT
;
;SET UP IN PROGRESS BAR AND TEXT WIDGET COUNTDOWN MODES
;
;LRK - 09/03/10
;
;
;





function nse_cwo_progress_class::checkstop

CATCH, Error_status
IF Error_status NE 0 THEN BEGIN
    help,/traceback
    void = dialog_message('Problem in CheckStop: turning off stopping.')
    self.noCheck = 1
    CATCH, /CANCEL
    return,mask
ENDIF


  ret = 0
;  if self.noCheck le 0 then begin
;        stopbutton = self.stopbutton
;        
;        if widget_info(self.tlb,/valid_id) gt 0 then begin
;          tlb = self.tlb
;      ;help,self.tlb
;          ;event = widget_event(self.tlb,/nowait)
;          event = widget_event(tlb,/nowait)
;          
;          if event.id eq stopbutton or self.stopped eq 1 then ret = 1
;          f0 = (*self.fields)[0]
;          if self.stopped eq 1 then widget_control,f0,set_value='STOPPED BY USER'
;          
;          self.stopped = 0  ;THIS IS TO CLEAR THE EVENT.
;          self.live = 1
;        endif else begin
;          self.stopped = 1
;          self.live = 0
;        endelse
;  endif;nocheck

  return,ret

end;nse_cwo_progress_class::checkStop

pro nse_cwo_progress_class::step,index,increment=increment
  ;index is the field index to increment
  if n_elements(index) eq 0 then return
  
  if index ge 0 and index lt n_elements(*self.fields) then begin
    if n_elements(increment) eq 0 then increment = (*self.steps)[index]

    (*self.values)[index] = (*self.values)[index] + increment

    value=strtrim(string((*self.values)[index]),2)+'/'+strtrim(string((*self.endvalues)[index]),2)
    widget_control,(*self.fields)[index],set_value=value

  endif 
  
end;nse_cwo_progress_class::step
pro nse_cwo_progress_class::set,index,value
  ;index is the field index to increment
  if n_elements(index) eq 0 then return
  
  if index ge 0 and index lt n_elements(*self.fields) then begin
  
    (*self.values)[index] = value
    
    myvalue=strtrim(string((*self.values)[index]),2)+'/'+strtrim(string((*self.endvalues)[index]),2)
    widget_control,(*self.fields)[index],set_value=myvalue
    
  endif 

end;nse_cwo_progress_class::set

pro nse_cwo_progress_class::getProperty,title=title,$
                                labels=labels,$
                                values=values,$
                                startvalues=startvalues,$
                                endvalues=endvalues,$
                                steps=steps,$
                                stopped=stopped,$
                                dialog_parent=dialog_parent,$
                                group_leader=group_leader,$ 
                                xoffset=xoffset,yoffset=yoffset,$ 
                                tlb=tlb
                               
  title = self.title
  values = *self.values
  steps = *self.steps
  tlb = self.tlb
  stopped = self.stopped

end;nse_cwo_progress_class::getProperty
pro nse_cwo_progress_class::setProperty,title=title,$
                                labels=labels,$
                                values=values,$
                                startvalues=startvalues,$
                                endvalues=endvalues,$
                                steps=steps,$
                                stopped=stopped,$
                                dialog_parent=dialog_parent,$
                                group_leader=group_leader,$ 
                                xoffset=xoffset,yoffset=yoffset,$ 
                                tlb=tlb


                               
end;nse_cwo_progress_class::setProperty
pro nse_cwo_progress_class::event,event
  print,'nse_cwo_progress_class::event'
  if event.id eq self.stopbutton then self.stopped = 1
end;nse_cwo_progress_class::event
pro nse_cwo_progress_event,event
  print,'nse_cwo_progress_event'
  widget_control,event.handler,get_uvalue=obj
  obj->event,event
end;nse_cwo_progress_event
pro nse_cwo_progress_class::cleanup

  print,'nse_cwo_progress_class::cleanup'
  
  widget_control,self.tlb,/destroy
  if ptr_valid(self.textWidgets) then ptr_free,self.textWidgets
  if ptr_valid(self.textLabels) then ptr_free,self.textLabels
  if ptr_valid(self.values) then ptr_free,self.values

  if ptr_valid(self.fields) then ptr_free,self.fields
  if ptr_valid(self.startvalues) gt 0 then ptr_free,self.startvalues
  if ptr_valid(self.endvalues) gt 0 then ptr_free,self.endvalues

end;nse_cwo_progress_class::cleanup
pro nse_cwo_progress_cleanup,id
  widget_control,id,get_uvalue=obj
  obj_destroy,obj
end;nse_cwo_progress_cleanup
function nse_cwo_progress_class::init,title=title,$
                                labels=labels,$
                                values=values,$
                                startvalues=startvalues,$
                                endvalues=endvalues,$
                                steps=steps,$                                
                                dialog_parent=dialog_parent,$      ;FOR LOCATION AND group_leader
                                group_leader=group_leader,$ 
                                xoffset=xoffset,yoffset=yoffset,$  ;FOR LOCATION 
                                tlb=tlb,$
                                nostop=nostop,$
                                xsize=xsize
                                

  if n_elements(nostop) eq 0 then nostop = 0                                
  if n_elements(dialog_parent) ne 0 then begin
    if widget_info(dialog_parent,/valid_id) gt 0 then begin
      geom = widget_info(dialog_parent,/geometry)
      myxoffset = geom.xoffset + geom.xsize/2 - 100
      myyoffset = geom.yoffset + geom.ysize/2 - 100
    endif else begin
      device,get_screen_size=sz 
      myxoffset = sz[0]/2 - 50 
      myyoffset = sz[1]/2 - 50 
    endelse
  endif else begin
      device,get_screen_size=sz 
      myxoffset = sz[0]/2 - 50 
      myyoffset = sz[1]/2 - 50 
  endelse
  if n_elements(xoffset) eq 0 then xoffset = myxoffset
  if n_elements(yoffset) eq 0 then yoffset = myyoffset

  ;n element array
  if n_elements(endvalues) eq 0 then myendvalues = lonarr(1)+1 else myendvalues = endvalues
  if ptr_valid(self.endvalues) gt 0 then ptr_free,self.endvalues
  self.endvalues = ptr_new(myendvalues)
  sz = size((*self.endvalues))

  ;n element array
  if n_elements(startvalues) eq 0 then mystartvalues = lonarr(n_elements(myenddvalues))+1 else mystartvalues = startvalues
  if ptr_valid(self.startvalues) gt 0 then ptr_free,self.startvalues
  self.startvalues = ptr_new(mystartvalues)
  sz = size((*self.startvalues))


  ;n element array
  if n_elements(values) eq 0 then myvalues = lonarr(n_elements(myendvalues)) else myvalues = values
  if ptr_valid(self.values) gt 0 then ptr_free,self.values
  self.values = ptr_new(myvalues)
  sz = size((*self.values))



  if n_elements(steps) eq 0 then mysteps = lonarr(n_elements(values)) + 1 else mysteps = steps
  if ptr_valid(self.steps) gt 0 then ptr_free,self.steps
  self.steps = ptr_new(mysteps)


  ;n labels
  if n_elements(Labels) eq 0 then mytextLabels = ['Index'] else mytextLabels = labels
  if n_elements(mytextlabels) ne n_elements(myendvalues) then $
                mytextlabels = 'Index '+strtrim(string(lindgen(n_elements(myendvalues))),2)
  if ptr_valid(self.textLabels) gt 0 then ptr_free,self.textLabels
  self.textLabels = ptr_new(mytextLabels)

  
  if n_elements(title) eq 0 then title = 'COUNTDOWN:   '
  self.title = title

  if n_elements(xsize) eq 0 then xsize = 50+10*strlen(title) 

  

  ;CREATE THE WIDGET
  
  tlb = widget_base(title=title,/column,$;group_leader = dialog_parent,$  ;GROUP_LEADER NOT ALLOWED IN SOME CASES WHERE THIS IS USED.
                    ;kill_notify = 'nse_cwo_progress_cleanup',$           ;SEEMS TO BE OS DEPEDENT.
                    uvalue=self,xoffset=xoffset,yoffset=yoffset,$
                    xsize=xsize,tlb_frame_attr=1);8)
  self.tlb = tlb
  fields = lonarr(sz[1])

  for i=0,n_elements(fields)-1 do begin
    thistitle=(*self.textLabels)[i]
    fields[i] = cw_field(self.tlb,$
                                value=strtrim(string((*self.values)[i]),2)+'/'+strtrim(string((*self.endvalues)[i]),2),$
                                title=thistitle,$
                                /row,$
                                /noedit)
  endfor;i

  if ptr_valid(self.fields) gt 0 then ptr_free,self.fields
  self.fields = ptr_new(fields)

  if nostop eq 0 then self.stopbutton = widget_button(self.tlb,value='STOP',xsize = 300) else self.stopbutton = -1L
  self.stopped = 0
  self.live = 1
  self.noCheck = -1
  
  
  widget_control,self.tlb,/realize
  xmanager,'nse_cwo_progress',tlb,/no_block,event_handler='nse_cwo_progress_event',cleanup='nse_cwo_progress_cleanup'

  return,1
end;nse_cwo_progress::init

pro nse_cwo_progress_class__define,class

  class = {nse_cwo_progress_class,$
            tlb:0L,$
            textWidgets:ptr_new(),$
            textLabels:ptr_new(),$
            fields:ptr_new(),$
            nocheck:0,$
            xoffset:0,$
            yoffset:0,$
            stopButton:0L,$            
            stopped:0,$            
            live:0,$
            title:'',$
            values:ptr_new(),$
            startvalues:ptr_new(),$
            endvalues:ptr_new(),$
            steps:ptr_new()}

end;nse_cwo_progress_class__define

;function nse_cwo_progress,title=title,$
;                          labels=labels,$
;                          values=values,$
;                          startvalues=startvalues,$
;                          endvalues=endvalues,$
;                          steps=steps,$                                
;                          dialog_parent=dialog_parent,$      ;FOR LOCATION AND group_leader
;                          group_leader=group_leader,$ 
;                          xoffset=xoffset,yoffset=yoffset,$
;                          obj=obj,nostop=nostop,$
;                          tlb=tlb,$
;                          xsize=xsize,$
;                          _Extra=extra 
;
;  obj = obj_new('nse_cwo_progress_class',title=title,$
;                                  labels=labels,$
;                                  values=values,$
;                                  startvalues=startvalues,$
;                                  endvalues=endvalues,$
;                                  steps=steps,$                                
;                                  dialog_parent=dialog_parent,$
;                                  group_leader=group_leader,$ 
;                                  xoffset=xoffset,yoffset=yoffset,$
;                                  tlb=tlb,nostop=nostop,$
;                                  xsize=xsize,$
;                                  _Extra=extra)
;
;  return,tlb
;
;end;nse_cwo_progress                          
;pro test_nse_cwo_progress
;
;
;  endvalues=[1000L,2000L,3000L]
;  duh = nse_cwo_progress(labels=['A:','2:','d    :'],$
;                         startvalues=[0,0,0],$
;                         endvalues=endvalues,$
;                         values=[0,0,0L],$
;                         steps=[1L,1,1],$
;                         obj=obj)
;
;  progressstopped = 0
;  for i=0L,endvalues[0] do begin 
;    for j=0L,endvalues[1] do begin 
;      for k=0L,endvalues[2] do begin 
;        obj->set,0,i
;        obj->set,1,j
;        obj->step,2
;        progressstopped=obj->checkStop()
;        if progressstopped eq 1 then break
;      endfor;k
;      if progressstopped eq 1 then break 
;    endfor;j
;    if progressstopped eq 1 then break 
;  endfor;i
;
;  if obj_valid(obj) gt 0 then obj_destroy,obj
;end;test_nse_cwo_progress




function nse_cwo_progress,title=title,$
                          labels=labels,$
                          values=values,$
                          startvalues=startvalues,$
                          endvalues=endvalues,$
                          steps=steps,$                                
                          dialog_parent=dialog_parent,$      ;FOR LOCATION AND group_leader
                          group_leader=group_leader,$ 
                          xoffset=xoffset,yoffset=yoffset,$
                          obj=obj,nostop=nostop,$
                          tlb=tlb,$
                          xsize=xsize,$
                          _Extra=extra 

  obj = obj_new('nse_cwo_progress_class',title=title,$
                                          labels=labels,$
                                          values=values,$
                                          startvalues=startvalues,$
                                          endvalues=endvalues,$
                                          steps=steps,$                                
                                          dialog_parent=dialog_parent,$
                                          group_leader=group_leader,$ 
                                          xoffset=xoffset,yoffset=yoffset,$
                                          tlb=tlb,nostop=nostop,$
                                          xsize=xsize,$
                                          _Extra=extra)

  return,tlb

end;nse_cwo_progress                          
pro test_nse_cwo_progress


  endvalues=[1000L,2000L,3000L]
  duh = nse_cwo_progress(labels=['A:','2:','d    :'],$
                         startvalues=[0,0,0],$
                         endvalues=endvalues,$
                         values=[0,0,0L],$
                         steps=[1L,1,1],$
                         obj=obj)

  progressstopped = 0
  for i=0L,endvalues[0] do begin 
    for j=0L,endvalues[1] do begin 
      for k=0L,endvalues[2] do begin 
        obj->set,0,i
        obj->set,1,j
        obj->step,2
        progressstopped=obj->checkStop()
        if progressstopped eq 1 then break
      endfor;k
      if progressstopped eq 1 then break 
    endfor;j
    if progressstopped eq 1 then break 
  endfor;i

  if obj_valid(obj) gt 0 then obj_destroy,obj
end;test_nse_cwo_progress

