; $Id$
;###############################################################################
;
;FILENAME:
;nse_createvar.pro
;
;PURPOSE:
;
;CATEGORY:
;
;
;METHODS IN FILE:
;
;    NSE_createvar
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Jan 24,2005
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used of if the code in this file is
; included in another product.
;
;###############################################################################


;PROGRAM TO PUT VALUES INTO MEMBER VARIABLES IN AN ECHO OBJECT.

pro NSE_createvar,obj,tag,data
;
;NAME:
;        NSE_createvar
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.


    case tag of
    'filename':begin
        obj->setproperty,tag,data
    end
    'workdir':begin
        obj->setproperty,tag,data
    end
    'datadir':begin
        obj->setproperty,tag,data
    end
    'type':begin
        obj->setproperty,tag,data
    end
    'reduced':begin
        obj->setproperty,tag,data
    end
    'reducedOld':begin
        obj->setproperty,tag,data
    end
    'e':begin
        ;print,tag
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'emask':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'eorig':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'mask2d':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'fitdisplaymask':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'mask1d':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'lambda':begin
        obj->setproperty,tag,data
    end
    'dlambda':begin
        obj->setproperty,tag,data
    end
    'comment':begin
        obj->setproperty,tag,data
    end
    'fixed':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'fitparms':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'fitparmsOld':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'chisq':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'chisqOld':begin
        ;print,'nse_createvar   line 88'
        ;help,data
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'Iup':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'Idown':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'sIup':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'sIdown':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'IupdownSwitch':begin
        obj->setproperty,tag,data
    end
    'S':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'sS':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'IQTInfo':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'IQT':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'sIQT':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'QVals':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'QValsSwitch':begin
        obj->setproperty,tag,data
    end
    'narcs':begin
        obj->setproperty,tag,data
    end
    'qarcs':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'phase':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'currentPhaseIndex':begin
        obj->setproperty,tag,data
    end
    'meters':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'counters':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'monitors':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'preset':begin
        obj->setproperty,tag,data
    end
    'no_of_phases':begin
        obj->setproperty,tag,data
    end
    'point_to_down':begin
        obj->setproperty,tag,data
    end
    'point_to_up':begin
        obj->setproperty,tag,data
    end
    'phase_step':begin
        obj->setproperty,tag,data
    end
    'no_of_fourier_times':begin
        obj->setproperty,tag,data
    end
    'no_of_pixels':begin
        obj->setproperty,tag,data
    end
    'beam_cen_x':begin
        obj->setproperty,tag,data
    end
    'beam_cen_y':begin
        obj->setproperty,tag,data
    end
    'transmission':begin
        obj->setproperty,tag,data
    end
    'volfrac':begin
        obj->setproperty,tag,data
    end
    'x_dim':begin
        obj->setproperty,tag,data
    end
    'y_dim':begin
        obj->setproperty,tag,data
    end
    'x_cen':begin
        obj->setproperty,tag,data
    end
    'y_cen':begin
        obj->setproperty,tag,data
    end
    'x_dim_orig':begin
        obj->setproperty,tag,data
    end
    'y_dim_orig':begin
        obj->setproperty,tag,data
    end
    'x_cen_orig':begin
        obj->setproperty,tag,data
    end
    'y_cen_orig':begin
        obj->setproperty,tag,data
    end
    'width':begin
        obj->setproperty,tag,data
    end
    'colorTable':begin
        obj->setproperty,tag,data
    end
    'q':begin
        obj->setproperty,tag,data
    end
    'qy':begin
        obj->setproperty,tag,data
    end
    'fourierTime':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'currentFourierTimeIndex':begin
        obj->setproperty,tag,data
    end
    'scanHeader':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'sampleHeader':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'techHeader':begin
            if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'physicsHeader':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'physicsParametersHeader':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'phaseHeader':begin
        if ptr_valid(obj->getproperty(tag=tag)) then $
                    ptr_free,obj->getproperty(tag=tag)
        obj->setproperty,tag,ptr_new(data)
    end
    'tags':begin
        obj->setproperty,tag,data
    end
    else:begin
        print,'createvar:  tag = '+tag+' is unknown.'
    end
    endcase

end;createvar
