; $Id$
;###############################################################################
;
;FILENAME:
;nse_createtempvar.pro
;
;PURPOSE:
;
;CATEGORY:
;
;
;METHODS IN FILE:
;
;    nse_createtempvar
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Jan 24,2005
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used of if the code in this file is
; included in another product.
;
;###############################################################################


function nse_createtempvar,tag,sz,type
;
;NAME:
;        nse_createtempvar
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.

;RETURN VALUE:
;


        iec_multimeter = {NSE_METERS_STRUCT,$
            Temperatur:0.0,$
            BSpiy:0.0,$
            BSpi21x:0.0,$
            BSpi21z:0.0,$
            BSpi22y:0.0,$
            BSpix:0.0,$
            BSpiz:0.0,$
            BSpi21y:0.0,$
            BSpi22x:0.0,$
            BSpi22z:0.0 $
            }
        monitor_struct = {NSE_MONITOR_STRUCT,m1:0.0,m2:0.0,m3:0.0}

    ;print,sz
    ;print,type

    case sz[0] of
    0:begin
        case type of
            'POINTER':begin
                tempvar = 0
            end
            'STRING':begin
                tempvar = ''
            end
            'INT':begin
                tempvar = 0
            end
            'DOUBLE':begin
                tempvar = 0.0d
            end
            'FLOAT':begin
                tempvar = 0.0
            end
            'STRUCT':begin
                if tag eq 'meters' then begin
                    tempvar = iec_multimeter
                endif else begin
                    tempvar = monitor_struct
                endelse
            end
            'LONG':begin
                tempvar = 0L
            end
            else:begin
                tempvar = ''    ;READ IN A LINE OF 'DATA'
            end
        endcase
    end        ;0
    1:begin
        case type of
            'POINTER':begin    ;CAN'T HAVE A SAVED PTRARR.
                tempvar = 0
            end
            'STRING':begin
                tempvar = strarr(sz[1])
            end
            'INT':begin
                tempvar = intarr(sz[1])
            end
            'DOUBLE':begin
                tempvar = dblarr(sz[1])
            end
            'FLOAT':begin
                tempvar = fltarr(sz[1])
            end
            'STRUCT':begin
                if tag eq 'meters' then begin
                    tempvar=replicate(iec_multimeter,sz[1])
                endif else begin
                    tempvar=replicate(monitor_struct,sz[1])
                endelse
            end
            'LONG':begin
                tempvar = lonarr(sz[1])
            end
        endcase
    end        ;1
    2:begin
        case type of
            'POINTER':begin    ;CAN'T HAVE A SAVED POINTER ARRAY
                tempvar = 0
            end
            'STRING':begin
                tempvar = strarr(sz[1],sz[2])
            end
            'INT':begin
                tempvar = intarr(sz[1],sz[2])
            end
            'DOUBLE':begin
                tempvar = dblarr(sz[1],sz[2])
            end
            'FLOAT':begin
                tempvar = fltarr(sz[1],sz[2])
            end
            'STRUCT':begin
                if tag eq 'meters' then begin
                    tempvar=replicate(iec_multimeter,sz[1],sz[2])
                endif else begin
                    tempvar=replicate(monitor_struct,sz[1],sz[2])
                endelse
            end
            'LONG':begin
                tempvar = lonarr(sz[1],sz[2])
            end
        endcase
    end        ;2
    3:begin
        case type of
            'POINTER':begin
                tempvar = 0
            end
            'STRING':begin
                tempvar = strarr(sz[1],sz[2],sz[3])
            end
            'INT':begin
                tempvar = intarr(sz[1],sz[2],sz[3])
            end
            'DOUBLE':begin
                tempvar = dblarr(sz[1],sz[2],sz[3])
            end
            'FLOAT':begin
                tempvar = fltarr(sz[1],sz[2],sz[3])
            end
            'STRUCT':begin
                if tag eq 'meters' then begin
                    tempvar=replicate(iec_multimeter,sz[1],sz[2],sz[3])
                endif else begin
                    tempvar=replicate(monitor_struct,sz[1],sz[2],sz[3])
                endelse
            end
            'LONG':begin
                tempvar = lonarr(sz[1],sz[2],sz[3])
            end
        endcase
    end        ;3
    4:begin
        case type of
            'POINTER':begin
                tempvar = 0
            end
            'STRING':begin
                tempvar = strarr(sz[1],sz[2],sz[3],sz[4])
            end
            'INT':begin
                tempvar = intarr(sz[1],sz[2],sz[3],sz[4])
            end
            'DOUBLE':begin
                tempvar = dblarr(sz[1],sz[2],sz[3],sz[4])
            end
            'FLOAT':begin
                tempvar = fltarr(sz[1],sz[2],sz[3],sz[4])
            end
            'STRUCT':begin
                if tag eq 'meters' then begin
                    tempvar=replicate(iec_multimeter,sz[1],sz[2],sz[3],sz[4])
                endif else begin
                    tempvar=replicate(monitor_struct,sz[1],sz[2],sz[3],sz[4])
                endelse
            end
            'LONG':begin
                tempvar = lonarr(sz[1],sz[2],sz[3],sz[4])
            end
        endcase
    end        ;4
    endcase;sz[0]


    return,tempvar
end;createtempvar
