; $Id$
;###############################################################################
;
;
;CLASS NAME:
;    cwo_displayIQT_improved_class
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;    idl_container
;
;
;METHODS:
;    cwo_displayIQT_improved_event
;    cwo_displayIQT_improved_class::event
;    cwo_displayIQT_improved_class::openObject
;    cwo_displayIQT_improved_class::setData
;    cwo_displayIQT_improved_class::resize
;    cwo_displayIQT_improved_class::stepCurve
;    cwo_displayIQT_improved_class::addData
;    cwo_displayIQT_improved_class::displayHelp
;    cwo_displayIQT_improved_class::quit
;    cwo_displayIQT_improved_class::draw
;    cwo_displayIQT_improved_class::setproperty
;    cwo_displayIQT_improved_class::getproperty
;    cwo_displayIQT_improved_cleanup
;    cwo_displayIQT_improved_class::cleanup
;    cwo_displayIQT_improved_class::init
;    cwo_displayIQT_improved_class__define
;    cwo_displayIQT_improved
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Thu Nov 09 23:24:21 2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################
;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_displayIQT_improved_event,event
    widget_control,event.handler,get_uvalue=obj

    ret = obj->event(event)

    return,ret
    ;DO I HAVE TO PASS THIS EVENT DIRECTLY TO THE PARENT SOMEHOW??????
end;cwo_displayIQT_improved_event
;###############################################################################
;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_class::event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_displayIQT_improved_class::event,event

case event.id of
  self.quitbutton:begin
      self->quit
  end;quitbutton

  self.openbutton:begin
      self->openObject
  end;openbutton

  self.helpbutton:begin
      self->displayHelp
  end;helpbutton

  self.rangeWidget:begin
      ;UPDATE RANGES
      dum = self.rangeWidgetObj->getvalues(xmin=xmin,ymin=ymin,$
                                           xmax=xmax,ymax=ymax,$
                                           xlog=xlog,ylog=ylog)
  
      self.drawplotobj->setValues,xmin=xmin,ymin=ymin,$
                                  xmax=xmax,ymax=ymax,$
                                  xlog=xlog,ylog=ylog
  end;rangeWidget

  self.drawplot:begin
  
      ;UPDATE RANGES
      self.drawplotobj->retrieveDataRanges,xmin=xmin,xmax=xmax,$
                                           ymin=ymin,ymax=ymax,$
                                           xlog=xlog,ylog=ylog
      self.rangeWidgetObj->setvalues,xmin=xmin,ymin=ymin,$
                                     xmax=xmax,ymax=ymax,$
                                     xlog=xlog,ylog=ylog
  
  end;draplot

  self.stepCurveButton:begin
      self->stepCurve
  
  end;stepcurvebutton

  self.writeToDaveButton:begin
      count = self->count()
      if count ne 0 then begin
          ref = self->get(position=0)
          workdir = self.workdir
          dum = ref[0]->writeDave(work_dir=workdir,group_leader=self.tlb)
          if n_elements(workdir) ne 0 then self.workdir = workdir
      endif
  end;writetodavebutton

  self.exportToDAVEDM:begin
    count = self->Count()
    if count ne 0 then begin
      ref = self->Get(position=0)
      workdir = self.workdir
      dum = ref[0]->Writedave(work_dir=workdir,group_leader=self.tlb,/exportToDAVEDM,DAVETool=Self.DAVETool)
      if N_elements(workdir) ne 0 then self.workdir = workdir
    endif
  end;exportToDAVEDM

  self.fitInPAN:begin
    count = self->Count()
    if count ne 0 then begin
      ref = self->Get(position=0)
      workdir = self.workdir
      dum = ref[0]->Writedave(work_dir=workdir,group_leader=self.tlb,/fitInPAN,DAVETool=Self.DAVETool)
      if N_elements(workdir) ne 0 then self.workdir = workdir
    endif
  end;fitInPAN

  self.writeASCIIFiles:begin
      count = self->count()
      if count ne 0 then begin
          ref = self->get(position=0)
          workdir = self.workdir
          dum = ref[0]->writeIQTIgor(work_dir=workdir,group_leader=self.tlb)
          if n_elements(workdir) ne 0 then self.workdir = workdir
      endif
  end;writeASCIIFiles

  self.writeASCIIFile:begin
      count = self->count()
      if count ne 0 then begin
          ref = self->get(position=0)
          workdir = self.workdir
          ref[0]->writeIQTASCII,workdir,group_leader=self.tlb
          if n_elements(workdir) ne 0 then self.workdir = workdir
      endif
  end;writeASCIIFile

  self.write3ColASCIIFiles:begin
      count = self->count()
      if count ne 0 then begin
          ref = self->get(position=0)
          workdir = self.workdir
          ref[0]->writeIQT3ColASCII,workdir,group_leader=self.tlb
          if n_elements(workdir) ne 0 then self.workdir = workdir
      endif
  
  end;write3ColASCIIFiles

  self.printbutton:begin
      self.drawplotobj->draw,/printwin,/ps
  end;printButton

  self.closeButton:begin
      self->quit
  end;closebutton

  self.tlb:begin
      self->resize,event
  end;tlb

  else:

endcase

return,-1
end;cwo_displayIQT_improved_class::event



;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_class::openObject
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_displayIQT_improved_class::openObject,object=object


    if n_elements(object) eq 0 then begin

        ;GET ALL ooEcho REFS
        nobj = checkforobjinstance('ooecho',ref=ref,/subclass)


        if nobj gt 0 then begin


            ;SORT OUT THE REFS NOT CONTAINED IN self
            list = ['']             ;
            obj_list = [obj_new()]  ;THIS LIST WILL OMIT ANY ref CONTAINED IN SELF
            myobj = self->get(/all)
            for i=0,nobj-1 do begin

                ;GET ALL ooEcho OBJECTS, BUT OMIT THE ONE CONTAINED IN self.
                help,myobj[0],output=myout,struct=0
                help,ref[i],output=refout,struct=0

                ;print,myout,refout
                if strcmp(myout,refout) eq 0 then begin
                    filename = ref[i]->getproperty(tag='filename')
                    type = size(filename,/type)
                    if type eq 7 then begin ;string
                        ;print,file_basename(filename)
                        list = [list,file_basename(filename)]
                        obj_list = [obj_list,ref[i]]
                    endif
                endif;strcmp
            endfor;i

            ;OPEN DIALOG TO SELECT REF TO VIEW I(Q,t) FOR
            if n_elements(list) gt 1 then begin
                list = list[1:*]
                obj_list = obj_list[1:*]
                index = lk_dialog_combobox(list,title='Select data object:')
                index = index[0]
    ;    print,'index=',index
            endif else begin
                index = -1
            endelse


            ;CLEAR DATA IN self.drawplotobj AND THEN ADD THE NEW DATA
            if index ne -1 then begin

;;;;;                self.drawplotobj->cleardata

                ;FOR NOW REMOVE THE OLD OBJECT AND INSERT A NEW ONE.
                old = self->get(/all)
                self->remove,/all
                if obj_valid(old[0]) ne 0 then obj_destroy,old[0]


                ;STORE A CLONE OF THE ooEcho OBJECT SO THAT IT CAN BE USED FOR WRITING OUTPUT IF NECESSARY.
                new = obj_list[index]->clone()
                self->add,new

                self->setData,list,index

;;;;;
;;;;;                ;NOW GET THE DATA FROM THE new OBJECT
;;;;;                t = (1e9)*double((*(new->getproperty(tag='fouriertime'))))
;;;;;                q = *(new->getproperty(tag='qarcs'))
;;;;;                iqt = *(new->getproperty(tag='iqt'))
;;;;;                siqt = *(new->getproperty(tag='siqt'))
;;;;;
;;;;;                ;help,t,q,iqt,siqt
;;;;;                isz = size(iqt)
;;;;;
;;;;;                title = 'I(Q,t) for '+list[index]
;;;;;                self.drawplotobj->setproperty,title=title,xtitle='t [ns]',ytitle = 'I(Q,t)'
;;;;;
;;;;;                color  = [0L,256L*256L*255L,256L*255L,255L,256L*(255L+256L*255L),255L+256L*256L*255L]
;;;;;                symbol = [2,4,5,6,7]
;;;;;
;;;;;                for i=0,isz[1]-1 do begin   ;n_elements(q)-1 do begin
;;;;;                    ;print,q[i]
;;;;;
;;;;;                    if finite(q[i],/nan) ne 1 then begin
;;;;;                        ;print,'Adding Q='+strtrim(string(q[i],format='(g7.4)'),2)
;;;;;                        dobj = obj_new('cwo_drawplot_data',abs(t),iqt[i,*],siqt[i,*],$
;;;;;                                                           legend='Q='+strtrim(string(q[i],format='(g7.4)'),2),$
;;;;;                                                           psym=symbol[i mod n_elements(symbol)],$
;;;;;                                                           color=color[i mod n_elements(color)],$
;;;;;                                                           linestyle=0,$
;;;;;                                                           ebshow=1,$
;;;;;                                                           showlegend=1)
;;;;;                        self.drawplotobj->add,dobj
;;;;;                        self.drawplotobj->defaultdraw
;;;;;                    endif;finite
;;;;;
;;;;;                endfor;i

            endif;index ne -1
        endif ;nobj gt 0;else begin
            ;void = dialog_message('')
        ;endelse
    endif else begin    ;n_elements(object) ne 0

        ;FOR NOW REMOVE THE OLD OBJECT AND INSERT A NEW ONE.
        old = self->get(/all)
        self->remove,/all
        if obj_valid(old[0]) ne 0 then obj_destroy,old[0]


        ;STORE A CLONE OF THE ooEcho OBJECT SO THAT IT CAN BE USED FOR WRITING OUTPUT IF NECESSARY.
        new = object->clone()
        self->add,new

        list = [file_basename(object->getproperty(tag='filename'))]
        index = [0]

        self->setData,list,index


    endelse


end;cwo_displayIQT_improved_class::openObject

;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_class::setData
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_displayIQT_improved_class::setData,list,index

        self.drawplotobj->cleardata

        dataobj = self->get(/all)

        new = dataobj[0]

        ;NOW GET THE DATA FROM THE new OBJECT
        t = (1e9)*double((*(new->getproperty(tag='fouriertime'))))
        q = *(new->getproperty(tag='qarcs'))
        iqt = *(new->getproperty(tag='iqt'))
        siqt = *(new->getproperty(tag='siqt'))

        ;help,t,q,iqt,siqt
        isz = size(iqt)

        title = 'I(Q,t) for '+list[index]
        self.drawplotobj->setproperty,title=title,xtitle='t [ns]',ytitle = 'I(Q,t)'

        color  = [0L,256L*256L*255L,256L*255L,255L,256L*(255L+256L*255L),255L+256L*256L*255L]
        symbol = [2,4,5,6,7]

        for i=0,isz[1]-1 do begin   ;n_elements(q)-1 do begin
            ;print,q[i]

            if finite(q[i],/nan) ne 1 then begin
                ;print,'Adding Q='+strtrim(string(q[i],format='(g7.4)'),2)
                dobj = obj_new('cwo_drawplot_data',abs(t),iqt[i,*],siqt[i,*],$
                                                   legend='Q='+strtrim(string(q[i],format='(g7.4)'),2),$
                                                   psym=symbol[i mod n_elements(symbol)],$
                                                   color=color[i mod n_elements(color)],$
                                                   linestyle=0,$
                                                   ebshow=1,$
                                                   showlegend=1)
                self.drawplotobj->add,dobj
                self.drawplotobj->defaultdraw
            endif;finite

        endfor;i
end;setData

;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_class::resize
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_displayIQT_improved_class::resize,event,xsize=xsize,ysize=ysize
    ;print,'cwo_displayIQT_improved_class::resize'

    if n_elements(event) ne 0 then begin

        geom = widget_info(self.tlb,/geometry)
;        print,tag_names(geom)
;        print,geom.scr_xsize
;        print,geom.scr_ysize


        if !version.os eq 'Win32' then offsets = [229,59] else offsets = [229,59]
        plotxsize = geom.scr_xsize - offsets[0]
        plotysize = geom.scr_ysize - offsets[1]

        self.drawplotobj->resize,plotxsize,plotysize

    endif else begin
    endelse

end;cwo_displayIQT_improved_class::resize

;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_class::stepCurve
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_displayIQT_improved_class::stepCurve


    ;STEP THROUGH THE CURVES

    count = self.drawplotobj->count()
    if count gt 1 then begin

        ;GET ALL DATA OBJECTS IN PLOT
        data = self.drawplotobj->get(/all)
        show = intarr(count)

        ;GET THE CURRENT SHOW STATE FOR EACH DATA OBJECT
        for i = 0,count-1 do begin
            data[i]->getproperty,showdata=showdata
            show[i] = showdata
        endfor;i



        wh = where(show ne 0,wh_count)
        if wh_count gt 1 then begin

            ;THIS SWITCHES FROM ALL SHOWN TO ONE SHOWN.
            show[0] = 1
            show[1:*] = 0
            for i = 0,count-1 do begin
                data[i]->setproperty,showdata=show[i]
            endfor;i


        endif else begin

            ;TOGGLE THE SHOW STATES SO ONLY ONE SET IS SHOWN
            newshow = 0*show

            ;WHY DOES THE NEXT LINE ONLY GO TO count-2?????????

            if show[count-1] eq 0 then begin
                for i = 0,count-2 do begin
                    if show[i] eq 1 then begin
                        newshow[i+1] = 1
                        break
                    endif
                endfor;i
            endif else begin
                newshow[*] = 1
            endelse
;            wh = where(newshow ne 0,wh_count)
;            if wh_count eq 0 then newshow[*] = 1

            ;WHY DOES THE NEXT LINE ONLY GO TO count-2?????????
            for i = 0,count-1 do begin;2 do begin
                data[i]->setproperty,showdata=newshow[i]
            endfor;i
        endelse

        self.drawplotobj->draw
    endif



end;cwo_displayIQT_improved_class::stepCurve
;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_class::addData
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_displayIQT_improved_class::addData,obj
     ;obj IS THE ooEcho OBJ WITH THE I(Q,t) DATA

    ;ADD DATA IN ORDER IN THE drawPlot CONTAINER.
    self.drawplotobj->cleardata
end;cwo_displayIQT_improved_class::addData

;###############################################################################
;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_class::displayHelp
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_displayIQT_improved_class::displayHelp

    b = widget_base(group_leader=self.tlb,title='Help on Display I(Q,t)',/floating,/col)
    text = widget_text(b,xsize=60,ysize = 10)
    s = ['DisplayIQT: Written by Larry Kneller',$
         'This is used to display I(Q,t) data created in ooDisplayEcho.',$
         'This allows output to several file formats as well as basic ',$
         'visualization.',$
         '']

    widget_control,text,set_value=s

    widget_control,b,/realize


end;cwo_displayIQT_improved_class::displayHelp


;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_class::quit
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_class::quit
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_displayIQT_improved_class::quit
    widget_control,self.tlb,/destroy
end;cwo_displayIQT_improved_class::quit


;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_class::draw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_class::draw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_displayIQT_improved_class::draw
end;cwo_displayIQT_improved_class::draw

;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_class::setproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_class::setproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_displayIQT_improved_class::setproperty,tb=tlb,workdir=workdir,datadir=datadir,_Extra=extra
    if n_elements(tlb) ne 0 then self.tlb =tlb
    if n_elements(workdir) ne 0 then self.workdir = workdir
    if n_elements(datadir) ne 0 then self.datadir = datadir
end;cwo_displayIQT_improved_class::setproperty


;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_class::getproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_class::getproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_displayIQT_improved_class::getproperty,tlb=tlb,_Extra=extra

    if arg_present(tlb) ne 0 then tlb = self.tlb
end;cwo_displayIQT_improved_class::getproperty

;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_displayIQT_improved_cleanup,id
    widget_control,id,get_uvalue=obj
    obj_destroy,obj
end;cwo_displayIQT_improved_cleanup

;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_class::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_class::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_displayIQT_improved_class::cleanup
    print,'cwo_displayIQT_improved_class::cleanup'
    obj_destroy,self.rangeWidgetObj
    obj_destroy,self.drawplotobj
    o = self->get(/all)
    self->remove,/all
    if obj_valid(o[0]) ne 0 then begin
        for i=0,n_elements(o)-1 do begin
            obj_destroy,o[i]
        endfor;i
    endif

end;cwo_displayIQT_improved_class::cleanup

;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_class::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_class::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_displayIQT_improved_class::init,parent,xsize=xsize,ysize=ysize,tlb=tlb,group_leader=group_leader,$
                                  datadir=datadir,workdir=workdir,dataobject=dataobject, $
                                  DAVETool=DAVETool,_Extra=extra

    nobj = checkforobjinstance('cwo_displayIQT_improved_class',ref=ref,/subclass)
    if nobj gt 1 then begin

        ;WHICH REFERENCE DO I WANT????
        ;IF A cwo_displayIQT_improved_class OBJECT ALREADY EXISTS, THEN PUT THE DATE INTO THAT ONE,
        ;SET THE

        help,ref[0],output=out0,struct=0
        help,ref[1],output=out1,struct=0
        help,self,output=outself,struct=0
        segs0 = strsplit(out0,'ObjHeapVar',/fold_case,/regex,/extract)
        segsself = strsplit(outself,'ObjHeapVar',/fold_case,/regex,/extract)

        ;print,segs0[1],segsself[1]
        if strcmp(segs0[1],segsself[1],/fold_case) eq 0 then begin
;            print,'REF[0] selected:'
;            print,'outself=',outself
;            print,'out0=',out0
;            print,'out1=',out1

            ref[0]->getproperty,tlb=tlb
	        if n_elements(datadir) ne 0 then ref[0]->setproperty,datadir = datadir
	        if n_elements(workdir) ne 0 then ref[0]->setproperty,workdir = workdir
            if n_elements(dataobject) ne 0 then begin
                ref[0]->openObject,object=dataobject
            endif
        endif else begin
;            print,'REF[1] selected:'
;            print,'outself=',outself
;            print,'out0=',out0
;            print,'out1=',out1
            ref[1]->getproperty,tlb=tlb
	        if n_elements(datadir) ne 0 then ref[1]->setproperty,datadir = datadir
	        if n_elements(workdir) ne 0 then ref[1]->setproperty,workdir = workdir
            if n_elements(dataobject) ne 0 then begin
                ref[1]->openObject,object=dataobject
            endif
        endelse

        widget_control,tlb,/show
        return,0
    endif else begin

        if n_elements(parent) eq 0 then parent = -1L

        if n_elements(datadir) eq 0 then self.datadir = '.' else self.datadir = datadir
        if n_elements(workdir) eq 0 then self.workdir = '.' else self.workdir = workdir

        if parent ne -1L then begin
            tlb = widget_base(parent,title='Display I(Q,t) data from NSE',group_leader=parent,/row,uvalue=self,$
                                kill_notify='cwo_displayIQT_improved_cleanup')
        endif else begin
            tlb = widget_base(title='Display I(Q,t) data from NSE',group_leader=group_leader,mbar=bar,/row,uvalue=self,$
                                kill_notify='cwo_displayIQT_improved_cleanup',/tlb_size_events,/floating)
        endelse

        llb1 = widget_base(tlb,/col)
        llb2 = widget_base(tlb,/col)

        self.rangeWidget = cwo_plotrangeloglin(llb1,$
                                               obj=rwobj,$
                                               /column,$
                                               frame=2)

        self.rangeWidgetObj = rwobj


        self.drawplot = cwo_drawplot(llb2,xsize=400,ysize=400,obj=dpobj)
        self.drawplotobj = dpobj


        if n_elements(bar) ne 0 then begin
            filemenu = widget_button(bar,value='File',/menu)
            self.openbutton = widget_button(filemenu,value='Open')
            self.quitbutton = widget_button(filemenu,value='Quit')
        endif else begin
            self.openbutton = widget_button(llb1,value='Open')
            self.quitbutton = widget_button(llb1,value='Quit')
        endelse

        self.stepCurveButton = widget_button(llb1,value='Step Through Curves')
        self.writeToDaveButton = widget_button(llb1,value='Write as DAVE')
        self.writeASCIIFiles = widget_button(llb1,value='Write as IGOR (multiple files)')
        self.writeASCIIFile = widget_button(llb1,value='Write as ASCII (single file)')
        self.write3ColASCIIFiles = widget_button(llb1,value='Write as ASCII 3Col (multiple files)')
        self.exportToDAVEDM = Widget_button(llb1,value='Export to DAVE Data Manager')
        self.fitInPAN = Widget_button(llb1,value='Fit in PAN')

        self.printbutton = widget_button(llb1,value='Print Plot')

        self.helpButton  = widget_button(llb1,value='Help',$
                                              tooltip='Help on Merge I(Q,t)')

        self.closeButton = widget_button(llb1,value='Close')

        ;centertlb,tlb
        widget_control,tlb,/realize
        lk_xmanager,'cwo_displayIQT_improved',tlb,/no_block,event_func='cwo_displayIQT_improved_event'

        self.tlb = tlb
        Self.DAVETool = DAVETool

        if n_elements(dataobject) ne 0 then begin
            self->openObject,object=dataobject
        endif

        return,1
    endelse
end;init

;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_class__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved_class__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_displayIQT_improved_class__define,class

    class = {cwo_displayIQT_improved_class,$
                inherits idl_container,$
                DAVETool:obj_new(), $
                datadir:'',$
                workdir:'',$
                tlb:0L,$
                rangeWidget:0L,$
                rangeWidgetObj:obj_new(),$
                drawplot:0L,$
                drawplotobj:obj_new(),$
                quitbutton:0L,$
                stepCurveButton:0L,$
                writeToDaveButton:0L,$
                writeASCIIFiles:0L,$
                writeASCIIFile:0L,$
                write3ColASCIIFiles:0L,$
                exportToDAVEDM:0L,$
                fitInPAN:0L,$
                printbutton:0L,$
                helpButton:0L,$
                closeButton:0L,$
                openbutton:0L}

end;cwo_displayIQT_improved_class__define

;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
;###############################################################################
;
;NAME:
;        cwo_displayIQT_improved
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_displayIQT_improved,parent,obj=obj,xsize=xsize,ysize=ysize,group_leader=group_leader,$
                                 dataobject=dataobject,workdir=workdir,datadir=datadir,$
                                 DAVETool=DAVETool,_Extra=extra

    if n_elements(parent) eq 0 then parent = -1L
    obj = obj_new('cwo_displayIQT_improved_class',parent,xsize=ysize,ysize=ysize,tlb=tlb,group_leader=group_leader,$
                                                  dataobject=dataobject,workdir=workdir,datadir=datadir, $
                                                  DAVETool=DAVETool,_Extra=extra)

    ;print,tlb
    return,tlb

end;cwo_displayIQT_improved
