; $Id$
;###############################################################################
;
;
;CLASS NAME:
;        autoplotiqt
;
;PURPOSE:
;        Display and fit I(Q,t) data from the NSE reduction program.
;
;
;CATEGORY:
;       Analysis
;
;SUPERCLASSES:
;       idl_container
;
;
;METHODS:
;    autoplotIQT::create_widgets
;    autoplotIQT::clearData
;    autoplotIQT::fitData
;    autoplotIQT::draw
;    autoplotIQT::openfiles
;    autoplotIQT::writeParms
;    autoplotiqt::getproperty
;    autoplotiqt::setproperty
;    autoplotiqt_realize
;    autoplotiqt::realize
;    autoplotiqt_cleanup
;    autoplotiqt::cleanup
;    autoplotiqt_event
;    autoplotiqt::event
;    autoplotIQT::init
;    autoplotIQT__define
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Fri Oct 21 18:16:19 2005
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################

;###############################################################################
;
;NAME:
;        autoplotIQT::create_widgets
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro autoplotIQT::create_widgets,bar

    xsize = self.drawxsize
    ysize = self.drawysize

    file = widget_button(bar,/menu,value='File',uvalue=self)
    self.open = widget_button(file,value='Open',uvalue=self)
    self.cleardata = widget_button(file,value='Clear All Data',uvalue=self)
    self.export = widget_button(file,value='Export D(Q)',uvalue=self,sensitive=0)
    self.parmsexport = widget_button(file,value='Export Fit Parameters',uvalue=self)
    self.Quit = widget_button(file,value='Quit',uvalue=self)



    self.fitparmstab = widget_tab(self.tlb,uvalue=self)

    fitparmbase = widget_base(self.fitparmstab,/col,title='Starting Parameters')
    resultsbase = widget_base(self.fitparmstab,/col,title='Fit Results')

    self.resultstext = widget_text(resultsbase,xsize=30,ysize=30,$
                                        value=['Q    A0   A1   D1   B1   A2   D2   B2','None'],$
                                        uvalue=self)



    plotbase = widget_base(self.tlb,/col)


    varbase = widget_base(fitparmbase,/row)
    label = widget_label(varbase,value='x values for fit: ')
    self.xvar = widget_combobox(varbase,value=['t','Q^2*t'],uvalue=self)

    label = widget_label(fitparmbase,value='Fit/Start Parameters')
    varyfix = ['vary','fix']
    label = ['A0','A1','D1','B1','A2','D2','B2']
    value = [1.0,0.5,0.5,1.0,0.0,1.0,1.0]
    fixed = [1,0,0,0,1,1,1]
    row = lindgen(7)
    for i=0,n_elements(row)-1 do begin
        row[i] = widget_base(fitparmbase,/row)
        self.combo[i] = widget_combobox(row[i],value=varyfix,uvalue=self)
        widget_control,self.combo[i],set_combobox_select=fixed[i]
        self.field[i] = cw_field(row[i],value=value[i],title=label[i],/floating,$
                                    noedit=0,uvalue=self)

    endfor;i
    self.fit = widget_button(fitparmbase,value='Fit Available I(Q,t)',uvalue=self)

;    self.xlog = widget_button(fitparmbase,value='Log X',uvalue=self)
;    self.xmin = cw_field(fitparmbase,value=0.0,title='xmin',$
;                            /floating,uvalue=self)
;    self.xmax = cw_field(fitparmbase,value=1.0,title='xmax',$
;                            /floating,uvalue=self)
;    self.ylog = widget_button(fitparmbase,value='Log Y',uvalue=self)
;    self.ymin = cw_field(fitparmbase,value=0.0,title='ymin',$
;                            /floating,uvalue=self)
;    self.ymax = cw_field(fitparmbase,value=1.0,title='ymax',$
;                            /floating,uvalue=self)



    self.draw = widget_draw(plotbase,xsize=xsize,ysize=ysize, $
                                notify_realize='autoplotiqt_realize', $
                                uvalue=self,/button_events,/motion_events)


end;autoplotIQT::create_widgets
;###############################################################################
;
;NAME:
;        autoplotIQT::clearData
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro autoplotIQT::clearData

    n = self->count()
    for i=0,n-1 do begin
        o = self->get(position=n-i-1)
        self->remove,position=n-i-1
        obj_destroy,o
    endfor;i

end;autoplotIQT::clearData
;###############################################################################
;
;NAME:
;        autoplotIQT::fitData
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro autoplotIQT::fitData


        start = dblarr(7)
        fixed = intarr(7)
        for j=0,n_elements(start)-1 do begin
            widget_control,self.field[j],get_value=sdum
            start[j] = sdum
            fixed[j] = nse_comboindex(self.combo[j])
        endfor

        for j=0,self->count()-1 do begin
            o = self->get(position=j)

            o->fitdse,start=start,fixed=fixed,draw=0,xvar=nse_comboindex(self.xvar)
        endfor

end;autoplotIQT::fitData

;###############################################################################
;
;NAME:
;        autoplotIQT::draw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro autoplotIQT::draw,fit=fit,zoombox=zoombox,firstplot=firstplot,_Extra=extra


;WARNING:

;THERE IS A LOT OF INTERMINGLING BETWEEN THE DATA OBJECT DRAW METHOD AND
;THIS DRAW METHOD!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;
;THIS DRAW METHOD SHOULD SIMPLY POLL THE DATA OBJECT FOR VALUES AND THEN
;PLOT THE DATA.


        if n_elements(fit) eq 0 then fit = 0
        if n_elements(zoombox) eq 0 then zoombox = 0
        if n_elements(firstplot) eq 0 then firstplot = 0

        device,get_decomposed=dc
        device,decomposed=1

        black = 0L
        red = 255L
        green = red*256L
        blue = green*256L
        white = red + green + blue

        color = [black,red,green,blue,red+blue,green+blue]
        psym = [2,4,5,6,7]
        wset,self.winpix

        if self->count() gt 0 then begin

            o = self->get(position=0)

            xleg = 0.7
            yleg = 0.95
            o->draw,wid = self.winpix, color = color[0], psym = psym[0],$
                        fit=fit,xvar = nse_comboindex(self.xvar)

            o->getproperty,q=q
            str = 'I('+strtrim(string(q,format='(d6.4)'),2)+',t)'
            nse_legend,self.winpix,xleg,yleg,str,color=color[0],psym=psym[0],symsize=1

            for j=1,self->count()-1 do begin
                ;print,j
                o = self->get(position=j)
                psymindex = j mod 5
                colorindex = j mod 6
                o->getproperty,q=q
                str = 'I('+strtrim(string(q,format='(d6.4)'),2)+',t)'
                o->draw,wid = self.winpix, /oplot, color = color[colorindex], $
                                psym = psym[psymindex],/nowid,fit=fit,xvar = nse_comboindex(self.xvar),$
                                xstyle=1,ystyle=1,$
                                xlog=self.xloglin,ylog=self.yloglin,$
                                _Extra=extra
                nse_legend,self.winpix,xleg,yleg-0.03*j,str,color=color[colorindex],$
                                psym=psym[psymindex],symsize=1
            endfor
        endif else begin
            if widget_info(self.xmin,/valid_id) gt 0 then begin
                widget_control,self.xmin,get_value=xmin
                widget_control,self.xmax,get_value=xmax
                widget_control,self.ymin,get_value=ymin
                widget_control,self.ymax,get_value=ymax
            endif else begin
                xmin = 0 & ymin = 0
                xmax = 0 & ymax = 0
            endelse
            plot,[xmin,xmax],[ymin,ymax],xtitle = 't (ns)',ytitle='I(Q,t)',title='I(Q,t) Data',$
                    color=black,background=white,/nodata,$
                    xstyle=1,ystyle=1,$
                    xlog=self.xloglin,ylog=self.yloglin
        endelse


        if zoombox eq 1 then begin
            plots,[self.pressx,self.pressx],$
                    [self.pressy,self.releasey],$
                    color=black,/data
            plots,[self.pressx,self.releasex],$
                    [self.releasey,self.releasey],$
                    color=black,/data
            plots,[self.releasex,self.releasex],$
                    [self.releasey,self.pressy],$
                    color=black,/data
            plots,[self.releasex,self.pressx],$
                    [self.pressy,self.pressy],$
                    color=black,/data

        endif


        wset,self.winvis
        device,copy=[0,0,self.drawxsize,self.drawysize,0,0,self.winpix]
        device,decomposed=dc

end;autoplotIQT:draw


;###############################################################################
;
;NAME:
;        autoplotIQT::openfiles
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro autoplotIQT::openfiles

    fn = dialog_pickfile(/multi,filter='*.dat')

    if fn[0] ne '' then begin
        fn = fn[sort(fn)]

        ln = file_lines(fn)

        line = ''
        for i=0,n_elements(fn)-1 do begin
            o=obj_new('ooIQT',fn=fn[i])
            self->add,o

        endfor;i


        self->fitdata
        self->draw,fit=0

    endif else begin
        print,'NO FILES SELECTED.'
    endelse


end;autoplotIQT::openfiles
;###############################################################################
;
;NAME:
;        autoplotIQT::writeParms
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro autoplotIQT::writeParms,d1=d1

    fn = dialog_pickfile(/overwrite_prompt)
    if n_elements(d1) eq 0 then d1 = 0



    lun = -1

    if fn ne '' then begin
        openw,lun,fn,/get_lun
        if d1 eq 0 then begin
            parmnames = ['A0: ','A1: ','D1: ','B1: ','A2: ','D2: ','B2: ']
            for i=0,self->count()-1 do begin
                (self->get(position=i))->getproperty,p=p,sp=sp,q=q
                printf,lun,'Q = ',strtrim(string(q,format='(d6.4)'),2)
                for j=0,6 do begin
                    printf,lun,parmnames[j], strtrim(string((*p)[j],format='(d14.7)'),2),$
                                        ' +/- ',strtrim(string((*sp)[j],format='(d14.7)'),2)
                endfor;j
                printf,lun,''
            endfor;i
        endif else begin
            printf,lun,'Q','D1','sD1',format = '(3A14)'
            for i=0,self->count()-1 do begin
                (self->get(position=i))->getproperty,p=p,sp=sp,q=q
                printf,lun,q,(*p)[2],(*sp)[2],format='(d14.7 d14.7 d14.7)'
            endfor;i
        endelse
        free_lun,lun

    endif


end;autoplotIQT::writeparms
;############################################
;###############################################################################
;
;NAME:
;        autoplotiqt::getproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro autoplotiqt::getproperty, $
                parent=parent,$
                group_leader=group_leader,$
                tlb=tlb,$
                combo=combo,$
                field=field,$
                xvar=xvar,$
                open=open,$
                datadir=datadir,$
                workdir=workdir,$
                cleardata=cleardata,$
                export=export,$
                parmsexport=parmsexport,$
                fit=fit,$
                quit=quit,$
                draw=draw,$
                drawxsize=drawxsize,$
                drawysize=drawysize,$
                winvis=winvis,$
                winpix=winpix,$
                _Extra=extra


    autoplotiqt__define,autoplotiqt
    tags = tag_names(autoplotiqt)



catch, theError

if theError ne 0 then begin
    catch,/cancel
    ok = error_message(!error_state.msg  $
                       +'Returning . . . ',$
                       traceback=1,/error)
    return
endif


    if arg_present(parent) then parent=self.parent
    if arg_present(group_leader) then group_leader=self.group_leader

    if arg_present(tlb) then tlb=self.tlb

    if arg_present(combo) then combo=self.combo
    if arg_present(field) then field=self.field
    if arg_present(xvar) then xvar=self.xvar
    if arg_present(open) then open=self.open

    if arg_present(cleardata) then cleardata=self.cleardata
    if arg_present(export) then export=self.export
    if arg_present(parmsexport) then parmsexport=self.parmsexport
    if arg_present(fit) then fit=self.fit
    if arg_present(quit) then quit=self.quit
    if arg_present(draw) then draw=self.draw
    if arg_present(drawxsize) then drawxsize=self.drawxsize
    if arg_present(drawysize) then drawysize=self.drawysize
    if arg_present(winvis) then winvis=self.winvis
    if arg_present(winpix) then winpix=self.winpix

    if arg_present(press) gt 0 then press=self.press
    if arg_present(pressx) gt 0 then pressx=self.pressx
    if arg_present(releasex) gt 0 then releasex=self.releasex
    if arg_present(pressy) gt 0 then pressy=self.pressy
    if arg_present(releasey) gt 0 then releasey=self.releasey
    if arg_present(xmin) gt 0 then xmin=self.xmin
    if arg_present(xmax) gt 0 then xmax=self.xmax
    if arg_present(ymin) gt 0 then ymin=self.yin
    if arg_present(ymax) gt 0 then ymax=self.ymax
    if arg_present(xlog) gt 0 then xlog=self.xlog
    if arg_present(ylog) gt 0 then ylog=self.ylog

end;autoplot::getproperty
;###############################################################################
;
;NAME:
;        autoplotiqt::setproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro autoplotiqt::setproperty, $
                i=i,$
                si=si,$
                q=q,$
                t=t,$
                P=p,$
                parent=parent,$
                group_leader=group_leader,$
                tlb=tlb,$
                combo=combo,$
                field=field,$
                xvar=xvar,$
                open=open,$
                cleardata=cleardata,$
                export=export,$
                parmsexport=parmsexport,$
                fit=fit,$
                quit=quit,$
                draw=draw,$
                drawxsize=drawxsize,$
                drawysize=drawysize,$
                winvis=winvis,$
                winpix=winpix,$
                _Extra=extra


    autoplotiqt__define,autoplotiqt
    tags = tag_names(autoplotiqt)


catch, theError

if theError ne 0 then begin
    catch,/cancel
    ok = error_message(!error_state.msg  $
                       +'Returning . . . ',$
                       traceback=1,/error)
    return
endif

    if n_elements(parent) gt 0 then self.parent=parent
    if n_elements(group_leader) gt 0 then self.group_leader=group_leader
    if n_elements(tlb) gt 0 then self.tlb=tlb
    if n_elements(combo) gt 0 then self.combo=combo
    if n_elements(field) gt 0 then self.field=field
    if n_elements(xvar) gt 0 then self.xvar=xvar
    if n_elements(open) gt 0 then self.open=open
    if n_elements(cleardata) gt 0 then self.cleardata=cleardata
    if n_elements(export) gt 0 then self.export=export
    if n_elements(parmsexport) gt 0 then self.parmsexport=parmsexport
    if n_elements(fit) gt 0 then self.fit=fit
    if n_elements(quit) gt 0 then self.quit=quit
    if n_elements(draw) gt 0 then self.draw=draw
    if n_elements(drawxsize) gt 0 then self.drawxsize=drawxsize
    if n_elements(drawysize) gt 0 then self.drawysize=drawysize
    if n_elements(winvis) gt 0 then self.winvis=winvis
    if n_elements(winpix) gt 0 then self.winpix=winpix
    if n_elements(press) gt 0 then self.press=press
    if n_elements(pressx) gt 0 then self.pressx=pressx
    if n_elements(releasex) gt 0 then self.releasex=releasex
    if n_elements(pressy) gt 0 then self.pressy=pressy
    if n_elements(releasey) gt 0 then self.releasey=releasey
    if n_elements(xmin) gt 0 then self.xmin=xmin
    if n_elements(xmax) gt 0 then self.xmax=xmax
    if n_elements(ymin) gt 0 then self.ymin=yin
    if n_elements(ymax) gt 0 then self.ymax=ymax
    if n_elements(xlog) gt 0 then self.xlog=xlog
    if n_elements(ylog) gt 0 then self.ylog=ylog

end;autoplot::setproperty
;###############################################################################
;
;NAME:
;        autoplotiqt_realize
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro autoplotiqt_realize,id

    widget_control,id,get_uvalue=obj
    obj->realize

end;autoplotiqt_realize

;###############################################################################
;
;NAME:
;        autoplotiqt::realize
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro autoplotiqt::realize
    print,'AutoplotIQT Realize'
    widget_control,self.draw,get_value=winvis
    self.winvis = winvis
    geom = widget_info(self.draw,/geometry)
    window,/free,/pixmap,xsize = geom.xsize,ysize=geom.ysize
    self.winpix = !d.window

end;autoplotiqt::realize
;###############################################################################
;
;NAME:
;        autoplotiqt_cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro autoplotiqt_cleanup,id
    widget_control,id,get_uvalue=obj
    print,id
    help,obj
    obj_destroy,obj
end;autoplotiqt_cleanup
;###############################################################################
;
;NAME:
;        autoplotiqt::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro autoplotiqt::cleanup
    print,'AutoplotIQT Cleanup.'
    self->clearData
end;autoplotiqt::cleanup
;###############################################################################
;
;NAME:
;        autoplotiqt_event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro autoplotiqt_event,event
    widget_control,event.id,get_uvalue=obj
    obj->event,event
end;event
;###############################################################################
;
;NAME:
;        autoplotiqt::event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro autoplotiqt::event,event

    case event.id of
    self.quit:begin
        print,'Quit'
        widget_control,self.tlb,/destroy
    end;quit
    self.fit:begin
        print,'Fit'
        self->fitdata
        self->displayParms
        self->draw,fit=1
    end;fit
    self.parmsexport:begin
        print,'Export Fit Parms'
        self->writeparms
    end;parmsexport
    self.cleardata:begin
        self->cleardata
        self->draw
    end;clearData
    self.open:begin
        print,'Open'
        self->openfiles
    end;open
    self.resultstext:begin
        print,'self.resultstext'
    end;
    self.fitparmstab:begin
        print,'self.fitparmstab'
    end;
;    self.draw:begin
;        if self.press ne 0 then begin
;            case self.press of
;            1:begin
;                ;print,'event.x,event.y=',event.x,event.y
;                coords = convert_coord(event.x,event.y,/device,/to_data)
;                ;print,coords
;                self.releasex = coords[0]
;                self.releasey = coords[1]
;
;                zoombox = 1
;            end;1
;            4:begin
;
;            end;4
;            else:
;            endcase
;
;            if n_elements(zoombox) eq 0 then zoombox = 0
;            if n_elements(firstplot) eq 0 then firstplot = 0
;            self->draw,zoombox=zoombox,firstplot = firstplot
;        endif else begin
;
;;DO NOTHING FOR MOTION ONLY, NO DRAG, NO BUTTON PRESS
;            if event.press ne 0 then begin
;                self.press = event.press
;                ;print,'event.x,event.y=',event.x,event.y
;                coords = convert_coord(event.x,event.y,/device,/to_data)
;                self.pressx = coords[0]
;                self.pressy = coords[1]
;
;            endif
;
;        endelse
;
;        if event.release ne 0 then begin
;
;            case self.press of
;            1:begin
;                self.press = 0
;                zoombox = 0
;
;                xvals = [self.pressx,self.releasex]
;                yvals = [self.pressy,self.releasey]
;
;                widget_control,self.xmin,set_value=min(xvals)
;                widget_control,self.xmax,set_value=max(xvals)
;                widget_control,self.ymin,set_value=min(yvals)
;                widget_control,self.ymax,set_value=max(yvals)
;            end;1
;            4:begin
;                self.press = 0
;                zoombox = -1    ;TELL DRAW TO USE DEFAULT AXIS RANGES BASED ON DATA
;                ;if ptr_valid(self.q) eq 0 and ptr_valid(self.s) eq 0 then begin
;                    firstplot = 1
;;                    widget_control,self.xmin,set_value=0.0
;;                    widget_control,self.xmax,set_value=1.0
;;                    widget_control,self.ymin,set_value=0.0
;;                    widget_control,self.ymax,set_value=1.0
;                ;endif
;            end
;            else:
;            endcase
;            if n_elements(zoombox) eq 0 then zoombox = 0
;            if n_elements(firstplot) eq 0 then firstplot = 0
;                widget_control,self.xmin,get_value=xmin
;                widget_control,self.xmax,get_value=xmax
;                widget_control,self.ymin,get_value=ymin
;                widget_control,self.ymax,get_value=ymax
;
;            self->draw,zoombox=zoombox,firstplot = firstplot,$
;                            xrange=[xmin,xmax],yrange=[ymin,ymax]
;        endif
;    end;draw
;
;
;

    else:
    endcase

end;event

;###############################################################################
;
;NAME:
;        autoplotIQT::displayparms
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
pro autoplotIQT::displayparms

    s = ['Q:__','A0:_','A1:_','D1:_','B1:_','A2:_','D2:_','B2:_']
    count = self->count()
    if count gt 0 then begin
        for i=0,count-1 do begin
            ref = self->get(position=i)
            ref->getproperty,t=t,q=q,P=P,sP=sP,chisq=chisq
            s[0] = s[0]+strtrim(string(q,format='(f6.4)'),2)+'__________'
            for j=0,n_elements(*P)-1 do begin
                s[j+1] = s[j+1]+strtrim(string((*P)[j],format='(f10.7)'),2)+'____'
            endfor;j
        endfor;i
    endif;count

    widget_control,self.resultstext,set_value=s

end;
;###############################################################################
;
;NAME:
;        autoplotIQT::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function autoplotIQT::init,parent=parent,tlb=tlb,group_leader=group_leader

    if n_elements(parent) eq 0 then parent = 0L
    if n_elements(tlb) eq 0 then tlb = 0L
    if n_elements(group_leader) eq 0 then group_leader = 0L

    self.drawxsize=400
    self.drawysize=400


    ret = self->idl_container::init()

    self.tlb = widget_base(group_leader=group_leader,mbar=bar,/row,title='AutoplotIQT',uvalue=self)
    self->create_widgets,bar
    widget_control,self.tlb,/realize

    xmanager,'autoplotiqt',self.tlb,/no_block,cleanup='autoplotiqt_cleanup'
    self->draw

    return,1
end;autoplotIQT::init


;###############################################################################
;
;NAME:
;        autoplotIQT__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro autoplotIQT__define,class

    class = {autoplotIQT, $
                inherits idl_container, $
                parent:0L,$
                group_leader:0L,$
                tlb:0L,$
                combo:lindgen(7),$
                field:lindgen(7),$
                xvar:0L,$
                open:0L,$
                cleardata:0L,$
                export:0L,$
                parmsexport:0L,$
                fit:0L,$
                quit:0L,$
                resultstext:0L,$
                fitparmstab:0L,$
                drawxsize:400,$
                drawysize:400,$
                draw:0L,$
                winvis:0L,$
                winpix:0L,$
                press:0,$
                pressx:0.0,$
                releasex:0.0,$
                pressy:0.0,$
                releasey:0.0,$
                xmin:0L,$
                xmax:0L,$
                ymin:0L,$
                ymax:0L,$
                xlog:0L,$
                ylog:0L,$
                xloglin:0,$
                yloglin:0 $
            }


end;autoplotIQT__define
