; $Id$
;
;
;+
;  FILE:
;       dave_uscensus.pro
;
;_____________________________________________________________________
;  THIS IS A MODIFIED VERSION OF THE IDL DEMO PROGRAM:
;       D_Uscensus.pro
;
;;      Copyright (c) 1997-2007, ITT Visual Information Solutions. All
;           rights reserved. Unauthorized reproduction is prohibited.
;_____________________________________________________________________
;
;  PURPOSE:
;       Make a basic mapping program starting from an IDL demo.
;
;
;
;  KEYWORD PARAMETERS:
;       GROUP_LEADER can be set to the ID of a parent widget when
;       this routine is called as a compound widget.
;
;       APPTLB returns the application top level base, mainly for
;       use in the IDL Demo.
;
;       /ANIMATE_STATES when set allows States to be individually
;       rendered when a new year of data is displayed.  By default
;       all States are scaled before the view is rendered.  This
;       option is recommended only on machines with good rendering
;       speed, such as a Pentium Pro 200 or Sun Ultra.
;
;       /BACKDROP when set causes a backdrop image to be drawn behind
;       the USA map.  It's a good example of view object instancing.
;       This is recommended only for machines with TrueColor displays
;       and good rendering speed.  By default, the backdrop image is
;       not displayed.
;
;       /DEPTH turns on depth cueing in the view.  By default, depth
;       cueing is not performed.
;


pro dave_uscensusconvertParticipants
;THIS METHOD IS USED TO PREPARE THE BASIC DATA SET FOR DISPLAY.

;BE SURE TO MOVE ANY NEW VERSION OF THE DATA FILE TO THE DAVE AUXILIARY DIRECTORY.


;CONVERTING A DATA FILE FROM PETER'S FORMAT.
;
;THIS IS SPECIFIC TO MY COMPUTER BECAUSE OF THE TRASFER OF DATA BY READING IN TO A FILE.
;THIS STEP COULD BE SKIPPED BY WRITING TO A VARIABLE!!!

fn = 'C:\Documents and Settings\kneller\Desktop\Data\ResearchParticipantsv1.txt'
ofn = 'C:\Documents and Settings\kneller\Desktop\Data\ResearchParticipants.txt'
nlines = file_lines(fn)

s=''
year = ''
nyears = 0
years =[0]

openr,lun,fn,/get_lun
openw,olun,ofn,/get_lun
for i=0,nlines-1 do begin
  readf,lun,s
  ;print,s
  segs = strsplit(s,/extract)

  nsegs = n_elements(segs)
  if nsegs eq 1 and segs[0] ne '' then begin
    year = segs[0]
    years = [years,long(year)]
    nyears++
  endif

  if nsegs ge 2 then begin
    printf,olun,segs[0],year,segs[1],format='(A10,A10,A10)'
    ;print,segs[0],year,segs[1],format='(A10,A10,A10)'
  endif
  ;print,n_elements(segs),segs[0]

endfor;i


free_lun,lun
free_lun,olun

if nyears gt 0 then years = years[1:*]
;help,years
;print,years

;GET ALL THE STATES INFORMATION
;Restore, DEMO_FILEPATH('states2.sav', SubDir = ['examples', 'demo', 'demodata'])
defsysv,'!DAVE_AUXILIARY_DIR',exists=exists
if exists ne 0 then begin
  datafile = !DAVE_AUXILIARY_DIR+ 'ResearchParticipantsData.sav'
endif else begin
  datafile = 'C:\Documents and Settings\kneller\Desktop\dave_clean_062409\dave\programs\auxiliary\ResearchParticipantsData.sav'
endelse
restore,datafile



;help,states

popstates = states

;help,states[0],/struct
str = {STATE:'Name',$ 
       ZIP:'PA',$
       SUBREGION:'',$
       POUTLINE:ptr_new(),$
       PNORMALOUTLINE:ptr_new(),$ 
       PPOLYGONLIST:ptr_new(),$
       PVERTEXLIST:ptr_new(),$
       ZVALUE:0.0,$
       COLOR:intarr(3),$
       NICKNAME:'',$
       POPULATION:lonarr(nyears),$
       researchParticipants:lonarr(nyears),$
       years:lonarr(nyears),$
       data:dblarr(nyears),$
       title:''}

states = replicate(str,n_elements(popstates))
for i=0,n_elements(states)-1 do begin
  states[i].state = popstates[i].state
  states[i].ZIP = popstates[i].ZIP
  states[i].subregion = popstates[i].subregion
  if ptr_valid(popstates[i].poutline) ne 0 then  states[i].poutline = ptr_new(*(popstates[i].poutline))
  if ptr_valid(popstates[i].pnormaloutline) ne 0 then  states[i].pnormaloutline = ptr_new(*(popstates[i].pnormaloutline))
  if ptr_valid(popstates[i].ppolygonlist) ne 0 then  states[i].ppolygonlist = ptr_new(*(popstates[i].ppolygonlist))
  if ptr_valid(popstates[i].pvertexlist) ne 0 then  states[i].pvertexlist = ptr_new(*(popstates[i].pvertexlist))
  states[i].zvalue = popstates[i].zvalue
  states[i].color = popstates[i].color
  states[i].nickname = popstates[i].nickname
  states[i].population = popstates[i].population[0:nyears-1]
  states[i].years = years
  states[i].title = 'NCNR Research Participant Data'
endfor;i


;GET THE DATA FROM THE FILE
nlines = file_lines(ofn)

;year0 = 2005
;print,'year0=',year0
;print,'min(years)=',min(years)
year0 = min(years)
openr,lun,ofn,/get_lun
for i=0,nlines-1 do begin
  readf,lun,s
  segs = strsplit(s,/extract)
  year = fix(segs[1])
  participants = fix(segs[2])
  whmatch = where(segs[0] eq states[*].zip,nmatch)
  ;print,whmatch
  if nmatch ne 0 then begin
    ;print,'year,year-year0=',year,year-year0
    states[whmatch[*]].population[year-year0] = participants
    states[whmatch[*]].researchParticipants[year-year0] = participants
    states[whmatch[*]].data[year-year0] = double(participants)
  endif
endfor;i
free_lun,lun

;ofn2 = 'C:\Documents and Settings\kneller\Desktop\Data\ResearchParticipantsData.txt'
ofn2 = 'C:\Documents and Settings\kneller\Desktop\Data\ResearchParticipantsData2008.sav'
save,states,filename=ofn2
end;dave_uscensusconvertParticipants



function dave_uscensusAngle3123, $
    cos_mat      ; IN: cosine direction matrix (3 x 3)
;
;This function returns the 3 angles of a space three 1-2-3
;given a 3 x 3 cosine direction matrix
;else -1 on failure.
;
;Definition :
;   Given 2 sets of dextral orthogonal unit vectors
;   (a1, a2, a3) and (b1, b2, b3), the cosine direction matrix
;   C (3 x 3) is defined as the dot product of:
;
;   C(i,j) = ai . bi  where i = 1,2,3
;
;   A column vector X (3 x 1) becomes X' (3 x 1)
;   after the rotation as defined as :
;
;   X' = C X
;
;   The space three 1-2-3 means that the x rotation is first,
;   followed by the y rotation, then the z.
;
;Verify input parameter.
;
if (n_params() ne 1) then begin
    print,'Error in dave_uscensusAngle3123: 1 parameters must be passed.'
    return, -1
    end
sizec = size(cos_mat)
if (sizec[0] ne 2) then begin
    print,'Error, the input matrix must be of dimension 2'
    return, -1
    end
if ((sizec[1] ne 3) or (sizec[2] ne 3)) then begin
    print,'Error, the input matrix must be 3 by 3'
    return, -1
    end
;
;Compute the 3 angles (in degrees)
;
cos_mat = transpose(cos_mat)
angle = fltarr(3)
angle[1] = -cos_mat[2,0]
angle[1] = asin(angle[1])
c2 = COS(angle[1])
if (abs(c2) lt 1.0e-6) then begin
    angle[0] = atan(-cos_mat[1,2], cos_mat[1,1])
    angle[2] = 0.0
    end $
else begin
    angle[0] = atan(cos_mat[2,1], cos_mat[2,2])
    angle[2] = atan(cos_mat[1,0], cos_mat[0,0])
    end
angle = angle * (180.0 / !dpi)

return, angle
end
;--------------------------------------------------------------------
function dave_uscensusSpace3123, $
    theta, $        ; IN: angle of rotation around the x axis (in degrees).
    phi, $          ; IN: angle of rotation around the y axis (in degrees).
    gamma           ; IN: angle of rotation around the z axis (in degrees).
;
;This function returns the cosine direction matrix (3 x 3)
;given the space three 1-2-3 rotation angles(i.e. rotation around
;x axis, followed by Y axis, then z axis),
;else -1 on failure.
;
;Definition :
;   Given 2 sets of dextral orthogonal unit vectors
;   (a1, a2, a3) and (b1, b2, b3), the cosine direction matrix
;   C (3 x 3) is defined as the dot product of:
;
;   C(i,j) = ai . bi  where i = 1,2,3
;
;   A column vector X (3 x 1) becomes X' (3 x 1)
;   after the rotation as defined as :
;
;   X' = C X
;
;Verify the input parameters.
;
if (n_params() ne 3) then begin
    print,'Error in dave_uscensusSpace3123: 3 parameters must be passed.'
    return, -1
endif

cos_mat = fltarr(3, 3)
;
;Transform the angle in radians.
;
r_theta = theta * !dpi / 180.0
r_phi = phi * !dpi / 180.0
r_gamma = gamma * !dpi / 180.0

cos1 = cos(r_theta)
cos2 = cos(r_phi)
cos3 = cos(r_gamma)
sin1 = sin(r_theta)
sin2 = sin(r_phi)
sin3 = sin(r_gamma)
;
;Compute the cosine direction matrix.
;
cos_mat[0,0] = cos2*cos3
cos_mat[1,0] = cos2*sin3
cos_mat[2,0] = -sin2
cos_mat[0,1] = (sin1*sin2*cos3) - (cos1*sin3)
cos_mat[1,1] = (sin1*sin2*sin3) + (cos1*cos3)
cos_mat[2,1] = sin1*cos2
cos_mat[0,2] = (cos1*sin2*cos3) + (sin1*sin3)
cos_mat[1,2] = (cos1*sin2*sin3) - (sin1*cos3)
cos_mat[2,2] = cos1*cos2

return, cos_mat
end
;--------------------------------------------------------------------
function dave_uscensusMercator, coordinate, circumference
;
;Given [longitude, latitude] on a sphere of size CIRCUMFERENCE,
;return a Mercator projection of [longitude, latitude].
;
if n_elements(circumference) eq 0 then $
    circumference = 360
result = coordinate
result[0, 0] = result[0, *] * float(circumference)/360.
result[1, 0] = (circumference/(2*!pi)) $
             * alog( 1/cos(!dtor*result[1, *]) + tan(!dtor*result[1, *]) )
return, result
end
;--------------------------------------------------------------------
pro dave_uscensusDraw, app_state, indx, create_instance=create_instance
;
;Silently flush any accumulated math error.
;
void = check_math()
;
;Silently accumulate any subsequent math errors.
;
orig_except = !except
!except = 0
;
;Draw.
;
if keyword_set(create_instance) then begin
    app_state.window_objects[indx]->Draw, $
        app_state.view_objects[indx], $
        create_instance=create_instance
    end $
else begin
    app_state.window_objects[indx]->Draw, $
        app_state.view_objects[indx], $
        draw_instance=([app_state.backdrop, 0b])[indx eq 1]
    end
;
;Silently flush any accumulated math error.
;
void = check_math()
;
;Restore original math error behavior.
;
!except = orig_except
end
;--------------------------------------------------------------------
function dave_uscensusRegion::init, $
    info, $
    offset=offset, $ ; Degrees.  [lon, lat]
    oTessellator=oTessellator, $
    debug=debug, $
    _extra=e

catch, error_status
if error_status ne 0 then begin
    catch, /cancel
    print, !error_state.msg
    return, 0
    end
if keyword_set(debug) then $
    catch, /cancel

outline = fltarr(3, (size(*info.pOutline))[2]) + 1
outline[0:1, *] = *info.pOutline
outline[0, *] = outline[0, *] + offset[0]
outline[1, *] = outline[1, *] + offset[1]
outline[0:1, *] = outline[0:1, *] / 180.
;
;A black outline serves as self's border.
;
self.oOutline = obj_new('IDLgrPolyline', $
    outline, $
    ;color=[0, 0, 0], $
    color=[200, 200, 20], $
    thick=([2,3])[!version.os_family eq 'MacOS'], $
    uvalue=self $
    )
;
;Create a skirt for self.  Note that we specify
;backface culling.  Since we won't be looking at the
;"inside" of self, we can speed rendering
;by telling IDL to reject back faces.
;
mesh_obj, 5, verts, polygons, outline, p2=[0,0,-1] ; Extrude
self.oSkirt = obj_new('IDLgrPolygon', $
    verts, $
    polygons=polygons, $
    shading=1, $ ; Gouraud.
    reject=2, $
    uvalue=self $
    )
;
;Create the top and bottom of self, using concave polygons derived
;from self's outline.  Event though the derived polygons are of
;uniform color, they can vary in their apparent color when directional
;IDLgrLight is shined at them.  So we specify Gouraud shading to
;smooth these apparent differences.
;
self.oFace = obj_new('IDLgrPolygon', $
    /reject, $
    shading=1, $ ; Gouraud.
    uvalue=self $
    )
self.oBase = obj_new('IDLgrPolygon', $
    reject=2, $
    shading=1, $ ; Gouraud.
    uvalue=self $
    )
if not keyword_set(oTessellator) then begin
    oTess = obj_new('IDLgrTessellator')
    end $
else begin
    oTess = oTessellator
    end
oTess->Reset
oTess->AddPolygon, outline[*, 0:(size(outline))[2]-2] * 500.
if (oTess->Tessellate(vertices, polygons)) then begin
    self.oFace->SetProperty, $
        data=vertices/500., $
        polygons=polygons
    vertices[2, *] = 0
    self.oBase->SetProperty, $
        data=vertices/500., $
        polygons=polygons, $
        color=[96, 96, 96]
    end $
else $
    message, 'Failed to Tessellate ' + info.state
;
self.oOutlineModel = obj_new('IDLgrModel')
self.oPolygonModel = obj_new('IDLgrModel')

self.oPolygonModel->Add, self.oSkirt
self.oPolygonModel->Add, self.oFace
self.oOutlineModel->Add, self.oOutline
self.oOutlineModel->Add, self.oBase

info.oPolygonRot->Add, self.oPolygonModel
info.oOutlineRot->Add, self.oOutlineModel

self.scale = [1, 1, 1]
self.pPopulation = ptr_new(info.population)
self.pData = ptr_new(info.data)
self.region_name = info.state
self.abbr = info.zip


if not keyword_set(oTessellator) then begin
    obj_destroy, oTess
    end
return, 1 ; Success.
end
;--------------------------------------------------------------------
pro dave_uscensusRegion::cleanup
ptr_free, self.pPopulation
ptr_free,self.pdata
end
;--------------------------------------------------------------------
function dave_uscensusRegion::Population, year_indx
dumindex = year_indx
if year_indx ge n_elements((*self.pdata)) then begin
  print,'dumindex=',dumindex
  dumindex = 0
  print,'dave_uscensusRegion::population,  year_indx out of range!!!'
help,/traceback
  
endif 

return, (*self.pPopulation)[dumindex]
end
;--------------------------------------------------------------------
function dave_uscensusRegion::data, year_indx

dumindex = year_indx
if year_indx ge n_elements((*self.pdata)) then begin
  dumindex = 0
  print,'dave_uscensusRegion::data,  year_indx out of range!!!'
endif 
return, (*self.pdata)[dumindex]
end
;--------------------------------------------------------------------
pro dave_uscensusRegion::SetProperty, $
    color=color, $
    scale=scale, $
    outline=outline, $
    uvalue=uvalue,$
    population=population,$
    data=data
    
if n_elements(population) ne 0 then begin
  if ptr_valid(self.pPopulation) ne 0 then ptr_free,self.pPopulation    
  self.pPopulation = ptr_new(population)    
;  print,'**********************************************************************'
  ;print,self.region_name
;  print,'POPULATION DATA CHANGED, BE SURE TO CHANGE THE DROPLIST AND ANY OTHER'
;  print,'ITEM THAT RELIES ON KNOWING THE NUMBER OF ELEMENTS IN *self.pPopulation'
;  print,''
;  print,'**********************************************************************'
endif
if n_elements(data) ne 0 then begin
  if ptr_valid(self.pdata) ne 0 then ptr_free,self.pdata    
  self.pData = ptr_new(data)    
;  print,'**********************************************************************'
;  print,'DATA CHANGED, BE SURE TO CHANGE THE DROPLIST AND ANY OTHER'
;  print,'ITEM THAT RELIES ON KNOWING THE NUMBER OF ELEMENTS IN *self.pData'
;  print,''
;  print,'**********************************************************************'
endif
if n_elements(color) ne 0 then begin
    self.oFace->SetProperty, color=color
    self.oSkirt->SetProperty, color=color
    end
if n_elements(scale) ne 0 then begin
    self.oPolygonModel->Scale, $
        1/self.scale[0], $
        1/self.scale[1], $
        1/self.scale[2]
    self.oPolygonModel->Scale, $
        scale[0], $
        scale[1], $
        scale[2]

    self.oOutlineModel->Scale, $
        1/self.scale[0], $
        1/self.scale[1], $
        1/self.scale[2]
    self.oOutlineModel->Scale, $
        scale[0], $
        scale[1], $
        scale[2]

    self.scale = scale
    end

if n_elements(outline) ne 0 then $
    self.oOutline->SetProperty, hide=([1,0])[keyword_set(outline)]

if n_elements(uvalue) ne 0 then begin
    self.oFace->SetProperty, uvalue=uvalue
    self.oSkirt->SetProperty, uvalue=uvalue
    self.oOutline->SetProperty, uvalue=uvalue
    self.oBase->SetProperty, uvalue=uvalue
    end
end
;--------------------------------------------------------------------
pro dave_uscensusRegion::GetProperty, $
    color=color, $
    region_name=region_name, $
    abbr=abbr,$
    population=population,$
    data=data,$
    _ref_extra=e

self.oFace->GetProperty, color=color

abbr = self.abbr
region_name = self.region_name
population = *self.pPopulation
data = *self.pdata
end
;--------------------------------------------------------------------
pro dave_uscensusRegion__define
void = {dave_uscensusRegion, $
    oFace: obj_new(), $
    oSkirt: obj_new(), $
    oOutline: obj_new(), $
    oBase: obj_new(), $
    oPolygonModel: obj_new(), $
    oOutlineModel: obj_new(), $
    scale: [0., 0., 0.], $
    pPopulation: ptr_new(), $
    region_name: '',$
    abbr:'',$
    pdata:ptr_new()}
end
;--------------------------------------------------------------------
Function dave_uscensusZColorCalc, PopulationChanges, PopulationScale
;
; Given a population change, determine the color that should be
; used for that State.
;
NPopulations = N_Elements(PopulationChanges)
Colors = BytArr(3, NPopulations)
Loss = Where(PopulationChanges lt PopulationScale.range_max[0], NLoss)
If (NLoss gt 0) then Begin
    For J = 0, 2 Do Begin
        Colors[J, Loss] = PopulationScale.Colors[J, 0]
    EndFor
EndIf
For I = 1, N_elements(PopulationScale.range_max) - 1 Do Begin
    ThisColor = Where(PopulationChanges ge $
        PopulationScale.range_max[I - 1] and $
        PopulationChanges lt PopulationScale.range_max[I], NThisColor)
    If (NThisColor ne 0) then Begin
        For J = 0, 2 Do Begin
            Colors[J, ThisColor] = PopulationScale.Colors[J, I]
        EndFor
    EndIf
EndFor
BigGain = Where(PopulationChanges ge PopulationScale.range_max[ $
    N_elements(PopulationScale.range_max) - 1], NBigGain)
If (NBigGain ne 0) then Begin
    For J = 0, 2 Do Begin
        Colors[J, BigGain] = PopulationScale.Colors[J, $
            N_elements(PopulationScale.range_max) - 1]
    EndFor
EndIf
Return, Colors
End
;--------------------------------------------------------------------
function dave_uscensusZ_color, app_state, oRegion


states = *app_state.pstates
;temppops = [states[*].data[0],states[*].data[1],states[*].data[2]]
temppops = [min(states[0].data[*])]
for i=0,n_elements(states[0].data[*])-1 do begin
  temppops = [temppops,states[*].data[i]]
endfor;i
ct = app_state.colorTable 
scaleVariable = app_state.scaleVariable
cb = app_state.oColorBar
logColor = app_state.logColor
;help,oregion

;print,'COLLECT ALL THE POPS HERE'
;help,states[0],/struct
case scaleVariable of 
0:begin
  ;pops = [states[*].data[0],states[*].data[1],states[*].data[2]]
  pops = [min(states[0].data[*])]
  for i=0,n_elements(states[0].data[*])-1 do begin
    pops = [pops,states[*].data[i]]
  endfor;i

end;0
1:begin
  ;pops = [states[*].data[0],states[*].data[1],states[*].data[2]]
  pops = [min(states[0].data[*])]
  for i=0,n_elements(states[0].data[*])-1 do begin
    pops = [pops,states[*].data[i]]
  endfor;i
end;1
else:begin
  ;pops = [states[*].data[0],states[*].data[1],states[*].data[2]]
  pops = [min(states[0].data[*])]
  for i=0,n_elements(states[0].data[*])-1 do begin
    pops = [pops,states[*].data[i]]
  endfor;i
endelse
endcase

cb->setDataRange,[min(pops),max(pops)]
;print,'dave_uscensusZ_color: THIS SCALING ONLY WORKS BECAUSE OF THE NEARLY EQUAL DATA RANGE.'
;print,'dave_uscensusZ_color: OTHERWISE THE TEXT IS MASSIVELY STRETCHED!!!!!'


;SET THE COLOR SCALE HERE
;SAVE THE ORIGINAL COLOR TABLE
TVLCT, Reds, Greens, Blues, /GET 

;LOAD THE SELECTED COLOR TABLE TO SET THE OBJECT COLORS FOR THE STATES
loadct,ct,rgb_table=colors
newcolor=intarr(3)
colora = 0;min(pops)

case logcolor of
1:begin

  colorb = 255.0/alog(max(pops)-min(pops))
  cindex = fix(colorb * alog(oRegion->data(app_state.year)))
  if cindex lt 0 then cindex = 0
  if cindex gt 255 then cindex = 255
  newcolor[0]=colors[cindex,0]
  newcolor[1]=colors[cindex,1]
  newcolor[2]=colors[cindex,2]
end;1
else:begin
  colorb = 255.0/(max(pops)-min(pops))
  cindex = fix(colorb * (oRegion->data(app_state.year)))
  if cindex lt 0 then cindex = 0
  if cindex gt 255 then cindex = 255
  newcolor[0]=colors[cindex,0]
  newcolor[1]=colors[cindex,1]
  newcolor[2]=colors[cindex,2]  
endelse
endcase

;
;Return a color for the given dave_uscensusRegion.
;
oRegion->GetProperty, region_name=region_name
if strpos(region_name, 'LAKE') ne -1 then begin
  if ct eq 3 then return,[20,20,240] else return,[255,255,255]
endif else begin
        ;newcolor = fix([0,0,255-(colora + colorb * alog(oRegion->Population(app_state.year)))])
        ;if newcolor[2] eq 0 then newcolor = [255,255,255]
        return,newcolor 
endelse

;RESTORE THE ORIGINAL COLOR TABLE
TVLCT, Reds, Greens, Blues

;
;case 1 of
;    strpos(region_name, 'LAKE') ne -1: $
;        return,[0,0,0]
;        ;return, [0, 0, 255]
;    oRegion->Population(app_state.year) eq 0: $
;        return, [20, 20, 20]
;
;    app_state.year eq app_state.n_years - 1: $
;        return, [255, 255, 255]
;    oRegion->Population(app_state.year + 1) eq 0: $
;        return, [255, 255, 255]
;    else: begin
;        ratio = oRegion->Population(app_state.year) $
;              / float(oRegion->Population(app_state.year + 1))
;        return, $
;            dave_uscensusZColorCalc( $
;                ratio, $
;                app_state.population_scale $
;                )
;        end
;    endcase
end;dave_uscensusZ_color
;--------------------------------------------------------------------
function dave_uscensusStrCommas, str
;
;Put commas in a string.
;
bstr = byte(strcompress(str, /remove_all))
if n_elements(bstr) le 3 then $
    return, string(bstr)

position = indgen(n_elements(bstr) / 3) * 3 + (n_elements(bstr) mod 3)
if position[0] eq 0 then $
    position = position[1:*]
result = bytarr(n_elements(bstr) + n_elements(position))
i = 0
j = 0
k = 0
while i le n_elements(result)-1 do begin
    if j le n_elements(position) - 1 then begin
        if i eq position[j] then begin
            result[i] = byte(',')
            j = j + 1
            i = i + 1
            position = position + 1
            end
        end
    result[i] = bstr[k]
    i = i + 1
    k = k + 1
    end
return, string(result)
end
;--------------------------------------------------------------------
Pro dave_uscensusBuild_Backdrop, BackdropImage, BackdropObject
;
; This routine builds the "curtain" or backdrop
; in front of which the map data are rendered.
; There's no real magic here.  I ("JLP") just played around
; with the values until I got the effect I wanted.
;
; Note that when texture mapping, IDL operates most
; efficiently on images that are a) square and b)
; dimensioned by powers of 2.
;
; ZZ defines the surface "height" of the backdrop.
; XX and YY are the coordinates of each of the
; ZZ values.
;
; Since the image is not a true child of the
; backdrop object (it's a property), we need
; to pass that back so we can destroy it later.
;
ZZ = Findgen(256)^7/1.E15 + .01
Z = FltArr(256, 256)
For I = 0, 255 Do Begin
    Z[I, *] = ZZ
EndFor
XX = FltArr(256, 256)
YY = XX
;
; Center the X and Y values
;
X = Reverse(.25 - Findgen(256)/512)
Y = Findgen(256)/128 - 1
;
; The Y values of the mapped image are
; the same across a row.  The X values
; spread out toward the bottom of the
; backdrop so the image appears "splayed".
;
For I = 0, 255 Do Begin
    YY[I, *] = Y/10.
    XX[*, I] = X * (1 + ((255 - I)/128.)^1.5)
EndFor
;
; Create the image that will be mapped onto
; the coordinates defined above, It's simply
; an image of vertical stripes with some border
; pixels.
;
Image = BytArr(3, 256, 256)
Image[*,254:*, *] = 255
Image[*, *, 254:*] = 255
Image[*,0:3, *] = 255
Image[*, *, 0:2] = 255
;
; Now we get obnoxiously partiotic and make
; the stripes red, white, and blue with some
; black left in for "shadows".
;
K = -1
For X = 30, 220, 10 Do Begin
    K = (K + 1) mod 3
    If (K eq 1) then Begin
        Image[*, X:X + 5, *] = 255
    EndIf Else Begin
        For I = 0, 2 Do Begin
            Image[I, X:X + 5, *] = 255 * (I eq K)
        EndFor
    EndElse
EndFor
;
; The next trick we perform is to de-focus the
; image in steps so that pixels nearest the
; top that appear farthest away are also the most
; out-of-focus.
;
For Y = (Size(Image))[2] - 31, 0, -32 Do Begin
    For I = 0, 2 Do Begin
;
; Smooth pixels from this row up.  Rows at the
; top are smoothed more often than rows at the
; bottom.
;
        Layer = Smooth(Reform(Image[I, *, Y:*]), 3)
        Image[I, *, Y:*] = Layer
    EndFor
EndFor
;
; Create the backdrop image.  Don't forget it's TrueColor!
;
BackdropImage = Obj_New('IDLgrImage', Image, Interleave = 0)
;
; Create the backdrop object using the image object as the
; texture object.  Keep in mind that the texture mapped image
; colors are convolved with the COLOR property of the surface
; object.
;
BackdropObject = Obj_New('IDLgrSurface', .2 - Z/100., 2.5*XX, YY*3.5, $
    Shading = 1, Style = 2, Texture_Map = BackdropImage, $
    Color = [255, 255, 255], /Texture_Interp)
End

;--------------------------------------------------------------------
function dave_uscensusBuild_Scale_Legend, info
;
;This routine builds the legend for the display.  Each legend entry
;consists of a color block and a text label associated
;with that color.  Colors in dave_uscensus represent rate of
;population change.
;
oScaleModel  = obj_new('IDLgrModel')

n_scale_colors = n_elements(info.range_max) + 2
scale_color_models = ObjArr(n_scale_colors)
scale_color_images = ObjArr(n_scale_colors)
scale_color_labels = ObjArr(n_scale_colors)
oFont = Obj_New('IDLgrFont', 'Hershey*3', size=7)
;
;Store font so that it will get destroyed when the Scale Legend
;is destroyed.
;
oContainer = obj_new('IDL_Container')
oContainer->Add, oFont
oScaleModel->Add, oContainer
;
pixel_block = bytarr(3, 30, 20)
;
;The color white is used when a State is "new"; no census
;was performed the previous decade.
;
scale_color_images[0] = obj_new('IDLgrImage', $
    pixel_block + 255, $
    interleave=0, $
    dimensions=[.1, .2] $
    )
scale_color_labels[0] = obj_new('IDLgrText', $
    'New State', $
    /onglass, $
    location=[.11, -0.06], $
    color=[255, 255, 255], $
    font=oFont $
    )
;
;Red indicates there was population loss compared with the
;previous decade.
;
pixel_block[0, *, *] = 255b ; Fill with red.
scale_color_images[1] = obj_new('IDLgrImage', $
    pixel_block, $
    interleave=0, $
    Dimensions=[.1, .2] $
    )
scale_color_labels[1] = obj_new('IDLgrText', $
    'Pop. Loss', $
    /onglass, $
    location=[.11, -0.06], $
    color = [255, 255, 255], $
    font=oFont $
    )
;
;The remaining keys indicate population change between one
;percentage and the next.
;
for i=2,n_scale_colors-1 do begin
    for j=0,2 do $
        pixel_block[j, *, *] = info.colors[j, i-1]
    scale_color_images[i] = obj_new('IDLgrImage', $
        pixel_block, $
        interleave=0, $
        dimensions=[0.1, 0.2] $
        )
    scale_color_labels[i] = obj_new('IDLgrText', $
        '> ' + strtrim(fix(100 * (info.range_max[i - 2] - .99999)), 2) $
             + '%', $
        color=[255, 255, 255], $
        location=[0.11, -0.06], $
        /onglass, $
        font=oFont $
        )
    end
;
;Combine the color blocks and text into a models, then
;translate them so we end up in 2 rows, each with 5 entries.
;
for i=0, n_scale_colors - 1 do begin
    scale_color_models[i] = obj_new('IDLgrModel')
    scale_color_models[i]->Add, scale_color_images[i]
    scale_color_models[i]->Add, scale_color_labels[i]
    scale_color_models[i]->Translate, $
        -.94 + .4 * (i mod 5), $
        -.575 * fix(i / 5), $
        0.
    end
oScaleModel->Add, obj_new('IDLgrText', $
    'Relative Population Change', $
    Location=[-.98, .55], $
    Font=oFont, $
    /onglass, $
    color=[255, 255, 255] $
    )
oScaleModel->Add, scale_color_models
return, oScaleModel
end
;--------------------------------------------------------------------
function dave_uscensusBuild_State_Objects, $
    states, $           ; IN
    xdim, $             ; IN
    ydim, $             ; IN
    oPolygonRot, $      ; IN
    oOutlineRot, $      ; IN
    debug=debug         ; IN
;
;Create a tessellator object.  A dave_uscensusRegion needs to use
;a Tessellator object to construct itself.  For efficiency, we will
;pass this single Tessellator to each of the regions we create,
;rather than requiring each region to construct its own Tessellator.
;
oTessellator = obj_new('IDLgrTessellator')
;
state_objects = objarr(n_elements(states))
hawaii_uval = obj_new()
for i=0,n_elements(states)-1 do begin
    info = create_struct( $
        states[i], $
        'oPolygonRot', oPolygonRot, $
        'oOutlineRot', oOutlineRot $
        )
;
;   Perform a Mercator projection on state's outline.
;   We use the Mercator projection in an attempt to
;   makes the state's shape look more familiar.
;
    *info.pOutline = dave_uscensusMercator(*info.pOutline)
;
;   Move Alaska and Hawaii so they lie closer to the
;   continental USA.  Make Alaska smaller.
;
    if info.state eq 'ALASKA' then begin
        *info.pOutline = *info.pOutline * .4
        (*info.pOutline)[0, *] = (*info.pOutline)[0, *] - 75
        (*info.pOutline)[1, *] = (*info.pOutline)[1, *] + 15
        end
    if info.state eq 'HAWAII' then begin
        (*info.pOutline)[0, *] = (*info.pOutline)[0, *] + 25
        (*info.pOutline)[1, *] = (*info.pOutline)[1, *] + 10
        end
;
;   Construct an object from the state info.
;
    state_objects[i] = obj_new('dave_uscensusRegion', $
        info, $
        offset=dave_uscensusMercator([104, -40]), $
        oTessellator=oTessellator, $
        debug=debug $
        )
;
;   Color lakes blue.
;
    if (strpos(states[i].state, 'LAKE') ne -1) then begin
        ;state_objects[i]->SetProperty, color=[0, 0, 255]
        state_objects[i]->SetProperty, color=[255, 255, 255]
        end
;
;   Gather up Hawaiian islands regions.
;
    if info.state eq 'HAWAII' then begin
        hawaii_uval = hawaii_uval[0] eq obj_new() ? $
            state_objects[i] : [hawaii_uval, state_objects[i]]
        end
    end
;
for i=0,n_elements(state_objects)-1 do begin
    state_objects[i]->GetProperty, region_name=region_name,abbr=abbr
    
    if strupcase(region_name eq 'HAWAII') then begin
        state_objects[i]->SetProperty, uvalue=hawaii_uval
        end
end
;
obj_destroy, oTessellator
return, state_objects
end;dave_uscensusBuild_State_Objects
;--------------------------------------------------------------------
Pro dave_uscensusDisplay_Census_Year, $
    app_state, $
    draw_individually=draw_individually

if n_elements(draw_individually) le 0 then $
    draw_indiv = app_state.draw_individually $
else $
    draw_indiv = draw_individually

if draw_indiv then begin
    widget_control, app_state.wYearDroplist, $
        set_droplist_select=app_state.year;app_state.n_years - app_state.year - 1
    end
;
;Label the census year.
;
;str = strtrim(1980 - (app_state.year - 1)*10, 2)
;str = strtrim(2008 - (app_state.year - 1), 2)
str = strtrim(string(app_state.year),2)
app_state.oYearText->SetProperty, string=str


for i=0,n_elements(app_state.state_objects)-1 do begin
    oRegion = app_state.state_objects[i]
    oRegion->SetProperty, color=dave_uscensusZ_color(app_state, oRegion)
;    if oRegion->Population(app_state.year) eq 0 then begin
    if oRegion->data(app_state.year) eq 0 then begin
        oRegion->SetProperty, scale=[1, 1, 1.e-4]
        end $
    else begin
        oRegion->SetProperty, scale=[ $
            1, $
            1, $
            (oRegion->Data(app_state.year) $
                / float(app_state.MaxZValue)) * .25 $
;            (oRegion->Population(app_state.year) $
;                / float(app_state.MaxZValue)) * .25 $
            ]
;
;       If we're on a fast machine, we might want to animate the States
;       individually growing.
;
        if draw_indiv then begin
            dave_uscensusDraw, app_state, 0
            end
        end
    end
;
if not draw_indiv then begin
    dave_uscensusDraw, app_state, 0
    widget_control, app_state.wYearDroplist, $
        set_droplist_select=app_state.year;app_state.n_years - app_state.year - 1
    end
end
;--------------------------------------------------------------------
pro dave_uscensusCleanup, tlb
widget_control, tlb, get_uvalue=pAppState

tvlct, (*pAppState).color_table
if widget_info((*pAppState).groupbase, /valid) then $
    widget_control, (*pAppState).groupbase, /map
;
;
tagnames = tag_names(*pAppState)
;Clean up heap variables.
;
for i=0,n_tags(*pAppState)-1 do begin
    case size((*pAppState).(i), /tname) of
        'POINTER': $
            ptr_free, (*pAppState).(i)
        'OBJREF': $
            if strupcase(tagnames[i]) ne 'DAVETOOL' then $  
                  obj_destroy, (*pAppState).(i)
        else:
        endcase
    end
ptr_free, pAppState
end
;--------------------------------------------------------------------
pro dave_uscensusUnselect, app_state, no_draw=no_draw
if (*app_state.pChosenRegions)[0] ne obj_new() then begin
    for i=0,n_elements(*app_state.pChosenRegions)-1 do begin
        (*app_state.pChosenRegions)[i]->SetProperty, $
            color=dave_uscensusZ_color( $
                app_state, $
                (*app_state.pChosenRegions)[i] $
                )
        end
    app_state.oStateText->SetProperty, string=''
    *app_state.pChosenRegions = obj_new()
    if not keyword_set(no_draw) then begin
        dave_uscensusDraw, app_state, 0
        end
    end
end
;--------------------------------------------------------------------
pro dave_uscensusSetOutlinesOnOrOff, app_state
;
;Turn region outlines on or off, depending on whether they are
;facing toward the user.
;
app_state.oPolygonRot->GetProperty, transform=transform
for i=0,n_elements(app_state.state_objects)-1 do begin
    app_state.state_objects[i]->SetProperty, $
        outline=transform[10] gt 0
    end
end
;--------------------------------------------------------------------

pro dave_uscensusconvertInputData,ifn,newStates

;CONVERTING A DATA FILE FROM PETER'S FORMAT.
;
;THIS IS SPECIFIC TO MY COMPUTER BECAUSE OF THE TRASFER OF DATA BY READING IN TO A FILE.
;THIS STEP COULD BE SKIPPED BY WRITING TO A VARIABLE!!!

fn = 'C:\Documents and Settings\kneller\Desktop\Data\ResearchParticipantsv1.txt'
if n_elements(ifn) eq 0 then begin
  return
endif
if ifn eq '' then return

fn = ifn

nlines = file_lines(fn)

s=''
snew = ['']
year = ''
nyears = 0
years =[0]

openr,lun,fn,/get_lun
for i=0,nlines-1 do begin
  readf,lun,s

  if strlen(s) gt 1 then begin

    ;IGNORE COMMENT LINES
    firstchar = strmid(s,0,1)
    if firstchar ne '#' then begin

      segs = strsplit(s,/extract)
      nsegs = n_elements(segs)

      ;YEAR LINES
      if nsegs eq 1 and segs[0] ne '' then begin
        year = segs[0]
        years = [years,long(year)]
        nyears++
      endif

      ;DATA LINES
      if nsegs ge 2 then begin
        snew = [snew,string(segs[0],year,segs[1],format='(A10,A10,A10)')]
      endif

    endif;firstchar      
  endif;strlen
endfor;i

free_lun,lun
if n_elements(snew) gt 1 then begin 
  snew = snew[1:*]
endif else begin
  void = dialog_message('No Data in File '+file_basename(ifn))
  return
endelse
if nyears gt 0 then years = years[1:*]

;GET ALL THE STATES INFORMATION
defsysv,'!DAVE_AUXILIARY_DIR',exists=exists
if exists ne 0 then begin
  datafile = !DAVE_AUXILIARY_DIR+ 'ResearchParticipantsData.sav'
endif else begin
  datafile = 'C:\Documents and Settings\kneller\Desktop\Data\ResearchParticipantsData.sav'
endelse
restore,datafile


popstates = states

;CREATE A NEW DATA STRUCTURE WITH THE DATA FIELD
str = {STATE:'Name',$ 
       ZIP:'PA',$
       SUBREGION:'',$
       POUTLINE:ptr_new(),$
       PNORMALOUTLINE:ptr_new(),$ 
       PPOLYGONLIST:ptr_new(),$
       PVERTEXLIST:ptr_new(),$
       ZVALUE:0.0,$
       COLOR:intarr(3),$
       NICKNAME:'',$
       POPULATION:lonarr(nyears),$
       researchParticipants:lonarr(nyears),$
       years:lonarr(nyears),$
       data:dblarr(nyears),$
       title:''}

newStates = replicate(str,n_elements(popstates))
for i=0,n_elements(newStates)-1 do begin
  newStates[i].state = popstates[i].state
  newStates[i].ZIP = popstates[i].ZIP
  newStates[i].subregion = popstates[i].subregion
  if ptr_valid(popstates[i].poutline) ne 0 then  newStates[i].poutline = ptr_new(*(popstates[i].poutline))
  if ptr_valid(popstates[i].pnormaloutline) ne 0 then  newStates[i].pnormaloutline = ptr_new(*(popstates[i].pnormaloutline))
  if ptr_valid(popstates[i].ppolygonlist) ne 0 then  newStates[i].ppolygonlist = ptr_new(*(popstates[i].ppolygonlist))
  if ptr_valid(popstates[i].pvertexlist) ne 0 then  newStates[i].pvertexlist = ptr_new(*(popstates[i].pvertexlist))
  newStates[i].zvalue = popstates[i].zvalue
;  print,'popstates[i].ZIP,zvalue=',popstates[i].zip,popstates[i].zvalue
  newStates[i].color = popstates[i].color
  newStates[i].nickname = popstates[i].nickname
  newStates[i].years = years
  newStates[i].title = file_basename(ifn)
endfor;i


;GET THE DATA FROM THE STRING;FILE
nlines = n_elements(snew);file_lines(ofn)

year0 = min(years)
for i=0,nlines-1 do begin
  s = snew[i]
  segs = strsplit(s,/extract)
  if n_elements(segs) eq 3 then begin
    year = fix(segs[1])
    participants = 0;fix(segs[2])
    dataPoint = double(segs[2])
    whmatch = where(segs[0] eq newStates[*].zip,nmatch)
    ;print,whmatch
    if nmatch ne 0 then begin
      newStates[whmatch[*]].population[(where(year eq years))[0]] = participants
      newStates[whmatch[*]].researchParticipants[(where(year eq years))[0]] = participants
      newStates[whmatch[*]].data[(where(year eq years))[0]] = dataPoint
;      newStates[whmatch[*]].population[year-year0] = participants
;      newStates[whmatch[*]].researchParticipants[year-year0] = participants
;      newStates[whmatch[*]].data[year-year0] = dataPoint
    endif
  endif;nsegs eq 3
endfor;i

;print,'end  dave_uscensusconvertInputData'
;ofn2 = dialog_pickfile()
;ofn2 = 'C:\Documents and Settings\kneller\Desktop\Data\ResearchParticipantsData2008.sav'
;save,states,filename=ofn2
end;dave_uscensusconvertInputData

pro dave_uscensusOpen,pAppState,init=init,nStates=nstates,nyears=nyears,states=states,years=years,$
                      oPolygonRot=oPolygonRot,$
                      oOutlineRot=oOutlineRot,$
                      oOutlineOffset=oOutlineOffset,$
                      oUnitedStates=oUnitedStates,$
                      workdir=workdir,$
                      datadir=datadir,$
                      wLabelYearDroplist=wLabelYearDroplist,$
                      wYearDroplist=wYearDroplist,$
                      state_objects=state_objects,$
                      ViewObject1=ViewObject1,$
                      xdim=xdim,ydim=ydim,$
                      datafile=datafile


      
      print,'dave_uscensusOpen'

      if n_elements(init) eq 0 then init = 0
      print,n_elements(pAppState)
;
;      restore,'C:\Documents and Settings\kneller\Desktop\Data\ResearchParticipantsData.txt'
;      help,states
;      help,*(*pAppState).pstates

if init eq 1 then begin
    defsysv,'!DAVE_AUXILIARY_DIR',exists=exists
    if exists ne 0 then begin
      datafile = !DAVE_AUXILIARY_DIR+ 'ResearchParticipantsData.sav'
    endif else begin
      datafile = 'C:\Documents and Settings\kneller\Desktop\dave_clean_062409\dave\programs\auxiliary\ResearchParticipantsData.sav'
    endelse
    restore,datafile
    ;restore,'C:\Documents and Settings\kneller\Desktop\Data\ResearchParticipantsData.sav'
    NStates = N_elements(States)
    NYears = N_elements(States[0].Population)
    title = N_elements(States[0].title)

;help,states
;help,states[0],/struct

    years = strtrim(string(states[0].years),2)

    oPolygonRot = obj_new('IDLexRotator', [xdim, ydim] / 2, xdim / 2)
    oOutlineRot = obj_new('IDLexRotator', [xdim, ydim] / 2, xdim / 2)
    
    oOutlineOffset = obj_new('IDLgrModel')
    oOutlineOffset->Add, oOutlineRot
    ;
    ; To avoid conflict with polygons, move outlines slightly.
    ;
    oOutlineOffset->Translate, 0, 0, .001 ; Amount determined empirically.
    ;
    oUnitedStates = obj_new('IDLgrModel')
    oUnitedStates->Add, oOutlineOffset
    oUnitedStates->Add, oPolygonRot
    
      if n_elements(workdir) eq 0 then workdir = file_dirname(datafile)
      if n_elements(datadir) eq 0 then datadir = file_dirname(datafile)
      widget_control,wYearDroplist,set_value=years
;print,years      
      state_objects = dave_uscensusBuild_State_Objects( $
          states, $
          xdim, $
          ydim, $
          oPolygonRot, $
          oOutlineRot, $
          debug=keyword_set(debug) $
          )

      
      ; Translate the model up Z toward the viewer so we can
      ; make room for the backdrop.
      ;
      oUnitedStates->Translate, 0., 0., .5
      ;
      ; Zoom-in for a nice initial view.
      ;
      oUnitedStates->Scale, 2.0, 2.0, 1
      ;
      ; Add the nation to the appropriate view.
      ;
      ViewObject1->Add, oUnitedStates




endif else begin
  
  if n_elements(datafile) eq 0 then begin
    fn = dialog_pickfile(title='Select the input file:  ',/read,path=(*pappstate).datadir)
  endif else begin
    fn = datafile
  endelse
  
    if fn[0] eq '' then begin   
      void = dialog_message('No file selected.',dialog_parent=(*pappstate).apptlb,/info)
      return
    endif else begin
      dave_uscensusconvertInputData,fn[0],newStates  
    endelse

    
    NStates = N_elements(newStates)
    years = newStates[0].years
    NYears = N_elements(newStates[0].data)
    title = newStates[0].title
;help,(*pappstate),/struct
    (*pappstate).n_years = nyears
    (*pappstate).year = 0;years
    

;help,states
;help,states[0],/struct

    years = strtrim(string(newstates[0].years),2)
    
    if n_elements(workdir) eq 0 then workdir = file_dirname(fn[0])
    if n_elements(datadir) eq 0 then datadir = file_dirname(fn[0])
    widget_control,(*pappstate).wYearDroplist,set_value=years
    widget_control,(*pappstate).wLabelYearDroplist,set_value='Select '+title+' Year:'
    widget_control,(*pappstate).apptlb,base_set_title='NCNR Mapping: '+title
    
    if ptr_valid((*pappstate).pstates) then ptr_free,(*pappstate).pstates    
    (*pappstate).pstates = ptr_new(newstates)
    state_objects = (*pappstate).state_objects

    ;RE-INITIALIZE THE STATES:
    for i=0,n_elements(state_objects)-1 do begin
       state_objects[i]->setproperty,data=0*newstates[0].data,population=0*newstates[0].population
    endfor;i

    
    ;NOW SCALE THE STATES:
    for i=0,n_elements(state_objects)-1 do begin
        state_objects[i]->GetProperty, region_name=region_name,abbr=abbr
        for j=0,n_elements(newstates)-1 do begin
          if strupcase(abbr) eq strupcase(newstates[i].zip) then begin
            state_objects[i]->setproperty,data=newstates[i].data,population=newstates[i].population
          endif
        endfor;j
    endfor;i
  (*pappstate).ocolorbar->setTitle,file_basename(fn[0]),$
                                   fontsize=45,$
                                   tickfontsize=30

  dave_uscensusSetColorTable,pAppState,/newFile
    
endelse

end;dave_uscensusOpen
;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
function dave_uscensusGetExt,s,iext=iext,len=len
        iext = strpos(s,'.',/reverse_search)

        if iext ne -1 then begin
            len  = strlen(s)
            ext  = strmid(s,iext+1,len-iext)
        endif else begin
            ext = ''
        endelse
        return,ext

end;dave_uscensusGetExt
pro dave_uscensusAddExtension,ofn,extension
        if n_elements(extension) eq 0 then extension = ''
      
        ext = dave_uscensusGetExt(ofn,iext=iext,len=len)        
        if ext ne extension then begin
            if iext gt 0 then begin
                sublen=len-iext
                ofn = strendsub(ofn,'.'+extension,sublen)
                ;void = dialog_message('AFTER strendsub call')

                ;print,'ofn after=',ofn
            endif else begin
                ofn = ofn+'.'+extension
            endelse
        endif

end;dave_uscensusAddExtension


pro dave_uscensusWriteImage,pAppState,tif=tif,png=png,jpg=jpg,_Extra=extra
print,'dave_uscensusWriteImage'
  
  if n_elements(tif) eq 0 then tif = 0
  if n_elements(jpg) eq 0 then jpg = 0
  if n_elements(png) eq 0 then png = 0

  ;help,(*pAppState),/struct
  oimage = (*pappstate).window_objects[0]->read()
  ;help,oimage
  obj_destroy,oimage

  
  (*pappstate).window_objects[0]->getProperty,image_data=image
  ;help,image
  fn = ''
  if tif eq 1 then begin
    fn = dialog_pickfile(filter = ['*.tif','*.tiff'],dialog_parent=(*pAppState).appTLB,/write)
    if fn ne '' then begin
      dave_uscensusAddExtension,fn,'tif'
      format='TIFF'
      for i=0,2 do begin
        tempimage = image[i,*,*]
        ;tempimage = reverse(tempimage,2)
        ;tempimage = reverse(tempimage,1)
        image[i,*,*] = tempimage
      endfor;i
    endif
  endif
  if png eq 1 then begin
    fn = dialog_pickfile(filter = ['*.png'],dialog_parent=(*pAppState).appTLB,/write)
    if fn ne '' then begin
      dave_uscensusAddExtension,fn,'png'
      format = 'PNG'
    endif
  endif
  if jpg eq 1 then begin
    fn = dialog_pickfile(filter = ['*.jpg','*.jpeg'],dialog_parent=(*pAppState).appTLB,/write)
    if fn ne '' then begin
      dave_uscensusAddExtension,fn,'jpg'
      format = 'JPEG'
    endif
  endif
  if fn ne '' then begin
    WRITE_IMAGE, fn, Format, image 
  endif


end;dave_uscensusWriteImage

pro dave_uscensusSetColorTable,pAppState,newfile=newfile
  if n_elements(newfile) eq 0 then newfile = 0
  
  if newfile eq 1 then begin
    ;print,'SETTING UP COLOR TABLE FOR NEW FILE.'
        tvlct,r,g,b,/get
        rgb_table = bytarr(n_elements(r),3)
        rgb_table[*,0] = r
        rgb_table[*,1] = g
        rgb_table[*,2] = b

        loadct,(*pAppState).colorTable
        tvlct,reds,greens,blues,/get


        (*pAppState).oColorBar->setProperty,red_values=reds,$
                                            green_values=greens,$
                                            blue_values=blues
;print,'dave_uscensusSetColorTable:   SET COLOR BAR TITLE!!!!'
        cbc = (*pAppState).oColorBar->get(/all)
        states = *(*pAppState).pstates
        temppops = [min(states[0].data[*])]
        for i=0,n_elements(states[0].data[*])-1 do begin
          temppops = [temppops,states[*].data[i]]
        endfor;i

        (*pAppState).oColorBar->setDataRange,[min(temppops),max(temppops)]

        ;GET COLOR TABLE      
        widget_control, (*pAppState).wDraw, draw_motion_events=0
        dave_uscensusUnselect, *pAppState

        (*pAppState).we_are_animating = 1b
        widget_control, (*pAppState).wAnimateButton, $
            set_value = 'Cancel Animation', $
            set_uvalue = 'CANCELANIMATION'
        (*pAppState).year = (*pAppState).n_years-1
        (*pAppState).tic = systime(1)
        widget_control, (*pAppState).wcontrols, timer = .1

       ; loadct,rgb_table=rgb_table

  endif else begin

        XCOLORS, /modal, ColorInfo=colorinfoStr,$
                         /noSliders,$
                         index=(*pAppState).colorTable ,$
                         /block,$
                         group_leader=(*pappstate).appTlb

        tvlct,r,g,b,/get
        rgb_table = bytarr(n_elements(r),3)
        rgb_table[*,0] = r
        rgb_table[*,1] = g
        rgb_table[*,2] = b

        loadct,(*pAppState).colorTable

        if colorinfoStr.index ne -1 then (*pAppState).colorTable = colorinfoStr.index

        (*pAppState).oColorBar->setProperty,red_values=colorinfoStr.r,$
                                            green_values=colorinfoStr.g,$
                                            blue_values=colorinfoStr.b

        cbc = (*pAppState).oColorBar->get(/all)
        states = *(*pAppState).pstates
        temppops = [min(states[0].data[*])]
        for i=0,n_elements(states[0].data[*])-1 do begin
          temppops = [temppops,states[*].data[i]]
        endfor;i

        (*pAppState).oColorBar->setDataRange,[min(temppops),max(temppops)]

        ;GET COLOR TABLE      
        widget_control, (*pAppState).wDraw, draw_motion_events=0
        dave_uscensusUnselect, *pAppState

        (*pAppState).we_are_animating = 1b
        widget_control, (*pAppState).wAnimateButton, $
            set_value = 'Cancel Animation', $
            set_uvalue = 'CANCELANIMATION'
        (*pAppState).year = (*pAppState).n_years-1
        (*pAppState).tic = systime(1)
        widget_control, (*pAppState).wcontrols, timer = .1
        ;loadct,rgb_table=rgb_table

  endelse
  (*pappstate).MaxZValue = max(temppops)
  dave_uscensusDisplay_census_year, *pAppState

end;dave_uscensusSetColorTable
pro dave_uscensus_event, event






widget_control, event.top, get_uvalue=pAppState ; Get state of application.

 CATCH, Error_status 
 
   ;This statement begins the error handler: 
   IF Error_status NE 0 THEN BEGIN 
      PRINT, 'Error index: ', Error_status 
      PRINT, 'Error message: ', !ERROR_STATE.MSG 
      ; Handle the error by extending A: 
      void = dialog_message(['In dave_usecensus_event:',$
                             !ERROR_STATE.MSG,$ 
                             'Contact Larry Kneller and/or the DAVE team.'],$
                             dialog_parent=(*pappstate).apptlb)
      return
      CATCH, /CANCEL 

   ENDIF 



;demo_record, event, filename=(*pAppState).record_to_filename

;
;
;Handle Widget Kill Requests explicitly.  Doing this is friendly
;to the demo_tour. i.e. it allows demo_tour recordings of dave_uscensus to
;have quit-via-the-window-manager events in them.
;
if tag_names(event, /structure_name) eq 'WIDGET_KILL_REQUEST' then begin
    widget_control, event.id, /destroy
    return
    end
;
if tag_names(event, /structure_name) eq 'WIDGET_BASE' then begin
    widget_control, /hourglass
;
;   Handle resize events on the top level base.
;
    scale_geom = widget_info((*pAppState).wScale, /geometry)
    button_base_geom = widget_info((*pAppState).wControls, /geometry)
    draw_xsize = event.x-button_base_geom.xsize-2
    draw_ysize = event.y-scale_geom.ysize-(*pAppState).status_geom.scr_ysize
    widget_control, $
        (*pAppState).wDraw, $
        xsize=draw_xsize, $
        ysize=draw_ysize
    (*pAppState).oPolygonRot->SetProperty, $
        center=[draw_xsize, draw_ysize]/2, $
        radius=draw_xsize/2
    (*pAppState).oOutlineRot->SetProperty, $
        center=[draw_xsize, draw_ysize]/2, $
        radius=draw_xsize/2
    widget_control, (*pAppState).wScale, xsize=draw_xsize
    widget_control, event.id, xsize=event.x
;
;   Resize the backdrop, if it's there, and create the
;   new instance.
;
    if (*pAppState).backdrop then begin
        (*pAppState).view_objects[0]->SetProperty, transparent=0
        (*pAppState).oUnitedStates->SetProperty, hide=1
        (*pAppState).oYearText->SetProperty, hide=1
        (*pAppState).oStateText->SetProperty, hide=1
        (*pAppState).oBackDropModel->SetProperty, hide=0

        dave_uscensusDraw, *pAppState, 0, /create_instance

        (*pAppState).oUnitedStates->SetProperty, hide=0
        (*pAppState).oYearText->SetProperty, hide=0
        (*pAppState).oStateText->SetProperty, hide=0
        (*pAppState).oBackDropModel->SetProperty, hide=1
        (*pAppState).view_objects[0]->SetProperty, transparent=1
    endif
;
;   Draw the view.
;
    dave_uscensusDraw, *pAppState, 0
    ;dave_uscensusDraw, *pAppState, 1
    return
    end
;
;Handle Trackball updates.
;
void = (*pAppState).oPolygonRot->Update(event)
if (*pAppState).oOutlineRot->Update(event) then begin

    (*pAppState).oOutlineRot->GetProperty, transform=transform
    angle = dave_uscensusAngle3123(transform[0:2, 0:2])
    widget_control, (*pAppState).wXSlider, set_value=angle[0]
    widget_control, (*pAppState).wYSlider, set_value=angle[1]
    widget_control, (*pAppState).wZSlider, set_value=angle[2]

    dave_uscensusSetOutlinesOnOrOff, *pAppState
    dave_uscensusDraw, *pAppState, 0
    end
;
widget_control, event.id, get_uvalue=uvalue

case uvalue of
    'OPEN':begin
      
      dave_uscensusOpen,pAppState
      (*pAppState).year = 0  ;NEED TO INITIALIZE THIS HERE, OTHERWISE WE MAY GET AN INIFINITE LOOP ELSEWHERE.

    end;open
    'SETCOLORTABLE':begin
        
         dave_uscensusSetColorTable,pAppState
;        XCOLORS, /modal, ColorInfo=colorinfoStr,/noSliders,index=(*pAppState).colorTable ,/block,group_leader=(*pappstate).appTlb
;        ;help,colorinfoStr,/struct
;  
;        if colorinfoStr.index ne -1 then (*pAppState).colorTable = colorinfoStr.index
;        
;        (*pAppState).oColorBar->setProperty,red_values=colorinfoStr.r,$
;                                            green_values=colorinfoStr.g,$
;                                            blue_values=colorinfoStr.b
;        
;        cbc = (*pAppState).oColorBar->get(/all)
;        states = *(*pAppState).pstates
;        ;temppops = [states[*].researchParticipants[0],states[*].researchParticipants[1],states[*].researchParticipants[2]]
;;        temppops = [min(states[0].researchParticipants[*])]
;;        for i=0,n_elements(states[0].researchParticipants[*])-1 do begin
;;          temppops = [temppops,states[*].researchParticipants[i]]
;;        endfor;i
;        temppops = [min(states[0].data[*])]
;        for i=0,n_elements(states[0].data[*])-1 do begin
;          temppops = [temppops,states[*].data[i]]
;        endfor;i
;        
;        (*pAppState).oColorBar->setDataRange,[min(temppops),max(temppops)]
;
;        ;GET COLOR TABLE      
;        widget_control, (*pAppState).wDraw, draw_motion_events=0
;        dave_uscensusUnselect, *pAppState
;
;        (*pAppState).we_are_animating = 1b
;        widget_control, (*pAppState).wAnimateButton, $
;            set_value = 'Cancel Animation', $
;            set_uvalue = 'CANCELANIMATION'
;        (*pAppState).year = (*pAppState).n_years
;        (*pAppState).tic = systime(1)
;        widget_control, (*pAppState).wcontrols, timer = .1

    end;SETCOLORTABLE
    'WRITEPNG':begin
      dave_uscensusWriteImage,pAppState,/png
    end;writePNG
    'WRITEJPG':begin
      dave_uscensusWriteImage,pAppState,/jpg
    end;writeJPG
    'WRITETIFF':begin
      dave_uscensusWriteImage,pAppState,/tif      
    end;writeTIFF
    'QUIT' : begin
        widget_control, event.top, /destroy
        return
        end
    'DRAW' : begin
        case event.type of
;
;           Dwell event.
;
            2: begin
                if (*pAppState).we_are_animating $
                or (*pAppState).we_are_rotating then $
                    return
                selected = (*pAppState).window_objects[0]->Select( $
                    (*pAppState).view_objects[0], $
                    [event.x, event.y] $
                    )
                if obj_valid(selected[0]) then begin
                    selected[0]->GetProperty, uvalue=chosen_regions
                    if n_elements(chosen_regions) eq 0 then $
                        chosen_regions = obj_new()
                    if obj_valid(chosen_regions[0]) then begin
                        if (*(*pAppState).pChosenRegions)[0] $
                        ne chosen_regions[0] $
                        then begin
                            dave_uscensusUnselect, *pAppState, /no_draw
                            pop = chosen_regions[0]->Population( $
                                (*pAppState).year $
                                )
                            chosen_regions[0]->GetProperty, region_name=str

;                              str = str $
;                                  + '  Research Participants: ' $
;                                  + dave_uscensusStrCommas(pop)

                  ;DISPLAY INFO IN THE TEXT WIDGET
                      chosen_regions[0]->GetProperty, region_name=stateName
                      dropyear = widget_info((*pAppState).wYearDroplist,/droplist_select)
                      widget_control,(*pAppState).wYearDroplist,get_value=year_eh
                      syear = strtrim(string(year_eh[dropyear]),2)      

                      ;title = 'NCNR Research Participants'
                      
                      title = (*(*pappstate).pstates)[0].title
                      ;print,title
                      teststr = [ syear,$
                                  title+':',$
                                  stateName+':   '+strtrim(string(chosen_regions[0]->Data((*pAppState).year)),2)]
                      
                      widget_control,(*pAppState).wInfoText,set_value=teststr

;                            if pop gt 0 then $
;                                str = str $
;                                    + '  population: ' $
;                                   + dave_uscensusStrCommas(pop)
                            (*pAppState).oStateText->SetProperty, string=str
                            ;(*pAppState).oStateText->SetProperty, hide=0

                            *(*pAppState).pChosenRegions = chosen_regions
                            for i=0,n_elements(chosen_regions)-1 do begin
                                chosen_regions[i]->SetProperty, $
                                    color=[255,255,63]
                                end
                            dave_uscensusDraw, *pAppState, 0
                            end
                        end
                    end $
                else begin
                    widget_control,(*pAppState).wInfoText,set_value=strarr(3)
                    dave_uscensusUnselect, *pAppState
                    end
                end
;
;           Mouse-button press.
;
            0: begin
                if event.press eq 1 then $
                    (*pAppState).we_are_rotating = 1b
                widget_control, (*pAppState).wDraw, draw_motion_events=1
                end
;
;           Mouse-button release.
;
            1: if event.release eq 1 then begin
                (*pAppState).we_are_rotating = 0b
                end
;
;           Expose event.
;
            4: begin
                dave_uscensusDraw, *pAppState, 0
                ;dave_uscensusDraw, *pAppState, 1
                end
            else:
            endcase
        end
    'CANCELANIMATION' : begin
        widget_control, (*pAppState).wAnimateButton, $
            set_value='Animate Census', $
            set_uvalue='ANIMATE'

        widget_control, event.top, /clear_events

        (*pAppState).we_are_animating = 0b
        widget_control, (*pAppState).wDraw, draw_motion_events=1
        end
    'DOINGANIMATION' : begin
;
;       This event was thrown from the controls base.  we use a timer
;       event off this base to indicate "frame advance" in the animation.
;
        case 1 of
            (*pAppState).we_are_rotating: $
                widget_control, (*pAppState).wControls, timer=.1
            ;(*pAppState).year ne 0 and (*pAppState).we_are_animating: begin
            (*pAppState).year lt (*pAppState).n_years-1 and (*pAppState).we_are_animating: begin
                (*pAppState).year = (*pAppState).year + 1;- 1
                dave_uscensusDisplay_census_year, *pAppState
                widget_control, (*pAppState).wControls, timer=.1
                end
            else: begin
;
;               End the animation,
;
                widget_control, (*pAppState).wAnimateButton, $
                    set_value='Animate Census', $
                    set_uvalue='ANIMATE'
                (*pAppState).we_are_animating=0b
                widget_control, (*pAppState).wDraw, draw_motion_events=1
                ;print, systime(1) - (*pAppState).tic
                end
            endcase
        end
    'ANIMATE' : begin
        widget_control, (*pAppState).wDraw, draw_motion_events=0
        dave_uscensusUnselect, *pAppState
        (*pAppState).we_are_animating = 1b
;
;       Modify the "Animate Census" button so it will now throw
;       "CANCELANIMATION" events.
;
        widget_control, (*pAppState).wAnimateButton, $
            set_value = 'Cancel Animation', $
            set_uvalue = 'CANCELANIMATION'
;
;       Initialize the year.
;
        (*pAppState).year = 0;(*pAppState).n_years
;
;       Throw a timer event from the controls base.  Events from the
;       controls base are handled as "animation frame advance" events.
;
        (*pAppState).tic = systime(1)
        widget_control, (*pAppState).wcontrols, timer = .001
        end
    'LEGEND' : begin
        dave_uscensusDraw, *pAppState, 0
        ;dave_uscensusDraw, *pAppState, 1
        end
    'CENSUSYEAR' : begin
        widget_control, /hourglass
        dave_uscensusUnselect, *pAppState, /no_draw
        ;(*pAppState).year = ((*pAppState).n_years-1) - event.index
        (*pAppState).year = widget_info((*pappstate).wYearDroplist,/droplist_select)

        dave_uscensusDisplay_census_year, (*pAppState)
        
        end
    'ROTATION_SLIDER': begin
        widget_control, (*pAppState).wXSlider, get_value=x_degree
        widget_control, (*pAppState).wYSlider, get_value=y_degree
        widget_control, (*pAppState).wZSlider, get_value=z_degree

        (*pAppState).oPolygonRot->GetProperty, transform=t
        rot_mat = dave_uscensusSpace3123(x_degree, y_degree, z_degree) $
                # t[0:2, 0:2]
;
;       Find the Euler parameters 'e4' of rot_mat which
;       is the rotation it takes to go from the original (T)
;       to the final (dave_uscensusSpace3123(X_DEGREE, Y_DEGREE, ZDEGREE)).
;
        e4 = 0.5 * sqrt(1.0 + rot_mat[0,0] + rot_mat[1,1] + rot_mat[2,2])
;
;       Find the unit vector of the single rotation axis
;       and the angle of rotation.
;
        case e4 of
            0: begin
                case 1 of
                    rot_mat[0, 0] eq 1: axis_rot = [1, 0, 0]
                    rot_mat[1, 1] eq 1: axis_rot = [0, 1, 0]
                    else: axis_rot = [0, 0, 1]
                    endcase
                angle_rot = 180.0
                end
            1: return ; We can't take ACOS(E4) so bail out.
            else: begin
                e1 = (rot_mat[2,1] - rot_mat[1,2]) / (4.0*e4)
                e2 = (rot_mat[0,2] - rot_mat[2,0]) / (4.0*e4)
                e3 = (rot_mat[1,0] - rot_mat[0,1]) / (4.0*e4)
                modulus_e = sqrt(e1*e1 + e2*e2 +e3*e3)
                if modulus_e eq 0.0 then $
                    return
                axis_rot = [e1, e2, e3] / modulus_e
                angle_rot = (2.0 * acos(e4)) * 180 / !dpi
                end
            endcase

        indx = where(abs(axis_rot) lt 1.0e-6)
        if indx[0] ne -1 then $
            axis_rot[indx] = 1.0e-6
;
;       Apply what we have found.
;
        (*pAppState).oPolygonRot->Rotate, axis_rot, angle_rot
        (*pAppState).oOutlineRot->Rotate, axis_rot, angle_rot
        dave_uscensusSetOutlinesOnOrOff, *pAppState
        dave_uscensusDraw, (*pAppState), 0
        end
    'SCALING': begin
        (*pAppState).oUnitedStates->Scale, $
            1/(*pAppState).scale, $
            1/(*pAppState).scale, $
            1

        range = widget_info(event.id, /slider_min_max)
        (*pAppState).scale = 0.25 + float(event.value) / (range[1] /2)
        widget_control, (*pAppState).wScalingLabel, $
            set_value='Scaling : ' $
                     + string((*pAppState).scale * 100., format='(f5.1)') $
                     + ' %'

        (*pAppState).oUnitedStates->Scale, $
            (*pAppState).scale, $
            (*pAppState).scale, $
            1
        widget_control, /hourglass
        dave_uscensusDisplay_census_year, *pAppState, draw_individually=0
        end
    'HELP' : begin
        online_help, 'd_uscensus', $
            book=demo_filepath( $
                "idldemo.adp", $
                subdir=['examples','demo','demohelp'] $
                ), $
            /full_path
        end
    else :
    endcase
end
;--------------------------------------------------------------------
Pro dave_uscensusCreateStates

end;dave_uscensusCreateStates
Pro dave_uscensus, Resizeable=Resizeable, $
    Animate_States = Animate_States, Backdrop = Backdrop, $
    Depth = Depth, Debug = Debug, $
    Record_To_Filename=record_to_filename, $
    Group_Leader = Group_Leader, AppTLB = AppTLB,$
    workDir=workDir, dataDir=dataDir, DAVETool=DAVETool, _EXTRA=extra    



 CATCH, Error_status 
 
   ;This statement begins the error handler: 
   IF Error_status NE 0 THEN BEGIN 
      PRINT, 'Error index: ', Error_status 
      PRINT, 'Error message: ', !ERROR_STATE.MSG 
      ; Handle the error by extending A: 
      void = dialog_message(['Could not Open MapApp:',$
                             !ERROR_STATE.MSG,$ 
                             'Contact Larry Kneller and/or the DAVE team.'],$
                             dialog_parent=group_leader)
      widget_control,wBase,/destroy                             
      return
      CATCH, /CANCEL 

   ENDIF 


If (XRegistered('dave_uscensus', /NoShow)) then Begin
    v = Dialog_Message('An instance of dave_uscensus is already running.')
    return
EndIf
if n_elements(davetool) eq 0 then begin
  davetool = getDaveTool()
  if obj_valid(daveTool) eq 0 then daveTool = obj_new()
endif



If (N_elements(Group_Leader) ne 0) then Begin
    If (N_elements(Group_Leader) eq 1) then Begin
        OkayGroupLeader = Widget_Info(Group_Leader, /Valid_ID)
    EndIf Else Begin
        OkayGroupLeader = 0
    EndElse
    If (not OkayGroupLeader) then Begin
        v = Dialog_Message('The GROUP_LEADER parameter is invalid.')
        return
    EndIf
        groupBase = Group_Leader
EndIf else groupBase = 0L

ngroup = N_elements(Group_Leader)



;
;
;
; Get the current color vectors to restore
; when this application is exited.
;
TVLCT, savedR, savedG, savedB, /GET
;
; Build color table from color vectors
;
colorTable = [[savedR],[savedG],[savedB]]
;
If (Keyword_Set(Depth)) then Begin
    Depth_Cue = [-.75, -0.25]
EndIf Else Begin
    Depth_Cue = [0., 0.]
EndElse
;
; We show relative population changes from decade to decade
; via color indices.
;
range_max = [1., 1.01, 1.1, 1.2, 1.5, 2., 3.]
Colors = [ $
    [255, 0, 0], $
    [115, 40, 100], $
    [105, 95, 105], $
    [15, 150, 0], $
    [0, 255, 0], $
    [105, 105, 200], $
    [145, 195, 125], $
    [195, 215, 255]]
population_scale = {range_max : range_max, Colors : Colors}
;
; Set the draw window size.
;
DEVICE, GET_SCREEN_SIZE = screenSize
XDim= 0.70 * screenSize[0]
YDim= 0.55 * XDim


;
;
;
;
;
; Create widgets.
;
If not Keyword_Set(resizeable) Then $
    If (Keyword_Set(Group_Leader)) then Begin
        wBase = Widget_Base(/COLUMN, Group=Group_Leader, MBar=MenuBar, $
            XPad = 0, YPad = 0, Title = 'DAVE: NCNR Research Participant Data', $
            /TLB_Size_Events, Space = 0, $
            TLB_Frame_Attr=1, $
            /TLB_Kill_Request_Events, $ ; A nicety for DEMO, /RECORD.
            UName = 'dave_uscensus:tlb')
    EndIf Else Begin
        wBase = Widget_Base(/COLUMN, MBar = MenuBar, $
            XPad = 0, YPad = 0, Title = 'DAVE: NCNR Research Participant Data', $
            /TLB_Size_Events, Space = 0, $
            TLB_Frame_attr=1, $
            UName = 'dave_uscensus:tlb')
    EndElse $
Else $
    If (Keyword_Set(Group_Leader)) then Begin
        wBase = Widget_Base(/COLUMN, Group=Group_Leader, MBar=MenuBar, $
            XPad = 0, YPad = 0, Title = 'DAVE: NCNR Research Participant Data', $
            /TLB_Size_Events, Space = 0, $
            UName = 'dave_uscensus:tlb')
    EndIf Else Begin
        wBase = Widget_Base(/COLUMN, MBar = MenuBar, $
            XPad = 0, YPad = 0, Title = 'DAVE: NCNR Research Participant Data', $
            /TLB_Size_Events, Space = 0, $
            UName = 'dave_uscensus:tlb')
    EndElse

wBase1 = WIDGET_BASE(wBase,/Row)

AppTLB = wBase
FileMenu = Widget_Button(MenuBar, Value = 'File', /Menu)
OpenButton = Widget_Button(FileMenu, Value = 'Open', $
    UValue = 'OPEN', UName = 'dave_uscensus:open');,sensitive=0)
SetColorTableButton = Widget_Button(FileMenu, Value = 'Set Color Table', $
    UValue = 'SETCOLORTABLE', UName = 'dave_uscensus:setcolortable')
WritePNGButton = Widget_Button(FileMenu, Value = 'Write to PNG', $
    UValue = 'WRITEPNG', UName = 'dave_uscensus:writepng')
WriteJPEGButton = Widget_Button(FileMenu, Value = 'Write to JPG', $
    UValue = 'WRITEJPG', UName = 'dave_uscensus:writejpg')
WriteTIFFButton = Widget_Button(FileMenu, Value = 'Write to TIFF', $
    UValue = 'WRITETIFF', UName = 'dave_uscensus:writetiff')

QuitButton = Widget_Button(FileMenu, Value = 'Quit', $
    UValue = 'QUIT', UName = 'dave_uscensus:quit')

HelpMenu = Widget_Button(MenuBar, Value = 'About', /Help,  /Menu)
;HelpButton = Widget_Button(HelpMenu, $
;    Value = 'About the U.S. Census demo...', UValue = 'HELP')

wControls = Widget_Base(wBase1, $
    /Column, $
    UValue = 'DOINGANIMATION', $
    UName = 'dave_uscensus:controls_base' $
    )

wAnimateButton = Widget_Button(wControls, $
    Value = 'Animate Census', $
    UValue = 'ANIMATE', $
    UName = 'dave_uscensus:animate' $
    )

wLabelYearDroplist = Widget_Label(wControls, Value='Select Research Participant Info Year:', /Align_Center)
wYearDroplist = Widget_Droplist(wControls, $
;    Value=StrTrim(1790 + Indgen(NYears)*10, 2), $
;    Value=StrTrim(2005 + Indgen(NYears), 2), $
    Value=StrTrim(2005 + Indgen(3), 2), $
    UValue = 'CENSUSYEAR', $
    /Align_Center, $
    UName='dave_uscensus:year' $
    )

wCenteringBase = Widget_Base(wControls, /Align_Center, /Column)
    ;initial_angles = [-10, 0, 0] ; degrees. [x, y, z]
    initial_angles = [0, 0, 0] ; degrees. [x, y, z]
    wRotationsBase = Widget_Base(wCenteringBase, /Column, /Frame)
        void = Widget_Label(wRotationsBase, Value='Rotation Angle')
        wXSlider = Widget_Slider( $
            wRotationsBase, $
            Title='X', $
            Minimum=-180, $
            Maximum=180, $
            UValue='ROTATION_SLIDER', $
            Value=initial_angles[0] $
            )
        wYSlider = Widget_Slider( $
            wRotationsBase, $
            Title='Y', $
            Minimum=-180, $
            Maximum=180, $
            UValue='ROTATION_SLIDER', $
            Value=initial_angles[1] $
            )
        wZSlider = Widget_Slider( $
            wRotationsBase, $
            Title='Z', $
            Minimum=-180, $
            Maximum=180, $
            UValue='ROTATION_SLIDER', $
            Value=initial_angles[2] $
            )

    wScalingBase = Widget_Base(wCenteringBase, /Column)
        wScalingLabel = Widget_Label( $
            wScalingBase, $
            Value='Scaling : ' $
                 + string(100, format='(f5.1)') $
                 + ' %' $
            )
        wScalingSlider = widget_slider(wScalingBase, $
            Minimum=0, $
            Maximum=40, $
            value=15, $
            /Suppress_Value, $
            Uvalue='SCALING' $
            )

winfotext = widget_text(wCenteringBase,xsize=40,ysize=4)

Drawbase = Widget_Base(wBase1, $
    /Column, $
    XPad = 0, $
    YPad = 0, $
    Space = 0, $
    Frame = 0 $
    )



wDraw = Widget_Draw(DrawBase, XSize = XDim, YSize = YDim+59, $
    /Button_Events, UValue = 'DRAW', Retain = 0, /Expose_Events, $
    Graphics_Level = 2, /Motion_Events, $
    Uname='dave_uscensus:draw')
wScale = Widget_Draw(DrawBase, XSize = XDim, YSize = 1,$;60, $
    UValue = 'LEGEND', Retain = 0, /Expose_Events, $
    Graphics_Level = 2)

        ; Create the status line label.
        ;
        wStatusBase = WIDGET_BASE(wBase, MAP=0, /ROW)


;;
;; Get the tips
;;
;sText = demo_getTips(demo_filepath('uscensus.tip', $
;                     SUBDIR=['examples','demo', 'demotext']), $
;                     wBase, $
;                     wStatusBase)
;
;help,stext,/struct
;
;stext.text = strarr(6)
;stext.contents = strarr(2,3)
;print,stext
;tags = tag_names(stext)
;for i=0,n_elements(tags)-1 do begin
;  print,tags[i]
;  print,stext.(i)
;
;endfor;i

StatusGeom = Widget_Info(wStatusBase, /Geometry)

;
; Realize the base widget.
;
Widget_Control, wBase, /Realize

Widget_Control, /Hourglass
;
; Get the window objects associated with the two
; draw widgets we've created.
;
Widget_Control, wDraw, Get_Value = oWindow
Widget_Control, wScale, Get_Value = oScale
;
; Create the views.  One will contain the USA and backdrop and
; the other will contain the scale legend.
;
ViewObject1 = Obj_New('IDLgrView', $
    viewplane_rect=[-.5, -ydim/xdim*.5, 1., ydim/xdim], $
    Color = [255, 255, 255], $
    proj=2, $
    ZClip = [50., -1.], Depth_Cue = Depth_Cue,$
    eye=50.1)
;    ZClip = [2., -1.], Depth_Cue = Depth_Cue)
ViewObject2 = Obj_New('IDLgrView', $
    Viewplane_Rect=[-1, -1, 2, 2], Color = [0, 0, 0])
;
; Build the backdrop
;
oBackDropModel = Obj_New('IDLgrModel')
dave_uscensusBuild_Backdrop, BackdropImage, BackdropObject
oBackDropModel->Add, BackdropObject
If (not Keyword_Set(Backdrop)) then Begin
    BackdropObject->SetProperty, Hide = 1
EndIf
;
; Create the population scale legend, add it to the
; appropriate view, and draw it.
;

ViewObject2->Add, dave_uscensusBuild_Scale_Legend(population_scale)
;print,'dave_uscensus ---- Do not draw the legend'
;oScale->Draw, ViewObject2

;
; Create a model for lights and place an ambient and
; directional light into the appropriate view.
;
LightFrame = Obj_New('IDLgrModel')
Light1 = Obj_New('IDLgrLight', Type = 0, Intensity = 0.85, $
    Color = [255, 255, 255])
Light2 = Obj_New('IDLgrLight', Location = [0, 2, 2], Type = 1, $
    Color = [255, 255, 255], Intensity = .5)
LightFrame->Add, Light1
LightFrame->Add, Light2
ViewObject1->Add, LightFrame

dave_uscensusOpen,pAppState,/init,$
                            nStates=nstates,$
                            nyears=nyears,$
                            states=states,$
                            years=years,$
                            oPolygonRot=oPolygonRot,$
                            oOutlineRot=oOutlineRot,$
                            oOutlineOffset=oOutlineOffset,$
                            oUnitedStates=oUnitedStates,$
                            workdir=workdir,$
                            datadir=datadir,$
                            wLabelYearDroplist=wLabelYearDroplist,$
                            wYearDroplist=wYearDroplist,$
                            state_objects=state_objects,$
                            ViewObject1=ViewObject1,$
                            xdim=xdim,ydim=ydim,$
                            datafile=datafile
;help,state_objects
;oPolygonRot = obj_new('IDLexRotator', [xdim, ydim] / 2, xdim / 2)
;oOutlineRot = obj_new('IDLexRotator', [xdim, ydim] / 2, xdim / 2)
;
;oOutlineOffset = obj_new('IDLgrModel')
;oOutlineOffset->Add, oOutlineRot
;;
;; To avoid conflict with polygons, move outlines slightly.
;;
;oOutlineOffset->Translate, 0, 0, .001 ; Amount determined empirically.
;;
;oUnitedStates = obj_new('IDLgrModel')
;oUnitedStates->Add, oOutlineOffset
;oUnitedStates->Add, oPolygonRot
;
;;dave_uscensusOpen,init=1,nStates=nstates,nyears=nyears,states=states,years=years
;if n_elements(workdir) eq 0 then workdir = file_dirname(datafile)
;if n_elements(datadir) eq 0 then datadir = file_dirname(datafile)
;widget_control,wYearDroplist,set_value=years
;
;state_objects = dave_uscensusBuild_State_Objects( $
;    states, $
;    xdim, $
;    ydim, $
;    oPolygonRot, $
;    oOutlineRot, $
;    debug=keyword_set(debug) $
;    )
;
;; Translate the model up Z toward the viewer so we can
;; make room for the backdrop.
;;
;oUnitedStates->Translate, 0., 0., .5
;;
;; Zoom-in for a nice initial view.
;;
;oUnitedStates->Scale, 2.0, 2.0, 1
;;
;; Add the nation to the appropriate view.
;;
;ViewObject1->Add, oUnitedStates

;
;
;
;
; Add a text objects which will hold the census year, and
; US State readouts.
;
TextModel = Obj_New('IDLgrModel')
If (Keyword_Set(Backdrop)) then Begin
    TextColor = [127,127,127]
Endif Else Begin
    TextColor = [0, 0, 0]
EndElse
;
; Create font for titles.
;
oFont = Obj_New('IDLgrFont', 'Helvetica*Bold', Size = 11 - $
    2*(!d.y_ch_size gt 12))
;
; Store font so that it will get destroyed when ViewObject1 is
; destroyed.
;
oContainer = obj_new('IDL_Container')
oContainer->Add, oFont
ViewObject1->Add, oContainer
;
oYearText = Obj_New('IDLgrText',  '', $
    Location=[-.48,-.26], $
    Color = TextColor, $
    /OnGlass, $
    Font = oFont $
    )
oStateText = Obj_New('IDLgrText',  $
    'State Specific Label', $
    Location = [0, -.26], $
    Color = [0,255,0],$;TextColor, $
    /OnGlass, $
    Font = oFont, $
    Align=.5 $
    )
bigFont = Obj_New('IDLgrFont', 'Helvetica*Bold', Size = 36)
oTitleText = Obj_New('IDLgrText',  $
    'NCNR RESEARCH PARTICIPANTS', $
    Location = [0.4,-.26], $
    Color = [0,255,0],$;TextColor, $
    /OnGlass, $
    Font = bigFont, $
    Align=.5 $
    )

TextModel->Add, oTitleText
TextModel->Add, oStateText
TextModel->Add, oYearText
ViewObject1->Add, TextModel
ctIndex=3

loadct,ctIndex,rgb_table=newct
ocolorModel = obj_new('IDLgrModel')
newctreds = newct[*,0]
newctgreens = newct[*,1]
newctblues = newct[*,2]
;help,newctreds
oFontCB = Obj_New('IDLgrFont', 'Helvetica*Bold', Size = 36)


oColorBartitle = obj_new('IDLgrText','Research Participants',font=oFontCB)
;oTickText = objarr(7)
;for i=0,n_elements(oTickText)-1 do begin
;  tickFont = Obj_New('IDLgrFont', 'Helvetica*Bold', Size = 26)
;  ;help,tickFont
;  oTickText[i] = Obj_New('IDLgrText',  $
;                          '', $
;                          Color = [0,255,0],$;TextColor, $
;                          /OnGlass, $
;                          Font = tickFont, $
;                          Align=.5 $
;                          )
;  ;help,tickfont
;endfor;i
oColorBar = obj_new('DAVE_MapAppColorbar',newctreds,newctgreens,newctblues,$
                    title=oColorBarTitle,$
                    dimensions=[0.2,0.03],$
                    /show_axis,/show_outline);,$
                    ;major=7,ticktext=oTickText)
;oColorBar = obj_new('IDLgrColorbar',newctreds,newctgreens,newctblues,$
;                    title=oColorBarTitle,$
;                    dimensions=[0.2,0.03],$
;                    /show_axis,/show_outline)
;help,oColorBar
ocolorModel->add,oColorBar
ViewObject1->Add, ocolorModel

oColorModel->translate,-0.25,-0.25,0

if not keyword_set(record_to_filename) then $
    record_to_filename = ''


app_state = { $
    appTLB          : appTLB,$
    view_objects    : [ViewObject1, ViewObject2], $
    window_objects  : [oWindow, oScale], $
    wDraw           : wDraw, $
    wInfoText       : wInfoText,$
    wScale          : wScale, $
    wControls       : wControls, $
    wLabelYearDroplist:wLabelYearDroplist,$
    wYearDroplist   : wYearDroplist, $
    wXSlider        : wXSlider, $
    wYSlider        : wYSlider, $
    wZSlider        : wZSlider, $
    wScalingLabel   : wScalingLabel, $
    wScalingSlider  : wScalingSlider, $
    colorTableControl:0L,$
    oColorBar       : oColorBar,$
    oColorBarTitle  : oColorBarTitle,$
    logColor        :1,$
    scale           : 1., $
    oYearText       : oYearText, $
    oStateText      : oStateText, $
    oTitleText      : oTitleText,$
    pstates         : ptr_new(states), $  ;SAVE THE STATES DATA
    colorTable      : ctIndex,$   ;THIS IS THE COLOR TABLE SELECTION.
    scaleVariable   : 0,$   ;DETERMINES WHICH ITEM IN THE states STRUCTURE TO USE FOR SCALING THE COLORS AND HEIGHTS 
    state_objects   : state_objects, $
    oUnitedStates   : oUnitedStates, $
    oPolygonRot     : oPolygonRot, $
    oOutlineRot     : oOutlineRot, $
    n_years         : NYears, $
    year            : NYears - 1, $
    oBackDropModel  : oBackDropModel, $
    BackdropImage   : BackdropImage, $
    DepthCue        : Depth_Cue, $
    draw_individually : Keyword_Set(Animate_States), $
    Backdrop        : Keyword_Set(Backdrop), $
    MaxZValue       : Max(States.Population), $
    population_scale : population_scale, $
    wAnimateButton  : wAnimateButton, $
    pChosenRegions  : ptr_new(obj_new()), $
    we_are_animating: 0b, $
    we_are_rotating : 0b, $
    status_geom     : StatusGeom, $
    color_table     : colorTable, $     ; Color table to restore at exit
    debug           : keyword_set(debug), $
    record_to_filename : record_to_filename, $
    tic             : 0.0d, $           ; Clock time at begin animation.
    groupBase       : groupBase,$       ; Base of Group Leader
    dataFile        : datafile,$
    workDir         : workdir,$
    datadir         : dataDir,$
    daveTool        : daveTool}

;
; If we're employing a backdrop image, we only need to draw it
; once as an instance and use that in subsequent draws of the USA.
;
If Keyword_Set(Backdrop) then Begin
    ViewObject1->Add, oBackDropModel
    oUnitedStates->SetProperty, Hide = 1
    oBackDropModel->SetProperty, Hide = 0
    dave_uscensusDraw, app_state, 0, /create_Instance
    oUnitedStates->SetProperty, Hide = 0
    oBackDropModel->SetProperty, Hide = 1
    ViewObject1->SetProperty, Transparent = 1
EndIf
dave_uscensusDisplay_Census_Year, app_state, draw_individually=0

Widget_Control, wBase, Set_UValue = ptr_new(app_state, /no_copy)
ptr_free, states.pOutline
ptr_free, states.pNormalOutline
ptr_free, states.pPolygonList
ptr_free, states.pVertexList
Widget_Control, wBase, /Clear_Events

XManager, 'dave_uscensus', wBase, $
    /No_Block, $
    CLEANUP='dave_uscensusCleanup'
return
End
