; $Id$
;
;
function vMACS_cgrain,z,nxa,nya,white=white

   nx =  n_elements(z(*,0))
   ny =  n_elements(z(0,*))
   zave  =  z
   
   if n_elements(white) ne 0 then               $
      for i=0L,nx-1 do begin
      for j=0L,ny-1 do if z(i,j) ne white then begin
         nav   =  0
         tav   =  0
         for iav=i-nxa/2,i+nxa/2 do begin
            for jav=j-nya/2,j+nya/2 do begin
               if (iav ge 0 and iav le nx-1 and jav ge 0 and jav le ny-1) then   $
                  if z(iav,jav) ne white then  begin
                  tav   =  tav+z(iav,jav)
                  nav   =  nav+1
               endif
            endfor
         endfor
         zave(i,j)   =  tav/nav
      end
   end else                      $
      for i=0L,nx-1 do begin
      for j=0L,ny-1 do begin
         nav   =  0
         tav   =  0
         for iav=i-nxa/2,i+nxa/2 do begin
            for jav=j-nya/2,j+nya/2 do begin
               if (iav ge 0 and iav le nx-1 and jav ge 0 and jav le ny-1) then  begin
                  tav   =  tav+z(iav,jav)
                  nav   =  nav+1
               endif
            endfor
         endfor
         zave(i,j)   =  tav/nav
      endfor
   endfor
   
   return,zave
   
end;vMACS_cgrain


;--------------------------------------------------------------------------------------------------------------------
; Formats Z-Range for display
;--------------------------------------------------------------------------------------------------------------------
function vMACS_ZrDisp,zr
  return, '['+strtrim(string(long(zr[0])),2)+','+strtrim(string(long(zr[1])),2)+']'
end



;--------------------------------------------------------------------------------------------------------------------
; Fills in the 2D plot
;--------------------------------------------------------------------------------------------------------------------
pro vMACS_plotsq,z,xi,yi,AXIS=axis,RATIO=ratio,zran=zran,  $
      			 xran=xran,yran=yran,exact_range=exact_range,pos=pos,  $
      			 title=title,xtitle=xtitle,ytitle=ytitle,nozr=nozr,notitle=notitle,  $
      			 logscal=logscal,white=white,chars=chars, $
      			 cbar=cbar,cbpos=cbpos,horizontal=horizontal,invert=invert,cbtickn=cbtickn, $
      			 xtickn=xtickn,ytickn=ytickn,isotropic=isotropic,_extra=_extra

   if not keyword_set(chars) then chars = 1
   
   if n_elements(white) ne 1 then white=-123.79e3;!values.f_nan
   n_x=n_elements(z(*,0))
   n_y=n_elements(z(0,*))
   syi = size(yi)
   sxi = size(xi)
   if sxi(0) eq 1 then begin
      x = z
      for i=0,n_y-1 do x(*,i)=xi
   endif else x=xi
   if syi(0) eq 1 then begin
      y = z
      for i=0,n_x-1 do y(i,*)=yi
   endif else y=yi
   
   ; now make the 2d plot
   
   if n_elements(xran) ne 2 then begin
      xmin=min(x) & xmax=max(x)
   endif  else begin
      xmin = xran(0)  &  xmax = xran(1)
   endelse
   if keyword_set(exact_range) then dx=0 else dx=(xmax-xmin)/20.
   xran_disp  = [xmin-dx/2,xmax+dx/2]
   
   if n_elements(yran) ne 2 then begin
      ymin=min(y) & ymax=max(y)
   endif else begin
      ymin  = yran(0)  &  ymax  = yran(1)
   endelse
   if keyword_set(exact_range) then dy=0 else dy=(ymax-ymin)/20.
   yran_disp  = [ymin-dy/2,ymax+dy/2]
   
   if n_elements(zran) ne 2 then zran  = [min(z),max(z)]
   if n_elements(title) ne 1 then title  = '!6' else $
      if not keyword_set(cbar) and not keyword_set(nozr) then title = title + ', ' + vmacs_zrdisp(zran)
   if not keyword_set(xtitle) then xtitle='!6Q!dx!n (!sA!r!e!u!9%!6-1!n)' 
   if not keyword_set(ytitle) then ytitle='!6Q!dy!n (!sA!r!e!u!9%!6-1!n)'
   if keyword_set(notitle) then title=' '
   
   if (keyword_set(RATIO)) then ra=ratio else ra=1.
   
   ; draw the frame
   if (keyword_set(cbar)) and (not keyword_set(pos)) then begin
      if keyword_set(horizontal) then pos = [.23,.13,.85,.76] else pos = [.20,.20,.77,.77]
   endif 
   
   plot,title=title,xrange=xran_disp,yrange=yran_disp, $
      xtitle=xtitle,ytitle=ytitle,/nodata,findgen(1), $
      color=0,back=fsc_color("white", !d.table_size-1), $
      chars=chars,xstyle=1,ystyle=1,pos=pos,isotropic=isotropic,$
      xtickn=xtickn,ytickn=ytickn,_extra=_extra
      
   ; now fill in the data
      
   for i=0,n_y-2 do begin
      for j=0,n_x-2 do begin
         zs  = [z(j,i),z(j,i+1),z(j+1,i),z(j+1,i+1)]
         lis = where(zs ne white and zs ne !values.f_nan,nlis)
         if nlis gt 0 then zav = total(zs(lis))/nlis else zav=white
         if ( x(j,i) GE xmin and x(j+1,i) LE xmax and $
            y(j,i) GE ymin and y(j,i+1) LE ymax and zav ne white) then begin
            if n_elements(logscal) eq 0 then color=(zav-zran(0))/(zran(1)-zran(0))*255.*ra else $
               if zav ge zran(0)+1 then color=alog(zav-zran(0))/alog(zran(1)-zran(0))*255.*ra else color=0
            if color GT 254 then color=254
            if color LE 0 then color = 0
            polyfill,[x(j,i),x(j,i+1),x(j+1,i+1),x(j+1,i)], $
               [y(j,i),y(j,i+1),y(j+1,i+1),y(j+1,i)],color=color
         endif
      endfor
   endfor
   
   if keyword_set(cbar) then begin
      if keyword_set(horizontal) then begin 
         if not keyword_set(cbpos) then cbpos = [pos[0], pos[3]+0.09, pos[2], pos[3]+0.13]  
         top='top'  &  chsc=0.6
      endif else begin                   
         if not keyword_set(cbpos) then cbpos = [pos[2]+0.06, pos[1], pos[2]+0.1, pos[3]] 
         vertical='vertical'  &  right='right'  &  chsc=0.85
      endelse
      if not keyword_set(divisions) then divisions=3
      if max(zran)-min(zran) eq 0 then zran=[zran[0]-0.01,zran[1]+0.01]
      Colorbar, range=zran, pos=cbpos, chars=chsc*chars, divisions=divisions, color=0, $
                vertical=vertical, right=right, top=top, invert=0, ytickn=cbtickn, xtickn=cbtickn, _extra=_extra 
   endif
   
end;vMACS_plotsq


;--------------------------------------------------------------------------------------------------------------------
; Calls vMACS_plotsq to plot data after graining data, adding titles etc.
;--------------------------------------------------------------------------------------------------------------------

pro vMACS_plotslice,xi,yi,zi,avhw,ncg=ncg,ps=ps,tit=tit,subtit=subtit,chars=chars,no_hw=no_hw,_extra=_extra
   ;-----------------------------------------------------------------------------------
   ;   ncg: pixel side length of averaging area
   ;   file: Name of output normalization file
   ;   ps: set to 1 for post script output
   ;   _extra: transfer additional keywords to plotsq routine
   ;------------------------------------------------------------------------------------

   if n_elements(chars)    ne 1    then chars           = 2
   if n_elements(ncg) eq 1 then zo = vMACS_cgrain(zi,ncg,ncg,white=white) else zo=zi
   if n_elements(tit) ne 1 then tit=' ' else tit = tit + ' '
   if !d.name eq 'WIN' then !p.font=-1 else !p.font=0
   if !p.font eq 0 then symhw = '!s!16h!r!u!18---!n!9w!3=' else symhw = '!6!s!8h!r!e!u!3__!n!7x!6='
   if not keyword_set(no_hw) then tit = tit + symhw + strtrim(string(avhw,form='(f5.2)'),2) + 'meV'
   
   ;--------------------
   ; actual plotting
   ;--------------------
   if keyword_set(ps) then begin
      mydevice = !D.NAME
      set_plot,'ps'
      device,/color,ysize=20,xsize=22,file=file,yoff=8
      loadct,4
      vMACS_plotsq,zo,xi,yi,white=white,xtit='!6Q!dx!n (!sA!r!e!u!9%!6-1!n)',ytit='!6Q!dy!n (!sA!r!e!u!9%!6-1!n)', $
         tit=tit,subtit=subtit,pos=[.15,.15,.85,.9],_extra=_extra
      device,/close
      SET_PLOT, mydevice
   end else $
      vMACS_plotsq,zo,xi,yi,white=white,xtit='!6Q!dx!n (!sA!r!e!u!9%!6-1!n)',ytit='!6Q!dy!n (!sA!r!e!u!9%!6-1!n)',   $
             tit=tit,subtit=subtit,chars=chars,_extra=_extra;,pos=[.15,.15,.85,.9];
      
end;vMACS_plotslice



;--------------------------------------------------------------------------------------------------------------------
; Puts the data in a square grid
;--------------------------------------------------------------------------------------------------------------------
pro vMACS_sqbin, xi, yi, zi, dzi, xo, yo, zo, dzo, nx=nx, ny=ny, mtx=mtx, mty=mty, xran=xran, $
      yran=yran, white=white, _extra=_extra
      
   x  =  xi
   y  =  yi
   z  =  zi
   dz =  dzi
   
   if n_elements(nx)    ne 1 then nx    = fix(sqrt(n_elements(x)))
   if n_elements(ny)    ne 1 then ny    = fix(sqrt(n_elements(y)))
   if n_elements(mtx)   ne 1 then mtx  = 0
   if n_elements(mty)   ne 1 then mty  = 0
   if n_elements(white) ne 1 then white = -123.79e3
   
   if n_elements(xran) ne 2 then xran  =  [min(x,/nan),max(x,/nan)]
   if n_elements(yran) ne 2 then yran  =  [min(y,/nan),max(y,/nan)]
   
   dx =  float(xran(1)-xran(0))
   dy =  float(yran(1)-yran(0))
   if nx gt 1 then dx = dx/(nx-1)
   if ny gt 1 then dy = dy/(ny-1)
   
   xo  = xran(0) + findgen(nx)*dx
   yo  = yran(0) + findgen(ny)*dy
   
   zo  = fltarr(nx,ny)
   dzo = fltarr(nx,ny)
   num = fltarr(nx,ny)
   
   for i=0L, n_elements(x)-1 do begin
      if nx eq 1 then xind = 0 else xind =  round((x(i)-xran(0))/dx)
      if ny eq 1 then yind = 0 else yind =  round((y(i)-yran(0))/dy)

      if (xind lt 0) or (xind gt nx-1) or (yind lt 0) or (yind gt ny-1) then continue
       
      num(xind,yind) =  num(xind,yind)+1
      zo(xind,yind)  =  zo(xind,yind)+z(i)
      dzo(xind,yind) =  dzo(xind,yind)+dz(i)^2
   end
   
   nonz     =  where(num ne 0., nnonz) ;Changed: and x ne mtx and y ne mty, nnonz)
   if nnonz gt 0 then begin
      zo(nonz) =  zo(nonz)/num(nonz)
      dzo(nonz)   =  sqrt(dzo(nonz))/num(nonz)
   end
   
   zer      =  where(num eq 0.,nzer)
   if nzer gt 0 then begin
      zo(zer)     =  replicate(white,nzer)
      dzo(zer) =  replicate(white,nzer)
   end
   
end;vMACS_sqbin



;--------------------------------------------------------------------------------------------------------------------
; Folds the data to an n-fold symmetry region
;--------------------------------------------------------------------------------------------------------------------
pro vMACS_fold,qx,qy,n,mirror_l=mirror_l,mirror_h=mirror_h,center=center
   angfold=360/n
   totang=fltarr(n_elements(qx))
   for nn=0L,n_elements(qx)-1 do begin
      totang[nn]=!radeg*atan(qy[nn],qx[nn])
      if totang[nn] lt 0 then totang[nn]=totang[nn]+360
      totang[nn]=totang[nn]-angfold*floor((totang[nn])/angfold)
      if keyword_set(mirror_l) then totang[nn]=(totang[nn])<(angfold-totang[nn])
      if keyword_set(mirror_h) then totang[nn]=(totang[nn])>(angfold-totang[nn])
      if keyword_set(center) then totang[nn]=totang[nn]-angfold/2.
   endfor
   ro=sqrt(qx^2+qy^2)
   qx=ro*cos(totang*!dtor)
   qy=ro*sin(totang*!dtor)
end;vMACS_fold




;--------------------------------------------------------------------------------------------------------------------
; Inputs data array and converts to wave vector and energy transfer
; 
; Input :
;     data    : Input data array
;     columns : Contains column names of the input data array
;     
; Output :
;     q, qx, qy, hw, rint, drint : Wave vector transfers, Energy transfer, Intensity and Errors
;--------------------------------------------------------------------------------------------------------------------
pro vMACS_calcqhw, data, columns, qtot, qx, qy, hw, rint, drint, dets=dets, $
               xpar=xpar, dat_xpar=dat_xpar, avhw=avhw, a4ran=a4ran, $
               invert=invert, abs=abs, xabs=xabs, yabs=yabs, xmirror=xmirror, ymirror=ymirror, n_fold=n_fold, $
               lattice=lattice, difdet=difdet,$
               ki_kf_cos_tt=ki_kf_cos_tt,$ ;FOR SUMMER SCHOOL EXPERIMENT
               ei=ei,ef=ef,qfold=qfold,$
               a3_mask=a3_mask,$
               a4_mask=a4_mask,$  ;LRK - 10/07/10
			   _ref_extra=_ref_extra   

   if keyword_set(invert) then begin
      inv_data = data 
      inv_data[where(columns eq 'A3'),*] -= 180.
      data = [[data],[inv_data]]
   end
   
   ndata  = n_elements(data[0,*])  &   ndets = n_elements(dets)
   a3     = reform(rebin(data[where(columns eq 'A3'    ), *], ndets,  ndata), ndata*ndets)
   a2     = reform(rebin(data[where(columns eq 'A2'    ), *], ndets,  ndata), ndata*ndets)
   a4     = reform(rebin(data[where(columns eq 'KIDNEY'), *], ndets,  ndata) + $
                   rebin(-76.+8*(dets-1), ndets, ndata),  ndets * ndata)
   a5     = reform(data[where(strmid(columns,0,13) eq 'ANALYZERTHETA'),*], ndata*ndets)
   
   taum   = 1.87325
   ki     = taum/2./sin(a2/2. * !dtor)
   kf     = taum/2./sin(a5 * !dtor)
   
  
   
   
   if keyword_set(difdet) then begin
      kf  = ki
   endif
   
   
   
   ei     = 2.072 * ki^2
   ef     = 2.072 * kf^2
   hw     = ei - ef
   avhw   = total(hw)/n_elements(hw)
   
   qabs   =  sqrt(ki^2 + kf^2 - 2.* ki * kf * cos(a4 * !dtor))
;WHAT IS THE 6.76697???   
   ki_kf_cos_tt = (ki - kf * cos(a4 * !dtor) )* 6.76697 / 2.0 / !PI
   qtot   =  sqrt(ki^2 + kf^2 - 2.* ki * kf * cos(a4 * !dtor)) * a4/(abs(a4) + 1.e-10)
   cospsi = (ki^2 + qabs^2 - kf^2)/(2. * ki * qabs + 1.e-10)
   psi    = acos(cospsi)/!dtor
   lis    = where(a4 lt 0, nlis)
   if nlis gt 0 then psi[lis] = -psi[lis]
   phi    = psi - (90. - a3)
   
   qx     = qabs * cos(phi * !dtor)
   qy     = qabs * sin(phi * !dtor)
   
   if keyword_set(difdet) then begin
      rint  = (data[(where(strmid(columns,0,4) eq 'DIFF'))[1:*], *])[*]
      drint = (data[(where(strmid(columns,0,8) eq 'ERR_DIFF'))[1:*], *])[*]
   endif else begin
      rint  = (data[(where(strmid(columns,0,4) eq 'SPEC'))[1:*], *])[*]
      drint = (data[(where(strmid(columns,0,8) eq 'ERR_SPEC'))[1:*], *])[*]
   endelse

   if n_elements(a4ran) eq 2 then begin
      lis = where((a4 lt a4ran[0]) or (a4 gt a4ran[1]), nlis)
      if nlis gt 0 then qtot[lis] = !values.f_nan
   endif
   
   if n_elements(a4_mask) eq 2 then begin
      lis = where((a4 gt a4_mask[0]) and (a4 lt a4_mask[1]), nlis)
      if nlis gt 0 then qtot[lis] = !values.f_nan
   endif
   
  if n_elements(a3_mask) eq 2 then begin
      lis = where((a3 gt a3_mask[0]) and (a3 lt a3_mask[1]), nlis)
      if nlis gt 0 then qtot[lis] = !values.f_nan
   endif
   
   
   print,'test2'
   help,qx,qy,qabs,ki_kf_cos_tt
   
   inds = where(finite(qtot) and finite(qx) and finite(qy))
   qtot=qtot[inds] & qx=qx[inds] & qy=qy[inds] & hw=hw[inds] & rint=rint[inds] & drint=drint[inds]
   qabs=qabs[inds] & ki_kf_cos_tt=ki_kf_cos_tt[inds]
   
   if qfold eq 1 then begin
      dfold=where(ki_kf_cos_tt gt 1.)
      ki_kf_cos_tt[dfold]=abs(1-ki_kf_cos_tt[dfold])
   endif
   
   print, 'test3'    
   help,qx,qy,qabs,ki_kf_cos_tt
   
   
   if n_elements(xpar) gt 0 then begin
      dat_xpar = fltarr(n_elements(xpar), ndata*20)
      for i = 0, n_elements(xpar)-1 do begin
         xcol = where(columns eq strupcase(xpar[i]), nxcol)
         if nxcol gt 0 then dat_xpar[i,*] = reform(rebin(data[xcol, *], 20, ndata), ndata*20)
         if strupcase(xpar[i]) eq 'A4' then dat_xpar[i,*] = a4 else if strupcase(xpar[i]) eq 'A5' then dat_xpar[i,*] = a5  
      endfor
      dat_xpar = dat_xpar[*,inds]
   endif

   if keyword_set(n_fold) then vMACS_fold, qx, qy, n_fold, mirror_l=mirror_l, mirror_h=mirror_h, center=center
   if keyword_set(yabs)   then if keyword_set(ymirror) then qy = -abs(qy) else qy = abs(qy) 
   if keyword_set(xabs)   then if keyword_set(xmirror) then qx = -abs(qx) else qx = abs(qx) 
   if keyword_set(abs)    then qtot = abs(qtot)
   
   if n_elements(lattice) ne 2 then lattice = [1.,1.]
   qx = qx/lattice(0)  &  qy = qy/lattice(1)

   
   
end;vMACS_calc_q_hw

;-------------------------------------------------------------------------------------------------------
; Calculates binsizes for a device (eg. a2, a3).
;  
; Returns the average difference between unique values of the device whose binsize is being calculated.
; 
; If background values for device are specified and have no deviation, then a big binsize is returned,
; such that the number of bins is 1, i.e. the device value is essentially disregarded for comparison. 
; 
; Input :
;     data    : device values whose binsize is being calculated.
;     inp_bg_data : device values for the background data if included.
; 
; Output :
;     binsize      
;     
; Written by : Vivek Thampy (01/05/2010)
;----------------------------------------------------a--------------------------------------------------- 
function vMACS_calcbinsize, data
   data    = round(data[sort(data)]*10)  
   data    = data[uniq(data)]

   if meanabsdev(data) lt 1. then begin
      binsize = 0.1
      return, binsize
   endif

   if n_elements(data) gt 3 then data = data[1:n_elements(data)-2] 
   binsize = (mean((data - shift(data,1))[1:*]))/30. 

   return, binsize
end;vMACS_calcbinsize


;--------------------------------------------------------------------------------------------------------------------
; Returns the product of the elements of an array
;--------------------------------------------------------------------------------------------------------------------
function vMACS_product, array
  product=1L  &  for i = 0, n_elements(array)-1 do product *= (reform(array))[i]
  return, product
end



;--------------------------------------------------------------------------------------------------------
; This function takes data as an array input whose columns are specified by the vector columns
; The devices which are compared for binning are specified by the vector devs
; 
; Input :
;     data    : data array to be binned
;     devs    : devices to be compared for binning
;     columns : data array columns
;     
; Output :
;     data    : binned data array
;     
; Written by : Vivek Thampy (01/05/2010)     
;--------------------------------------------------------------------------------------------------------
function vMACS_bindata, data, devs, columns, bin_size=bin_size, dev_ran=dev_ran, $
                       pbpbin=pbpbin, avg=avg, _extra=_extra

   ndata    = n_elements(data[0,*])
   ndevs    = n_elements(devs)
   
   mon_col  = where( (strmid(columns,0,7) eq 'MONITOR') )
   det_cols = where( (strmid(columns,0,4) eq 'SPEC') or (strmid(columns,0,4) eq 'DIFF') ) 
   err_cols = where( (strmid(columns,0,4) eq 'ERR_') or (strmid(columns,0,4) eq 'ERR_') ) 
   
   ;-----------------------------------------------------------------------------------------------------
   ; Similar to bkg_sub routine. Binsize and ranges for devices calculated
   ; Index the data on the devices (dev_inds).
   ; The n-dimensional indices (for n devices) are converted into 1-dimensional indices (inds)
   ;-----------------------------------------------------------------------------------------------------
   dev_cols = intarr(ndevs)  &  for i = 0, ndevs-1 do dev_cols[i] = where(columns eq strupcase(devs[i]))

   if n_elements(bin_size) eq 0 then bin_size = fltarr(ndevs) else $
      if n_elements(bin_size) lt ndevs then bin_size = [bin_size, fltarr(ndevs-n_elements(bin_size))]
   bin_size=float(bin_size) 
   for i = 0, ndevs-1 do if (bin_size[i]  eq 0) then bin_size[i] = vMACS_calcbinsize(data[dev_cols[i],*])
   binsz = bin_size[0:ndevs-1]

   if n_elements(dev_ran) lt ndevs*2 then begin
      dev_ran = fltarr(ndevs,2)
      for i = 0, ndevs-1 do dev_ran[i,0] = [[min(data[dev_cols[i],*]) - binsz[i]/2], [max(data[dev_cols[i],*]) + binsz[i]/2]]
   endif
   dev_bins = round((dev_ran[*,1] - dev_ran[*,0])/binsz)
   
   lis = where(dev_bins gt 1, nlis)
   if nlis ge 1 then begin
      devs=devs[lis]  &  ndevs=n_elements(devs)  &  binsz=binsz[lis]  
      dev_cols=dev_cols[lis]  &  dev_bins=dev_bins[lis]  &  dev_ran=dev_ran[lis,*]
   endif 

   ;-----------------------------------------------------------------------------------------------------
   if keyword_set(pbpbin)  then goto, pbpbin
   ;-----------------------------------------------------------------------------------------------------

   dev_cols = dev_cols[sort(dev_bins)]  &  binsz = binsz[sort(dev_bins)]
   dev_inds = long(fix((data[dev_cols,*] - rebin(dev_ran[*,0], ndevs, ndata))/rebin(reform(binsz), ndevs, ndata)))

   data     = data[*, vmacs_multisort([dev_inds, data[dev_cols,*]])]

   i = 0L  &  j = 1L
   while (j le ndata) do begin
      if (j lt ndata) then nomatch = total(abs(data[dev_cols, i]-data[dev_cols, j]) gt binsz/2) 
      if (nomatch) or (j eq ndata) then begin
         if (j - i gt 1) then begin
            if keyword_set(avg) then n = j-i else n = 1
            data[mon_col,  i] = total(data[mon_col,  i:j-1])/n
            data[det_cols, i] = total(data[det_cols, i:j-1], 2)/n
            if keyword_set(avg) then data[err_cols, i] = sqrt(total(data[err_cols, i:j-1]^2, 2))/n $
                                else data[err_cols, i] = sqrt(data[det_cols, i])
            for k = 0, ndevs-1 do data[dev_cols[k], i] = mean(data[dev_cols[k], i:j-1])
            data[0,i+1:j-1] = !values.f_nan
         endif 
         i = j
      endif
      j += 1   
   endwhile

   return, data[*, where(finite(data[0,*]))]
   

   ;-----------------------------------------------------------------------------------------------------
   pbpbin:
   ;-----------------------------------------------------------------------------------------------------
   dev_cols = dev_cols[reverse(sort(dev_bins))]  &  binsz = binsz[reverse(sort(dev_bins))]
   data   =   data[*, sort(  data[dev_cols[0], *])]

   di = fltarr(n_elements(columns))
   repeat begin
      j = 1  &  match = 0  &  nmatch = 1  &  ndata = n_elements(data[0, *])
      repeat begin
         diff = data[dev_cols, j] - data[dev_cols, 0]
         if (total(abs(diff) gt binsz/2) eq 0) then begin 
            nmatch += 1  &  match = [match, j]
         endif
         j += 1
      endrep until (diff[0] gt 0.5*binsz[0]) or (j eq ndata) 
      if nmatch gt 1 then begin
         for k = 1, nmatch-1 do begin
            data[mon_col,  0] += data[mon_col,  match[k]]
            data[det_cols, 0] += data[det_cols, match[k]]
            data[err_cols, 0]  = sqrt(data[err_cols, 0]^2  + data[err_cols, match[k]]^2)
            data[dev_cols, 0] += data[dev_cols, match[k]]
         endfor
         if keyword_set(avg) then begin
            data[mon_col,  0] /= nmatch
            data[det_cols, 0] /= nmatch
            data[err_cols, 0] /= nmatch
         endif else data[err_cols, 0] = sqrt(data[det_cols, 0])
         data[dev_cols, 0] /= nmatch
         data[0, match[1:*]] = !values.f_nan
      endif   
      di = [[di], [data[*,0]]] 
      if n_elements(data[0,*]) gt nmatch then data = data[*, (where(finite(data[0,*])))[1:*]] else break
      if n_elements(data[0,*]) eq 1 then di =[[di], [data[*,0]]]
   endrep until (n_elements(data[0,*]) le 1)
         
   return, di[*,1:*]
      
end




;----------------------------------------------------------------------------------------------------------
; Procedure to subtract background data point by point. This is used in conjunction with the 
; routine extract_data which reads data files and populates the data arrays used here.
;
; Input: 
;     data    : Signal Data
;     bgdata  : Background Data 
;     columns : The detectors, monitor, and devices in the data and bgdata arrays
; Output :
;     data    : Background subtracted Signal data
; Optional inputs :
;     devs    : devices that are compared between Signal and Background data for subtraction
;     binsize : tolerances for the values of the devices being compared
;          
; The columns in the data arrays are passed through the vector columns (specified in extract_data)
;
; Columns : [Monitor, Spec, Diff, ErrSpec, ErrDiff, Device Columns (specified in extract_data)]

; If devs not specified, then default devs are a2, a3 and kidney.
; If tolerances not specified they are calculated from the Signal data using the vMACS_calcbinsize
; 
; The function bin_data used to concatenate the background data in case the files are 
; repeated or the points in the files are to be averaged. It uses the devices passsed through devs.
; 
; Written by: Vivek Thampy and Collin Broholm (01/05/2010)
;----------------------------------------------------------------------------------------------------------
pro vMACS_bgsub, data, bgdata, columns, devs=devs, bin_size=bin_size, empty=empty, dev_ran=dev_ran, $
                no_bin=no_bin, white=white, pbpsub=pbpsub, _extra=_extra

   if n_elements(white) ne 1 then white = -123.79e3
   if n_elements(devs)  gt 0 then devs = strupcase(devs) else devs = ['A2', 'A3', 'KIDNEY']
 
   if keyword_set(empty) then begin
      lis = where(devs eq 'A3', nlis, complement=rem)
      if (n_elements(rem) gt 0) then devs=devs[rem]  
      if (n_elements(rem) gt 0) and (keyword_set(bin_size)) then bin_size=bin_size[rem]
   endif    
   
   ndata    = n_elements(data[0,*])
   nbgdata  = n_elements(bgdata[0,*])
   ndevs    = n_elements(devs)
   
   det_cols = where((strmid(columns,0,4) eq 'SPEC') or (strmid(columns,0,4) eq 'DIFF')) 
   err_cols = where((strmid(columns,0,4) eq 'ERR_') or (strmid(columns,0,4) eq 'ERR_')) 

   ;-------------------------------------------------------------------------------------------------------
   ; Calculate device tolerances if not specified. Calculate range of device values fom data and bin sizes.
   ; Exclude background data points that are beyond that range  
   ;-------------------------------------------------------------------------------------------------------
   dev_cols = intarr(ndevs)  &  for i = 0, ndevs-1 do dev_cols[i] = where(columns eq strupcase(devs[i]))

   if n_elements(bin_size) eq 0 then bin_size=fltarr(ndevs) else $
      if n_elements(bin_size) lt ndevs then bin_size = [bin_size, fltarr(ndevs-n_elements(bin_size))]
   bin_size=float(bin_size) 
   for i = 0, ndevs-1 do if (bin_size[i]  eq 0) then bin_size[i] = MACS_calcbinsize(data[dev_cols[i],*])
   binsz = bin_size[0:ndevs-1]

   if n_elements(dev_ran) lt ndevs*2 then begin
      dev_ran = fltarr(ndevs,2)
      for i = 0, ndevs-1 do dev_ran[i,0] = [[min(data[dev_cols[i],*]) - binsz[i]/2], [max(data[dev_cols[i],*]) + binsz[i]/2]]
   endif
   dev_bins = round((dev_ran[*,1] - dev_ran[*,0])/binsz)
   
   for i = 0, ndevs-1 do begin
      lis = where((bgdata[dev_cols[i],*] ge dev_ran[i,0]) and (bgdata[dev_cols[i],*] le dev_ran[i,1]), nlis)
      if nlis gt 0 then bgdata = bgdata[*,lis] else exit  &  nbgdata  = n_elements(bgdata[0,*]) 
   endfor
      
   lis = where(dev_bins gt 1, nlis)
   if nlis ge 1 then begin
      devs=devs[lis]  &  ndevs=n_elements(devs)  &  binsz=binsz[lis]  
      dev_cols=dev_cols[lis]  &  dev_bins=dev_bins[lis]  &  dev_ran=dev_ran[lis,*]
   endif 
   
   ;-------------------------------------------------------------------------------------------------------------------------
   if keyword_set(pbpsub)  then goto, pbpsub
   ;-------------------------------------------------------------------------------------------------------------------------
   
   dev_cols = dev_cols[sort(dev_bins)]  &  binsz = binsz[sort(dev_bins)]

   siginds = long(fix((  data[dev_cols,*] - rebin(dev_ran[*,0], ndevs,   ndata))/rebin(reform(binsz), ndevs,   ndata)))
   bginds  = long(fix((bgdata[dev_cols,*] - rebin(dev_ran[*,0], ndevs, nbgdata))/rebin(reform(binsz), ndevs, nbgdata)))

   data    =   data[*, vmacs_multisort([siginds,   data[dev_cols,*]])]
   bgdata  = bgdata[*, vmacs_multisort([ bginds, bgdata[dev_cols,*]])]

   j = 0L
   for i = 0L, ndata-1 do begin
      nmatch = 0  &  j0 = j  &  jmatch = lonarr(nbgdata)+j
      repeat begin 
         diff = bgdata[dev_cols, j] - data[dev_cols, i]  
         if total(abs(diff) gt binsz/2) eq 0 then begin
            data[det_cols, i] -= bgdata[det_cols, j]
            data[err_cols, i]  = sqrt(data[err_cols, i]^2 + bgdata[err_cols, j]^2)
            jmatch[nmatch] = j  &  nmatch += 1  &  j += 1       
         endif else begin $ 
            for k = 0, ndevs-1 do if (diff[k] gt 0.5*binsz[k]) then break
            if (k ge ndevs) then j += 1 else break
         endelse   
      endrep until (j eq nbgdata) 

      if nmatch eq 0 then data[0, i] = white

      if (i lt ndata-1) then begin
         if (j le nbgdata) && (j gt j0) && (total(abs(data[dev_cols, i+1] - bgdata[dev_cols, j0]) gt binsz) eq 0) then j = j0
         if (j eq nbgdata) then begin
            data[0,i+1:*] = white  &  break
         endif
      endif
   endfor
      
   no_white = where(data[0,*] ne white, nno_white)
   if nno_white eq 0 then data[det_cols,*] = white else data = data[*, no_white]

   return

   ;------------------------------------------------------------------------------------------------------------------------
   pbpsub:
   ;------------------------------------------------------------------------------------------------------------------------
   dev_cols = dev_cols[reverse(sort(dev_bins))]  &  binsz = binsz[reverse(sort(dev_bins))]
   data   =   data[*, sort(  data[dev_cols[0], *])]
   bgdata = bgdata[*, sort(bgdata[dev_cols[0], *])]

   j = 0L
   for i = 0L, ndata-1 do begin
      nmatch = 0  &  j0 = j  &  jmatch = lonarr(nbgdata)+j
      repeat begin 
         diff = bgdata[dev_cols, j] - data[dev_cols, i]  
         if (total(abs(diff) gt binsz/2) eq 0) then begin
            data[det_cols, i] -= bgdata[det_cols, j]
            data[err_cols, i]  = sqrt(data[err_cols, i]^2 + bgdata[err_cols, j]^2)
            jmatch[nmatch] = j  &  nmatch += 1  &  j += 1       
         endif else begin $ 
            if (diff[0] gt 0.5*binsz[0]) then break else j += 1
         endelse   
      endrep until (j eq nbgdata) 

      if nmatch eq 0 then begin
         data[0, i] = white
      endif
      if (i lt ndata-1) then begin
         if (j le nbgdata) && (j gt j0) then $
            if (data[dev_cols[0], i+1] - data[dev_cols[0], i] lt binsz[0]) then j = j0 else j = jmatch[0]
         if (j eq nbgdata) then begin
            data[0,i+1:*] = white  &  break
         endif
      endif
   endfor
      
   no_white = where(data[0,*] ne white, nno_white)
   if nno_white eq 0 then data[det_cols,*] = white else data = data[*, no_white]

   return
   
end;vMACS_bg_sub



;-------------------------------------------------------------------------------------------------------------------
; Reads MACS files, and returns pointer with all the data extracted from the file.
;-------------------------------------------------------------------------------------------------------------------
pro vMACS_readfile, file2read, macs_data, titles=titles, indep_var=indep_var, dep_var=dep_var
  total_lines = file_lines(file2read)
  totalstr = strarr(total_lines)
  openr, lun, file2read, /get_lun
  readf, lun, totalstr
  if strmid(totalstr(total_lines-1),0,1) eq '#' then totalstr=totalstr(0:total_lines-2)
  free_lun, lun
  err=vMACS_dave_parse_ice(totalstr,macs_data,indep_var_pos=indep_var,dep_var_pos=dep_var,titles=titles)
end




;-------------------------------------------------------------------------------------------------------------------
; Reads MACS files, and returns data array with appropriate columns extracted from the files.
; 
; Input :
;     files   : Input MACS files
;     
; Output :
;     data    : Output data array
;     columns : Vector with names of columns extracted from the files. These columns are
;               [Monitor, SPEC[1-20], DIFF[1-20], Devices]. 
;               Devices by default are a2, a3, kidney and a5. If devices are specified explicitly, then they are
;               appended to the default list specified above 
;                
; Optional Input :
;     devices  : See columns above
;     no_norm  : Specify of the counts are not to be normalized. Normalized by default to monitor count 1e6
;     bin_devs : Devices which are compared  for binning of data. By default : a2, a3, kidney and a5
;     scale    : Weights of the background/signal files.
;     a3ran    : Range of A3 values to be extracted
;     
; Written by : Vivek Thampy (01/05/2010) 
;-------------------------------------------------------------------------------------------------------------------
pro vMACS_extract, files, data, columns, devs=devs, bin_devs=bin_devs, $ 
                  xpar=xpar, bin_size=bin_size, empty=empty, no_bin=no_bin, $
                  weights=weights, scale=scale, no_norm=no_norm, dets=dets, $
                  a3ran=a3ran, a3shift=a3shift, mask=mask, shiftptai=shiftptai, $ 
                  _extra=_extra
                  
   normonct = 1.e6
   
   default_devs = ['PTAI','A2','A3','KIDNEY','A5']
   if n_elements(bin_devs)     gt 0 then bin_devs = strupcase(bin_devs) $
      else if n_elements(devs) gt 0 then bin_devs = strupcase(devs) else bin_devs = ['A3', 'KIDNEY']
   if n_elements(devs)         eq 0 then devices  = default_devs    else devices        = [default_devs, strupcase(devs)]
   if n_elements(xpar)         gt 0 then devices  = [devices, strupcase(xpar)]
   devices = (devices[sort(devices)])[uniq(devices[sort(devices)])]
   
   nfiles = n_elements(files)
   if n_elements(scale)     ne nfiles then scale     = (n_elements(scale)   eq 1) ? fltarr(nfiles)+scale[0]   : fltarr(nfiles)+1.
   if n_elements(a3shift)   ne nfiles then a3shift   = (n_elements(a3shift) eq 1) ? fltarr(nfiles)+a3shift[0] : fltarr(nfiles) 
   if n_elements(shiftptai) ne 1      then shiftptai = 0
   
   dets      = indgen(20)+1  &  for i = 0, n_elements(mask)-1 do dets = dets[where(dets ne mask[i])]
   spec      = ['SPEC', 'SPEC'  + string(dets, form='(i02)')]
   diff      = ['DIFF', 'DIFF'  + string(dets, form='(i02)')]
   a5theta   = ['ANALYZERTHETA' + string(dets, form='(i02)')]

   columns   = ['MONITOR', diff, spec, a5theta, devices]
   columns   = (columns[sort(columns)])[uniq(columns[sort(columns)])]

   mon_col   = where(strmid(columns,0,7) eq 'MONITOR')  
   spec_cols = where(strmid(columns,0,4) eq 'SPEC')
   det_cols  = where(strmid(columns,0,4) eq 'SPEC' or strmid(columns,0,4) eq 'DIFF') 

   ndets    = n_elements(det_cols)
   ncolumns = n_elements(columns)
   inds     = intarr(ncolumns)
   data     = fltarr(ncolumns + ndets + 1,1)
   
   for i=0, nfiles-1 do begin
      vMACS_readfile, files[i], ptr
      for j = 0, ncolumns-1 do inds[j] = where(tag_names(ptr) eq strupcase(columns[j])) 
    
      npoints = n_elements(*ptr.a2)
      di = fltarr(ncolumns, npoints)
      for j = 0, ncolumns-1 do di[j,*] = *ptr.(inds[j])
      
      ; Check if detectors readings are finite
      for j = 0, ndets-1 do begin
         lis = where(finite(di[det_cols[j],*]) and (di[det_cols[j],*] ge 0) and (di[det_cols[j],*] lt 1e10), nlis)
         if nlis gt 0 then di = di[*,lis] else break
      endfor 
      if nlis le 0 then continue else npoints = nlis 
     
      ; Apply A3 Shift
      di[where(columns eq 'A3'), *] += a3shift[i]

      ; Shift PTAI
      ptai = di[where(columns eq 'PTAI'),*]
      if keyword_set(shiftptai) then begin
         if ( max(ptai + shiftptai) le 20 ) or ( min(ptai + shiftptai) ge 1 ) then ptai += shiftptai
         for j = 0, npoints-1 do $
             di[where(columns eq 'SPEC'),j] = di[where(columns eq ('SPEC'+string(PTAI[j], form='(i02)'))), j]
      endif
         
      ; Apply Weights   
      if n_elements(weights) eq 20 then begin 
         for j = 0, npoints-1 do di[where(columns eq 'SPEC'), j] *= weights[ptai[j]-1]
         non_mask_weights = weights[dets-1]  
         di[spec_cols[1:*], *] *= rebin(non_mask_weights, n_elements(spec_cols)-1, npoints)
      endif
      
      ; Add Errors and Scale if any to data array
      di = [ di, sqrt(di[det_cols,*]), fltarr(1,npoints)+scale[i] ]
      data = [ [data],[di] ]
   end
   
   data = data[*, 1:*]

   errspec  = 'ERR_' + ['SPEC', 'SPEC'  + string(dets, form='(i02)')]
   errdiff  = 'ERR_' + ['DIFF', 'DIFF'  + string(dets, form='(i02)')]
   columns  = [columns, errdiff, errspec, 'SCALE']
   err_cols = where(strmid(columns,0,4) eq 'ERR_') 
   
   if n_elements(a3ran) eq 2 then begin
      a3col = where(columns eq 'A3')
      lis   = where((data[a3col, *] ge a3ran[0]) and (data[a3col,*] le a3ran[1]), nlis)
      if nlis gt 0 then data = data[*,lis] else data[det_cols, *] = 0
   endif
   
   if meanabsdev(scale) ne 0 then bin_devs = [bin_devs, 'SCALE']
   if ( keyword_set(empty) and (where(strupcase(bin_devs) eq 'A3') eq -1) ) then bin_devs = [bin_devs, 'A3']
   if not keyword_set(no_bin) then data = vMACS_bindata(data, bin_devs, columns, bin_size=bin_size, _extra=_extra) 
   
   ndata = n_elements(data[0,*])
   if keyword_set(no_norm) then normon = 1 $ 
      else normon = normonct/rebin(data[mon_col,*]+1e-10, n_elements(det_cols), ndata)
   data[det_cols, *] *= normon * rebin(data[where(columns eq 'SCALE'),*], n_elements(det_cols), ndata)  
   data[err_cols, *] *= normon * rebin(data[where(columns eq 'SCALE'),*], n_elements(err_cols), ndata)  
end




;--------------------------------------------------------------------------------------------------------------------
; Function to perform background subtraction after data has been binned in square grid
;--------------------------------------------------------------------------------------------------------------------
pro vMACS_subrint, rint1, rint2, rint, drint1, drint2, drint, white=white
   if not keyword_set(white) then white = -123.79e3
   rint = rint1 - rint2
   lis = where( (rint1 eq white) or (rint2 eq white), nlis )
   if nlis gt 0 then rint[lis] = white
   drint = sqrt(drint1^2 + drint2^2)
end




;-----------------------------------------------------------------------------------------------------
; General procedure to extract and plot MACS data
; 
; Required Input :
;     fgfil : signal data file/s
; 
;
;********************************     
; Optional inputs :
;********************************
; 
; ----File Options      
;     
;     bgfil    : Background file/s
;     fg_mtfil : Empty can file/s for the Signal data
;     bg_mtfil : Empty can file/s for the Background data 
;     
;        
; ----Data Extraction and Binning Options   
;        
;     devs     : Device values that are extracted through vmacs_extract in addition to the default devices [PTAI, A2, A3, Kidney, A5].
;                These are also the devices that are compared for point by point subtraction in "MACS_bgsub. 
;                The values passes should be exactly the same as the names in the data files.  
;               (passed through _extra to "MACS_extract" and "MACS_bgsub")
;             eg. devs=['temp', 'qx', 'AnalyzerTheta01']   (Case not important)         
;                
;     bin_devs : By default, the data points which have the same values for the devices specified by "bin_devs" are binned together
;                If "bin_devs" is not specified explicitly, then the binned devices is specified by "devs"
;               (passed through _extra to "MACS_extract")
;             eg. if bin_devs = 'A6' then all data points with 'A6' value within Bin Size (see binsz) are added up
;
;     no_bin    : option to disable binning of data (see bin_devs above). Data is binned by default. 
;        
;        
;     binsz     : Bin Size for devices. Should have same number of elements as "devs". If it is not specified or is equal to zero, 
;                 the the bin size is calculated automatically using "MACS_calcbinsize".   
;             eg. devs = ['a3', 'kidney'], binsz = [0.5, 1.5]]
;     (fg, bg, fg_mt, bg_mt)-binsz : Bin Sizes specifically for subtraction/binning for respective fg, bg etc. files. If not 
;                 specified and "binsz" is specified, then these values default to the "binsz" values.              
;             eg. devs = ['a3', 'kidney'], fgbinsz = [0.5, 1.5], bgbinsz = [1., 2.]
; 
;        
;     scale     : Scale factor applied to the "Spec" and "Diff" counts extracted from the data files. If this keyword 
;                 is specified, this factor applied to all the data files (including bgfil, fg_mtfil etc), 
;                 unless those are specified explicitly (see next keyword below). If only one value is specified, that value
;                 is used for all the files. But an array of values for each of the files can be specified as well. In that case,
;                 the number of values must equal the number of files.
;                (passed through _extra to "MACS_extract")
;             eg. scale = 0.5  (for all files)  or  scale = [fltarr(10)+0.5, fltarr(5)+0.8]  (for 15 files)    
;     (fg, bg, fg_mt, bg_mt)-sc : Scaling factors specifically for fg, bg etc. files.
;        
;        
;     no_norm   : Option to disable normalization of data to common monitor counts. Normalization is done by default.
;                (passed through _extra to vMACS_extract)
;                  
;     weights   : Weights for the detectors. Should be an array of 20 values for the 20 detectors.  
;                (passed through _extra to "vMACS_extract")
;                   
;     mask      : List of Detectors (from 1-20) which are to be excluded.  
;                (passed through _extra to "vMACS_extract")
;             eg. mask =[1,4,8]   (exclude detectors 1, 4 and 8. Note: detectors are numbered "1 through 20")
;                  
;     a3ran     : Range of A3 to limit the extracted data to. 
;                (passed through _extra to vMACS_extract)
;             eg. a3ran = [90.,180.]
;        
;     a4ran     : Range of A4 to limit the extracted data to. 
;                (passed through _extra to vMACS_calc_q_hw respectively)
;     
;     a3shift   : Shift of A3 values. Again can be specified as a single value which will apply to all files, or an array 
;                 of values, one for each file. 
;                (passed through _extra to "vMACS_extract")
;             eg. a3shift = 30  (for all files)  or  scale = [fltarr(10)+30, fltarr(5)+15]  (for 15 files)    
;     (fg, bg, fg_mt, bg_mt)-a3sh  : A3 shift values for fg, bg etc. files. If not specified and "a3shift" is specified, 
;                 then these values default to the "a3shift" values.              
;     
;     shiftptai : Used especially with plotfiles routine to plot data from an alternate detector. By default the 
;                 "SPEC" or "DIFF" detector values are returned when using the instrument in a triple axis mode. This option
;                 allows plotting an alternative detector which is shifted from the default PTAI value (detector number) by 
;                 a fixed number specified by "shiftptai".              
;                (passed through _extra to vMACS_extract)
;     

;----Background Subtraction Options
;
;    devs      : See more description above. Devices that are compared for point by point subtraction in "MACS_bgsub". 
;                 The tolerances for point by point subtraction are specified by the keywords "('', bg, fg_mt, bg_mt)binsz".

;                 There are four methods to subtract background data:
;                 1. Point by point, but might miss a few points. Much faster than the default option.
;                    Keyword - None required (default action)
;                 2. True point by point - 
;                    Keyword - "pbp"
;                 3. Bin the data in a square grid and then subtract. 
;                    Keyword - "/binsub"      
;                (passed through _extra to "MACS_extract" and "MACS_bgsub")
;              eg. devs=['temp', 'qx', 'AnalyzerTheta01']   (Case not important)         
;                
;     binxr, binyr : X and Y ranges for square grid binning. Recommended for the "binsub" option.
;    
;     empty     : Use for Empty Can subtraction where the data is independant of "A3".   
;
;        
;----Calculation of Projections Options
; 
;    invert     : Option to invert data. Duplicates data for "A3" to "A3-180"  
;                (passed through _extra to vMACS_calc_q_hw)
;
;    xabs, yabs : Option to fold data along X(Y) axis
;                (passed through _extra to vMACS_calc_q_hw)
;    x/ymirror  : Mirrors data folded using x/yabs above along the x/y axis
;
;    n_fold     : Option to fold data with n fold symmetry into a single irreducible section
;                (passed through _extra to vMACS_calc_q_hw)
;                
;    mirror_l/h : Fold along the mirror axis after the n_fold is done. Keyword passed to "MACS_fold" 
;    
;    center     : Rotate the coordinate to the center of the n_folded zone. "MACS_fold" keyword.
;     
;    lattice    : Reciprocal lattice vectors passed to calculate qx and qy in terms of r.l.u. (default [1,1])
;                (passed through _extra to vmacs_calc_q_hw)
;       
;       
;----Plotting Options
;       
;    mslice     : Calls the mslice routine with 'qx', 'qy', and 'hw' values as default
;    
;    grain      : Specifies the number of bins to be averaged for smoothing plots
;     
;    chars      : Character size used in the plotted figures
;     
;    xr, yr     : X Range and Y Range for plotting      
;
;    x/ytickn   : Ticknames for X and Y Ticks 
;    
;    no_plot    : Option used to return calculated projections and other reduced data without plotting 
;     
;    no_hw      : Does not output the average Energy tranfer values as a plot heading which is done by default 
;     
;    nozr       : Dooes not output the Z-Range to the plot which is done by default
;     
;    cbar       : Adds a Color bar to the plot (Vertical by default)
;     
;    horizontal : Makes the Color bar horizontal if the keyword "cbar" is also present
;     
;    cbtickn    : Tick names for the Color Bar
;     
;    pos        : Position of the plot in normalized coordnates
;    
;    cbpos      : Position of the Color Bar in normalized coordnates
;    
;    isotropic  : Isotropic scaling of X and Y axis
;     
;    difdet     : Option to plot Diffraction detectors data instead of the spectroscopic ones 
;                  
;     
;----Returned Data Options
;     
;    qx, qy, qtot : Calculated Qx, Qy and total Q 
;    
;    rint, drint  : Intensity and Errors for all points
;    
;    hw, avhw     : Calculated Energy transfer for each point and average Energy transfer for all the points. 
;     
;    binqx, binqy, binrint etc.  : Calculated values as above binned in square grid (returned by vmacs_sqbin)
;     
;    data     : Full data array with subtracted data or otherwise returned (Not binned in square grid)

;    columns  : Ctring array with names of columns in the data array
;    
;    xpar     : Any extra parameter that needs to be extracted.
;           eg. dat_xpar = ['Temp', 'Time'] 
;    
;    dat_xpar : data for that extra parameter is returned in this array
;
;
; Written by : Vivek Thampy (01/05/2010)
;---------------------------------------------------------------------------------------------------------------------
pro vMACS_qmap, fgfil, bgfil=bgfil, fg_mtfil=fg_mtfil, bg_mtfil=bg_mtfil, empty=empty, $
               binsz=binsz, fgbinsz=fgbinsz, bgbinsz=bgbinsz, fg_mtbinsz=fg_mtbinsz, bg_mtbinsz=bg_mtbinsz, $
               fgsc=fgsc, bgsc=bgsc, fg_mtsc=fg_mtsc, bg_mtsc=bg_mtsc, $ 
               fga3sh=fga3sh, bga3sh=bga3sh, fg_mta3sh=fg_mta3sh, bg_mta3sh=bg_mta3sh, $
               qtot=qtot, qx=qx, qy=qy, rint=rint, drint=drint, avhw=avhw, hw=hw, $
               data=data, columns=columns, xpar=xpar, dat_xpar=dat_xpar, $
               binqx=binqx, binqy=binqy, binrint=binrint, bindrint=bindrint, $
               binxr=binxr, binyr=binyr, xr=xr, yr=yr, binsub=binsub, $               
               white=white, grain=grain, chars=chars, no_plot=no_plot, pos=pos, mslice=mslice, $
		           ei=ei,ef=ef,$
               ki_kf_cos_tt=ki_kf_cos_tt,qfold=qfold ,$ ;(FOR SUMMER SCHOOL EXPERIMENT)
               summerSchool = SummerSchool,$ ;UNUSED HERE
               UseWin=UseWin,$
               dataRange=dataRange,$
               _extra=_extra  
;help,_extra,/struct          
;winsave = !d.window
;if n_elements(UseWin) ne 0 then begin
;  wset,UseWin
;endif
  if n_elements(qfold) eq 0 then qfold=0
   if n_elements(grain)  ne 1  then grain  = 2
   if n_elements(chars)  ne 1  then chars  = 2
   if n_elements(white)  ne 1  then white  = -123.79e3
   if n_elements(xtit)   ne 1  then xtit   = 'H (rlu)'
   if n_elements(ytit)   ne 1  then ytit   = 'K (rlu)'
   if total(strmatch(tag_names(_extra),'SUBTITLE',/fold_case)) ne 0 then begin
      subtitle=_extra.subtitle
   endif
   if n_elements(subtitle) ne 1 then subtitle = ''
   
   if total(strmatch(tag_names(_extra),'DIFDET',/fold_case)) ne 0 then begin
      difdet=_extra.difdet
      ;help,_extra,/struct
   endif
   if keyword_set(binsz) then begin
      if not keyword_set(fgbinsz)    then fgbinsz    = binsz
      if not keyword_set(fg_mtbinsz) then fg_mtbinsz = binsz
      if not keyword_set(bgbinsz)    then bgbinsz    = binsz
      if not keyword_set(bg_mtbinsz) then bg_mtbinsz = binsz
   endif
   if n_elements(difdet) eq 0 then difdet = 0
   if keyword_set(a3shift) then begin
      if not keyword_set(fga3sh)    then fga3sh    = a3shift
      if not keyword_set(fg_mta3sh) then fg_mta3sh = a3shift
      if not keyword_set(bga3sh)    then bga3sh    = a3shift
      if not keyword_set(bg_mta3sh) then bg_mta3sh = a3shift
   endif
   ;---------------------------------------------------------------------------------------------------
   ; data: [a2, a3, a4, a5, kidney, intensity, error]
   ;---------------------------------------------------------------------------------------------------
   vMACS_extract, fgfil, data, columns, xpar=xpar, bin_size=fgbinsz, scale=fgsc, a3shift=fga3sh, dets=dets, _extra=_extra
   if keyword_set(fg_mtfil) then begin
      vMACS_extract, fg_mtfil, fg_mtdata, columns, xpar=xpar, bin_size=fg_mtbinsz, scale=fg_mtsc, a3shift=fg_mta3sh, _extra=_extra
      vMACS_bgsub, data, fg_mtdata, columns, bin_size=fg_mtbinsz, _extra=_extra
	  ;vMACS_bg_sub, data, fg_mtdata, columns, bin_size=fg_mtbinsz, empty=1, _extra=_extra;empty=empty, _extra=_extra
   endif
   
   if keyword_set(bgfil) then begin
      vMACS_extract, bgfil, bgdata, columns, xpar=xpar, bin_size=bgbinsz, scale=bgsc, a3shift=bga3sh, _extra=_extra
      if keyword_set(bg_mtfil) then begin
         print,'EXTRACT OR EXTRACT DATA?????'
         ;LRK - 060611 SOMETHING SEEMS FUNNY HERE.  I THOUGHT ALL OF THIS WAS FOLDED IN TO vMACS_Extract
         
         ;vMACS_extract_data, bg_mtfil, bg_mtdata, columns, xpar=xpar, bin_size=bg_mtbinsz, scale=bg_mtsc, a3shift=bg_mta3sh, _extra=_extra
         vMACS_extract, bg_mtfil, bg_mtdata, columns, xpar=xpar, bin_size=bg_mtbinsz, scale=bg_mtsc, a3shift=bg_mta3sh, _extra=_extra
         ;vMACS_bg_sub, bgdata, bg_mtdata, columns, bin_size=bg_mtbinsz, empty=1, _extra=_extra;empty=empty, _extra=_extra
         vMACS_bgsub, bgdata, bg_mtdata, columns, bin_size=bg_mtbinsz, empty=1, _extra=_extra;empty=empty, _extra=_extra
      endif
      if not keyword_set(binsub) then vMACS_bgsub, data, bgdata, columns, bin_size=binsz, _extra=_extra 
   endif
   
   ;---------------------------------------------------------------------------------------------------
   ; evaluate wave vector and energy transfer
   ;---------------------------------------------------------------------------------------------------
   vMACS_calcqhw, data, columns, qtot, qx, qy, hw, rint, drint, dets=dets, xpar=xpar, dat_xpar=dat_xpar, avhw=avhw,$
                                   ei=ei,ef=ef,ki_kf_cos_tt=ki_kf_cos_tt,qfold=qfold,_extra=_extra  
   if keyword_set(binsub) and keyword_set(bgfil) then $
      vMACS_calcqhw, bgdata, columns, bgqtot, bgqx, bgqy, bghw, bgrint, bgdrint, dets=dets,ki_kf_cos_tt=ki_kf_cos_tt, _extra=_extra  
   
   ;---------------------------------------------------------------------------------------------------
   ; if "mslice" option given then call mslice
   ;---------------------------------------------------------------------------------------------------
   if keyword_set(mslice) then vMACS_mslice, rint, drint, qx, qy, z=hw

   ;---------------------------------------------------------------------------------------------------
   ; bin it in a square grid
   ;---------------------------------------------------------------------------------------------------
   vMACS_sqbin, qx, qy, rint, drint, binqx, binqy, binrint, bindrint, xran=binxr, yran=binyr, white=white, _extra=_extra
   if keyword_set(binsub) and keyword_set(bgfil) then begin
      vMACS_sqbin, bgqx, bgqy, bgrint, bgdrint, bgbinqx, bgbinqy, bgbinrint, bgbindrint, xran=binxr, yran=binyr, white=white, _extra=_extra
      vMACS_subrint, binrint, bgbinrint, subbinrint, bindrint, bgbindrint, subbindrint, white=white
      binrint = subbinrint  &  bindrint = subbindrint
      qx = binqx & qy = binqy & rint = binrint & drint = bindrint
   endif
   
   ;---------------------------------------------------------------------------------------------------
   ; if "no_plot" option given then return
   ;---------------------------------------------------------------------------------------------------
   dataRange=[min(vmacs_cgrain(binrint, grain, grain, white=white)),max(vmacs_cgrain(binrint, grain, grain, white=white))]
   if keyword_set(no_plot) then return
      
      
   if difdet eq 1 then begin
     subtitle = subtitle+':  EiMin='+string(min(ei))+','+' EiMax='+string(max(ei))+','
     _Extra.subtitle=subtitle
   endif   
   vMACS_plotslice, binqx, binqy, vmacs_cgrain(binrint, grain, grain, white=white), avhw, white=white, xr=xr, yr=yr, $
              xtit=xtit, ytit=ytit,subtit=subtit,ps=ps, chars=chars, pos=pos, _extra=_extra 

  ;wset,winsave
end;vmacs_qmap
