; $Id$


pro macs_slice2,files,emptyfile=emptyfile,empsc=empsc,xo,yo,zo,avhw,a3ran=a3ran,white=white,$
    nx=nx,ny=ny,xran=xran,yran=yran,difdet=difdet,a3shift=a3shift,weights=weights,$
    specweights=specweights,diffweights=diffweights,$   ;LRK - 04/12/10  ADDING THESE KEYWORDS B/C I BELIEVE WEIGHTS
                                                        ;                ARE NOT PROPERLY APPLIED
    xabs=xabs,yabs=yabs,invert=invert,n_fold=n_fold,mask_pos=mask_pos,a3_mask=a3_mask,$
    a4_mask=a4_mask,mask_det=mask_det,a4_pos=a4_pos,$
    dataObj=dataObj,emptyObj=emptyObj ; THESE KEYWORDS WILL REPLACE THE files ARGUMENT
    
    
;void = dialog_message('GET THE OBJECTS WORKING!!!!!!  macs_slice2')
    
;    help,dataObj
;    help,emptyObj
;------------------------------------------------------------------------------------------------------------------
;
; simple routine to read and grid MACS data projected on momentum plane
;   files: array of file names to be included. It reads raw macs data
;   x0 : qx in A(-1)
;   y0 : qy in A(-1)
;   zo : intensity.
;   detector:  'diff'  for diffraction detectors. 'spec' for spectroscopic  Default value 'spec'
;   white: special value assigned to empty pixel
;   nx:number of pixels along Qx
;   ny:number of pixels along Qy
;   empty: empty scan to be substracted
;   a3 shift:  a3 shift value.
;   weights:  20x1 elements array. Detector weights. Default value: 1 for all the detectors
;   a3_mask:  2x1 elements array. a3 range to be mask.
;   a4_mask:  2x1 elements array. a4 range to be mask 
;   mask_det: 20x1 elements array. Mask detectors values:  0-mask  1-mask
;   a4_pos: 20x1 elements array a4 detector positions. default values: 8 degrees distance between detectors.
;   zoerr:  intensity error
;   nfold:  folding simmetry.
;   xabs:  all the x0 values are positive
;   yabs:  all the y0 values are positive
;   invert: The data will be plotted in the positive and negative xo and y0 values.
;-----------------------------------------------------------------------------------------------------------------
  if n_elements(ef) ne 1 then ef=2.35
  if n_elements(white) ne 1 then white=-123.79
  if n_elements(file) ne 1 then file='slice.ps'
  if n_elements(a3ran) ne 2 then a3ran=[-360,360]
  
  ;print,weights
  ;d = fltarr(5000000,6)
  d = fltarr(1000000,6)
  d=d*0
  point = 0
  nempty  =  n_elements(emptyfile)
  if  nempty gt 0 then begin
    if nempty ne n_elements(empsc) then empsc=1.0+fltarr(nempty)

    ;LRK - 04/16/10
    ;NOW REPLACE THE NEXT LINE WITH THE ONE BELOW IT
    ;macs_readmacsfile,emptyfile(0),emptyptr0
    check = emptyObj[0]->getData(emptyPtr0)
    emptyPtr0 = emptyObj[0]->pullTheData('STR')

    ;INSTEAD OF THIS STEP EXTRACT EACH EMPTY SET FROM THE DATA OBJECT BELOW WHEN THE SUBTRACTION IS DONE.
    ;I.E. REPLACE THIS RE-READING WITH EXTRACTION FROM THE DATA OBJECTS
    if check ne 0 then begin
      emptyptr  =  replicate(emptyptr0,nempty)
      for i=1,nempty-1 do begin
        print,''
        ;macs_readmacsfile,emptyfile(i),emptyptr0       
        emptyPtr0 = emptyObj[i]->pullTheData('STR')
        emptyptr[i]  =  emptyptr0                    
      end
    endif else begin
      print,'No valid data in selected "Empty" objects.'
    endelse
  endif
  
  
  ;void = dialog_message('THE READING OF DATA OBJECTS DOES NOT SEEM TO WORK LIKE I THOUGHT IT WOULD!!!!')
  for i=0,n_elements(files)-1 do begin
;    print,'______________________'
;    help,dataobj[i]
    ;macs_readmacsfile,files[i],ptr
    ;duh = dataobj[i]->getData(ptr)
    ptr = dataObj[i]->pullTheData('STR')
    if nempty ne 0 then begin
;      void = dialog_message('In macs_slice2: Calling macs_subtract_empty ---- CHECK THAT IT WORKS RIGHT.')
      
      ;REPLACE THE NEXT LINE WITH THE BLOCK BELOW IT
      ;for j=0,nempty-1 do macs_subtract_empty,ptr,emptyptr[j],empsc=empsc[j]
      
      for j=0,nempty-1 do begin
        ;duh = emptyObj[j]->getData(emptyPtr)
        emptyPtr = emptyObj[j]->pullTheData('STR')
        macs_subtract_empty,ptr,emptyPtr,empsc=empsc[j]
      endfor;j
    endif;nempty
    macs_get_a12345_int,ptr,a1,a2,a3,a4,a5,a6,spec,diff,monitor=monitor,weights=weights,mask_det=mask_det,$
                        specweights=specweights,diffweights=diffweights,$   ;LRK - 04/12/10  ADDING THESE KEYWORDS B/C I BELIEVE WEIGHTS
                                                                            ;                ARE NOT PROPERLY APPLIED
                        a3_mask=a3_mask,a4_mask=a4_mask,a4_pos=a4_pos
    if n_elements(a3shift) eq 1 then begin
      a3=a3+a3shift
    endif
    ;t1=!radeg*asin(sqrt(1.81816/14.0))
    ;t2=!radeg*asin(sqrt(1.81816/15.6))
    ;a1=a1*0+t1
    ;a2=a1*2
    ;a5=a5*0+t2
    ;a6=a5*2
    if keyword_set(mask_pos) then begin
      all_neg=where(a4 lt 0)
      a1=a1[all_neg]
      a2=a2[all_neg]
      a3=a3[all_neg]
      a4=a4[all_neg]
      a5=a5[all_neg]
      a6=a6[all_neg]
      spec=spec[all_neg]
      diff=diff[all_neg]
      monitor=monitor[all_neg]
    endif
    
    if keyword_set(invert) then begin
       a1 = [a1,a1]
       a2 = [a2,a2]
       a3 = [a3,a3-180.]
       a4 = [a4,a4]
       a5 = [a5,a5]
       a6 = [a6,a6]
       spec = [spec,spec]
       diff = [diff,diff]
       monitor = [monitor,monitor]
    end
    di=fltarr(n_elements(a1),6)
    di(*,0)=a1
    di(*,1)=a2
    di(*,2)=a3

    
    di(*,3)=a4
    di(*,4)=a5
    di(*,5)=spec*1200000/monitor
    
    
    if keyword_set(difdet) then begin
      di(*,5)=diff*1200000/monitor
    endif
    nnew  = long64(n_elements(di(*,0)))
    d(point:point+nnew-1,*) = di(*,*)
    point = long64(point+nnew)
  end
  d = d(0:point-1,*)
  ndef  = fix(sqrt(point))
  if n_elements(nx) ne 1 then nx=ndef
  if n_elements(ny) ne 1 then ny=ndef
  
  ;------------------------------------------------
  ; convert to wave vector and energy transfer
  ;------------------------------------------------
  taum    = 1.87325
  
  ki    = taum/2./sin(d(*,1)/2.*!dtor)
  kf    = taum/2./sin(d(*,4)*!dtor)
  if keyword_set(difdet) then begin
    kf=ki
  endif
  ;ki=sqrt(5/2.072)
  ;ki=kf
  
  ;kf = ki ; for diffraction
  ei    = 2.072*ki^2
  ef    = 2.072*kf^2
  
  ;print,ei,ef
  ;ei=5.0
  ;ef=5.0
  
  hw    = ei-ef
  avhw    = total(hw)/n_elements(hw)
  q   = sqrt(ki^2+kf^2-2.*ki*kf*cos(d(*,3)*!dtor))
  cospsi  = (ki^2+q^2-kf^2)/2./ki/q
  psi   = acos(cospsi)/!dtor
  lis   = where(d(*,3) lt 0,nlis)
  if nlis gt 0 then psi(lis)  = -psi(lis)
  lis = where(d(*,2) ge a3ran(0) and d(*,2) le a3ran(1),nlis)
  phi   = psi(lis)-(90.-d(lis,2))
  qx    = q(lis)*cos(phi*!dtor)
  qy    = q(lis)*sin(phi*!dtor)
  
  if n_elements(n_fold) eq 1 then MACS_fold,qx,qy,n_fold
  if keyword_set(xabs) then qx = abs(qx)
  if keyword_set(yabs) then qy = abs(qy)
  
  rint    = d(lis,5)
  
  ;----------------------------
  ; bin it in a square grid
  ;----------------------------
  macs_sqbin,qx,qy,rint,sqrt(abs(rint)),xo,yo,zo,dzo,nx=nx,ny=ny,white=white;,xran=xran,yran=yran
  
end;macs_slice2


