; $Id$
;-------------------------------------------------------------------------------------------------------
; Calculates binsizes for a device (eg. a2, a3).
;  
; Returns the average difference between unique values of the device whose binsize is being calculated.
; 
; If background values for device are specified and have no deviation, then a big binsize is returned,
; such that the number of bins is 1, i.e. the device value is essentially disregarded for comparison. 
; 
; Input :
;     inp_data    : device values whose binsize is being calculated.
;     inp_bg_data : device values for the background data if included.
; 
; Output :
;     binsize      
;     
; Written by : Vivek Thampy (01/05/2010)
;----------------------------------------------------a--------------------------------------------------- 
function MACS_calc_binsize, inp_data, inp_bg_data=inp_bg_data

   max_binsize = 1000.
   if not keyword_set(inp_bg_data) then inp_bg_data = inp_data
   inp_data    = round(inp_data[sort(inp_data)]*10)  
   inp_bg_data = round(inp_bg_data[sort(inp_bg_data)]*10)
   
   if meanabsdev(inp_bg_data) lt 1.0 then begin
      binsize = max_binsize
      return, binsize
   endif
   
   inp_bg_data = inp_bg_data[uniq(inp_bg_data)]
   inp_data    = inp_data[uniq(inp_data)]
   if n_elements(inp_data) gt 3 then inp_data = inp_data[1:n_elements(inp_data)-2] 
   binsize   = (n_elements(inp_data) le 1) ? (mean((inp_bg_data - shift(inp_bg_data,1))[1:*]))/30. $
                                           : (mean((inp_data - shift(inp_data,1))[1:*]))/30. 
   
   return, binsize
   
end;MACS_calc_binsize
