;$Id$
;###############################################################################
;
; NAME:
;  SPLIT_SCAN
;
; PURPOSE:
;  See description below.
;
; CATEGORY:
;  DAVE, HFBS, data reduction
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;+
; NAME:
;       SPLIT_SCAN
;
; PURPOSE:
;
;		Simple function wrapper for the "SPLIT" functionality of in the object
;		class HSCN_DATA.  Suitable for invocation at the command line.  The
;		function returns an array of new object references containing the data
;		for the split datasets.
;
; AUTHOR:
;
;       Robert M. Dimeo, Ph.D.
;		NIST Center for Neutron Research
;       100 Bureau Drive
;		Gaithersburg, MD 20899
;       Phone: (301) 975-8135
;       E-mail: robert.dimeo@nist.gov
;       http://www.ncnr.nist.gov/staff/dimeo
;
; CATEGORY:
;
;       Data reduction, DAVE project, HFBS
;
; CALLING SEQUENCE:
;
;		DNEW = SPLIT_SCAN(DATA,TARRAY)
;
; PARAMETERS:
;
;		DATA:		Object reference for the data objects to be split.  If N splits
;					are defined then there will be N+1 object references in DATA.  The
;					DATA and DNEW are of the HSCN_DATA class.
;
;		TARRAY:		Vector of temperatures (or times) at which points data will be split.
;					e.g. TARRAY = [T1,T2,T3]
;
; KEYWORDS:
;
;		None
;
; COMMON BLOCKS:
;
;		None
;
; REQUIREMENTS:
;
;		HSCN_DATA__DEFINE.PRO
;
; MODIFICATION HISTORY:
;
;       Written by Rob Dimeo, July 14, 2003
;-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function split_scan,data,tarray
; Check if correct number of parameters were passed in
if n_params() lt 2 then return,0
dnew = data[0]->split(tarray,msg = msg)
return,dnew
end