; $Id$
;###############################################################################
;
; NAME:
;  HSCN_REBIN
;
; PURPOSE:
;  Rebin widget for fixed-window scan files.
;
; CATEGORY:
;  DAVE, HFBS, data reduction
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro hreb_event,event
widget_control,event.top,get_uvalue = pstate
uname = widget_info(event.id,/uname)
case uname of
'CANCEL': $
	begin
		(*pstate).cancel = 1
		widget_control,event.top,/destroy
	end
'ACCEPT': $
	begin
		(*pstate).cancel = 0
		xlo_id = widget_info(event.top,find_by_uname = 'DES_XLO')
		xhi_id = widget_info(event.top,find_by_uname = 'DES_XHI')
		nbins_id = widget_info(event.top,find_by_uname = 'DES_NBINS')
		widget_control,xlo_id,get_value = xlo
		widget_control,xhi_id,get_value = xhi
		widget_control,nbins_id,get_value = nbins
		(*pstate).xlo = float(xlo[0])
		(*pstate).xhi = float(xhi[0])
		(*pstate).nbins = fix(nbins[0])
		widget_control,event.top,/destroy
	end
else:
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function hscn_rebin,x,group_leader = group_leader
; Widget definition module
xlo = min(x,max = xhi) & nbins = n_elements(x)
tlb = widget_base(group_leader = group_leader,title = 'Rebinning information', $
	/tlb_frame_attr,/modal,/row)
col_1 = widget_base(tlb,/col,/align_right)
labels = [' ',' ','XLO','XHI','NBINS']
for i = 0,n_elements(labels)-1 do $
	void = widget_label(col_1,value = labels[i])

col_2 = widget_base(tlb,/col,/align_right)
void = widget_label(col_2,value = 'Original')
void = widget_text(col_2,value = strtrim(string(xlo),2),uname = 'XLO', $
	/editable)
void = widget_text(col_2,value = strtrim(string(xhi),2),uname = 'XHI', $
	/editable)
void = widget_text(col_2,value = strtrim(string(nbins),2),uname = 'NBINS', $
	/editable)

col_3 = widget_base(tlb,/col,/align_right)
void = widget_label(col_3,value = 'Desired')
void = widget_text(col_3,value = strtrim(string(xlo),2),uname = 'DES_XLO', $
	/editable)
void = widget_text(col_3,value = strtrim(string(xhi),2),uname = 'DES_XHI', $
	/editable)
void = widget_text(col_3,value = strtrim(string(nbins),2),uname = 'DES_NBINS', $
	/editable)

col_4 = widget_base(tlb,/col,/align_right)
void = widget_button(col_4,value = 'CANCEL',uname = 'CANCEL')
void = widget_button(col_4,value = 'ACCEPT',uname = 'ACCEPT')

widget_control,tlb,/realize
state = {xlo:xlo,xhi:xhi,nbins:nbins,cancel:0}
pstate = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pstate

xmanager,'hscn_rebin',tlb,event_handler = 'hreb_event'
xlo = (*pstate).xlo & xhi = (*pstate).xhi & nbins = (*pstate).nbins
cancel = (*pstate).cancel
ptr_free,pstate
return,{xlo:xlo,xhi:xhi,nbins:nbins,cancel:cancel}
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;