; $ Id $
;###############################################################################
;
; NAME:
;  HFBS_WRITECON
;
; PURPOSE:
;  Writes out reduced data files in an ascii format
;
; CATEGORY:
;  DAVE, HFBS, data reduction
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; hfbs_writeCon.pro
;
; Widget application to convert .DAVE files to the
; HFBS formatted .CON files.  This allows the user to
; write out data files that have been regrouped.
;
; Written by R.M.Dimeo (01/16/02)
;;;;;;;;;;;;;;;;;;;;;
pro hfbswcQuit,event
widget_control,event.top,get_uvalue = pState,/no_copy
(*pState).msg = 'CANCEL'
widget_control,event.top,set_uvalue = pState,/no_copy
widget_control,event.top,/destroy
return
end
;;;;;;;;;;;;;;;;;;;;;
pro hfbswcSelFiles,event
widget_control,event.top,get_uvalue = pState,/no_copy
files = dialog_pickfile(dialog_parent = event.top,/read, $
                               filter = ['*.dave','*.DAVE'],$
                               title = 'Select .DAVE files',$
                               path = (*pState).path,$
                               /multiple_files)
; Desensitize the widgets
widget_control,event.top,sensitive = 0
nfiles = n_elements(files)
if (1.0*total(file_test(files,/regular)) ne nfiles) then begin
  void = dialog_message(dialog_parent = event.top,'At least one of the selected files is invalid')
  ; Desensitize the widgets
  widget_control,event.top,sensitive = 1
  widget_control,event.top,set_uvalue = pState,/no_copy
  return
endif
*(*pState).filePtr = files

; Now restore each file and write out a new .CON file
for i = 0,nfiles-1 do begin

  dotPos = strpos(files[i],'.dave')
  fileOut = strmid(files[i],0,dotPos)+'.con'
  restore,files[i]
  inPtr = davePtr
  instrument = (*(*inPtr).dataStrPtr).commonStr.instrument
  if instrument ne 'HFBS' then begin
    void = dialog_message(dialog_parent = event.top,'Not an HFBS file')
    ; Sensitize the widgets
    widget_control,event.top,sensitive = 1
    widget_control,event.top,set_uvalue = pState,/no_copy
    return
  endif
  if (*(*(*inPtr).dataStrPtr).specificPtr).daqmode eq 'elastic' then begin
    strout = 'Cannot write a fixed-window scan out as a .CON file'
    void = dialog_message(/error,strout,dialog_parent = event.top)
    widget_control,event.top,set_uvalue = pState,/no_copy
    return
  endif


  detangles = *(*(*(*inPtr).dataStrPtr).specificPtr).phiPtr
  sumTBM = (*(*(*inPtr).dataStrPtr).specificPtr).sumtbm
  mon = *(*(*(*inPtr).dataStrPtr).specificPtr).monPtr
  monErr = *(*(*(*inPtr).dataStrPtr).specificPtr).monErrPtr

  ;sumFC = total((*(*(*inPtr).dataStrPtr).commonStr.histPtr).qty[*,0])
  ;print,sumFc
  sumFC = total(mon)
  sumWBM = (*(*(*inPtr).dataStrPtr).specificPtr).sumwbm
  comments = (*(*(*inPtr).dataStrPtr).specificPtr).comments
  header = (*(*(*inPtr).dataStrPtr).specificPtr).header
  ;file = (*(*(*(*pState).inPtr).dataStrPtr).specificPtr).rawFileName

  data = (*(*(*inPtr).dataStrPtr).commonStr.histPtr).qty
  energy = (*(*(*inPtr).dataStrPtr).commonStr.histPtr).x
  q = (*(*(*inPtr).dataStrPtr).commonStr.histPtr).y
  error = (*(*(*inPtr).dataStrPtr).commonStr.histPtr).err
  ndet = n_elements(q)

  if n_elements((*(*(*inPtr).dataStrPtr).specificPtr).temp_sample) gt 0 then begin
    temperature = (*(*(*inPtr).dataStrPtr).specificPtr).temp_sample
  endif
  datsize = size(data)
  nchan = datSize[1]
  ;sumFC = total(data[0:nchan-1,0])
  nheader = n_elements(header)
  newFile = fileOut
  OPENW, lun, newfile, /GET_LUN
  ; write header
  for k=0,nheader-1 do begin
    printf,lun,header[k]
  endfor

;  The above lines were commented out and replaced with the lines below 5/26/2000
  printf,lun,'White beam monitor: '+string(sumWBM)
  ; write tbm
  printf,lun,'Transmitted beam monitor: '+string(sumTBM)
  ; write fission chamber sum
  printf,lun,'Fission chamber sum: '+string(sumFC)

 ; if temperature data present, write out to file
  if n_elements(temperature) gt 0 then begin
    ntemps = n_elements(temperature)
    printf,lun,'Temperature log: '
    for j = 0,ntemps-1 do begin
      printf,lun,temperature[j]
    endfor
  endif
  ; write data
  detQ = ['beam monitor',string(q)]

  for k=0,ndet do begin
    if k eq 0 then begin
      printf,lun,'#Detector '+strcompress(string(k))+$
                 ': '+strcompress(detQ[k])
    endif else begin
      printf,lun,'#Detector '+strcompress(string(k))+$
                 ':  Q = '+strcompress(detQ[k])+' (inverse angstroms)'
    endelse
    for j=0,nchan-1 do begin

;  The format statement was removed for Taub's group 5/26/2000
      if k eq 0 then begin ; print the monitor spectrum first
        printf,lun,energy[j],mon[j],monerr[j],format='(3(e15.6,x))'
      endif else begin
        printf,lun,energy[j],data[j,k-1],error[j,k-1],format='(3(e15.6,x))'
      endelse
    endfor
  endfor
  ;
  free_lun, lun

endfor
void = dialog_message(/information,'Data file successfully written',$
       dialog_parent = event.top)
; Sensitize the widgets
widget_control,event.top,sensitive = 1
widget_control,event.top,set_uvalue = pState,/no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;
pro hfbs_writeCon_event
return
end
;;;;;;;;;;;;;;;;;;;;;
function hfbs_writeCon,group_leader = group_leader
widget_control,group_leader,get_uvalue = inPtr  ; get the pointer information from group leader
davePtr = (*inPtr).davePtr
path = (*!dave_defaults).workDir;(*inPtr).workDir
tlb = widget_base(/col,group_leader = group_leader,title = 'DAVE to CON Converter')
butsize = 150
void = widget_button(tlb,value = 'Select DAVE Files to Convert',$
       event_pro = 'hfbswcSelFiles',xsize = butsize)
void = widget_button(tlb,value = 'Dismiss',xsize = butsize,event_pro = 'hfbswcQuit')
centertlb,tlb
widget_control,tlb,/realize
msg = 'CANCEL'
state = {filePtr:ptr_new(/allocate_heap),$
         msg:msg,$
         path:path,$
         inPtr:davePtr}
pState = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pState
xmanager,'hfbs_writeCon',tlb

return,pState
end
;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;