; $Id$
;###############################################################################
;
; NAME:
;  HFBS_SHOWDAVE
;
; PURPOSE:
;
;
; CATEGORY:
;  DAVE, HFBS, data reduction
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; hfbs_showDave.pro
;
; This function widget displays the data files that were
; reduced using hfbs_redDyn.pro
;
; Written by R.M.Dimeo (01/18/02)
;
; Modification history:
; --------------------
;;;;;;;;;;;;;;;;;;;;;
pro hfbs_sdQuit,event
widget_control,event.top,/destroy
return
end
;;;;;;;;;;;;;;;;;;;;;
pro hfbs_sdCleanup,tlb
widget_control,tlb,get_uvalue = pState,/no_copy
wdelete,(*pState).winPix
ptr_free,(*pState).dataPtr
ptr_free,(*pState).ePtr
ptr_free,(*pState).errPtr
ptr_free,(*pState).qPtr
widget_control,tlb,set_uvalue = pState,/no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;
pro hfbs_sdPlot,event
widget_control,event.top,get_uvalue = pState,/no_copy
nfiles = n_elements((*pState).dataPtr)
widget_control,(*pState).detSlider,get_value = index
index = index - 1

data = *(*pState).dataPtr[0]
datSize = size(data)
ndet = datSize[2]
nchan = datSize[1]
if ndet eq 1 then index = 0

ymax = -1.e20
ymin = 1.e20
if (*pState).autoscale eq 1 then begin
  nfiles = n_elements((*pState).dataPtr)
  for i = 0,nfiles-1 do begin
    ymax = ymax > max((*(*pState).dataPtr[i])[*,index])
    ymin = ymin < min((*(*pState).dataPtr[i])[*,index])
  endfor
  dy = ymax-ymin
  (*pState).yviewrange = [ymin-0.2*dy,ymax+0.2*dy]
  (*pState).xviewrange = [min(*(*pState).ePtr[0]),max(*(*pState).ePtr[0])]
endif

for i = 0,nfiles-1 do begin
  x = *(*pState).ePtr[i]
  q = (*(*pState).qPtr[i])[index]
  outTitle = '!3Q = '+strcompress(string(q,format = '(f10.3)'))+' ('+!dave_invAngstromSym+')'
  y = (*(*pState).dataPtr[i])[*,index]
  yerr = (*(*pState).errPtr[i])[*,index]
  wset,(*pState).winPix
  if i eq 0 then begin
    plot,x,y,psym = hfbs_selsym(i),xrange = (*pState).xviewrange,xstyle = 1,$
         yrange = (*pState).yviewrange,ystyle = 1,xtitle = (*pState).xlabel,$
         ytitle = (*pState).ylabel,title = outTitle
  endif else begin
    oplot,x,y,psym = hfbs_selsym(i)
  endelse
  errplot,x,y-yerr,y+yerr,width = 0.0
endfor
wset,(*pState).winVis
device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
empty
widget_control,event.top,set_uvalue = pState,/no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;
pro hfbs_sdDraw,event
widget_control,event.top,get_uvalue = pState,/no_copy
case event.type of
0:	begin		; button press
	  (*pState).mouse = event.press
	  if (*pState).mouse eq 4 then begin
	    (*pState).autoscale = 1
	  endif
	  if (*pState).mouse eq 1 then begin
	    (*pState).xbox[0] = event.x
	    (*pState).ybox[0] = event.y
	    wset,(*pState).winVis
	    device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
	    empty
	    (*pState).autoscale = 0
	    widget_control,(*pState).datWin,draw_motion_events = 1
	  endif
	end
1:	begin	; button release
	  xll = (*pState).xbox[0] < (*pState).xbox[1]
	  yll = (*pState).ybox[0] < (*pState).ybox[1]
	  w = abs((*pState).xbox[1] - (*pState).xbox[0])
	  h = abs((*pState).ybox[1] - (*pState).ybox[0])
	  xur = xll + w
	  yur = yll + h
	  ll = convert_coord(xll,yll,/device,/to_data)
	  ur = convert_coord(xur,yur,/device,/to_data)
	  (*pState).xviewrange = [ll[0],ur[0]]
	  (*pState).yviewrange = [ll[1],ur[1]]
	  widget_control,event.top,set_uvalue = pState,/no_copy
	  hfbs_sdPlot,event
	  widget_control,event.top,get_uvalue = pState,/no_copy
	  widget_control,(*pState).datWin,draw_motion_events = 0
	  (*pState).mouse = 0B
	end
2:	begin
	  (*pState).xbox[1] = event.x
	  (*pState).ybox[1] = event.y
	  xc = [(*pState).xbox[0],event.x,event.x,(*pState).xbox[0],(*pState).xbox[0]]
	  yc = [(*pState).ybox[0],(*pState).ybox[0],event.y,event.y,(*pState).ybox[0]]
	  wset,(*pState).winVis
	  device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
	  plots,xc,yc,/device
	  empty
	end
else:
endcase
widget_control,event.top,set_uvalue = pState,/no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;
pro hfbs_showDave_event,event
;widget_control,event.top,get_uvalue = pState,/no_copy
;widget_control,event.top,set_uvalue = pState,/no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;
function hfbs_showDave,group_leader = group_leader,files
; Widget definition module
;widget_control,group_leader,get_uvalue = inPtr	; get the pointer information from group leader
loadct,0,/silent
nfiles = n_elements(files)
dataPtr = ptrarr(nfiles,/allocate_heap)
errPtr = ptrarr(nfiles,/allocate_heap)
ePtr = ptrarr(nfiles,/allocate_heap)
qPtr = ptrarr(nfiles,/allocate_heap)

; Load the data
for i = 0,nfiles-1 do begin
  filename = files[i]
  restore,filename
  *dataPtr[i] = (*(*(*davePtr).dataStrPtr).commonStr.histPtr).qty
  *errPtr[i]  = (*(*(*davePtr).dataStrPtr).commonStr.histPtr).err
  *ePtr[i]    = (*(*(*davePtr).dataStrPtr).commonStr.histPtr).x
  *qPtr[i]	  = (*(*(*davePtr).dataStrPtr).commonStr.histPtr).y

  xlabel =  (*(*davePtr).dataStrPtr).commonStr.xlabel
  ylabel =  (*(*davePtr).dataStrPtr).commonStr.histlabel

  dave_beast_ops,"rem",davePtr
endfor
ndet = n_elements((*qPtr[0]))
winxsize = 400 & winysize = 300
butSize = 150
if n_elements(group_leader) ne 0 then begin
  tlb = widget_base(/row,/modal,group_leader = group_leader,$
        title = 'HFBS Dave File Display')
endif else begin
  tlb = widget_base(/row,title = 'HFBS Dave File Display')
endelse
datWin = widget_draw(tlb,xsize = winxsize,ysize = winysize,/button_events,$
         event_pro = 'hfbs_sdDraw')
colBase = widget_base(tlb,/col)
if ndet eq 1 then ndet = 2
detSlider = widget_slider(colBase,minimum = 1,maximum = ndet,value = 1,event_pro = 'hfbs_sdPlot')
info = widget_text(colBase,xsize = 40,ysize = 10,/scroll,value = files)
void = widget_button(colBase,value = 'Dismiss',xsize = butsize,event_pro = 'hfbs_sdQuit')

centertlb,tlb
widget_control,tlb,/realize
widget_control,datWin,get_value = winVis
window,0,/free,/pixmap,xsize = winxsize,ysize = winysize
winPix = !d.window

state = {files:files,$
         dataPtr:dataPtr,$
         ePtr:ePtr,$
         errPtr:errPtr,$
         qPtr:qPtr,$
         winVis:winVis,$
         winPix:winPix,$
         detSlider:detSlider,$
         xviewrange:[0.0,1.0],$
         yviewrange:[0.0,1.0],$
         xbox:[0.0,1.0],$
         ybox:[0.0,1.0],$
         mouse:0B,$
         autoscale:1,$
         datWin:datWin,$
         xlabel:xlabel,$
         ylabel:ylabel}

pState = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pState
hfbs_sdPlot,{event,id:void,top:tlb,handler:0l}

xmanager,'hfbs_showDave',tlb,cleanup = 'hfbs_sdCleanup'
return,pState
end