; $Id$
;==========================================
;+
; NAME:
;       InformationPanel
;
; PURPOSE:
;       This widget creates a way of getting general information from a user
;               without having to create a new widget every time.
;
; CATEGORY:
;       Information Widget
;
; CALLING SEQUENCE:
;       Result = informationPanel(title='Enter number of steps in file',nSteps=10)
;
; INPUTS:
;
;
; KEYWORD PARAMETERS:
;       TITLE:  A string containing the text to be used as the label for the
;               information panel.  The default is a null string.
;
;               group_leader :  Specifying this keyword will create information panel
;                               as a blocking widget that will appear centered over the parent.
;
;       All other keywords will appear as a cw_field type widget.  The keyword will
;               be the label, while the value will be the value in the input field.  Note that
;               since keywords can only be single words, then the labels may only be single words
;               also. i.e. timeStep = 10 is fine, but time step = 10 is not.
;
; OUTPUTS:
;       This function returns an anonymous structure with the values containing
;               whatever values the user entered on the widget.
;
; COMMON BLOCKS:
;       None.
;
; PROCEDURE:
;       Allows a general way of creating a user input panel.
;
; SIDE EFFECTS:
;       None known
;
; EXAMPLE:
;
;           The following creates a panel with a title and three input fields.
;
;               result = informationPanel(title='example input', time = 1440, $
;                                                                 month='March', year = 1999)
;       result will be an anonymous structure with the field names equal to
;       the keywords, and the values equal to whatever the user entered.
;
; MODIFICATION HISTORY:
;       Written by:
;       RLK, Ronn Kling Consulting.
;       ronn@rlkling.com
;       www.rlkling.com
;               June 1999
;
;-

pro InformationPanel_event,event

widget_Control,event.top,get_uvalue=state
NumEntries = n_tags((*state.extra))
names = tag_names((*state.extra))
for i =0,numEntries-1 do begin ;pull off the values in the fields
  widget_control,state.fieldIds[i],get_value=value
  (*state.extra).(i) = value(0) ;place the values in the pointer
endfor
widget_control,event.top,/destroy
return
end

function InformationPanel,_extra=extra,group_leader=group_leader, $
                 title=title

NumEntries = n_tags(extra)
names = tag_names(extra)
fieldIds = lonArr(numEntries)
if keyword_set(group_leader) then base = widget_base(/column ,group_leader=group_leader,/modal) $
   else base = widget_base(/column)
;Put a label at the top if a title was specified
if keyword_set(title) then void = widget_label(base,value=title)
;build a field for every entry in the input structure
for i =0,numEntries-1 do begin
  fieldIds[i] = cw_field(base,value=extra.(i),title=names[i]+' ',/string)
endfor
void = widget_button(base,value='done')
widget_control,base,/realize
state = { fieldIds : fieldIds, $
                  extra : ptr_new(extra) } ;store extra in a pointer so that we can retrieve it later
widget_control,base,set_uvalue=state
xmanager,'InformationPanel',base
extra = (*state.extra) ;retrieve the information
ptr_free,state.extra ;free the pointer
return,extra
end