; $Id$
;###############################################################################
;
; NAME:
;  HFBS_READHEADER
;
; PURPOSE:
;  Reads in the header of an HFBS file.
;
; CATEGORY:
;  DAVE, HFBS, utility
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; hfbs_readHeader.pro
;
; This procedure returns a string array
; containing the contents of the header of
; an HFBS data file.
;
; Written by R.M.Dimeo (01/15/02)
;
pro hfbs_readheader,filename,header,thisTemperature,thisDopplerRate,thisSumWBM,thisSumTBM
openr, lun, filename, /get_lun
nlines = 0
nheader = 9
dumstr = ''
header=strarr(nheader)
for i=0,nheader-1 do begin
  readf,lun,dumstr
  header[i] = dumstr
  nlines = nlines+1
endfor

thisLiveTime = (strmid(header[7],21))
timebin = float(strmid(header[8],21,2))
;timebin = 50.0

; Read in the Log Doppler Frequency vector
READF, lun, dumstr & nlines = nlines+1
dopFreq = 0.0
READF, lun, dumstr & nlines = nlines+1
sumDop = float(dumstr)
countDop = 1
while strmid(dumstr,0,1) ne '#' do begin
  readf, lun, dumstr & nlines = nlines+1
  countDop = countDop + 1
  if (strmid(dumstr,0,1) ne '#') then  begin
  dopFreq = float(dumstr)
  sumDop = temporary(sumDop) + dopFreq
  endif
endwhile
countDop = temporary(countDop) - 1
DopFreq = sumDop/countDop
thisDopplerRate = DopFreq
realchannels = 0.0

; Read in the Log white beam vector
sumWBM = 0.0
WBM = 0.0
for i = 0,countDop - 1 do begin
  READF,lun, dumstr & nlines = nlines+1
  WBM = WBM+float(dumstr)
  sumWBM = WBM
endfor
thisSumWBM = sumWBM

changetoenergy = 1
; Read in the Log trans beam vector
sumTBM = 0.0
TBM = 0.0
READF,lun, dumstr  & nlines = nlines+1  ; read the text header for the TBM
for i = 0,countDop - 1 do begin
  READF,lun, dumstr & nlines = nlines+1
  TBM = TBM+float(dumstr)
  sumTBM = TBM
endfor
thisSumTBM = sumTBM
readf,lun,dumstr & nlines = nlines + 1
free_lun,lun

if strmid(dumstr,0,3) eq '# D' then begin
  openr,lun,filename
  for i = 0,nlines-2 do begin
    readf,lun,dumstr
  endfor
  skipthis = 1
endif else begin
  openr,lun,filename
  for i = 0,nlines-2 do begin
    readf,lun,dumstr
  endfor
  skipthis = 0
endelse

; Read in the log sample temperature
if skipthis eq 0 then begin
  READF,lun, dumstr     ; '#Log sample temp'
  READF,lun, dumstr
  if float(dumstr) ne 0.0 then begin
    temperature = fltarr(countdop)
    temperature[0] = float(dumstr)
    for i = 1,countdop-1 do begin
      readf,lun,dumstr
      temperature[i] = float(dumstr)
    endfor
    tempPtr = ptr_new(temperature)
  endif
endif
timeMinutes = (double(thisLiveTime))/60d
if ptr_valid(tempPtr) then begin
  thisTemperature = temperature
  ptr_free,tempPtr
endif else begin
  thisTemperature = 0.0
endelse



free_lun,lun

return
end