;
; NAME:
;       Graphical_Masking
;PD Dr. Philip Tregenna-Piggott,
;Laboratory for Neutron Scattering,
;ETHZ and Paul-Scherrer Institute,
;CH-5232 Villigen PSI,
;Switzerland.
;
;Tel. :+41 56 310 54 05
;Fax. :+41 56 310 29 39
;Email:philip.tregenna@psi.ch
;
;Based on Programs written by:
;       Robert M. Dimeo, Ph.D.
;     NIST Center for Neutron Research
;       100 Bureau Drive
;     Gaithersburg, MD 20899
;       Phone: (301) 975-8135
;       E-mail: robert.dimeo@nist.gov
;       http://www.ncnr.nist.gov/staff/dimeo
;
; CATEGORY:
;
;       Focus Utilities
;
; CALLING SEQUENCE:
;
;      Graphical_Masking
;
;
; INPUT FIELDS:
;
;
; EXAMPLES FOR POTENTIALS (must use IDL syntax as shown below):
;
;
; DISCLAIMER
;
;     This software is provided as is without any warranty whatsoever.
;     Permission to use, copy, modify, and distribute modified or
;     unmodified copies is granted, provided this disclaimer
;     is included unchanged.
;
; MODIFICATION HISTORY:
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro GMCancel,event
widget_control,event.top,get_uvalue = pState
detarr1d=(*pState).detarr1d
wherezero=where(detarr1d eq 0,count)
if count ne 0 then begin
detarr1d[wherezero]=1
(*pState).detarr1d=detarr1d
endif
widget_control,event.top,/destroy
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro GMAccept,event
widget_control,event.top,/destroy
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro GMReset,event
widget_control,event.top,get_uvalue = pState
detarr1d=(*pState).detarr1d
wherezero=where(detarr1d eq 0,count)
if count eq 0 then return
detarr1d[wherezero]=1
(*pState).detarr1d=detarr1d
widget_control,(*pState).omit,set_value = ''
widget_control,(*pState).remain,set_value = n_elements(detarr1d)
(*pState).autoscale = 1
      gmplot,event
      (*pState).mouse = 0B
      widget_control,(*pState).win,draw_motion_events = 0
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro GMReset2d,event
widget_control,event.top,get_uvalue = pState
detarr2d=(*pState).detarr2d
wherezero=where(detarr2d eq 0,count)
if count eq 0 then return
detarr2d[wherezero]=1
(*pState).detarr2d=detarr2d
widget_control,(*pState).omit2d,set_value = 'Detectors to be omitted {x,y}'
widget_control,(*pState).remain2d,set_value = n_elements(detarr2d)
(*pState).autoscale2d = 1
      gmplot2d,event
      (*pState).mouse2d = 0B
      widget_control,(*pState).win2d,draw_motion_events = 0
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro gmPlot,event
widget_control,event.top,get_uvalue = pState
x = (*pState).x
y = (*pState).y
detarr1d=(*pState).detarr1d
x=x[where(detarr1d eq 1)]
y=y[where(detarr1d eq 1)]
if (*pState).autoscale eq 1 then begin
  xlo = min(x) & xhi = max(x)
  ylo = min(y) & yhi = max(y)
  (*pState).xrange = [xlo,xhi]
  (*pState).yrange = [ylo,yhi]
endif

widget_control,(*pState).XAxis,get_value = val
if val eq 0 then begin
xtitle = '2 Theta / Degrees'
title = 'Intensity vs. 2 Theta'
endif
if val eq 1 then begin
xtitle = 'Sin(Theta) / Lambda'
title = 'Intensity vs. Sin(Theta)/Lambda'
endif
if val eq 2 then begin
xtitle = 'Detector Number'
title = 'Intensity vs. Detector Number'
endif

wset,(*pState).winPix

plot,x,y,xrange = (*pState).xrange,yrange = (*pState).yrange, $
     xstyle = 1,ystyle = 1,xtitle = xtitle, $
     ytitle = 'Intensity', title = title,linestyle = 0, $
     thick = 3.0, psym=-4, symsize=1.0

wset,(*pState).winVis
device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]

(*pState).pix=0

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro gmdraw,event
widget_control,event.top,get_uvalue = pState

if (*pState).pix ne 0 then begin
        gmPlot,event
endif

widget_control,(*pState).action,get_value = val
if val eq 0 then begin
case event.type of
0:  begin       ; button press
      (*pState).mouse = event.press
      if (*pState).mouse eq 4 then begin
        (*pState).autoscale = 1
        gmPlot,event
      endif
      if (*pState).mouse eq 1 then begin
        (*pState).xbox[0] = event.x
        (*pState).ybox[0] = event.y
        wset,(*pState).winVis
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
        empty
        (*pState).autoscale = 0
        widget_control,(*pState).win,/draw_motion_events
      endif
    end
1:  begin    ; button release
     if (*pState).mouse eq 1 then begin
      xll = (*pState).xbox[0] < (*pState).xbox[1]
      yll = (*pState).ybox[0] < (*pState).ybox[1]
      w = abs((*pState).xbox[1] - (*pState).xbox[0])
      h = abs((*pState).ybox[1] - (*pState).ybox[0])
      xur = xll + w
      yur = yll + h
      ll = convert_coord(xll,yll,/device,/to_data)
      ur = convert_coord(xur,yur,/device,/to_data)
      (*pState).xrange = [ll[0],ur[0]]
      (*pState).yrange = [ll[1],ur[1]]
      gmplot,event
      (*pState).mouse = 0B
      widget_control,(*pState).win,draw_motion_events = 0
     endif
     if (*pState).mouse eq 4 then begin
      gmplot,event
      (*pState).mouse = 0B
      widget_control,(*pState).win,draw_motion_events = 0
     endif
    end
2:  begin    ; mouse motion
      if (*pState).mouse eq 1 then begin
       (*pState).xbox[1] = event.x
       (*pState).ybox[1] = event.y
       xc = [(*pState).xbox[0],event.x,event.x,$
             (*pState).xbox[0],$
             (*pState).xbox[0]]
       yc = [(*pState).ybox[0],(*pState).ybox[0],$
             event.y,event.y,$
             (*pState).ybox[0]]
       wset,(*pState).winVis
       device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
       plots,xc,yc,/device
       empty
      endif
    end
else:
endcase
return
endif
if val eq 1 then begin
case event.type of
0:  begin       ; button press
      (*pState).mouse = event.press
      if (*pState).mouse eq 4 then begin
        (*pState).autoscale = 1
        gmPlot,event
      endif
      if (*pState).mouse eq 1 then begin
        (*pState).xbox[0] = event.x
        (*pState).ybox[0] = event.y
        wset,(*pState).winVis
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
        empty
        (*pState).autoscale = 0
        widget_control,(*pState).win,/draw_motion_events
      endif
    end
1:  begin    ; button release
     if (*pState).mouse eq 1 then begin
      xll = (*pState).xbox[0] < (*pState).xbox[1]
      yll = (*pState).ybox[0] < (*pState).ybox[1]
      w = abs((*pState).xbox[1] - (*pState).xbox[0])
      h = abs((*pState).ybox[1] - (*pState).ybox[0])
      xur = xll + w
      yur = yll + h
      ll = convert_coord(xll,yll,/device,/to_data)
      ur = convert_coord(xur,yur,/device,/to_data)
      ;
      ;Here we add some new code
      (*pState).xrangedel = [ll[0],ur[0]]
      (*pState).yrangedel = [ll[1],ur[1]]
      ;print, 'xrange:',(*pState).xrange
      ;print, 'yrange:',(*pState).yrange
      ;print,''
      ;print, 'xrangedel:',(*pState).xrangedel
      ;print, 'yrangedel:',(*pState).yrangedel
      GMremove_detectors,event
      gmplot,event
      (*pState).mouse = 0B
      widget_control,(*pState).win,draw_motion_events = 0
     endif
     if (*pState).mouse eq 4 then begin
      gmplot,event
      (*pState).mouse = 0B
      widget_control,(*pState).win,draw_motion_events = 0
     endif
    end
2:  begin    ; mouse motion
      if (*pState).mouse eq 1 then begin
       (*pState).xbox[1] = event.x
       (*pState).ybox[1] = event.y
       xc = [(*pState).xbox[0],event.x,event.x,$
             (*pState).xbox[0],$
             (*pState).xbox[0]]
       yc = [(*pState).ybox[0],(*pState).ybox[0],$
             event.y,event.y,$
             (*pState).ybox[0]]
       wset,(*pState).winVis
       device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
       plots,xc,yc,/device
       empty
      endif
    end
else:
endcase
return
endif
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro gmPlot2d,event
widget_control,event.top,get_uvalue = pState
widget_control,(*pState).Display2d,get_value = Display2d
SumData2d=(*pState).SumData2d
detarr2d=(*pState).detarr2d

IF Display2d eq 0 THEN BEGIN
widget_control,(*pState).ColourGradient,get_value=CG
c=Indgen(12)+1
wherezero=where(detarr2d eq 0,count)
if count ne 0 then begin
SumData2d[wherezero]=-1
endif
ydim=(size(SumData2d))[1]
xdim=(size(SumData2d))[2]
z=fltarr(xdim,ydim)
for i = 0, xdim-1 do begin
z[i,*]=SumData2d[*,i]
endfor
zstep=(max(z)-min(z))/100.0
zmin=min(z)+zstep*(CG-1)
index=where(z lt zmin,count)
if count ne 0 then z[index] = zmin
if (*pState).autoscale2d eq 1 then begin
  xlo = 0 & xhi = xdim-1
  ylo = 0 & yhi = ydim-1
  (*pState).xrange2d = [xlo,xhi]
  (*pState).yrange2d = [ylo,yhi]
endif
wset,(*pState).winPix2d
contour,z,xtitle = 'Abscissa', ytitle = 'Ordinate', $
       xrange = (*pState).xrange2d,yrange = (*pState).yrange2d, $
     xstyle = 1,ystyle = 1,c_colors=c,nlevels=12,/fill
wset,(*pState).winVis2d
device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix2d]

ENDIF ELSE BEGIN

wherezero=where(detarr2d eq 0,count)
if count ne 0 then begin
SumData2d[wherezero]=0
endif
SumData2dy=total(SumData2d,1)
x = indgen(n_elements(SumData2dy))
y = SumData2dy
detarr2dy=total(detarr2d,1)
x=x[where(detarr2dy ne 0)]
y=y[where(detarr2dy ne 0)]

if (*pState).autoscale2d eq 1 then begin
  xlo = min(x) & xhi = max(x)
  ylo = min(y) & yhi = max(y)
  (*pState).xrange2d = [xlo,xhi]
  (*pState).yrange2d = [ylo,yhi]
endif


wset,(*pState).winPix2d

plot,x,y,xrange = (*pState).xrange2d,yrange = (*pState).yrange2d, $
     xstyle = 1,ystyle = 1, $
     ytitle = 'Intensity', xtitle = 'Abscissa',linestyle = 0, $
     thick = 3.0, psym=-4, symsize=1.0

wset,(*pState).winVis2d
device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix2d]
ENDELSE
    (*pState).pix = 1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro gmdraw2d,event
widget_control,event.top,get_uvalue = pState

if (*pState).pix ne 1 then begin
    gmPlot2d,event
endif

widget_control,(*pState).action2d,get_value = val
if val eq 0 then begin
case event.type of
0:  begin       ; button press
      (*pState).mouse2d = event.press
      if (*pState).mouse2d eq 4 then begin
        (*pState).autoscale2d = 1
        gmPlot2d,event
      endif
      if (*pState).mouse2d eq 1 then begin
        (*pState).xbox2d[0] = event.x
        (*pState).ybox2d[0] = event.y
        wset,(*pState).winVis2d
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix2d]
        empty
        (*pState).autoscale2d = 0
        widget_control,(*pState).win2d,/draw_motion_events
      endif
    end
1:  begin    ; button release
     if (*pState).mouse2d eq 1 then begin
      xll = (*pState).xbox2d[0] < (*pState).xbox2d[1]
      yll = (*pState).ybox2d[0] < (*pState).ybox2d[1]
      w = abs((*pState).xbox2d[1] - (*pState).xbox2d[0])
      h = abs((*pState).ybox2d[1] - (*pState).ybox2d[0])
      xur = xll + w
      yur = yll + h
      ll = convert_coord(xll,yll,/device,/to_data)
      ur = convert_coord(xur,yur,/device,/to_data)
      (*pState).xrange2d = [ll[0],ur[0]]
      (*pState).yrange2d = [ll[1],ur[1]]
      gmplot2d,event
      (*pState).mouse2d = 0B
      widget_control,(*pState).win2d,draw_motion_events = 0
     endif
     if (*pState).mouse2d eq 4 then begin
      gmplot2d,event
      (*pState).mouse2d = 0B
      widget_control,(*pState).win2d,draw_motion_events = 0
     endif
    end
2:  begin    ; mouse motion
      if (*pState).mouse2d eq 1 then begin
       (*pState).xbox2d[1] = event.x
       (*pState).ybox2d[1] = event.y
       xc = [(*pState).xbox2d[0],event.x,event.x,$
             (*pState).xbox2d[0],$
             (*pState).xbox2d[0]]
       yc = [(*pState).ybox2d[0],(*pState).ybox2d[0],$
             event.y,event.y,$
             (*pState).ybox2d[0]]
       wset,(*pState).winVis2d
       device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix2d]
       plots,xc,yc,/device
       empty
      endif
    end
else:
endcase
return
endif
if val eq 1 then begin
case event.type of
0:  begin       ; button press
      (*pState).mouse2d = event.press
      if (*pState).mouse2d eq 4 then begin
        (*pState).autoscale2d = 1
        gmPlot2d,event
      endif
      if (*pState).mouse2d eq 1 then begin
        (*pState).xbox2d[0] = event.x
        (*pState).ybox2d[0] = event.y
        wset,(*pState).winVis2d
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix2d]
        empty
        (*pState).autoscale2d = 0
        widget_control,(*pState).win2d,/draw_motion_events
      endif
    end
1:  begin    ; button release
     if (*pState).mouse2d eq 1 then begin
      xll = (*pState).xbox2d[0] < (*pState).xbox2d[1]
      yll = (*pState).ybox2d[0] < (*pState).ybox2d[1]
      w = abs((*pState).xbox2d[1] - (*pState).xbox2d[0])
      h = abs((*pState).ybox2d[1] - (*pState).ybox2d[0])
      xur = xll + w
      yur = yll + h
      ll = convert_coord(xll,yll,/device,/to_data)
      ur = convert_coord(xur,yur,/device,/to_data)
      ;
      ;Here we add some new code
      (*pState).xrangedel2d = [ll[0],ur[0]]
      (*pState).yrangedel2d = [ll[1],ur[1]]
      ;print, 'xrange:',(*pState).xrange
      ;print, 'yrange:',(*pState).yrange
      ;print,''
      ;print, 'xrangedel:',(*pState).xrangedel
      ;print, 'yrangedel:',(*pState).yrangedel
      GMremove_detectors2d,event
      gmplot2d,event
      (*pState).mouse2d = 0B
      widget_control,(*pState).win2d,draw_motion_events = 0
     endif
     if (*pState).mouse2d eq 4 then begin
      gmplot2d,event
      (*pState).mouse2d = 0B
      widget_control,(*pState).win2d,draw_motion_events = 0
     endif
    end
2:  begin    ; mouse motion
      if (*pState).mouse2d eq 1 then begin
       (*pState).xbox2d[1] = event.x
       (*pState).ybox2d[1] = event.y
       xc = [(*pState).xbox2d[0],event.x,event.x,$
             (*pState).xbox2d[0],$
             (*pState).xbox2d[0]]
       yc = [(*pState).ybox2d[0],(*pState).ybox2d[0],$
             event.y,event.y,$
             (*pState).ybox2d[0]]
       wset,(*pState).winVis2d
       device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix2d]
       plots,xc,yc,/device
       empty
      endif
    end
else:
endcase
return
endif
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro GMremove_detectors,event
widget_control,event.top,get_uvalue = pState
xrangedel=(*pState).xrangedel
yrangedel=(*pState).yrangedel
detarr1d=(*pState).detarr1d
x=(*pState).x
y=(*pState).y
;print,'x =',x
;filter the data first by the x range
;print,''
;print,'xrangedel[0]',xrangedel[0]
;print,'xrangedel[1]',xrangedel[1]
;print,''
;print,'yrangedel[0]',yrangedel[0]
;print,'yrangedel[1]',yrangedel[1]
whereinxrange=where(x ge xrangedel[0],count)
if count eq 0 then return
subscriptref=whereinxrange
;print,'subscriptref: ',subscriptref
;print,'subscriptref[0]: ',subscriptref[0]
x_1stcull=x[whereinxrange]
y_1stcull=y[whereinxrange]
;print,'y_1stcull',y_1stcull
whereinxrange=where(x_1stcull lt xrangedel[1],count)
if count eq 0 then return
subscriptref=subscriptref[0]+whereinxrange
;print,'subscriptref: ',subscriptref
;print,'whereinxrange: ',whereinxrange
x_2ndcull=x_1stcull[whereinxrange]
y_2ndcull=y_1stcull[whereinxrange]
;print,'x_2ndcull',x_2ndcull
;print,'y_2ndcull',y_2ndcull
;
;now filter the data by the y range
whereinyrange=where(y_2ndcull ge yrangedel[0],count)
if count eq 0 then return
subscriptref1=subscriptref[0]+whereinyrange
;print,'subscriptref1 = ',subscriptref1
whereinyrange=where(y_2ndcull le yrangedel[1],count)
if count eq 0 then return
subscriptref2=subscriptref[0]+whereinyrange
;print,'subscriptref2 = ',subscriptref2
uni1=1+bytarr(n_elements(subscriptref1))
uni2=1+bytarr(n_elements(subscriptref2))
mat1=uni1#subscriptref2
mat2=subscriptref1#uni2
mat3=mat1-mat2
;print,'mat3 =',mat3
wherezero=where(mat3 eq 0,count)
if count eq 0 then return
;print,'mat1[wherezero] =',mat1[wherezero]
;print,'mat2[wherezero] =',mat2[wherezero]
;subscriptref3=subscriptref1 eq subscriptref2
;print,'subscriptref3 = ',subscriptref3
;print,'y[subscriptref3] =',y[subscriptref3]
remdet=mat1[wherezero]
;print,'remdet =',remdet
detarr1d[remdet]=0
(*pState).detarr1d=detarr1d

wherezero=where(detarr1d eq 0,count)
num=n_elements(y)-count
if num eq 0 then begin
GMReset,event
return
endif
if count ne 0 then begin
;print,wherezero
wherezero+=1
;print,wherezero
n=n_elements(wherezero)
omit=string(wherezero[0])
for i=1,n-1 do begin
omit=[omit,','+strtrim(string(wherezero[i]),2)]
endfor
;help,omit
widget_control,(*pState).omit,set_value = strtrim(omit,2)
endif
widget_control,(*pState).remain,set_value = num
end;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro GMremove_detectors2d,event
widget_control,event.top,get_uvalue = pState
xrangedel2d=(*pState).xrangedel2d
yrangedel2d=(*pState).yrangedel2d
widget_control,(*pState).Display2d,get_value = Display2d
detarr2d=(*pState).detarr2d

IF Display2d EQ 0 THEN BEGIN

xrangedel2d=round(xrangedel2d)
yrangedel2d=round(yrangedel2d)
;print,'xrangedel2d :',xrangedel2d
;print,'yrangedel2d :',yrangedel2d
;
;
;help,detarr2d
ydim=(size(detarr2d))[1]
xdim=(size(detarr2d))[2]
x=indgen(xdim)
y=indgen(ydim)
;print,'x:',x
;print,'y:',y
; check to see whether window is in range
if xrangedel2d[1] lt min(x) then return ; to the left
if xrangedel2d[0] gt max(x) then return ; to the right
if yrangedel2d[1] lt min(y) then return ; to the bottom
if yrangedel2d[0] gt max(y) then return ; to the top

if xrangedel2d[1] gt max(x) then xrangedel2d[1] = max(x)
if xrangedel2d[0] lt min(x) then xrangedel2d[0] = min(x)
if yrangedel2d[1] gt max(y) then yrangedel2d[1] = max(y)
if yrangedel2d[0] lt min(y) then yrangedel2d[0] = min(y)
;
detarr2d[yrangedel2d[0]:yrangedel2d[1],xrangedel2d[0]:xrangedel2d[1]]=0

;omitted='blah'
OmitTotal=(yrangedel2d[1]-yrangedel2d[0]+1)*(xrangedel2d[1]-xrangedel2d[0]+1)
omitted=strarr(OmitTotal)
k=0
for i= xrangedel2d[0], xrangedel2d[1] do begin
    for    j = yrangedel2d[0], yrangedel2d[1] do begin
    coord='{'+strtrim(string(i),2)+','+strtrim(string(j),2)+'}'
;    omitted=[omitted,coord]
    omitted[k]=coord
    k+=1
    endfor
endfor
widget_control,(*pState).omit2d,get_value = old
omitted=[old,omitted]
widget_control,(*pState).omit2d,set_value = omitted

(*pState).detarr2d=detarr2d
;print, 'reached here'
wherezero=where(detarr2d eq 0,count)
left=xdim*ydim-count
widget_control,(*pState).remain2d,set_value = left

ENDIF ELSE BEGIN
SumData2d=(*pState).SumData2d
wherezero=where(detarr2d eq 0,count)
if count ne 0 then begin
SumData2d[wherezero]=0
endif
SumData2dy=total(SumData2d,1)
x = indgen(n_elements(SumData2dy))
y = SumData2dy
whereinxrange=where(x ge xrangedel2d[0],count)
if count eq 0 then return
subscriptref=whereinxrange
;print,'subscriptref: ',subscriptref
;print,'subscriptref[0]: ',subscriptref[0]
x_1stcull=x[whereinxrange]
y_1stcull=y[whereinxrange]
;print,'y_1stcull',y_1stcull
whereinxrange=where(x_1stcull lt xrangedel2d[1],count)
if count eq 0 then return
subscriptref=subscriptref[0]+whereinxrange
;print,'subscriptref: ',subscriptref
;print,'whereinxrange: ',whereinxrange
x_2ndcull=x_1stcull[whereinxrange]
y_2ndcull=y_1stcull[whereinxrange]
;print,'x_2ndcull',x_2ndcull
;print,'y_2ndcull',y_2ndcull
;
;now filter the data by the y range
whereinyrange=where(y_2ndcull ge yrangedel2d[0],count)
if count eq 0 then return
subscriptref1=subscriptref[0]+whereinyrange
;print,'subscriptref1 = ',subscriptref1
whereinyrange=where(y_2ndcull le yrangedel2d[1],count)
if count eq 0 then return
subscriptref2=subscriptref[0]+whereinyrange
;print,'subscriptref2 = ',subscriptref2
uni1=1+bytarr(n_elements(subscriptref1))
uni2=1+bytarr(n_elements(subscriptref2))
mat1=uni1#subscriptref2
mat2=subscriptref1#uni2
mat3=mat1-mat2
;print,'mat3 =',mat3
wherezero=where(mat3 eq 0,count)
if count eq 0 then return
;print,'mat1[wherezero] =',mat1[wherezero]
;print,'mat2[wherezero] =',mat2[wherezero]
;subscriptref3=subscriptref1 eq subscriptref2
;print,'subscriptref3 = ',subscriptref3
;print,'y[subscriptref3] =',y[subscriptref3]
remdet=mat1[wherezero]
;print,'remdet =',remdet
olddetarr2d=detarr2d
detarr2d[*,remdet]=0
;print,'where(olddetarr2d eq 0): ',where(olddetarr2d eq 0)
newomitted=where((olddetarr2d-detarr2d) eq 1, OmitTotal)
ydim=(size(SumData2d))[1]
omitted=strarr(OmitTotal)
for k = 0, OmitTotal - 1 do begin
xcoord=newomitted[k]/ydim
ycoord=newomitted[k]-xcoord*ydim
omitted[k]='{'+strtrim(string(xcoord),2)+','+strtrim(string(ycoord),2)+'}'
endfor
widget_control,(*pState).omit2d,get_value = old
omitted=[old,omitted]
widget_control,(*pState).omit2d,set_value = omitted
(*pState).detarr2d=detarr2d
;print, 'reached here'
wherezero=where(detarr2d eq 0,count)
left=n_elements(detarr2d)-count
widget_control,(*pState).remain2d,set_value = left

ENDELSE


end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Change_Xaxis,event
widget_control,event.top,get_uvalue = pState
widget_control,(*pState).XAxis,get_value = val
if val eq 0 then (*pState).x = (*pState).twotheta
if val eq 1 then (*pState).x = (*pState).sintholam
if val eq 2 then (*pState).x = (*pState).xdet
x=(*pState).x
y= (*pState).y
  xlo = min(x) & xhi = max(x)
  ylo = min(y) & yhi = max(y)
  (*pState).xrange = [xlo,xhi]
  (*pState).yrange = [ylo,yhi]
   gmplot,event
   return
; Handle the resizing events
ctrlgeom = widget_info((*pState).BaseUpper,/geometry)
tlbgeom = widget_info(event.top,/geometry)
xsize = event.x
ysize = event.y

newxsize = xsize-ctrlgeom.xsize
newysize = ysize

widget_control,(*pState).win,draw_xsize = newxsize, $
               draw_ysize = newysize
wdelete,(*pState).winPix
window,/free,/pixmap,xsize = newxsize,ysize = newysize
(*pState).winPix = !d.window
gmplot,event
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro GMLoadPrevious,event
widget_control,event.top,get_uvalue = pState
file='BadDetParameters1D.sav'
fileout= (*pState).workDir+file
    if file_test(fileout) eq 0 then begin
    void=dialog_message(dialog_parent=event.top,/error, $
    'The file: '+fileout+' has not been found')
    return
    endif
    restore, fileout
if (n_elements(detarr1d) eq 0) then begin
    void=dialog_message(dialog_parent=event.top,/error, $
    'The required information is not contained in this file')
return
endif
(*pState).detarr1d=detarr1d
wherezero=where(detarr1d eq 0,count)
num=n_elements((*pState).y)-count
if num eq 0 then begin
GMReset,event
return
endif
if count ne 0 then begin
;print,wherezero
wherezero+=1
;print,wherezero
n=n_elements(wherezero)
omit=string(wherezero[0])
for i=1,n-1 do begin
omit=[omit,','+strtrim(string(wherezero[i]),2)]
endfor
;help,omit
widget_control,(*pState).omit,set_value = strtrim(omit,2)
endif
widget_control,(*pState).remain,set_value = num
gmplot,event
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro GMLoadPrevious2d,event
widget_control,event.top,get_uvalue = pState
file='BadDetParameters2d.sav'
fileout= (*pState).workDir+file
    if file_test(fileout) eq 0 then begin
    void=dialog_message(dialog_parent=event.top,/error, $
    'The file: '+fileout+' has not been found')
    return
    endif
    restore, fileout
if (n_elements(BadDet2d) eq 0) then begin
    void=dialog_message(dialog_parent=event.top,/error, $
    'The required information is not contained in this file')
return
endif
if ((tag_names(BadDet2d))[0] ne 'DETARR2D') then begin
    void=dialog_message(dialog_parent=event.top,/error, $
    'The required information is not contained in this file')
return
endif
detarr2d=BadDet2d.detarr2d
dimensions2d=(*pState).dimensions2d
if ((size(detarr2d))[1] ne dimensions2d[2]) or ((size(detarr2d))[2] ne dimensions2d[3]) then begin
    void=dialog_message(dialog_parent=event.top,/error, $
    'Incompatible array dimensions2d')
return
endif
wherezero=where(detarr2d eq 0,count)
left=n_elements(detarr2d)-count
if left eq 0 then begin
GMReset2d,event
endif
(*pState).detarr2d=detarr2d
widget_control,(*pState).omit2d,set_value = BadDet2d.omitted
widget_control,(*pState).remain2d,set_value = left
gmplot2d,event
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro GMLoadFile,event
widget_control,event.top,get_uvalue = pState
workDir=(*pState).workDir
    filename=dialog_pickfile(path=workDir,$
      file='BadDetParameters1d.sav',/read,filter="*.sav",/fix_filter)
if n_elements(filename) eq 0 then return
if filename eq '' then return
    restore, filename
if (n_elements(detarr1d) eq 0) then begin
    void=dialog_message(dialog_parent=event.top,/error, $
    'The required information is not contained in this file')
return
endif
(*pState).detarr1d=detarr1d
wherezero=where(detarr1d eq 0,count)
num=n_elements((*pState).y)-count
if num eq 0 then begin
GMReset,event
return
endif
if count ne 0 then begin
;print,wherezero
wherezero+=1
;print,wherezero
n=n_elements(wherezero)
omit=string(wherezero[0])
for i=1,n-1 do begin
omit=[omit,','+strtrim(string(wherezero[i]),2)]
endfor
;help,omit
widget_control,(*pState).omit,set_value = strtrim(omit,2)
endif
widget_control,(*pState).remain,set_value = num
gmplot,event
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro GMLoadFile2d,event
widget_control,event.top,get_uvalue = pState
workDir=(*pState).workDir
    filename=dialog_pickfile(path=workDir,$
      file='BadDetParameters2d.sav',/read,filter="*.sav",/fix_filter)
if n_elements(filename) eq 0 then return
if filename eq '' then return
    restore, filename
if (n_elements(BadDet2d) eq 0) then begin
    void=dialog_message(dialog_parent=event.top,/error, $
    'The required information is not contained in this file')
return
endif
if ((tag_names(BadDet2d))[0] ne 'DETARR2D') then begin
    void=dialog_message(dialog_parent=event.top,/error, $
    'The required information is not contained in this file')
return
endif
detarr2d=BadDet2d.detarr2d
dimensions2d=(*pState).dimensions2d
if ((size(detarr2d))[1] ne dimensions2d[2]) or ((size(detarr2d))[2] ne dimensions2d[3]) then begin
    void=dialog_message(dialog_parent=event.top,/error, $
    'Incompatible array dimensions2d')
return
endif
wherezero=where(detarr2d eq 0,count)
left=n_elements(detarr2d)-count
if left eq 0 then begin
GMReset2d,event
endif
(*pState).detarr2d=detarr2d
widget_control,(*pState).omit2d,set_value = BadDet2d.omitted
widget_control,(*pState).remain2d,set_value = left
gmplot2d,event
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro GMSaveFile,event
widget_control,event.top,get_uvalue = pState
detarr1d=(*pState).detarr1d
workDir=(*pState).workDir
    filename=dialog_pickfile(path=workDir,$
      file='BadDetParameters1d.sav',/write,filter="*.sav",/fix_filter)
save,filename=filename,detarr1d
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro GMSaveFile2d,event
widget_control,event.top,get_uvalue = pState
workDir=(*pState).workDir
detarr2d=(*pState).detarr2d
widget_control,(*pState).omit2d,get_value = omitted
BadDet2d={detarr2d:detarr2d,omitted:omitted}
    filename=dialog_pickfile(path=workDir,$
      file='BadDetParameters2d.sav',/write,filter="*.sav",/fix_filter)
save,filename=filename,BadDet2d
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Options,event
widget_control,event.top,get_uvalue = pState
dimensions2d=(*pState).dimensions2d
dimensions1d=(*pState).dimensions1d
if dimensions2d[0] eq 0 then widget_control,(*pState).opt_tab,SET_TAB_CURRENT = 0
if dimensions1d[0] eq 0 then widget_control,(*pState).opt_tab,SET_TAB_CURRENT = 1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro GMSpikes,event
widget_control,event.top,get_uvalue = pState
detarr2d=(*pState).detarr2d
olddetarr2d=detarr2d
dimensions2d=(*pState).dimensions2d
SpikeFactor=(*pState).SpikeFactor
ydim=dimensions2d[2]
xdim=dimensions2d[3]
SumData2d=(*pState).SumData2d
temp=fltarr(4)
;timestart=systime(1,/seconds)
for i = 0, ydim-1 do begin
    for j = 0, xdim- 1 do begin
       if i eq 0 then temp[0]=-1
       if i eq (ydim-1) then temp[1]=-1
       if j eq 0 then temp[2]=-1
       if j eq (xdim-1) then temp[3]=-1
if temp[0] ne -1 then temp[0] = SumData2d[i-1,j]
if temp[1] ne -1 then temp[1] = SumData2d[i+1,j]
if temp[2] ne -1 then temp[2] = SumData2d[i,j-1]
if temp[3] ne -1 then temp[3] = SumData2d[i,j+1]
newtemp=temp[where(temp ne -1)]
av=(moment(newtemp))[0]
if av lt 0.0 then av = 1.0
if SumData2d[i,j] gt av*SpikeFactor then detarr2d[i,j] = 0
temp[*]=0.0
    endfor
endfor
(*pState).detarr2d=detarr2d
newomitted=where((olddetarr2d-detarr2d) eq 1, OmitTotal)
if OmitTotal ne 0 then begin
ydim=(size(SumData2d))[1]
omitted=strarr(OmitTotal)
for k = 0, OmitTotal - 1 do begin
xcoord=newomitted[k]/ydim
ycoord=newomitted[k]-xcoord*ydim
omitted[k]='{'+strtrim(string(xcoord),2)+','+strtrim(string(ycoord),2)+'}'
endfor
widget_control,(*pState).omit2d,get_value = old
omitted=[old,omitted]
widget_control,(*pState).omit2d,set_value = omitted
(*pState).detarr2d=detarr2d
;print, 'reached here'
wherezero=where(detarr2d eq 0,count)
left=n_elements(detarr2d)-count
widget_control,(*pState).remain2d,set_value = left
gmplot2d,event
endif
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro gmEvents,event
widget_control,event.top,get_uvalue = pState
uname=widget_info(event.id,/uname)
case uname of
'xaxis':    $
begin
Change_Xaxis,event
end
'GM_Reset':    $
begin
GMReset,event
end
'GM_Reset2d':    $
begin
GMReset2d,event
end
'GM_LoadPrevious':    $
begin
GMLoadPrevious,event
end
'GM_LoadPrevious2d':    $
begin
GMLoadPrevious2d,event
end
'GM_LoadFile':    $
begin
GMLoadFile,event
end
'GM_LoadFile2d':    $
begin
GMLoadFile2d,event
end
'GM_SaveFile':    $
begin
GMSaveFile,event
end
'GM_SaveFile2d':    $
begin
GMSaveFile2d,event
end
'ColourGradient':    $
begin
gmPlot2d,event
end
'2dDisplay':    $
begin
(*pState).autoscale2d=1
gmPlot2d,event
end
'opttab':    $
begin
Options,event
end
'Spikes':    $
begin
GMSpikes,event
end
else:
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function Graphical_Masking,data,data2d,twotheta,lambda,SpikeFactor,group_leader=group_leader, $
       WorkDir=WorkDir
if n_elements(group_leader) eq 0 then begin
  tlb = widget_base(/col,title = 'Graphical Masking Utility')
endif else begin
  tlb = widget_base(group_leader = group_leader, /col,/modal, $
        title = 'Graphical Masking Utility')
endelse
device, get_decomposed = old_dc
device,decomposed = 0
loadCT,5,NColors=12,Bottom=1 ,/silent

x=twotheta
sintholam=sin((!dtor*twotheta/2.0)/lambda[0])
;print,sintholam
xdet=1+findgen(n_elements(x))
xlo=min(x)
xhi=max(x)

dimensions2d=size(data2d)
;print,dimensions2d
if dimensions2d[0] eq 0 then begin
SumData2d=0
detarr2d=0
num2d=0
ydim=0
xdim=0
endif else begin
SumData2d=total(data2d,1)
;num2d=size(SumData2d,/dimension)
ydim=dimensions2d[2]
xdim=dimensions2d[3]
num2d=ydim*xdim
detarr2d=intarr(ydim,xdim)+1
endelse

dimensions1d=size(data)
if dimensions1d[0] eq 0 then begin
ylo=0.0
yhi=0.0
y=0.0
detarr1d=0
endif else begin
SumData=total(Data,1)
;x is a vector of the phi values
ylo=min(SumData)
yhi=max(SumData)
y=SumData
detarr1d=1+intarr(n_elements(y))
endelse

opt_tab=widget_tab(tlb,uname='opttab')


courier_largefont = get_font_name(/large, /courier)


BaseUpper = widget_base(opt_tab,/row,title='Conventional Detector Bank(s)')
;void=widget_label(BaseUpper,value = 'Conventional Detector Bank(s)',font=courier_largefont)
;newBase = widget_base(base,/row,/align_center)
thisbase = widget_base(BaseUpper,/col,/align_center)


Action_Types = ['Zoom',$
              'Omit']
Action = cw_bgroup(thisbase,Action_Types,/col,/exclusive,label_top='Mouse Action', $
           set_value = 1,/return_index,/no_release, /frame)

XAxis_Types = ['2 Theta',$
              'Sin(theta)/Lambda', $
              'Detector Number']
XAxis = cw_bgroup(thisbase,XAxis_Types,/col,/exclusive,label_top='X Axis', uname='xaxis', $
           set_value = 0,/return_index,/no_release, /frame)

omit = cw_field(thisbase,/col,title = 'Detectors to be omitted',/string, $
      /noedit)
remain = cw_field(thisbase,/col,value=n_elements(y),title = 'Number of Detectors Remaining',/string, $
      /noedit)

void = widget_button(thisbase,value = 'Load Previous',uname = 'GM_LoadPrevious')
void = widget_button(thisbase,value = 'Load From File',uname = 'GM_LoadFile')
void = widget_button(thisbase,value = 'Save Selection',uname = 'GM_SaveFile')
void = widget_button(thisbase,value = 'Reset',uname = 'GM_Reset')


GoldenRatio=0.5*(1.0+sqrt(5.0))
;xsize = 500 & ysize = 400
xsize = 700 & ysize = xsize/GoldenRatio
win = widget_draw(BaseUpper,xsize = xsize,ysize = ysize,/button_events, $
      event_pro = 'gmdraw')

geom = widget_info(BaseUpper,/geometry)
newysize = geom.ysize
widget_control,win,draw_ysize = newysize


;print,'winPix: ',winPix
;print,'1winVis: ',winVis


BaseMiddle = widget_base(opt_tab,/row,title = '2d Detector')
;void=widget_label(BaseMiddle,value = '2d Detector',font=courier_largefont)
BaseMiddle_Left = widget_base(BaseMiddle,/col,/align_center)


Action_Types2d = ['Zoom',$
              'Omit']
Action2d = cw_bgroup(BaseMiddle_Left,Action_Types2d,/col,/exclusive,label_top='Mouse Action', $
           set_value = 1,/return_index,/no_release, /frame)


Display2d_Fields = ['2d Contour Plot',$
              'Sum Over Ordinate']
Display2d = cw_bgroup(BaseMiddle_Left,Display2d_Fields,/col,/exclusive,label_top='Display' , $
           set_value = 0,/return_index,/no_release, /frame,uname='2dDisplay')

ColourGradient=widget_slider(BaseMiddle_Left, $
              value=1,min=1,max=100,title='2D Colour Gradient',xsize=100, $
              uname='ColourGradient',/suppress_value)

void = widget_button(BaseMiddle_Left,value = 'Remove Spikes',uname = 'Spikes')

omit2d=widget_Droplist(BaseMiddle_Left,value='Detectors to be omitted {x,y}', $
              /dynamic_resize,uname='omit2d' )


remain2d = cw_field(BaseMiddle_Left,/col,value=num2d,title = 'Number of Detectors Remaining',/string, $
      /noedit)
void = widget_button(BaseMiddle_Left,value = 'Load Previous',uname = 'GM_LoadPrevious2d')
void = widget_button(BaseMiddle_Left,value = 'Load From File',uname = 'GM_LoadFile2d')
void = widget_button(BaseMiddle_Left,value = 'Save Selection',uname = 'GM_SaveFile2d')
void = widget_button(BaseMiddle_Left,value = 'Reset',uname = 'GM_Reset2d')


;xsize2d = 500 & ysize2d = 500
xsize2d = 700 & ysize2d = xsize2d/GoldenRatio
win2d = widget_draw(BaseMiddle,xsize = xsize2d,ysize = ysize2d,/button_events, $
      event_pro = 'gmdraw2d')

geom2d = widget_info(BaseMiddle,/geometry)
newysize2d = geom2d.ysize
widget_control,win2d,draw_ysize = newysize2d

;BaseLower = widget_base(tlb,/row)

courier_hugefont = get_font_name(/huge, /courier)

void = widget_button(tlb,value = 'Cancel',event_pro = 'GMCancel',font=courier_hugefont)
void = widget_button(tlb,value = 'Accept',event_pro = 'GMAccept',font=courier_hugefont)


widget_control,tlb,/realize

widget_control,win,get_value = winVis
window,/free,/pixmap,xsize = xsize,ysize = newysize
winPix = !d.window

widget_control,win2d,get_value = winVis2d
window,/free,/pixmap,xsize = xsize2d,ysize = newysize2d
winPix2d = !d.window


state = {winVis:winVis, $
         winPix:winPix, $
         winVis2d:winVis2d, $
         winPix2d:winPix2d, $
         autoscale:1, $
         autoscale2d:1, $
         xrange:[xlo,xhi], $
         yrange:[ylo,yhi], $
         xrange2d:[0.0,xdim-1], $
         yrange2d:[0.0,ydim-1], $
         xrangedel:[0.0,1.0], $
         yrangedel:[0.0,1.0], $
         xrangedel2d:[0.0,1.0], $
         yrangedel2d:[0.0,1.0], $
         xbox:[xlo,xhi], $
         ybox:[ylo,yhi], $
         xbox2d:[0.0,0.0], $
         ybox2d:[0.0,0.0], $
         mouse:0B, $
         mouse2d:0B, $
         action:action, $
         action2d:action2d, $
         win:win, $
         win2d:win2d, $
         xlo:xlo, $
         xhi:xhi, $
         ylo:ylo, $
         yhi:yhi, $
         XAxis:XAxis, $
         x:x, $
         twotheta:twotheta, $
         sintholam:sintholam, $
         xdet:xdet, $
         y:y, $
         detarr1d:detarr1d, $
         detarr2d:detarr2d, $
         BaseUpper:BaseUpper, $
         WorkDir:WorkDir, $
         omit:omit, $
         omit2d:omit2d, $
         SumData2d:SumData2d, $
         old_dc:old_dc, $
         ColourGradient:ColourGradient, $
         Display2d:Display2d, $
         pix:1B, $
         remain2d:remain2d, $
         dimensions1d:dimensions1d, $
         dimensions2d:dimensions2d, $
         opt_tab:opt_tab, $
         SpikeFactor:SpikeFactor, $
         remain:remain}



pState = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pState

;print,'1(*pState).winPix: ',(*pState).winPix
;print,'1(*pState).winPix2d: ',(*pState).winPix2d

if dimensions1d[0] ne 0 then begin
wset,(*pState).winPix

plot,x,y,xrange = (*pState).xrange,yrange = (*pState).yrange, $
     xstyle = 1,ystyle = 1,xtitle = '2 Theta / degrees', $
     ytitle = 'Intensity', title = 'Intensity vs. 2 Theta',linestyle = 0, $
     thick = 3.0, psym=-4, symsize=1.0
wset,(*pState).winVis
device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
endif else begin
widget_control,(*pState).opt_tab,SET_TAB_CURRENT = 1
endelse

if dimensions2d[0] ne 0 then begin
wset,(*pState).winPix2d
c=Indgen(12)+1
ydim=((*pState).dimensions2d)[2]
xdim=((*pState).dimensions2d)[3]
;print,'ydim: ',ydim
;print,'xdim: ',xdim
z=fltarr(xdim,ydim)
for i = 0, xdim-1 do begin
z[i,*]=SumData2d[*,i]
endfor
contour,z,xtitle = 'Abscissa', ytitle = 'Ordinate', $
     xstyle = 1,ystyle = 1,c_colors=c,nlevels=12,/fill
wset,(*pState).winVis2d
device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix2d]
endif
xmanager,'Graphical_Masking',tlb,event_handler = 'gmEvents'

detarr1d=(*pState).detarr1d
detarr2d=(*pState).detarr2d
omitstruc={detarr1d:detarr1d,detarr2d:detarr2d}
wdelete,(*pState).winPix
wdelete,(*pState).winPix2d
device, decomposed = (*pState).old_dc
ptr_free,pState
return,omitstruc
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;