; $Id$
;
;----------------------------------------------------------------------------
; Purpose:
;   The IDLitOrbLegendItem class is the component wrapper
;   for the plot item subcomponent of the legend.
;

;----------------------------------------------------------------------------
; Purpose:
;   Initialize this component
;
function IDLitOrbLegendItem::Init, $
                               ITFONT=oItFont, $
                               ITEM=item, $
                               _REF_EXTRA=_extra

    compile_opt idl2, hidden

    ; Initialize superclass
    success = self->IDLitVisualization::Init( $
        ICON='demo', $
        IMPACTS_RANGE=0, $   ; should not affect DataSpace range
        TYPE="IDLLEGENDITEM", $
        /MANIPULATOR_TARGET,$
        _EXTRA=_extra)

    if (not success) then $
        return, 0

    ; Register the parameters we are using for data
    self->RegisterParameter, 'VISUALIZATION', DESCRIPTION='Visualizations ', $
                            /INPUT, TYPES='VISUALIZATION',/optarget

    ; Use the current zoom factor of the tool window as the
    ; initial font zoom factor.  Likewise for view zoom, and normalization
    ; factor.
    oTool = self->GetTool()
    if (OBJ_VALID(oTool) && OBJ_ISA(oTool, 'IDLitTool')) then begin
        oWin = oTool->GetCurrentWindow()
        if (OBJ_VALID(oWin)) then begin
            oWin->GetProperty, CURRENT_ZOOM=fontZoom
            oView = oWin->GetCurrentView()
            if (OBJ_VALID(oView)) then begin
                oView->GetProperty, CURRENT_ZOOM=viewZoom
                normViewDims = oView->GetViewport(UNITS=3,/VIRTUAL)
                fontNorm = MIN(normViewDims)
            endif
        endif
    endif
    self._oItFont = OBJ_NEW('IDLitFont', FONT_ZOOM=fontZoom, VIEW_ZOOM=viewZoom, $
        FONT_NORM=fontNorm)
    ; NOTE: the IDLitFont  properties will be aggregated
    ; as part of the property registration process in an upcoming call
    ; to ::_RegisterProperties.

    ; Register all properties and set property attributes
    self->IDLitOrbLegendItem::_RegisterProperties

    self._oText = OBJ_NEW('IDLgrText', $
        /ENABLE_FORMATTING, $
        RECOMPUTE_DIMENSIONS=2, $
        FONT=self._oItFont->GetFont(), $
        /KERNING, $
        /PRIVATE)
    self->Add, self._oText


;NEED TO ADD THE ORB:
;;;;;; Create an orb and add it to self
;;;;;; use /private so that this orb will not be displayed seperately in the iTool browser window
;;;;;; use /register_properties to register properties defined within the orb class
;;;;;self._orb = obj_new('orb',/register_properties,_EXTRA=etc,/private)
;;;;;self->add, self._orb, /aggregate
;;;;;
;;;;;
;;;;;;self->RegisterParameter, 'GRAPHICS OBJECT', $
;;;;;;  DESCRIPTION='A IDL Object Graphics element.', $
;;;;;;  /OPTARGET, /INPUT, TYPES='IDLGROBJECT'
;;;;;
;;;;;
;;;;;;; Register properties
;;;;;self->registerProperty,'RADIUS',/float,name='Orb radius',description='Radius of sphere in data units'
;;;;;
;;;;;self->registerProperty,'DENSITY',/float,name='Density' $
;;;;;  ,description='Density at which vertices are generated along the orb surface'
;;;;;
;;;;;self->registerProperty,'STYLE',name='Style',description='Style polygon to be drawn',enumlist=['0','1','2']
;;;;;
;;;;;self->registerProperty,'COLOR',/color,name='Color',description='Orb Color'
;;;;;
;;;;;self->registerProperty,'SPECULAR',/color,name='Specular highlight color',description='Specify the color of the specular highlights of this object'
;;;;;
;;;;;self->registerProperty,'SHADING',name='Shading',description='Type of shading to use',enumlist=['0','1']
;;;;;
;;;;;desc = 'Higher values of shininess concentrate specular highlights into smaller and brighter areas'
;;;;;self->registerProperty,'SHININESS',/float,name='Shininess',description=desc,valid_range=[0.0,128.0,5.0]
;;;;;
;;;;;self->registerProperty, 'TRANSPARENCY', /INTEGER, name='Transparency',description='Transparency of Orb',valid_range=[0,100,5]
;;;;;
;;;;;self->registerProperty,'XPOS',/float,name='X Position',description='X Coordinate of Orb'
;;;;;self->registerProperty,'YPOS',/float,name='Y Position',description='Y Coordinate of Orb'
;;;;;self->registerProperty,'ZPOS',/float,name='Z Position',description='Z Coordinate of Orb'
;;;;;;self->registerProperty,'',/,name='',description=''
;;;;;;self->registerProperty,'',/,name='',description=''
;;;;;;self->registerProperty,'',/,name='',description=''
;;;;;;self->registerProperty,'',/,name='',description=''
;;;;;;self->registerProperty,'',/,name='',description=''
;;;;;;self->registerProperty,'',/,name='',description=''
;;;;;
;;;;;
;;;;;
;;;;;
;;;;;
;;;;;
;;;;;self->aggregate, self._orb      ; aggregate the orb properties (ie those defined for its IDLgrPolygon component)
;;;;
;;;
;;
;

    return, 1 ; Success
end

;----------------------------------------------------------------------------
; Purpose:
;    Cleanup this component
;
pro IDLitOrbLegendItem::Cleanup

    compile_opt idl2, hidden

    ; These are the only objects that won't be destroyed automatically.
    OBJ_DESTROY, [self._oItFont, self._oItSymbol]

    ; Cleanup superclass
    self->IDLitVisualization::Cleanup
end

;----------------------------------------------------------------------------
pro IDLitOrbLegendItem::_RegisterProperties, $
    UPDATE_FROM_VERSION=updateFromVersion

    compile_opt idl2, hidden

    registerAll = ~KEYWORD_SET(updateFromVersion)

    if (registerAll) then begin
        self->RegisterProperty, 'ITEM_TEXT', /STRING, $
            DESCRIPTION='Item text', $
            NAME='Text'

        self->RegisterProperty, 'TEXT_COLOR', /COLOR, $
            DESCRIPTION='Item text color', $
            NAME='Text color'

        self->Aggregate, self._oItFont

        self->SetPropertyAttribute,'FONT_INDEX', $
            DESCRIPTION='Item text font'
        self->SetPropertyAttribute,'FONT_STYLE', $
            DESCRIPTION='Item text style'
        self->SetPropertyAttribute,'FONT_SIZE', $
            DESCRIPTION='Item text size'
    endif

end

;----------------------------------------------------------------------------
; IDLitOrbLegendItem::Restore
;
; Purpose:
;   This procedure method performs any cleanup work required after
;   an object of this class has been restored from a save file to
;   ensure that its state is appropriate for the current revision.
;
pro IDLitOrbLegendItem::Restore
    compile_opt idl2, hidden

    ; Call superclass restore.
    self->_IDLitVisualization::Restore

    ; Call ::Restore on each aggregated ItVis object
    ; to ensure any new properties are registered.  Also
    ; call its UpdateComponentVersion method so that this
    ; will not be attempted later
    if (OBJ_VALID(self._oItFont)) then begin
        self._oItFont->Restore
        self._oItFont->UpdateComponentVersion
    endif

    ; Register new properties.
    self->IDLitOrbLegendItem::_RegisterProperties, $
        UPDATE_FROM_VERSION=self.idlitcomponentversion

    ; ---- Required for SAVE files transitioning ----------------------------
    ;      from IDL 6.0 to 6.1 or above:
    if (self.idlitcomponentversion lt 610) then begin
        ; Use the current zoom factor of the tool window as the
        ; initial font zoom factor.
        fontZoom = 1.0
        oTool = self->GetTool()
        if (OBJ_VALID(oTool) && OBJ_ISA(oTool, 'IDLitTool')) then begin
            oWin = oTool->GetCurrentWindow()
            if (OBJ_VALID(oWin)) then $
                oWin->GetProperty, CURRENT_ZOOM=fontZoom
        endif

        if (OBJ_VALID(self._oItFont)) then $
            self._oItFont->SetProperty, FONT_ZOOM=fontZoom

        if (OBJ_VALID(self._oText)) then $
            self._oText->SetProperty, RECOMPUTE_DIMENSIONS=2
    endif
end


;----------------------------------------------------------------------------
pro IDLitOrbLegendItem::Add, oTargets, $
    _EXTRA=_extra

    compile_opt idl2, hidden

    ; We allow a legend item to be a target for a legend item paste
    ; If so, we need to add it to the parent legend instead of ourself.
    if (OBJ_ISA(oTargets[0], 'IDLitVisLegendPlotItem') || $
        OBJ_ISA(oTargets[0], 'IDLitVisLegendSurfaceItem') || $
        OBJ_ISA(oTargets[0], 'IDLitVisLegendContourItem')) then begin
        self->GetProperty, PARENT=oLegend
        oLegend->Add, oTargets, _EXTRA=_extra
    endif else self->IDLitVisualization::Add, oTargets, _EXTRA=_extra

end


;----------------------------------------------------------------------------
pro IDLitOrbLegendItem::BuildItem

    compile_opt idl2, hidden

    self->GetProperty, PARENT=oParent
    while (~OBJ_ISA(oParent, 'IDLitOrbLegend')) do begin
        oParent[0]->IDLitComponent::GetProperty, _PARENT=oParent
        if ~OBJ_VALID(oParent) then $
            return
    endwhile

    oParent->GetProperty, $
        FONT_INDEX=fontIndex, $
        FONT_SIZE=fontSize, $
        FONT_STYLE=fontStyle, $
        TEXT_COLOR=textColor, $
        SAMPLE_WIDTH=sampleWidth, $
        HORIZONTAL_SPACING=horizSpacing, $
        VERTICAL_SPACING=vertSpacing

    ; Set these properties directly on our member data, to avoid
    ; going thru our own SetProperty and possibly causing
    ; a recomputelayout.
    self._oItFont->SetProperty, $
        FONT_INDEX=fontIndex, $
        FONT_SIZE=fontSize, $
        FONT_STYLE=fontStyle

    self._oText->SetProperty, $
        COLOR=textColor

    self._sampleWidth = sampleWidth
    self._horizSpacing = horizSpacing
    self._vertSpacing = vertSpacing

end


;----------------------------------------------------------------------------
; IIDLProperty Interface
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;+
; METHODNAME:
;      IDLitOrbLegendItem::GetProperty
;
; PURPOSE:
;      This procedure method retrieves the
;      value of a property or group of properties.
;
; CALLING SEQUENCE:
;      Obj->[IDLitOrbLegendItem::]GetProperty
;
; INPUTS:
;      There are no inputs for this method.
;
; KEYWORD PARAMETERS:
;      Any keyword to IDLitOrbLegendItem::Init followed by the word "Get"
;      can be retrieved using IDLitOrbLegendItem::GetProperty.  In addition
;      the following keywords are available:
;
pro IDLitOrbLegendItem::GetProperty, $
    TEXT_COLOR=textColor, $
    ITEM_TEXT=itemText, $
    ORIENTATION=orientation, $
    ITEM_RANGE=itemRange, $
    VIS_TARGET=visTarget, $
    _REF_EXTRA=_extra

    compile_opt idl2, hidden

    ; Get my properties
    if (ARG_PRESENT(itemText)) then $
        self._oText->GetProperty, STRINGS=itemText

    if (ARG_PRESENT(textColor)) then $
        self._oText->GetProperty, COLOR=textColor

    if (ARG_PRESENT(itemRange)) then begin
        oTool = self->GetTool()
        oWindow = oTool->GetCurrentWindow()
        if (~OBJ_VALID(oWindow)) then $
            return
        textDimensions = oWindow->GetTextDimensions(self._oText)
        itemRange = [self._sampleWidth+self._horizSpacing+textDimensions[0], $
                 textDimensions[1]]
    endif

    if (ARG_PRESENT(visTarget)) then begin
        visTarget = Obj_Valid(self._oVisTarget) ? $
            self._oVisTarget->GetFullIdentifier() : ''
    endif

    ; get superclass properties
    if (N_ELEMENTS(_extra) gt 0) then $
        self->IDLitVisualization::GetProperty, _EXTRA=_extra

end

;----------------------------------------------------------------------------
;+
; METHODNAME:
;      IDLitOrbLegendItem::SetProperty
;
; PURPOSE:
;      This procedure method sets the value
;      of a property or group of properties.
;
; CALLING SEQUENCE:
;      Obj->[IDLitOrbLegendItem::]SetProperty
;
; INPUTS:
;      There are no inputs for this method.
;
; KEYWORD PARAMETERS:
;      Any keyword to IDLitOrbLegendItem::Init followed by the word "Set"
;      can be set using IDLitOrbLegendItem::SetProperty.
;-
pro IDLitOrbLegendItem::SetProperty,  $
    TEXT_COLOR=textColor, $
    HIDE=hide, $
    HORIZONTAL_SPACING=horizSpacing, $
    ITEM_TEXT=itemText, $
    SAMPLE_WIDTH=sampleWidth, $
    ORIENTATION=orientation, $
    FONT_INDEX=fontIndex, $
    FONT_NORM=fontNorm, $
    FONT_STYLE=fontStyle, $
    FONT_SIZE=fontSize, $
    FONT_ZOOM=fontZoom, $
    VIEW_ZOOM=viewZoom, $
    VIS_TARGET=visTarget, $
    _EXTRA=_extra

    compile_opt idl2, hidden

    bRecompLayout = 0b

    if (N_ELEMENTS(itemText) gt 0) then begin
        self._oText->SetProperty, STRINGS=itemText
        bRecompLayout = 1b
    endif

    if (N_ELEMENTS(textColor) gt 0) then begin
        self._oText->SetProperty, COLOR=textColor
    endif

    if (N_ELEMENTS(hide) gt 0) then begin
        self->IDLitVisualization::SetProperty, HIDE=hide
        ; no need to recompute our layout, but legend must recompute
        self->GetProperty, PARENT=oLegend
        if (OBJ_VALID(oLegend)) then $
            oLegend->RecomputeLayout
    endif

    if (N_ELEMENTS(horizSpacing) gt 0) then begin
        self._horizSpacing = horizSpacing
        bRecompLayout = 1b
    endif

    if (N_ELEMENTS(sampleWidth) gt 0) then begin
        self._sampleWidth = sampleWidth
        bRecompLayout = 1b
    endif

    if (N_ELEMENTS(fontIndex) gt 0) then begin
        self._oItFont->SetProperty, FONT_INDEX=fontIndex
        bRecompLayout = 1b
    endif
    if (N_ELEMENTS(fontNorm) gt 0) then begin
        self._oItFont->SetProperty, FONT_NORM=fontNorm
        bRecompLayout = 1b
    endif
    if (N_ELEMENTS(fontStyle) gt 0) then begin
        self._oItFont->SetProperty, FONT_STYLE=fontStyle
        bRecompLayout = 1b
    endif
    if (N_ELEMENTS(fontSize) gt 0) then begin
        self._oItFont->SetProperty, FONT_SIZE=fontSize
        bRecompLayout = 1b
    endif
    if (N_ELEMENTS(fontZoom) gt 0) then begin
        self._oItFont->SetProperty, FONT_ZOOM=fontZoom
        bRecompLayout = 1b
    endif
    if (N_ELEMENTS(viewZoom) gt 0) then begin
        self._oItFont->SetProperty, VIEW_ZOOM=viewZoom
        bRecompLayout = 1b
    endif

    if (N_ELEMENTS(visTarget) gt 0) then begin
        oTool = self->GetTool()
        if (Obj_Valid(oTool)) then begin
            oVis = oTool->GetByIdentifier(visTarget)
            if (Obj_Valid(oVis)) then begin
                self._oVisTarget = oVis
                self->BuildItem
            endif
        endif
    endif

    ; Set superclass properties
    if (N_ELEMENTS(orientation) || N_ELEMENTS(_extra)) then begin
        self->IDLitVisualization::SetProperty, DIRECTION=orientation, $
            _EXTRA=_extra
    endif

    if (bRecompLayout) then $
        self->RecomputeLayout
end

;---------------------------------------------------------------------------
; IDLitOrbLegend::OnNotify
;
;
;  strItem - The item being observed
;
;  strMessage - What happend. For properties this would be
;               "SETPROPERTY"
;
;  strUser    - Message related data. For SETPROPERTY, this is the
;               property that changed.
;
pro IDLitOrbLegendItem::OnNotify, strItem, StrMessage, strUser

   compile_opt idl2, hidden

    case strMessage of

        ; Setting our hide property will also call a RecomputeLayout.
        'DELETE': begin
            self->GetProperty, PARENT=oLegend
            if (OBJ_VALID(oLegend)) then begin
                oLegend->Remove, self
                oLegend->RecomputeLayout
            endif
            end

        'UNDELETE': begin
            self._oVisTarget->GetProperty, HIDE=hide
            self->SetProperty, HIDE=hide
            end

        else: ; ignore unknown messages
    endcase

end

;---------------------------------------------------------------------------
function IDLitOrbLegendItem::GetVis

    compile_opt idl2, hidden

    return, self._oVisTarget
end


;----------------------------------------------------------------------------
; Object Definition
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
;+
; IDLitOrbLegendItem__Define
;
; PURPOSE:
;    Defines the object structure for an IDLitOrbLegendItem object.
;
;-
pro IDLitOrbLegendItem__Define

    compile_opt idl2, hidden

    struct = { IDLitOrbLegendItem, $
        inherits IDLitVisualization, $
        inherits IDLitPropertyBag, $
        _oVisTarget: OBJ_NEW(), $
        _oOrb: obj_new(), $
        _oText: OBJ_NEW(), $
        _oItFont: OBJ_NEW(), $
        _oItSymbol: OBJ_NEW(), $
        _textInitted: 0L, $
        _textDescent: 0.0d, $
        _sampleWidth: 0.0, $
        _horizSpacing: 0.0, $
        _vertSpacing: 0.0 $
    }
end
