


;-------------------------------------------------------------------------------
; Purpose
;   Get method
;===============================================================================
pro DenProVisMol::cleanup
compile_opt idl2

obj_destroy, self._orb

self->IDLitVisualization::cleanup

end


;-------------------------------------------------------------------------------
; Purpose
;   Get method
;===============================================================================
pro DenProVisMol::setProperty, parent=parent $
    ,transparency=transparency $
    ,xpos=xpos $
    ,ypos=ypos $
    ,zpos=zpos $
    ,_EXTRA=etc
compile_opt idl2

;; Parent requires careful handling since any IDLitComponent should
;; only have 1 parent
if (n_elements(parent) gt 0) then $
    self->IDLgrModel::setProperty, parent=parent

if (n_elements(transparency) gt 0) then $ ; convert transparency to alpha_channel
    self._orb->setProperty, alpha_channel=0 > ((100.0 - transparency)/100) < 1
     
if (n_elements(xpos) gt 0) then begin
    self._orb->getProperty, pos=pos
    pos[0] = xpos
    self._orb->setProperty, pos=pos
endif
if (n_elements(ypos) gt 0) then begin
    self._orb->getProperty, pos=pos
    pos[1] = ypos
    self._orb->setProperty, pos=pos
endif
if (n_elements(zpos) gt 0) then begin
    self._orb->getProperty, pos=pos
    pos[2] = zpos
    self._orb->setProperty, pos=pos
endif
            
;; Call the set method on the base class and orb component
if (n_elements(etc) gt 0) then begin
    self._orb->setProperty, _EXTRA=etc
    self->IDLitVisualization::setProperty, _EXTRA=etc
endif


end


;-------------------------------------------------------------------------------
; Purpose
;   Get method
;===============================================================================
pro DenProVisMol::getProperty, transparency=transparency $
    ,xpos=xpos $
    ,ypos=ypos $
    ,zpos=zpos $
    ,_REF_EXTRA=etc
compile_opt idl2


if arg_present(transparency) then begin
    self._orb->getProperty, alpha_channel=alpha
    transparency = 0 > fix(100 - alpha * 100) < 100
endif

if (arg_present(xpos) || arg_present(ypos) || arg_present(zpos)) then begin
    self._orb->getProperty, pos=pos
    xpos = pos[0]
    ypos = pos[1]
    zpos = pos[2]
endif

;; Call the get method on the base class and orb component
if (n_elements(etc) gt 0) then begin
    self._orb->getproperty, _EXTRA=etc
    self->IDLitVisualization::getProperty, _EXTRA=etc
endif

end



;-------------------------------------------------------------------------------
; DenProVisMol::Restore
;
; Purpose:
;   This procedure method performs any cleanup work required after
;   an object of this class has been restored from a save file to
;   ensure that its state is appropriate for the current revision.
;
;===============================================================================
pro DenProVisMol::Restore
compile_opt idl2

;; Call superclass restore.
self->_IDLitVisualization::Restore

;; Call ::GetProperty on each aggregated graphic object
;; to force its internal restore process to be called, thereby
;; ensuring any new properties are registered.
if (obj_valid(self._orb)) then self._orb->GetProperty

;; Register new properties.
self->DenProVisMol::_RegisterProperties, update_from_version=self.idlitcomponentversion

end


;===============================================================================
function DenProVisMol::init, name=name, description=desc, _REF_EXTRA=etc
compile_opt idl2


;print,'DenProVisMol::init'

if (~keyword_set(name)) then name = 'Orb'
if (~keyword_set(desc)) then desc = 'Spherical Graphic Atom'

;; Initialize superclass
if (not self->IDLitVisualization::Init(name=name $
                                       ,type='DENPROMOL' $
                                       ,icon='demo' $
                                       ,description=desc $
                                       ,/MANIPULATOR_TARGET $
                                       ,_EXTRA=etc)) $
  then return, 0

; Create an orb and add it to self
; use /private so that this orb will not be displayed seperately in the iTool browser window
; use /register_properties to register properties defined within the orb class




self._orb = obj_new('orb',/register_properties,_EXTRA=etc,/private)
self->add, self._orb, /aggregate

self._ballAndStick = obj_new('idlgrmodel',/register_properties,_EXTRA=etc,/private,name='BallAndStickModel',hide=0)
self->add, self._ballAndStick, /aggregate

self._spaceFill = obj_new('idlgrmodel',/register_properties,_EXTRA=etc,/private,name='SpaceFillModel',hide=1)
self->add, self._spaceFill, /aggregate

self._wireFrame = obj_new('idlgrmodel',/register_properties,_EXTRA=etc,/private,name='WireFrameModel',hide=1)
self->add, self._wireFrame, /aggregate



;- THIS CLASS IS AN IDLgrModel.  
;- IT CAN CONTAIN AS MANY ORBS AS I WANT.
;- IT CAN ALSO CONTAIN ALL THE BONDS THAT I WANT.  
;- I WANT TO CONTROL THE PROPERTIES OF EACH INDIVIDUAL ORB AND EACH BOND.
;- HOW TO I ADD ALL THE ORBS AND BONDS TO THIS AND STILL CONTROL THE PROPERTIES OF
;  EACH INDIVIDUAL ITEM?????
;

;EACH ORB MUST HAVE radius, x,y,zPOS AND color
;
;IF THESE ARE SET BY THE USER THEY MUST BE PUSHED DOWN TO THE GROUP MEMBERS.
;
;PERHAPS THERE IS A WAY TO LET THE USER MARK AN INDIVIDUAL ATOM TO BE DIFFERENT.
;
;EACH BOND MUST HAVE TWO POSITIONS AND THE 
;
;NEED spacefill, wireframe, ball and stick -----> INITIALLY FILL MODEL WITH THESE AND DON'T ALLOW CONTROL YET.
;
;
;




;self->RegisterParameter, 'GRAPHICS OBJECT', $
;  DESCRIPTION='A IDL Object Graphics element.', $
;  /OPTARGET, /INPUT, TYPES='IDLGROBJECT'


;;; Register properties
;self->registerProperty,'RADIUS',/float,name='Orb radius',description='Radius of sphere in data units'
;
;self->registerProperty,'DENSITY',/float,name='Density' $
;  ,description='Density at which vertices are generated along the orb surface'
;
;self->registerProperty,'STYLE',name='Style',description='Style polygon to be drawn',enumlist=['0','1','2']
;
;self->registerProperty,'COLOR',/color,name='Color',description='Orb Color'
;
;self->registerProperty,'SPECULAR',/color,name='Specular highlight color',description='Specify the color of the specular highlights of this object'
;
;self->registerProperty,'SHADING',name='Shading',description='Type of shading to use',enumlist=['0','1']
;
;desc = 'Higher values of shininess concentrate specular highlights into smaller and brighter areas'
;self->registerProperty,'SHININESS',/float,name='Shininess',description=desc,valid_range=[0.0,128.0,5.0]
;
;self->registerProperty, 'TRANSPARENCY', /INTEGER, name='Transparency',description='Transparency of Orb',valid_range=[0,100,5]
;
;self->registerProperty,'XPOS',/float,name='X Position',description='X Coordinate of Orb'
;self->registerProperty,'YPOS',/float,name='Y Position',description='Y Coordinate of Orb'
;self->registerProperty,'ZPOS',/float,name='Z Position',description='Z Coordinate of Orb'
;;self->registerProperty,'',/,name='',description=''
;;self->registerProperty,'',/,name='',description=''
;;self->registerProperty,'',/,name='',description=''
;;self->registerProperty,'',/,name='',description=''
;;self->registerProperty,'',/,name='',description=''
;;self->registerProperty,'',/,name='',description=''






self->aggregate, self._orb      ; aggregate the orb properties (ie those defined for its IDLgrPolygon component)


return, 1                       ; Success

end


;===============================================================================
pro DenProVisMol__Define
compile_opt idl2

struct = {DenProVisMol,           $
          inherits IDLitVisualization $ ; Superclass: _IDLitVisualization, IDLgrModel
          ,_orb:obj_new() $
          ,_ballAndStick:obj_new() $
          ,_spaceFill:obj_new() $
          ,_wireframe:obj_new() $
         }

end
