; $Id$
;
;Reads a grd file and returns the information via arguments
;and keywords.
;
;Return value is 1 for success, 0 for failure.

function threeDenPro_readgrid,abc,abg,vol,nx,ny,nz,fn=fn,x=x,y=y,z=z,$
                              datapath=datapath
;pro gridder_open,pstate,vol,fn=fn
;void = dialog_message('Starting threeDenPro_readgrid')
  if n_elements(datapath) eq 0 then $
    datapath = 'C:\Documents and Settings\kneller\Desktop\GRID\GRID\Data\'


	  ;fn = 'C:\Documents and Settings\kneller\Desktop\GRID\4larrySpecial.grd'
	  ;fn = 'C:\Documents and Settings\kneller\Desktop\GRID\GRID\Data\4larrySpecial.grd'
    if n_elements(fn) eq 0 or file_test(fn) eq 0 then begin
        fn = dialog_pickfile(filter='*.grd',title='PLEASE SELECT A .grd FILE:',$
                              path=datapath)
    endif
    
    print,fn

    if fn eq '' then begin
    	return,0
	  endif else begin

      if fn ne '' then datapath = file_dirname(fn)
	    openr,lun,fn,/get_lun

	    line = ''
	    readf,lun,line
	    print,line

	    readf,lun,line
	    segs = strsplit(line,/extract)

	    abc = double(segs[0:2])
	    abg = double(segs[3:5])

	    readf,lun,line
	    segs = strsplit(line,/extract)

      ;091608
      ;THIS APPEARS TO BE THE CORRECT READ - AND THE FOR LOOPS ARE SUGGESTIVE OF HOW THE
      ;PERSONE WHO WROTE THE FILE WOULD HAVE PROCEEDED.
      nx = fix(segs[0])      
      ny = fix(segs[1])      
      nz = fix(segs[2])
      vol = fltarr(nx,ny,nz)
      temp = fltarr(nz)
      for i = 0,nx-1 do begin
        for j = 0,ny-1 do begin
          readf,lun,temp
          vol[i,j,*] = temp
        endfor;j
      endfor;i

	    free_lun,lun

		;THIS CALCULATION SHOULD BE DONE FOR THE VERTICES OF THE POLYGONS
;		coords = readgrid_convert_coords(xyz,abc,abg)

		return,1
	endelse
end;threeDenPro_readgrid

