; $Id$
;
;Converts one XYZ point in crystal coordinates
;into the Cartesian values for those coordinates.
;
;The return value is the three-element array
;of the new coordinates.
;
function threeDenPro_convertCoords,xyz,abc,abg


	;BORROWED CALCULATIONS FROM readcifspecial.pro
	;CONVERTING abc,abg, xyz TO CRYSTALLOGRAPHIC COORDINATES.

	;CALCULATE ANGLES IN RADIANS
	alpha = !dtor*abg[0]
	beta  = !dtor*abg[1]
	gamma = !dtor*abg[2]
	delta = acos(sqrt( (cos(beta) + cos(alpha)*cos(gamma))^2 + (cos(alpha)*sin(gamma))^2))

	;CALCULATE PRIMITIVE LATTICE COMPONENTS
	a1 = [abc[0],0,0]
	a2 = abc[1]*[cos(gamma),sin(gamma),0]
	a3 = abc[2]*[cos(beta)+cos(alpha)*cos(gamma),cos(alpha)*sin(gamma),sin(delta)]


;	sz = size(vol)
;	print,'sz=',sz
;	nx = sz[1]
;	ny = sz[2]
;	nz = sz[3]
;
;	ux = (dindgen(nx)/double(nx-1.))##(1+dblarr(3))
;	uy = (dindgen(nx)/double(nx-1.))##(1+dblarr(3))
;	uz = (dindgen(nx)/double(nx-1.))##(1+dblarr(3))
;print,xyz,a1,a2,a3

	result = xyz[0]*a1 + xyz[1]*a2 + xyz[2]*a3

	;help,result
;	help,ux
;	print,ux
;	coords1 = dindgen(3,nx)
;	coords2 = dindgen(3,ny)
;	coords3 = dindgen(3,nz)
;	for i=0,nx-1 do begin
;		coords1[*,i] = a1*double(i)/double(nx-1.);a1*ux[*,i]
;	endfor;i
;	for i=0,ny-1 do begin
;		coords2[*,i] = a2*double(i)/double(ny-1.);a2*uy[*,i]
;	endfor;i
;	for i=0,nz-1 do begin
;		coords3[*,i] = a3*double(i)/double(nz-1.);a3*uz[*,i]
;	endfor;i
;
;	;CREATE COORDINATES AT EACH POINT IN THE DATA VOLUME
;	coords = dindgen(3,nx,ny,nz)
;
;
;
;	help,coords1,coords2,coords3


	return,result


end;threeDenPro_convertCoords
