


pro create3DenProMolecule,oTool
compile_opt idl2



;Create3DenProOrbs,oTool

;ADD ORB OPERATION ID 
addOpID = 'Operations/Insert/Add Orb'


;GET THE Add Orb DESCRIPTOR OBJECT
opDescOrb = oTool->getByIdentifier(addOpID)
if (~obj_valid(opDescOrb)) then return


;GET THE Add Orb OBJECT ---- THIS WILL BE USED TO 
oAddOpOrb = opDescOrb->getObjectInstance()
if (~obj_valid(oAddOpOrb)) then return

;GET THE CURRENT SETTING OF THE show_execution VARIABLE
;showUiSetting WILL HOLD THE CURRENT STATE
oAddOpOrb->getProperty, show_execution_ui=showUiSetting

;SET THE show_execution VARIABLE TO 0 SO BNO DIALOG IS DISPLAYED
oAddOpOrb->setProperty, show_execution_ui=0 ; switch off ui - no user interation required





; Create a sphere
oAddOpOrb->setProperty, radius=0.16, color=[255,0,0],label='Na',xpos=-0.3,ypos=0.3,zpos=0.1

;THE NEXT LINE CREATES THE SPHERE AND RETURNS ITS iTools IDENTIFIER IN THE DATA HIERARCHY
void = oAddOpOrb->doAction(oTool,identifier=id)

;GET THE ACTUAL IDLitVisOrb(?) OBJECT
sodium = oTool->getByIdentifier(id)

;SET UP THE GROUPING IN THE VISUALIZATION HIERARCHY
;CREATE AN IDLitVisGroup THAT CAN BE AFFECTED BY A MANIPULATOR
;
;
;THERE IS A PROBLEM HERE:
;1) IF I TURN ON manipulator_target THEN THE MOLECULE IS ROTATED SEPARATELY
;   FROM THE AXES AND OTHER OBJECTS IN THE SCENE
;2) IF I TURN OFF manipulator_target THEN I CAN'T CONTROL THE 
;   OTHER PROPERIES I WANT TO CONTROL, SUCH AS COLOR.
;3) SO I HAVE TO TURN OFF SOME OF THE MANIPULATORS WHILE STILL PROVIDING ACCESS
;   TO THE PRPOERTY SHEET.
;  
;  MANIPULATORS MUST BE REGISTERED IN op_addorbs__define.pro
;
;


;IDLitVisGroup is a subclass of IDLitVisualization 
oGroupMolecule = obj_new('IDLitvisGroup',name='Molecule',/manipulator_target)
oGroupAtoms = obj_new('IDLitvisGroup',name='MoleculeAtoms',/manipulator_target)
oGroupBonds = obj_new('IDLitvisGroup',name='MoleculeBonds',/manipulator_target)
oGroupUC = obj_new('IDLitvisGroup',name='MoleculeUC',/manipulator_target)


;FIRST ADD THE GROUP TO THE VISUALIZATION HIERARCHY
;NEED TO ACQUIRE THE parent OBJECT:
sodium->getProperty,_parent=oParent

oparent->getproperty,_parent=parentsparent
help,parentsparent
oParent->add, oGroupMolecule

oGroupMolecule->add, oGroupAtoms
oGroupMolecule->add, oGroupBonds
oParent->add, oGroupUC
oParent->remove,sodium  ;REMOVE THIS DUMMY ATOM SINCE WE ARE ONLY INTERESTED  
                        ;IN ACQUIRING ITS PARENT


;NOW READ IN THE DATA FROM A CIF FILE
print,threeDenPro_readCIF(atoms,x,y,z,$
                        list=list,bonds=bonds,$
                        ucboxpoints=ucboxpoints,$
                        abc=abc,abg=abg,$
                        datapath=datapath)

help,atoms
print,atoms[0],atoms[n_elements(atoms)-1]



;;REMOVE THE ATOMS FROM THE HIERARCHY
;oParent->remove, [oxy,H1,H2]
;
;;PLACE THE ATOMS IN THE GROUP IN THE HIERARCHY
;oGroup->add, Oxy ; bug in IDLitvisGroup::Add prevents adding a vector of objects
;oGroup->add, H1
;oGroup->add, H2

;print,'Atoms='
;print,list[*]._ATOM_SITE_TYPE_SYMBOL
;SEE 3denprro_createomAtomBalls.pro

;for i=0,n_elements(list)-1 do begin
for i=0,5 do begin
  ;oAddOpOrb->setProperty, radius=0.01, color=[0,0,255],label='dum',xpos=x[i],ypos=y[i],zpos=z[i]
  oAddOpOrb->setProperty,xpos=list[i].x,ypos=list[i].y,zpos=list[i].z,$
                      color = list[i].color,radius=list[i].radius,label=list[i]._ATOM_SITE_TYPE_SYMBOL;'balls'  
  void = oAddOpOrb->doAction(oTool,identifier=id)
  dum = oTool->getByIdentifier(id)
  oParent->remove,dum
  oGroupAtoms->add,dum
endfor;i


;WHAT DOES THIS DO?  UPDATE THE SELECTION TREE????  UPDATE THE VISUALIZATION????
;
;oGroup->UpdateSelectionVisual

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;oGroup2->UpdateSelectionVisual



;NOW ALL OF THE ITEMS CAN BE ADDED AT WILL:
;VOLUME DATA (WHICH WILL NEED TO HAVE ITS ISOSURFACE VERTICES SKEWED)
;BONDS  (NEEDS opp_addbonds__define.pro
;UNIT CELL OUTLINE ()




;RESTORE THE ORIGINAL show_execution SETTING
oAddOpOrb->setProperty, show_execution_ui=showUiSetting ; revert to original setting


;__________________________________________________________________________________
;
; NOW ADD A "Bond"
;
;__________________________________________________________________________________

addOpID = 'Operations/Insert/Add Bond'
opDescBond = oTool->getByIdentifier(addOpID)
if (~obj_valid(opDescBond)) then begin
  print,'opDesc = oTool->getByIdentifier("Operations/Insert/Add Bond"): not found!'
  return
endif  
;print,'Got Add Bond Descriptor'  
oAddOpBond = opDescBond->getObjectInstance()
if (~obj_valid(oAddOpBond)) then begin
  print,'oAddOpBond = opDescBond->getObjectInstance(): Operation not found!'
  return
endif  
;print,'Got Add Bond Operation'  
  
oAddOpBond->getProperty, show_execution_ui=showUiSetting
oAddOpBond->setProperty, show_execution_ui=0 ; switch off ui - no user interation required




;NOW UPDATE THIS SO THAT I ADD ALL THE BONDS:
;
;  I SUSPECT THAT I WILL WANT TO DEFINE A FILE READER FOR THIS PROCESS 
;  IN A SIMILAR MANNER TO ADDING ATOMS OR BONDS:
;
;CIF READER:
;
;  1) Create op_readCIF__define.pro     (analogous to op_addbonds__define.pro)
;  2) Create IDLit<Read>CIF__define.pro (analogous to IDLitVisBond__define.pro)  
;  3) Create denproCIFData__define.pro  (analogous to denprobond__define.pro or orb__define.pro)
;  4) Register this reader in denprotool__define.pro
;
;GRD READER:
;
;  1) Create op_readGRD__define.pro     (analogous to op_addbonds__define.pro)
;  2) Create IDLit<Read>GRD__define.pro (analogous to IDLitVisBond__define.pro)  
;  3) Create denproGRDData__define.pro  (analogous to denprobond__define.pro or orb__define.pro)
;  4) Register this reader in denprotool__define.pro
;
;



;NOTE: ONE OPERATION OBJECT IS USED TO ADD ALL OF THE BOND VISUALIZATIONS (ALSO TRUE )
; Create a "Bond"
print,'Adding a "bond":'
help,bonds
  help,oAddOpBond
;  oAddOpBond->setProperty, radius=1.0, color=[0,0,255],label='Sticks',$
;                       xpos=0,ypos=0,zpos=0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    if n_elements(bonds) gt 0 then begin

        ;sticks = objarr(n_elements(bonds))
    
        ;for i = 0,n_elements(bonds)-1 do begin
        for i = 0,10 do begin
 ;   print,'_________________________________________________________________________'
 ;   print,'ADDING BONDS: i=',i
          ;FIRST GET XBEGIN AND XEND
          whbeg = -1
          for j=0,n_elements(list)-1 do begin
            ;VERIFY SAME LENGTHS.  IF LENGTHS SAME THEN DO stregex TEST.
            if strlen(list[j]._atom_site_label) eq strlen(bonds[i]._geom_bond_atom_site_label_1) then begin
              if stregex(strlowcase(list[j]._atom_site_label),$
                         strlowcase(bonds[i]._geom_bond_atom_site_label_1),$
                         /boolean,/fold_case) gt 0 then begin
                  whbeg = j
                  break
              endif
            endif
          endfor;j
    
          whend = -1
          for j=0,n_elements(list)-1 do begin
            ;VERIFY SAME LENGTHS.  IF LENGTHS SAME THEN DO stregex TEST.
            if strlen(list[j]._atom_site_label) eq strlen(bonds[i]._geom_bond_atom_site_label_2) then begin
              if stregex(list[j]._atom_site_label,$
                         bonds[i]._geom_bond_atom_site_label_2,$
                         /boolean,/fold_case) gt 0 then begin
                  whend = j
                  break
              endif
            endif
          endfor;j

    if whbeg ne -1 and whend ne -1 then begin 
                      ;print,'whbeg,whend=',whbeg,whend
                            xbond = [list[whbeg].x,list[whend].x]
                            ybond = [list[whbeg].y,list[whend].y]
                            zbond = [list[whbeg].z,list[whend].z]
                      
                            calclen = sqrt((xbond[0]-xbond[1])^2 + (ybond[0]-ybond[1])^2 + (zbond[0]-zbond[1])^2)
                            diff = calclen - bonds[i]._geom_bond_distance
                            print,'create3DenProMolecule whbeg,whend,diff=',whbeg,whend,diff
                      
                            ;HIDE BONDS THAT CROSS THE UNIT CELL BORDER
                            if abs(diff) lt 0.1 then begin  ;hide = 0 else hide = 1  (hide mechanism was for obj graphics version)
                      
                              
                      
                              ; make the sticks
                              bondcolor = [10,10,10]
                  ;            sticks[i] = obj_new('IDLgrPolyline', xbond,ybond,zbond, color=bondcolor, thick=6.5,hide=hide,name='sticks')
                  ;            if hide eq 1 then sticks[i]->setproperty,name='hiddensticks'
                  ;            sticksmodel->add,sticks[i]
                              bondcolor[0] = i mod 255
                              bondcolor[1] = 10
                              bondcolor[2] = 10
                              
                                  oAddOpBond->setProperty, radius=0.2, color=bondcolor,$;[0,0,255],
                                                           label='Sticks',$
                                                           xpos=xbond[0],ypos=ybond[0],zpos=zbond[0],$
                                                           xbeg=xbond[0],ybeg=ybond[0],zbeg=zbond[0],$
                                                           xend=xbond[1],yend=ybond[1],zend=zbond[1]
                                
                                
                                  void = oAddOpBond->doAction(oTool,identifier=id)
                                
                                
                                  dum = oTool->getByIdentifier(id)
                                  oParent->remove,dum
                                  oGroupBonds->add,dum
                              
                            endif;abs(diff)  
           endif;whbeg/whend
    
        endfor;i
        
        
       
        
        
    endif;n_elements(bonds)



;READ IN A GRID FILE HERE, ALTHOUGH THIS WILL EVENTUALLY BE DONE IN A READ_GRID FILE READER
;AT THIS STAGE THE GRD FILE IS ONLY FOR PRACTICE AND TO GET REASONABLE NUMBERS FOR nx,ny,nz

        ;NOW ADD THE UNIT CELL OUTLINE USING op_addunitcelloutline
        print,'NOW ADD THE UNIT CELL OUTLINE USING op_addunitcelloutline'
        
addOpID = 'Operations/Insert/Add Unit Cell Outline'
opDescUC = oTool->getByIdentifier(addOpID)
if (~obj_valid(opDescUC)) then begin
  print,'opDescUC = oTool->getByIdentifier("Operations/Insert/Add Unit Cell Outline"): not found!'
  return
endif  
;print,'Got Add Unit Cell Outline Descriptor'  
oAddOpUC = opDescUC->getObjectInstance()
if (~obj_valid(oAddOpUC)) then begin
  print,'oAddOpUC = opDescUC->getObjectInstance(): Operation not found!'
  return
endif  
;print,'Got Add Bond Operation'  
  
oAddOpUC->getProperty, show_execution_ui=showUISetting
print,'showUiSetting=',showUISetting
oAddOpUC->setProperty, show_execution_ui=0 ; switch off ui - no user interation required



    print,abc,abg

    ;duh = ThreeDenPro_createVolVertices(abc,abg,nx,ny,nz,corners=corners)
    duh = ThreeDenPro_createVolVertices(abc,abg,128,64,64,corners=corners)
help,corners
    colors = bytarr(3,3)
    colors[*,0] = [240,0,0]
    colors[*,1] = [0,240,0]
    colors[*,2] = [0,0,240]

;    ;'X' DIRECTION:
    oAddOpUC->setProperty, radius=0.1, color=colors[*,0],$
                             label='UCX',$
                             xpos=corners[0,0],ypos=corners[1,0],zpos=corners[2,0],$
                             xbeg=corners[0,0],ybeg=corners[1,0],zbeg=corners[2,0],$
                             xend=corners[0,1],yend=corners[1,1],zend=corners[2,1]
    void = oAddOpUC->doAction(oTool,identifier=id)
    dum = oTool->getByIdentifier(id)
    oParent->remove,dum
    oGroupUC->add,dum

    oAddOpUC->setProperty, radius=0.1, color=colors[*,0],$
                             label='UCX',$
                             xpos=corners[0,3],ypos=corners[1,3],zpos=corners[2,3],$
                             xbeg=corners[0,3],ybeg=corners[1,3],zbeg=corners[2,3],$
                             xend=corners[0,2],yend=corners[1,2],zend=corners[2,2]
    void = oAddOpUC->doAction(oTool,identifier=id)
    dum = oTool->getByIdentifier(id)
    oParent->remove,dum
    oGroupUC->add,dum

    oAddOpUC->setProperty, radius=0.1, color=colors[*,0],$
                             label='UCX',$
                             xpos=corners[0,4],ypos=corners[1,4],zpos=corners[2,4],$
                             xbeg=corners[0,4],ybeg=corners[1,4],zbeg=corners[2,4],$
                             xend=corners[0,5],yend=corners[1,5],zend=corners[2,5]
    void = oAddOpUC->doAction(oTool,identifier=id)
    dum = oTool->getByIdentifier(id)
    oParent->remove,dum
    oGroupUC->add,dum

    oAddOpUC->setProperty, radius=0.1, color=colors[*,0],$
                             label='UCX',$
                             xpos=corners[0,7],ypos=corners[1,7],zpos=corners[2,7],$
                             xbeg=corners[0,7],ybeg=corners[1,7],zbeg=corners[2,7],$
                             xend=corners[0,6],yend=corners[1,6],zend=corners[2,6]
    void = oAddOpUC->doAction(oTool,identifier=id)
    dum = oTool->getByIdentifier(id)
    oParent->remove,dum
    oGroupUC->add,dum
  

;    ;'Y' DIRECTION:
    oAddOpUC->setProperty, radius=0.1, color=colors[*,1],$
                             label='UCY',$
                             xpos=corners[0,0],ypos=corners[1,0],zpos=corners[2,0],$
                             xbeg=corners[0,0],ybeg=corners[1,0],zbeg=corners[2,0],$
                             xend=corners[0,3],yend=corners[1,3],zend=corners[2,3]
    void = oAddOpUC->doAction(oTool,identifier=id)
    dum = oTool->getByIdentifier(id)
    oParent->remove,dum
    oGroupUC->add,dum

    oAddOpUC->setProperty, radius=0.1, color=colors[*,1],$
                             label='UCY',$
                             xpos=corners[0,1],ypos=corners[1,1],zpos=corners[2,1],$
                             xbeg=corners[0,1],ybeg=corners[1,1],zbeg=corners[2,1],$
                             xend=corners[0,2],yend=corners[1,2],zend=corners[2,2]
    void = oAddOpUC->doAction(oTool,identifier=id)
    dum = oTool->getByIdentifier(id)
    oParent->remove,dum
    oGroupUC->add,dum

    oAddOpUC->setProperty, radius=0.1, color=colors[*,1],$
                             label='UCY',$
                             xpos=corners[0,4],ypos=corners[1,4],zpos=corners[2,4],$
                             xbeg=corners[0,4],ybeg=corners[1,4],zbeg=corners[2,4],$
                             xend=corners[0,7],yend=corners[1,7],zend=corners[2,7]
    void = oAddOpUC->doAction(oTool,identifier=id)
    dum = oTool->getByIdentifier(id)
    oParent->remove,dum
    oGroupUC->add,dum

    oAddOpUC->setProperty, radius=0.1, color=colors[*,1],$
                             label='UCY',$
                             xpos=corners[0,5],ypos=corners[1,5],zpos=corners[2,5],$
                             xbeg=corners[0,5],ybeg=corners[1,5],zbeg=corners[2,5],$
                             xend=corners[0,6],yend=corners[1,6],zend=corners[2,6]
    void = oAddOpUC->doAction(oTool,identifier=id)
    dum = oTool->getByIdentifier(id)
    oParent->remove,dum
    oGroupUC->add,dum

  

;    ;'Z' DIRECTION:
    oAddOpUC->setProperty, radius=0.1, color=colors[*,2],$
                             label='UCZ',$
                             xpos=corners[0,0],ypos=corners[1,0],zpos=corners[2,0],$
                             xbeg=corners[0,0],ybeg=corners[1,0],zbeg=corners[2,0],$
                             xend=corners[0,4],yend=corners[1,4],zend=corners[2,4]
    void = oAddOpUC->doAction(oTool,identifier=id)
    dum = oTool->getByIdentifier(id)
    oParent->remove,dum
    oGroupUC->add,dum

    oAddOpUC->setProperty, radius=0.1, color=colors[*,2],$
                             label='UCZ',$
                             xpos=corners[0,1],ypos=corners[1,1],zpos=corners[2,1],$
                             xbeg=corners[0,1],ybeg=corners[1,1],zbeg=corners[2,1],$
                             xend=corners[0,5],yend=corners[1,5],zend=corners[2,5]
    void = oAddOpUC->doAction(oTool,identifier=id)
    dum = oTool->getByIdentifier(id)
    oParent->remove,dum
    oGroupUC->add,dum

    oAddOpUC->setProperty, radius=0.1, color=colors[*,2],$
                             label='UCZ',$
                             xpos=corners[0,3],ypos=corners[1,3],zpos=corners[2,3],$
                             xbeg=corners[0,3],ybeg=corners[1,3],zbeg=corners[2,3],$
                             xend=corners[0,7],yend=corners[1,7],zend=corners[2,7]
    void = oAddOpUC->doAction(oTool,identifier=id)
    dum = oTool->getByIdentifier(id)
    oParent->remove,dum
    oGroupUC->add,dum

    oAddOpUC->setProperty, radius=0.1, color=colors[*,2],$
                             label='UCZ',$
                             xpos=corners[0,2],ypos=corners[1,2],zpos=corners[2,2],$
                             xbeg=corners[0,2],ybeg=corners[1,2],zbeg=corners[2,2],$
                             xend=corners[0,6],yend=corners[1,6],zend=corners[2,6]
    void = oAddOpUC->doAction(oTool,identifier=id)
    dum = oTool->getByIdentifier(id)
    oParent->remove,dum
    oGroupUC->add,dum

  




oAddOpUC->setProperty, show_execution_ui=showUISetting ; switch off ui - no user interation required


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;







;  oAddOpOrb->setProperty,xpos=0,ypos=0,zpos=0,$
;                      color = [0,0,255],radius=1.0,label='sticks'  
;  void = oAddOpOrb->doAction(oTool,identifier=id)
;  dum = oTool->getByIdentifier(id)
;  oParent->remove,dum
;  oGroupAtoms->add,dum



  
print,'Added Bond'  
  
  oGroupBonds->UpdateSelectionVisual
print,'Updated Bonds Visual'  

  oGroupAtoms->UpdateSelectionVisual

print,'Updated Atoms Visual'  

  oAddOpBond->setProperty, show_execution_ui=showUiSetting ; revert to original setting

print,'Reset Add Bond show_execution property'  


end;create3DenProMolecule

