; $Id$
;
;Following Richard's manual p. 31ff.
;
;

function DAVEreadBT1::IsA,strFilename
compile_opt idl2


  catch,err
  if err ne 0 then begin
    catch,/cancel
    return,0
  endif

  print,'DAVEreadBT1::IsA   -   Checking '+strFilename

  ;CALL THE BASE CLASS READER TO DETERMINE IF THE EXTENSION IS RIGHT.
  if (~self->IDLitReader::IsA(strFilename)) then return,0

  print,'DAVEreadBT1::IsA    -    There is a BT1 or bt1 EXTENSION.'
  ;FOR THE REAL CHECK I MAY NEED TO SIMPLY READ THE FILE AND SEE WHAT HAPPENS.

  return,1
end;DAVEreadBT1::IsA


function DAVEreadBT1::readBT1,filename,s,result
  
  catch,err
  if err ne 0 then begin
    void = dialog_message('AN ERROR OCCURRED IN DAVEreadBT1::readBT1')
    catch,/cancel
    return,0
  endif
 
 
 
 
  readbt1,result,fn=filename,ofn=ofn,$
            /xIndex,$
            ;xIndex=xxIndex,xT=xxT,xH=xxH,xM4=xxM4,$
            /nodavewrite
  
  
  
  help,result,/struct

  

  print,result.yrsf
  print,result.yrza


;NOW ALL OF THE DATA NEEED TO BE INTERPOLATED ONTO THE REGULAR GRID FROM TEH POSITIONS OFFSET BY
;THE RELATIVE ZERO ANGLES. 

  return,1

    
  
  return,1

end;DAVEreadBT1::readBT1

;DAVEreadBT1::getData  IS SUPPOSED TO DO ALL OF THE WORK OF READING THE DATA. 
function DAVEreadBT1::getData,oData
compile_opt idl2

  print,'DAVEreadBT1::getData'

  catch,err
  if err ne 0 then begin
    catch,/cancel
    return,0
  endif

  oTool = self->getTool()
  if (not obj_valid(oTool)) then return,0
  
  filename = self->getFilename()

  ;THIS GETS A SINGLE BT1 FILE.  COMBINING FILES INTO ONE DAVE FILE WILL MEAN 
  ;MERGING MULTIPLE DATA OBJECTS AFTER READING FROM FILE.
  print,';;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;'
print,'PRE-READ'  

;HERE IF MULTIPLE FILES ARE SELECTED, THEN THEY SHOULD BE COMBINED INTO A SINGLE 2D ARRAY!!!
  ret = self->readBT1(filename,str,result)
print,'POST-READ'  

  print,';;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;'
;  for i=0,(30 < n_elements(str)-1) do begin
;    print,str[i]
;    print
;  endfor;i


  strings = obj_new('idlitdata',str,name='TEMPORARY BT1 DATA')
  qty = result.y
  err = result.dy
  x = result.x
  y = findgen(32)

  xdata = obj_new('idlitdataidlvector',x,name='x')
  ydata = obj_new('idlitdataidlvector',y,name='y')
  qtydata = obj_new('idlitdataidlarray2d',qty,name='qty')
  errdata = obj_new('idlitdataidlarray2d',err,name='err')
  
  
;
;  ;NOW I NEED TO CONVERT THIS TO AN OBJECT 
;  ;THE DATA WILL BE PUT INTO oData.
;
;  ;oData = obj_new('IDLitDataContainer',name=filename,identifier='id_'+filename,type='DAVECIFDATASET') 
  oData = obj_new('IDLitParameterSet',name=file_basename(filename),identifier='id_'+file_basename(filename),type='DAVEBT1DATASET')
  oData->add,strings,parameter_name='BT1TEXT'
  oData->add,qtydata,parameter_name='QTY'
  oData->add,errdata,parameter_name='ERR'
  oData->add,xdata,parameter_name='x'
  oData->add,ydata,parameter_name='y'



  return,ret

end;DAVEreadBT1::getData


;----------------------------------------------------------------------------
; Purpose:
;   This reader reads BT1 data.
;
function DAVEreadBT1::Init, _Ref_Extra=etc
    compile_opt idl2, hidden

  print,'DAVEreadBT1::Init'
    ; Init superclass
    if (self->IDLitReader::Init(['bt1','BT1'], $
        NAME='BT1 Data File', $
        DESCRIPTION="NCNR BT1 Data File (BT1)", $
        _EXTRA=_extra) eq 0) then $
        return, 0

    if n_elements(etc) gt 0 then self->setProperty,_Extra=etc

    return, 1
end;DAVEreadBT1::Init



pro DAVEreadBT1__Define
  ; Pragmas
  compile_opt idl2, hidden
print,'DAVEreadBT1__Define'

  void = {DAVEreadBT1, $
          inherits IDLitReader}
end;DAVEreadBT1__Define


