
;===============================================================================
pro DenProTool::SetProperty, data_directory=dataDir $
  , _EXTRA=etc
compile_opt idl2

if (n_elements(dataDir) gt 0) then begin
      self.dataDir = dataDir
endif

if(n_elements(etc) gt 0) then $
  self->IDLitToolbase::SetProperty, _EXTRA=etc 

end



;===============================================================================
pro DenProTool::GetProperty, data_directory=datadir $
  ,_REF_EXTRA=etc
compile_opt idl2

if (arg_present(dataDir)) then begin
    dataDir =  self.dataDir
endif

if(n_elements(etc) gt 0) then $
  self->IDLitToolbase::GetProperty, _EXTRA=etc

end
function DenProTool::getDAVEtlb
  
  davetlb = -1L
  dt = getdavetool()
  if obj_valid(dt) gt 0 then begin 
    ui = dt->getUI()
    if obj_valid(ui) then begin
      ui->getproperty,group_leader=dtlb
      if widget_info(dtlb,/valid_id) then begin
        davetlb = dtlb  
      endif;dtlb
    endif;ui
  endif;dt

  return,davetlb
end;DenProTool::getDAVEtlb
function DenProtool::GetTLB

    oUI = self->getUI()
    
    ;print,'FROM oUI CAN GET THE tlb.'
    oUI->getproperty,group_leader=tlb
    return,tlb

end;DenProtool::GetTLB


function DenProtool::GetUI
compile_opt idl2

return, self._oUIConnection

end

pro DenProTool::addToDataTree,oData,filename,oVis

;oVis IS NOT YET DEFINED.  IT WILL BE CREATED USING oData IN THE denProWDTool_AddDataToTree METHOD CALLED BELOW.
;if obj_valid(ovis) ne 0 then begin


    print,'CALLED BY DenProOpFileOpen?'
  help,oData,filename
    print,'GET THE TOOL AND RETRIEVE THE oUI'
    oUI = self->getUI()
    
    print,'FROM oUI CAN GET THE tlb.'
    oUI->getproperty,group_leader=tlb
  
    print,'THEN GET THE TREE AND CREATE A NEW BRANCH.'
    stash = widget_info(tlb,/child)
    widget_control,stash,get_uvalue=pstate
    help,(*pstate),/struct
  
    print,'DETERMINE THE DATA TYPE AND ADD TO THE DATA TREE.'
    help,pstate,oData,filename,oVis
    denProWDTool_AddDataToTree,pstate,oData,filename,oVis
    
    print,'THEN DECIDE WHETHER TO ADD VISUALIZATION' 
;endif else begin
;  void = dialog_message('DenProTool::addToDataTree    oVis is not defined!!!!',/error)
;endelse


end;DenProTool::addToDataTree



;===============================================================================
function DenProTool::InitExtra
compile_opt idl2

; Unregister following built-in example iTools as they are not relevant
self->unregisterOperation, 'File/New/Plot'
self->unregisterOperation, 'File/New/Surface'
self->unregisterOperation, 'File/New/Contour'
self->unregisterOperation, 'File/New/Image'
;self->unregisterOperation, 'File/New/Volume'
self->unregisterOperation, 'File/New/Map'
self->unregisterOperation, 'File/New/Vector'
self->unregisterOperation, 'File/Import'
;self->unregisterOperation, 'File/Export'

self->RegisterOperation, 'Read CIF Op', 'DenProOpFileOpen', IDENTIFIER='File/Import/Open CIF File',$
                          name='Open CIF File(s)',$
                          DESCRIPTION='Open CIF file(s)', $
                          readerNames='Read CIF'
self->RegisterOperation, 'Read GRD Op', 'DenProOpFileOpen', IDENTIFIER='File/Import/Open GRD File',$
                          name='Open GRD File(s)',$
                          DESCRIPTION='Open GRD file(s)', $
                          readerNames='Read GRD'

print,'          Added CIF READER Operation!!!'



self->unregisterOperation, 'Insert/Visualization'
self->unregisterOperation, 'Insert/View'
self->unregisterOperation, 'Insert/Data Space'
self->unregisterOperation, 'Insert/Axis'
self->unregisterOperation, 'Insert/Axis/X Axis'
self->unregisterOperation, 'Insert/Axis/Y Axis'
self->unregisterOperation, 'Insert/Axis/Z Axis'

self->unregisterOperation, 'Operations/Map Projection'


print,'DenProTool::InitExtra:'
; Register addOrb and addClouds operations
self->registerOperation, 'Add Orb','Op_addOrbs', identifier='Insert/Add Orb'
print,'          Added Orbs Operation!!!'
self->registerOperation, 'Add Bond','Op_addBonds', identifier='Insert/Add Bond'
print,'          Added Bonds Operation!!!'
;self->registerOperation, 'Add Unit Cell Outline','Op_addUnitCellOutline', identifier='Insert/Add Unit Cell Outline'
;print,'          Added UnitCellOutline Operation!!!'

self->registerOperation, 'Add Unit Cell Outline','Op_addUCOutline', identifier='Insert/Add Unit Cell Outline'
print,'          Added UnitCellOutline Operation!!!'


;self->registerOperation, 'Add Clouds','Op_addClouds', identifier='Insert/Add Clouds'
;print,'          Added Clouds Operation!!!'

self->registerOperation, 'Add GRD','Op_addGRD', identifier='Insert/Add GRD'
;print,'          Added GRD Operation!!!'
self->registerOperation, 'Add Molecule','Op_addMolecule', identifier='Insert/Add Molecule'
;print,'          Added Molecule Operation!!!'

self->registerOperation, 'DenProIsosurface','DenProOpIsosurface',identifier='Operations/Volume/DenProIsosurface'
;print,'          Registered DenProOpIsosurface??????????????????????????????????????????????????????!!!'

;Print,'Registering thelog ooperation in denprotool__define.pro'
;self->registerOperation,'DenProLogOfDataPlusOne','DenproLogOfDataPlusOne',identifier='Operations/DenProLogOfDataPlusOne';type=3



;self->RegisterOperation, 'CIF', 'DAVEReadCIF', IDENTIFIER='File/READCIF',DESCRIPTION='Open CIF file(s)'
;self->RegisterOperation, 'CIF', 'DAVEOpCIFOpen', IDENTIFIER='File/READCIF',DESCRIPTION='Open CIF file(s)'
;self->RegisterOperation, 'CIF', 'DAVEReadCIF', IDENTIFIER='File/READCIF',DESCRIPTION='Open CIF file(s)'
;self->RegisterOperation, 'GRD', 'DAVEReadGRD', IDENTIFIER='File/READGRD',DESCRIPTION='Open GRD file(s)'
;self->RegisterOperation, 'CIF', 'DAVEOpFileOpen', IDENTIFIER='DaveREADCIF',DESCRIPTION='Open CIF file(s)'
;self->RegisterOperation, 'GRD', 'DAVEOpFileOpen', IDENTIFIER='DaveREADGRD',DESCRIPTION='Open GRD file(s)'



print,'DenProTool::InitExtra'
; return success
return, 1

end;DenProTool::InitExtra

;===============================================================================
function DenProTool::Init, _REF_EXTRA=etc
compile_opt idl2

on_error, 2
catch, theError
if (theError ne 0) then begin
    catch, /cancel
    message, /reissue_last
    return, 0
endif
print,'NEED TO CENTER APP OVER DAVE WINDOW:'
davetlb = -1;getDAVETLB();self->getdavetlb()
print,'DAVE tlb=',davetlb
print,'DenProTool::Init1'
; call superclass
if (~self->IDLitToolbase::init(_EXTRA=etc)) then return, 0
print,'DenProTool::Init2'
; Perform additional inits not already done by base class
if (~self->initExtra()) then return, 0
print,'DenProTool::Init3'
; return success
return, 1

end


;===============================================================================
; Class structure definition
pro DenProTool__Define
compile_opt idl2

void = {DenProTool, inherits IDLitToolbase $
        ,dataDir:'' $
       }

end
