; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
pro dcs_heights_cleanup,tlb
;************************************************************************************************
;
compile_opt strictarr
;
widget_control,tlb,get_uvalue=pState
ptr_free,pState
end


;************************************************************************************************
pro dcs_heights_handler,event
;************************************************************************************************
;
compile_opt strictarr
;
widget_control,event.top,get_uvalue=pState
if (event.id eq (*pState).done) then begin
    widget_control,event.top,/destroy
    return
endif
end


;************************************************************************************************
pro dcs_heights_calcs,pState,chosen,zvalue,distances,disnames,results,resnames,messages
;************************************************************************************************
;
compile_opt strictarr
;
conv=25.4
;
; Inner shield
A=((*pState).indistances)[chosen[0],0]
B=((*pState).indistances)[chosen[0],1]
C=((*pState).indistances)[chosen[0],2]
D=((*pState).indistances)[chosen[0],3]
;
; Outer shield
E=((*pState).indistances)[chosen[1],4]
F=((*pState).indistances)[chosen[1],5]
G=((*pState).indistances)[chosen[1],6]
H=((*pState).indistances)[chosen[1],7]
;
; Vacuum can
I=((*pState).indistances)[chosen[2],8]
J=((*pState).indistances)[chosen[2],9]
; Displex
aa=((*pState).indistances)[chosen[3],10]
cc=((*pState).indistances)[chosen[3],11]

D1=aa+(B-D)+C
D2=cc+(E-H)
D3=cc+(F-H)+G
D4=J
;
Dp=I-(*pState).dis154-aa+(*pState).zvalue
Dpp=-I+(*pState).dis154+aa+A-D-(*pState).zvalue
Dppp=-I+(*pState).dis154+cc+E-H-(*pState).zvalue
;
distances=[A,B,C,D,E,F,G,H,I,J,aa,cc]
disnames='    '+['A','B','C','D','E','F','G','H','I','J','a','c']
;
results=[D1,D2,D3,D4,Dp,Dpp,Dppp]
resnames='    '+['D1  ','D2  ','D3  ','D4  ',"D'  ","D'' ","D'''"]
;
messages=['MESSAGES',strarr(4)]
k=0
warning='This will not work:'
if (D1 ge D2) then begin
    k=k+1
    messages[k]=warning+' D1 < D2'
endif
if (D2 ge D3) then begin
    k=k+1
    messages[k]=warning+' D2 < D3'
endif
if (D3 ge D4) then begin
    k=k+1
    messages[k]=warning+' D3 < D4'
endif
;
end


;************************************************************************************************
pro dcs_heights_get,event
;************************************************************************************************
;
compile_opt strictarr
;
widget_control,event.top,get_uvalue=pState
chosen=(*pState).chosen
zvalmin=(*pState).zvalmin
zvalmax=(*pState).zvalmax
zvalue=(*pState).zvalue
;
if (event.id eq (*pState).widz) then begin
    widget_control,event.id,get_value=zvalue
    if (zvalue lt zvalmin or zvalue gt zvalmax) then begin
       res=dialog_message("z value is outside limits")
    endif else begin
       (*pState).zvalue=zvalue
    endelse
    widget_control,event.id,set_value=string((*pState).zvalue)
endif
;
k=where(event.id eq (*pState).widg,count)
if (count gt 0) then begin
    k=k[0]
    chosen[k]=event.index
    (*pState).chosen=chosen
endif
;
if (chosen[0] eq 3 or chosen[0] eq 4) then begin
    res=dialog_message("This heat shield is **MISSING**")
endif
;
widget_control,event.top,set_uvalue=pState
dcs_heights_calcs,pState,chosen,zvalue,distances,disnames,results,resnames,messages
dcs_heights_writeout,pState,chosen,zvalue,distances,disnames,results,resnames,messages
end


;************************************************************************************************
pro dcs_heights_writeout,pState,chosen,zvalue,distances,disnames,results,resnames,messages
;************************************************************************************************
;
compile_opt strictarr
;
conv=25.4
zvalue=(*pState).zvalue
zoffset=(*pState).zoffset
;
sdistances=[[string(distances,format='(f8.1)')],[string(distances/conv,format='(f9.2)')]]
sresults=[[string(results,format='(f8.1)')],[string(results/conv,format='(f9.2)')]]
if (chosen[0] eq 0) then begin
    sdistances[0:3,*]=' '
    sresults[0,*]=' '
    sresults[5,*]=' '
endif
if (chosen[1] eq 0) then begin
    sdistances[4:7,*]=' '
    sresults[1:2,*]=' '
    sresults[6,*]=' '
endif
text1=['INPUT DISTANCES','             mm       in',disnames+" = "+sdistances[*,0]+sdistances[*,1]]
text2=['OUTPUT DISTANCES','                mm       in',resnames+" = "+sresults[*,0]+sresults[*,1],$
    '','  (z stage reading = '+strcompress(string(zvalue+zoffset,format='(f5.1)'))+')']
widget_control,(*pState).input,set_value=text1
widget_control,(*pState).output,set_value=text2
widget_control,(*pState).mess,set_value=messages
end




;************************************************************************************************
pro dcs_heights_test,event
;************************************************************************************************
;
compile_opt strictarr
;
if (n_elements(event) eq 0) then group_leader=0 else group_leader=event.top
;
inputfile=file_which('dcs_heights.dat',/include_current_dir)
openr,u,inputfile,/get_lun
    nquans=4
    choices=strarr(10,nquans)
    values=strarr(nquans)
    nchoices=intarr(nquans)
    chosen=intarr(nquans)
    ndistances=intarr(nquans)
    indistances=fltarr(10,12)
    chosenfilename=strarr(80)
    jk=-1
    kk=intarr(4)
    dummy=''
    for k=0,nquans-1 do begin
       readf,u,kk
       nchoices[k]=kk[1]
       chosen[k]=kk[2]
       ndistances[k]=kk[3]
       readf,u,dummy
       values[k]=dummy
       readf,u,dummy
       temp=strsplit(dummy,' ',/extract)
       choices[0:nchoices[k]-1,k]=temp[0:nchoices[k]-1]
       dumdis=fltarr(nchoices[k])
       for j=0,ndistances[k]-1 do begin
         jk=jk+1
         readf,u,dumdis
         indistances[0:nchoices[k]-1,jk]=dumdis
       endfor
    endfor
    readf,u,dis154,zvalmin,zvalmax,zoffset
free_lun,u
;
zvalue=0.0
;

; Image preparation
; Determine the color depth of the computer
device,get_visual_depth = thisDepth
if thisDepth eq 8 then begin
   filename = file_which('displex.png',/include_current_dir)
   image = read_png(filename,r,g,b)
   s = size(image)
   sx = s[1] & sy = s[2]
endif else begin
   filename = file_which('displex.jpg',/include_current_dir)
   read_jpeg,filename,image
   s = size(image)
   sx = s[2] & sy = s[3]
endelse
aspect = 1.0*sy/sx     ; find the aspect ratio of the image...
; ...and set the display window's dimensions based on this
;    aspect ratio.
winxsize = 350 &  winysize = fix(aspect*winxsize)

tlb=widget_base(title='Sample height calculations',/col,group_leader=group_leader)
    b1=widget_base(tlb,/row)
    sb1=lonarr(nquans+1)
    widg=lonarr(nquans+1)
    for k=0,nquans-1 do begin
       sb1[k]=widget_base(b1,/col)
         void=widget_label(sb1[k],value=values[k],/align_left)
         widg[k]=widget_combobox(sb1[k],xsize=120,value=choices[0:nchoices[k]-1,k],$
          event_pro="dcs_heights_get")
         widget_control,widg[k],set_combobox_select=chosen[k]
    endfor
       sb1[nquans]=widget_base(b1,/col)
         void=widget_label(sb1[nquans],value='z motor reading',/align_left)
         widz=widget_text(sb1[nquans],/editable,xsize=10,ysize=1,value=string(0.0),font='Courier',$
          event_pro="dcs_heights_get")
    b2=widget_base(tlb,/row)
       inpb=widget_base(b2,/col)
         input=widget_text(inpb,/editable,value=text1,font='Courier',xsize=6,ysize=24)
       outpb=widget_base(b2,/col)
         output=widget_text(outpb,/editable,value=text2,font='Courier',xsize=6,ysize=24)
    mess=widget_text(tlb,/editable,ysize=5,value=messages,font='Courier')
       c3=widget_base(b2,/col)
       win = widget_draw(c3,xsize = winxsize,ysize = winysize)

    b3=widget_base(tlb,/row)
       done=widget_button(b3,value='Done')
geom=widget_info(tlb,/geometry)
geom2=widget_info(input,/geometry)




widget_control,input,scr_xsize=geom.xsize/2-4*geom2.margin
widget_control,output,scr_xsize=geom.xsize/2-4*geom2.margin
centertlb,tlb

widget_control,tlb,/realize
widget_control,win,get_value = winVis
window,/free,/pixmap,xsize = winxsize,ysize = winysize
winPix = !d.window


;wset,winPix
if thisDepth eq 8 then begin
   device,decomposed = 0
   tvlct,r,g,b   ; load the proper color tables as found in
   ; read_png above.
   dispImage = congrid(image,winxsize,winysize)
endif else begin
   device,decomposed = 1
   dispimage = image
endelse

wset,winPix
tvimage,dispImage
wset,winVis
device,copy = [0,0,!d.x_size,!d.y_size,0,0,winPix]
wdelete,winPix


;
State={done:done,$
    input:input,$
    output:output,$
    mess:mess,$
    widg:widg,$
    nquans:nquans,$
    widz:widz,$
    chosen:chosen,$
    indistances:indistances,$
    dis154:dis154,$
    zvalmin:zvalmin,$
    zvalmax:zvalmax,$
    zoffset:zoffset,$
    zvalue:zvalue}
pState=ptr_new(State)
widget_control,tlb,set_uvalue=pState
;
dcs_heights_calcs,pState,chosen,zvalue,distances,disnames,results,resnames,messages
dcs_heights_writeout,pState,chosen,zvalue,distances,disnames,results,resnames,messages
;
xmanager,'dcs_heights',tlb,event_handler='dcs_heights_handler',cleanup='dcs_heights_cleanup'
;
end