; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
pro DCStoolsSanitycheck_getinfo_handler,event
;************************************************************************************************
;
compile_opt strictarr

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'DCStoolsSanitycheck_getinfo_handler: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
;    eMsg = [eMsg,'Function/module name: calledfunc()',!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return
    endif
endif


;
widget_control,event.top,get_uvalue=pstate
;
if (event.id eq (*pstate).done) then begin
	widget_control,event.top,/destroy
	return
endif
;
if (event.id eq (*pstate).cancel) then begin
	(*(*pstate).answers_ptr)[0]=999
	widget_control,event.top,/destroy
	return
endif
;
if (event.id eq (*pstate).allbuts) then begin
	for k=1,(*pstate).nchecks-1 do begin
		if (k ne 3) then begin
			widget_control,(*pstate).buts[k],set_button=event.select
			(*(*pstate).answers_ptr)[k]=event.select
		endif
	endfor
	case event.select of
		0: widget_control,(*pstate).allbuts,set_value="ALL SUPPORTED SANITY CHECKS"
		1: widget_control,(*pstate).allbuts,set_value="MANDATORY SANITY CHECKS ONLY"
		else:
	endcase
endif
;
if (event.id eq (*pstate).buts[0]) then widget_control,(*pstate).buts[0],/set_button
;
for k=1,(*pstate).nchecks-1 do begin
	if (event.id eq (*pstate).buts[k]) then (*(*pstate).answers_ptr)[k]=event.select
endfor
;
for k=0,2 do begin
	if (event.id eq (*pstate).fbuts[k]) then begin
		if (event.select eq 1) then (*(*pstate).answers_ptr)[(*pstate).nchecks]=k
	endif
endfor
;
if (event.id eq (*pstate).allfiles) then (*(*pstate).answers_ptr)[(*pstate).nchecks]=-1
;
widget_control,event.top,set_uvalue=pstate
;
end


;************************************************************************************************
pro DCStoolsSanitycheck_getinfo,group_leader=group_leader,answers=answers,filetype=filetype
;************************************************************************************************
;
compile_opt strictarr
;
nchecks=7
checks=["BITFLIPS (mandatory)",$
	"Time channel/chopper period mismatch",$
	"Counts in high channels",$
	"Fast/slow chopper ratio (not used)",$
	"Invalid boards",$
	"Invalid detectors",$
	"Repeats and resets"]
;
tlb=widget_base(title="Sanity check widget.",/col,group_leader=group_leader,/modal)
	void=widget_label(tlb,value="Data directory is "+(*!dave_defaults).datdir)
	tbase=widget_label(tlb,value="Choose sanity checks to be performed.")
	bfbase=widget_base(tlb,/col)
		bbase=widget_base(bfbase,/col,/nonexclusive,/frame)
			buts=intarr(nchecks)
			for k=0,nchecks-1 do begin
				buts[k]=widget_button(bbase,value=checks[k])
			endfor
			widget_control,buts[0],/set_button
			widget_control,buts[3],sensitive=0
			allbuts=widget_button(bbase,value="ALL SUPPORTED SANITY CHECKS")
		fbase=widget_base(bfbase,/col,/exclusive,/frame)
			fbuts=intarr(3)
			fbuts[0]=widget_button(fbase,value="Examine .dcs files only")
			fbuts[1]=widget_button(fbase,value="Examine .dcs.gz files only")
			fbuts[2]=widget_button(fbase,value="Examine .dcs & .dcs.gz files")
			allfiles=widget_button(fbase,value="Examine ALL FILES in data directory")
			widget_control,fbuts[2],/set_button
		dbase=widget_base(tlb,/row)
			done=widget_button(dbase,value="PROCEED")
			cancel=widget_button(dbase,value="CANCEL")
;
centertlb,tlb
widget_control,tlb,/realize
;
answers=[1,0,0,0,0,0,0,2]
answers_ptr=ptr_new(answers)
;
state={$
	nchecks:nchecks,$
	buts:buts,fbuts:fbuts,$
	allbuts:allbuts,$
	allfiles:allfiles,$
	answers_ptr:answers_ptr,$
	done:done,$
	cancel:cancel}
;
widget_control,tlb,set_uvalue=ptr_new(state,/no_copy)
;
xmanager,'DCStoolsSanitycheck_getinfo',tlb,$
	event_handler='DCStoolsSanitycheck_getinfo_handler'
;
answers=(*answers_ptr)[0:nchecks-1]
filetype=(*answers_ptr)[nchecks]
ptr_free,answers_ptr
;
end

;************************************************************************************************
;pro DCStoolsSanitycheck,event
pro DCStoolsSanityCheck, group_leader=group_leader, dataDir=dataDir, workDir=workDir, _EXTRA=etc
;************************************************************************************************
; This procedure loops over .dcs and .dcs.gz runs in the
; chosen directory and performs various sanity checks. The results are
; written to a summary output file.
;
compile_opt strictarr
;
;widget_control,event.top,get_uvalue=statePtr
;davePtr=(*statePtr).davePtr
;
if (n_elements(workDir) eq 0) then workDir=''
if (n_elements(dataDir) eq 0) then dataDir=''
if (n_elements(group_leader) eq 0) then group_leader=0L

dave_makeDavePtr,davePtr=davePtr ; define an empty davePtr structure
dcs_definedavestructure,davePtr=davePtr ; redefine the structure with default DCS values
;
dcs_sysvars,davePtr=davePtr
;
DCStoolsSanitycheck_getinfo,group_leader=group_leader,answers=answers,filetype=filetype
;
if (answers[0] eq 999) then begin
;	(*statePtr).davePtr=davePtr
	return
endif
;
; Get the raw data file list.
;
files0=""
if (filetype eq 0 or filetype eq 2) then begin
	files0=dialog_pickfile(title="Select UNCOMPRESSED raw data file(s) (if any):",$
		filter=["*.dcs"],/multiple_files,/must_exist,path=dataDir);path=!dcs_data_directory)
	files0=files0[sort(files0)]
endif
files1=""
if (filetype eq 1 or filetype eq 2) then begin
	files1=	dialog_pickfile(title="Select COMPRESSED raw data file(s) (if any):",$
		filter=["*.dcs.gz"],/multiple_files,/must_exist,path=dataDir);path=!dcs_data_directory)
	files1=files1[sort(files1)]
endif
;
if (filetype eq -1) then begin
	files0=findfile(dataDir+"*.dcs")
	files1=findfile(dataDir+"*.dcs.gz")
endif
;
files0=files0[sort(files0)]
files1=files1[sort(files1)]
;
if (files0[0] eq "" and files1[0] eq "") then begin
	x=dialog_message(["No files selected.","Exiting ..."])
	;(*statePtr).davePtr=davePtr
	return
endif
if (files0[0] eq "" and files1[0] ne "") then begin
	nfiles0=0
	files=files1
	nfiles1=n_elements(files1)
	nfiles=nfiles1
endif
if (files0[0] ne "" and files1[0] eq "") then begin
	files=files0
	nfiles0=n_elements(files0)
	nfiles1=0
	nfiles=nfiles0
endif
if (files0[0] ne "" and files1[0] ne "") then begin
	files=[files0,files1]
	nfiles0=n_elements(files0)
	nfiles1=n_elements(files1)
	nfiles=nfiles0+nfiles1
endif
;
; Get the output summary file.
;
outfile=dialog_pickfile(title="Supply an output summary file name.",$
	path=workdir,file="sanitycheck.dat",filter="*.dat") ;path=(*!dave_defaults).workdir
if (outfile eq "") then begin
	x=dialog_message(["No summary file supplied.","Exiting ..."])
	;(*statePtr).davePtr=davePtr
	return
endif
if (strpos(outfile,".") eq -1) then outfile=outfile+".dat"
defsysv,'!logfile',outfile
;
ratiocriterion=0.0001
;
maxbitflips=10
bitflips=lonarr(3,maxbitflips,nfiles)+1000
;
;	This is required for the call to DCS_sanitycheck
;
runtemperatures=fltarr(nfiles)
;
;inputfile=file_which("dcs_multiple_messages.txt",/include_current_dir)
inputfile=!DAVE_AUXILIARY_DIR+'dcs_multiple_messages.txt'
;
dcs_read_multiple_messages,inputfile,message_str
;
; Call dcs_sanitycheck to do the sanity checks.
;
nhedet=913
dcs_sanitycheck,group_leader,files,nfiles,nhedet,/allchecks,/silent,bitflips,maxbitflips,$
	davePtr=davePtr,runtemperatures,message_str,$
	ratiocriterion=ratiocriterion,$
	skipdefaultchoices=0,$
	skiptchanmismatchmes=0,$
	logentry="",$
	n_insane=n_insane,$
	dochecks=answers
;
; Write a message to the screen.
;
lines="The sanity check of"
if (nfiles0 gt 0 and nfiles1 eq 0) then $
	lines=lines+strcompress(nfiles0)+" *.dcs runs is completed."
if (nfiles0 eq 0 and nfiles1 gt 0) then $
	lines=lines+strcompress(nfiles1)+" *.dcs.gz runs is completed."
if (nfiles0 gt 0 and nfiles1 gt 0) then $
	lines=lines+strcompress(nfiles0)+" *.dcs runs"+$
	" and/or"+strcompress(nfiles1)+" *.dcs.gz runs is completed."
if (total(n_insane) eq 0) then begin
	lines=[lines,"","No runs failed."]
	result=dialog_message(lines,/information)
endif else begin
	for i=0,6 do begin
		number=fix(n_insane[i])
		if (number gt 0) then lines=$
			[lines,"",strcompress(number,/remove_all)+$
			" runs failed sanity check #"+strcompress(i+1)+"."]
	endfor
	lines=[lines,"","The results are in the file ","  "+outfile,$
		"Do you wish to examine the file?"]
;
	result=dialog_message(lines,/question)
	if (result eq "Yes") then begin
		if (!windows) then dcs_fixedfont="courier*12"
		if (!unix) then dcs_fixedfont="courier-12"
		if (!macos) then dcs_fixedfont="courier*12"
		xdisplayfile,outfile,$
			DONE_BUTTON="Quit",$
			FONT=dcs_fixedfont,$
			/EDITABLE,$
			GROUP=group_leader,$
			/MODAL,$
			TITLE="Sanity check summary file "+outfile
	endif
endelse
;
;(*statePtr).davePtr=davePtr
end
