; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
pro dcs_write_summaryfile,$
	summary_line,datafile_ptr=davePtr,choice=choice,icall,delim,$
	short_form,sns=sns,tagnames=tagnames,omitfilename=omitfilename,$
	ndq=ndq,answers=answers,entries=entries,filetype=filetype
;************************************************************************************************
;
compile_opt strictarr
;
; This procedure is used to generate a delimited file summary.
;
if (icall eq 0) then begin
	if (omitfilename) then summary_line="#" else summary_line="#File_name"
endif

if (icall eq 1) then begin
	if (omitfilename) then begin
		summary_line=""
	endif else begin
		if (filetype eq "dcs") then	short_form=strmid(short_form,0,8)+"."+strmid(short_form,9,3)
		summary_line=short_form
	endelse
endif
;
nvars=n_elements(tagnames)
;
ivar_written=0
;
for ivar=0,nvars-1 do begin
	if (choice[ivar]) then begin
		ivar_written=ivar_written+1
		name=sns[ivar]
		longname=tagnames[ivar]
		result=execute("data="+longname)
		if ( strlowcase(name) eq "duration_csum" $
			or strlowcase(name) eq "he3_csum" $
			or strlowcase(name) eq "high_csum") then begin
			data=data[where(data ge 0)]
		endif
		if ( strlowcase(name) eq "temp_control" $
			or strlowcase(name) eq "temp_sample") then begin
			data=data[where(data gt 0.0)]
		endif
		nelements=n_elements(data)
		if (nelements gt 1) then name=name+"("+strcompress(nelements,/remove_all)+")"
		if (icall eq 0) then begin
			n_el=n_elements(name)
			if (n_el eq 1) then summary_line=summary_line+delim+name else $
				for j=0,n_el-1 do summary_line=summary_line+delim+name+strcompress(j,/remove_all)
		endif
		if (icall eq 1) then begin
			nsize=size(data)
			ns0=nsize[0]
			nst=nsize[ns0+1]
			n_el=n_elements(data)
			if (ns0 eq 0) then begin
				case nst of
					7: dt=5; string
					else: dt=1; scalar
				endcase
			endif
			if (ns0 eq 1) then begin
				case nst of
					7: dt=7; string array
					else: dt=2
				endcase
				if (dt eq 2) then begin & n1=nsize[1] & n2=1 & end
			endif
			if (ns0 eq 2) then begin
				case nst of
					7: dt=0
					else: dt=2
				endcase
				if (dt eq 2) then begin & n1=nsize[1] & n2=nsize[2] & end
			endif
;
			case dt of
				1: begin; write scalar
					summary_line=summary_line+delim+strcompress(string(format=((f)),data))
				end
				2: begin; write matrix
					for j=0,n_el-1 do summary_line=summary_line+delim+strcompress(string(format=((f)),data[j]))
				end
				5: begin; write string
					summary_line=summary_line+delim+strcompress(data)
				end
				7: begin; write string array
					for j=0,n_el-1 do summary_line=summary_line+delim+strcompress(data[j])
				end
				else: stop,"No good"
			endcase
		endif
	endif
endfor
;
if (ndq gt 0) then begin
	if (icall eq 0) then begin
		for k=0,ndq-1 do begin
			if (answers[k]) then begin
				summary_line=summary_line+delim+entries[k]
			endif
		endfor
	endif
	if (icall eq 1) then begin
		for k=0,ndq-1 do begin
			if (answers[k]) then begin
				name=entries[k]
				result=execute("data="+name)
				summary_line=summary_line+delim+strjoin(strcompress(data))
			endif
		endfor
	endif
endif
;
end
