; $Id$
;#######################################################################
;
; NAME:
;  dm_set_droplist
;
; PURPOSE:
;  this program sets values for widget_droplist(IDL5.5 or before),
;  or for widget_combobox(IDL5.6 or later)
;
; CATEGORY:
;  widget
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-6102
;  United States
;  yiming.qiu@nist.gov
;  March, 2011
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

; parameter:
;   parent:     the widget ID of the parent for the new button widget
; keyword:
;   select:     =set_combobox_select keyword for combobox, =set_droplist_select for droplist
pro dm_set_droplist,id,select=select,_ref_extra=_extra
    if (n_elements(id) eq 0) or (n_elements(select) eq 0) then return
    if ~(widget_info(id,/valid_id)) then return
    type = widget_info(id,/type)
    if type eq 12  then $       ;widget_combobox
       widget_control,id,set_combobox_select=select,_extra=_extra $
    else if type eq 8 then $    ;widget_droplist
       widget_control,id,set_droplist_select=select,_extra=_extra
end
