; $Id: $
;#######################################################################
;
; NAME:
;  dm_save_parameter
;
; PURPOSE:
;  save parameters in a file
;
; CATEGORY:
;  dcs_mslice
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-6102
;  United States
;  yiming.qiu@nist.gov
;  March, 2025
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

pro dcs_mslice::dm_save_parameter,parmfile,quiet=quiet,session=session
    openw,unit,parmfile,/get_lun,error=openerr
    if openerr ne 0 then begin
       if ~keyword_set(quiet) then ok = dialog_message("Can't write in "+parmfile+'.',/error,dialog_parent=self.tlb,/center)
       return
    endif
    printf,unit,'#dcs_mslice '+self.mod_date+' IDL '+!version.release+' '+!version.os_name
    printf,unit,'samptyp:'+dm_to_string(self.samp_typ,/int)
    printf,unit,'datadir:'+self.dirs[0]
    printf,unit,'workdir:'+self.dirs[1]
    printf,unit,'selfshd:'+dm_to_string(self.ssfac)
    printf,unit,'binmeth:'+dm_to_string(self.bin_avgsum,/int)
    printf,unit,'bincons:'+dm_to_string(self.bin_conststep,/int)
    printf,unit,'binextl:'+dm_to_string(self.bin_extlib,/int)
    printf,unit,'toloptn:'+dm_to_string(self.empt_tol_optn,/int)
    printf,unit,'bgcolor:'+dm_to_string(self.pbgcol_bw,/int)
    printf,unit,'pvt_col:'+dm_to_string(self.ppvc_choice,/int)
    printf,unit,'tickdir:'+dm_to_string(self.tdir_choice,/int)
    printf,unit,'pxysize:'+dm_to_string(self.pdim_choice,/int)
    printf,unit,'volselx:'+dm_to_string(self.volsel_x,/int,separator='&')
    printf,unit,'volsely:'+dm_to_string(self.volsel_y,/int,separator='&')
    printf,unit,'volselz:'+dm_to_string(self.volsel_z,/int,separator='&')
    printf,unit,'volxran:'+dm_to_string(self.vol_xran,separator='&')
    printf,unit,'volx_st:'+dm_to_string(self.vol_xstep)
    printf,unit,'volyran:'+dm_to_string(self.vol_yran,separator='&')
    printf,unit,'voly_st:'+dm_to_string(self.vol_ystep)
    printf,unit,'volzran:'+dm_to_string(self.vol_zran,separator='&')
    printf,unit,'volz_st:'+dm_to_string(self.vol_zstep)
    printf,unit,'voliran:'+dm_to_string(self.vol_iran,separator='&')
    printf,unit,'vol_smo:'+dm_to_string(self.vol_smooth,/int)
    printf,unit,'volintp:'+dm_to_string(self.vol_interp,/int)
    printf,unit,'vol_col:'+dm_to_string(self.vol_color,/int)
    printf,unit,'dispslh:'+dm_to_string(self.slice_x,/int,separator='&')
    printf,unit,'dispslv:'+dm_to_string(self.slice_y,/int,separator='&')
    printf,unit,'dispx_r:'+dm_to_string(self.slice_xran,separator='&')
    printf,unit,'dispxst:'+dm_to_string(self.slice_xstep)
    printf,unit,'dispy_r:'+dm_to_string(self.slice_yran,separator='&')
    printf,unit,'dispyst:'+dm_to_string(self.slice_ystep)
    printf,unit,'dispi_r:'+dm_to_string(self.slice_iran,separator='&')
    printf,unit,'dispsmo:'+dm_to_string(self.slice_smooth,/int)
    printf,unit,'dispker:'+dm_to_string(self.slice_sm_kernel,separator='&')
    printf,unit,'dispsha:'+dm_to_string(self.slice_shading,/int)
    printf,unit,'dispcol:'+dm_to_string(self.slice_color,/int)
    printf,unit,'dispcut:'+dm_to_string(self.slice_cutcolor)
    printf,unit,'cut___x:'+dm_to_string(self.cut_x,/int,separator='&')
    printf,unit,'cutxran:'+dm_to_string(self.cut_ran,separator='&')
    printf,unit,'cut_xst:'+dm_to_string(self.cut_step)
    printf,unit,'cut___y:'+dm_to_string(self.cut_y,/int,separator='&')
    printf,unit,'cutyran:'+dm_to_string(self.cut_yran,separator='&')
    printf,unit,'cut_sym:'+dm_to_string(self.cut_symbol,/int)
    printf,unit,'cut_col:'+dm_to_string(self.cut_color,/int)
    printf,unit,'userdef:'+dm_to_string(self.coldefine,/int,separator='&')
    printf,unit,'cutline:'+dm_to_string(self.cut_line,/int)
    if self.samp_typ eq -1 then begin
       n_item = n_elements((*self.dataPtr).label)  
       if n_item gt 5 then begin
          for i=0,n_item-6 do begin
              if i eq 0 then begin
                 tmp1 = dm_to_string((*self.volsel_t)[i],/int)
                 tmp2 = dm_to_string((*self.volsel_tft)[i,0])+'&'+dm_to_string((*self.volsel_tft)[i,1])
              endif else begin
                 tmp1 = tmp1+'&'+dm_to_string((*self.volsel_t)[i],/int)
                 tmp2 = tmp2+'&'+dm_to_string((*self.volsel_tft)[i,0])+'&'+dm_to_string((*self.volsel_tft)[i,1])
              endelse
          endfor
          printf,unit,'vol_slt:'+tmp1
          printf,unit,'vol_tft:'+tmp2
       endif
       if n_item gt 4 then begin
          for i=0,n_item-5 do begin
              if i eq 0 then begin
                 tmp1 = dm_to_string((*self.slice_t)[i],/int)
                 tmp2 = dm_to_string((*self.slice_tft)[i,0])+'&'+dm_to_string((*self.slice_tft)[i,1])
              endif else begin
                 tmp1 = tmp1+'&'+dm_to_string((*self.slice_t)[i],/int)
                 tmp2 = tmp2+'&'+dm_to_string((*self.slice_tft)[i,0])+'&'+dm_to_string((*self.slice_tft)[i,1])
              endelse
          endfor
          printf,unit,'dispslt:'+tmp1
          printf,unit,'disptft:'+tmp2
       endif    
       if n_item gt 3 then begin
          for i=0,n_item-4 do begin
              if i eq 0 then begin
                 tmp1 = dm_to_string((*self.cutsel_t)[i],/int)
                 tmp2 = dm_to_string((*self.cutsel_tft)[i,0])+'&'+dm_to_string((*self.cutsel_tft)[i,1])
              endif else begin
                 tmp1 = tmp1+'&'+dm_to_string((*self.cutsel_t)[i],/int)
                 tmp2 = tmp2+'&'+dm_to_string((*self.cutsel_tft)[i,0])+'&'+dm_to_string((*self.cutsel_tft)[i,1])
              endelse
          endfor
          printf,unit,'cut_slt:'+tmp1
          printf,unit,'cut_tft:'+tmp2
       endif
       if ptr_valid(self.bgdata[0]) or ptr_valid(self.bgdata[1]) then printf,unit,'datatol:'+dm_to_string(*self.data_tolerance,separator='&')
       printf,unit,'maskfil:'+dm_to_string(self.mask_filler,separator='&')
    endif else begin
       printf,unit,'ncnrftp:'+dm_to_string(self.ncnrftp,/int)
       if ptr_valid(self.absp_info) then begin
          tmp = dm_to_string((*(self.absp_info))[0],/int) +'&'+dm_to_string((*(self.absp_info))[1],/int)+'&'+dm_to_string((*(self.absp_info))[2],/int)
          for i=3,n_elements(*(self.absp_info))-1 do tmp=tmp+'&'+dm_to_string((*(self.absp_info))[i])
          printf,unit,'sshield:'+tmp
          printf,unit,'l1_fact:'+dm_to_string(self.absp_l1factor)
       endif
       printf,unit,'in_geom:'+dm_to_string(self.instrgeom,/int)
       printf,unit,'viewwin:'+dm_to_string(self.view,/int,separator='&')
       printf,unit,'f__type:'+dm_to_string(self.ftype,/int)
       printf,unit,'zeroerr:'+dm_to_string(self.zero_error[0])
       printf,unit,'binzerr:'+dm_to_string(self.bin_zeroerror,/int)
       printf,unit,'statest:'+dm_to_string(self.bin_statrange,/int,separator='&')
       if self.instrname eq 'macs' then begin
          printf,unit,'koffset:'+dm_to_string(self.kidney_offset) 
          printf,unit,'macstol:'+dm_to_string(self.macs_tolerance,separator='&') 
          printf,unit,'macslm2:'+dm_to_string(self.macs_lamb2,/int)
          printf,unit,'macsmon:'+dm_to_string(self.macs_mon[1,*],separator='&')
          printf,unit,'evax_yn:'+dm_to_string(self.extravaxis_yn,/int,separator='&')
          if self.extravaxis_yn[1] then begin  ;temperature axis enabled
             printf,unit,'macsttp:'+dm_to_string(self.macstemp_typ,/int)
             printf,unit,'tempavg:'+dm_to_string(self.tempavg_yn,/int)
          endif
          if self.extravaxis_yn[0] then begin  ;specify axis name and unit
             printf,unit,'evax_sp:'+self.extravaxis_spec[0]+string('A4'xb)+self.extravaxis_spec[1]+string('A4'xb)+self.extravaxis_spec[2]
          endif
          printf,unit,'macsseq:'+dm_to_string(self.macs_seq_geom,separator='&')
          printf,unit,'macshis:'+dm_to_string(self.macshistomode)
          if self.macshistomode ne 0 then begin
             printf,unit,'macswid:'+dm_to_string(self.macshistowidth)
             printf,unit,'macsunt:'+dm_to_string(self.macshistounit)
             printf,unit,'macsnch:'+dm_to_string(self.macshistonchan)
             printf,unit,'macscut:'+dm_to_string(self.macshistocut)
             printf,unit,'macsraw:'+dm_to_string(self.macs_rawintn)
          endif
          if ptr_valid(self.a3mask)   then printf,unit,'a3_mask:'+(*self.a3mask)
          if ptr_valid(self.bga3mask) then printf,unit,'bga3msk:'+(*self.bga3mask)
       endif else begin
          if self.instrname eq 'dcs' then begin
             printf,unit,'ftlflag:'+dm_to_string(self.ftoolflag,/int,separator='&')
             if total(self.dcsdetmask) ne 0 then $
                printf,unit,'dcsmask:'+dm_to_string(self.dcsdetmask,/int,separator='&')
             printf,unit,'bitflip:'+dm_to_string(self.bitflip,/int)
             printf,unit,'evax_yn:'+dm_to_string(self.extravaxis_yn,/int,separator='&')
             if self.extravaxis_yn[1] then begin  ;temperature axis enabled
                printf,unit,'macsttp:'+dm_to_string(self.macstemp_typ,/int)
                printf,unit,'tempavg:'+dm_to_string(self.tempavg_yn,/int)
             endif
          endif else begin
             printf,unit,'evax_yn:'+dm_to_string(self.extravaxis_yn[0],/int)
             if (self.instrname eq 'wand') and self.extravaxis_yn[0] then $
                printf,unit,'tempavg:'+dm_to_string(self.tempavg_yn,/int)
          endelse
          printf,unit,'psi_tol:'+dm_to_string(self.psi_tolerance,separator='&')     
          if ptr_valid(self.ssfacPtr) then printf,unit,'ssdfile:'+dm_to_string((*self.ssfacPtr).det_or_en)+string('A4'xb)+(*self.ssfacPtr).file
       endelse
       if self.instrname eq 'inx' then $
       printf,unit,'inxerev:'+dm_to_string(self.inxerev,/int)
       printf,unit,'powd_la:'+dm_to_string(self.powd_latta)
       printf,unit,'powd_bc:'+dm_to_string(self.powd_bcc,/int)
       if finite(self.datr_psi)   then printf,unit,'datrpsi:'+dm_to_string(self.datr_psi)
       if finite(self.datr_width) then printf,unit,'datrwid:'+dm_to_string(self.datr_width)
       printf,unit,'dcor_eq:'+dm_to_string(self.dcor_eqran,separator='&')
       printf,unit,'dcor_yn:'+dm_to_string(self.dcor_yn,/int)
       printf,unit,'eemp_yn:'+dm_to_string(self.extraempcan_yn,/int)
       printf,unit,'emp_fac:'+dm_to_string(self.empcanfactor,separator='&')
       printf,unit,'edep_yn:'+dm_to_string(self.edep_yn,/int)
       printf,unit,'edep_dt:'+dm_to_string(self.edep_det,separator='&')
       printf,unit,'dcs2thc:'+dm_to_string(self.tthcorr,/int)
       printf,unit,'eadj_yn:'+dm_to_string(self.eadjust,/int)
       printf,unit,'eadj_sp:'+dm_to_string(self.eadjust_spec)
       printf,unit,'eadj_cf:'+dm_to_string(self.eadjust_checkfirst,/int)
       printf,unit,'eint_yn:'+dm_to_string(self.eint_yn,/int)
       printf,unit,'intnlab:'+self.intn_lab
       printf,unit,'intntyp:'+dm_to_string(self.intn_typ,/int)
       printf,unit,'ebinsiz:'+dm_to_string(self.e_bin,/int,separator='&')
       printf,unit,'e_range:'+dm_to_string(self.e_range,separator='&')
       if (self.instrname eq 'dcs') or (self.instrname eq 'macs') then begin
          printf,unit,'mon_fit:'+dm_to_string(self.mon_sumfit,/int,separator='&')
          printf,unit,'mon_typ:'+dm_to_string(self.mon_typ,/int,separator='&')
       endif
       printf,unit,'ortharb:'+dm_to_string(self.view_ortharbi,/int)
       printf,unit,'latt__a:'+dm_to_string(float(self.latt_parm[0]))
       printf,unit,'latt__b:'+dm_to_string(float(self.latt_parm[1]))
       printf,unit,'latt__c:'+dm_to_string(float(self.latt_parm[2]))
       printf,unit,'latt_aa:'+dm_to_string(float(self.latt_parm[3]))
       printf,unit,'latt_bb:'+dm_to_string(float(self.latt_parm[4]))
       printf,unit,'latt_cc:'+dm_to_string(float(self.latt_parm[5]))
       printf,unit,'orie_ux:'+dm_to_string(self.orie_u[0])
       printf,unit,'orie_uy:'+dm_to_string(self.orie_u[1])
       printf,unit,'orie_uz:'+dm_to_string(self.orie_u[2])
       printf,unit,'orie_vx:'+dm_to_string(self.orie_v[0])
       printf,unit,'orie_vy:'+dm_to_string(self.orie_v[1])
       printf,unit,'orie_vz:'+dm_to_string(self.orie_v[2])
       printf,unit,'lockluv:'+dm_to_string(self.locklattuv,/int)
       printf,unit,'chckluv:'+dm_to_string(self.checklattuv,/int)
       printf,unit,'oriepsi:'+dm_to_string(self.orie_psi,resolution=3)
       printf,unit,'orieoff:'+dm_to_string(self.orie_offset,resolution=3)
       printf,unit,'foldtyp:'+dm_to_string(self.fold_type,/int)
       printf,unit,'num_rot:'+dm_to_string(self.numrot_optn,/int)
       printf,unit,'statvec:'+dm_to_string(self.symrot_startvec)
       printf,unit,'view1tp:'+dm_to_string(self.view_u1typ,/int)
       printf,unit,'view2tp:'+dm_to_string(self.view_u2typ,/int)
       printf,unit,'viewu1h:'+dm_to_string(self.view_u1[0])
       printf,unit,'viewu1k:'+dm_to_string(self.view_u1[1])
       printf,unit,'viewu1l:'+dm_to_string(self.view_u1[2])
       printf,unit,'view1lb:'+self.view_u1lab[0]+'&'+self.view_u1lab[1]
       printf,unit,'viewu1f:'+dm_to_string(self.view_u1fold,/int)
       printf,unit,'viewu1d:'+dm_to_string(*(self.view_u1folddir),/int,separator='&')
       printf,unit,'viewu1c:'+dm_to_string(*(self.view_u1foldcenter),separator='&')
       printf,unit,'viewu2h:'+dm_to_string(self.view_u2[0])
       printf,unit,'viewu2k:'+dm_to_string(self.view_u2[1])
       printf,unit,'viewu2l:'+dm_to_string(self.view_u2[2])
       printf,unit,'view2lb:'+self.view_u2lab[0]+'&'+self.view_u2lab[1]
       printf,unit,'viewu2f:'+dm_to_string(self.view_u2fold,/int)
       printf,unit,'viewu2d:'+dm_to_string(*(self.view_u2folddir),/int,separator='&')
       printf,unit,'viewu2c:'+dm_to_string(*(self.view_u2foldcenter),separator='&')
       printf,unit,'viewu3h:'+dm_to_string(self.view_u3[0])
       printf,unit,'viewu3k:'+dm_to_string(self.view_u3[1])
       printf,unit,'viewu3l:'+dm_to_string(self.view_u3[2])
       printf,unit,'view3lb:'+self.view_u3lab
       printf,unit,'viewu3f:'+dm_to_string(self.view_u3fold,/int)
       printf,unit,'viewu3d:'+dm_to_string(*(self.view_u3folddir),/int,separator='&')
       printf,unit,'viewu3c:'+dm_to_string(*(self.view_u3foldcenter),separator='&')
       printf,unit,'d4selx1:'+dm_to_string(self.d4sel_x1,/int,separator='&')
       printf,unit,'d4selx2:'+dm_to_string(self.d4sel_x2,/int,separator='&')
       printf,unit,'d4selx3:'+dm_to_string(self.d4sel_x3,/int,separator='&')
       printf,unit,'d4selx4:'+dm_to_string(self.d4sel_x4,/int,separator='&')
       printf,unit,'d4selt1:'+dm_to_string(self.d4sel_t1,/int,separator='&')
       printf,unit,'d4selt2:'+dm_to_string(self.d4sel_t2,/int,separator='&')
       printf,unit,'d4s_t1r:'+dm_to_string(self.d4sel_tft1,separator='&')
       printf,unit,'d4s_t2r:'+dm_to_string(self.d4sel_tft2,separator='&')
       printf,unit,'d4s_x1r:'+dm_to_string(self.d4_x1ran,separator='&')
       printf,unit,'d4s_x2r:'+dm_to_string(self.d4_x2ran,separator='&')
       printf,unit,'d4s_x3r:'+dm_to_string(self.d4_x3ran,separator='&')
       printf,unit,'d4s_x4r:'+dm_to_string(self.d4_x4ran,separator='&')
       printf,unit,'d4s_x1s:'+dm_to_string(self.d4_x1step)
       printf,unit,'d4s_x2s:'+dm_to_string(self.d4_x2step)
       printf,unit,'d4s_x3s:'+dm_to_string(self.d4_x3step)
       printf,unit,'d4s_x4s:'+dm_to_string(self.d4_x3step)
       printf,unit,'vol__t1:'+dm_to_string(self.volsel_t1,/int,separator='&')
       printf,unit,'vol__t2:'+dm_to_string(self.volsel_t2,/int,separator='&')
       printf,unit,'vol__t3:'+dm_to_string(self.volsel_t3,/int,separator='&')
       printf,unit,'vol_t1r:'+dm_to_string(self.volsel_tft1,separator='&')
       printf,unit,'vol_t2r:'+dm_to_string(self.volsel_tft2,separator='&')
       printf,unit,'vol_t3r:'+dm_to_string(self.volsel_tft3,separator='&')
       printf,unit,'disp_t1:'+dm_to_string(self.slice_t1,/int,separator='&')
       printf,unit,'disp_t2:'+dm_to_string(self.slice_t2,/int,separator='&')
       printf,unit,'disp_t3:'+dm_to_string(self.slice_t3,/int,separator='&')
       printf,unit,'disp_t4:'+dm_to_string(self.slice_t4,/int,separator='&')
       printf,unit,'dispt1r:'+dm_to_string(self.slice_t1ran,separator='&')
       printf,unit,'dispt2r:'+dm_to_string(self.slice_t2ran,separator='&')
       printf,unit,'dispt3r:'+dm_to_string(self.slice_t3ran,separator='&')
       printf,unit,'dispt4r:'+dm_to_string(self.slice_t4ran,separator='&')
       printf,unit,'cut__t1:'+dm_to_string(self.cut_t1,/int,separator='&')
       printf,unit,'cut__t2:'+dm_to_string(self.cut_t2,/int,separator='&')
       printf,unit,'cut__t3:'+dm_to_string(self.cut_t3,/int,separator='&')
       printf,unit,'cut__t4:'+dm_to_string(self.cut_t4,/int,separator='&')
       printf,unit,'cut__t5:'+dm_to_string(self.cut_t5,/int,separator='&')
       printf,unit,'cut_t1r:'+dm_to_string(self.cut_t1ran,separator='&')
       printf,unit,'cut_t2r:'+dm_to_string(self.cut_t2ran,separator='&')
       printf,unit,'cut_t3r:'+dm_to_string(self.cut_t3ran,separator='&')
       printf,unit,'cut_t4r:'+dm_to_string(self.cut_t4ran,separator='&')
       printf,unit,'cut_t5r:'+dm_to_string(self.cut_t5ran,separator='&')
       printf,unit,'traj__x:'+dm_to_string(self.traj_x,/int,separator='&')
       printf,unit,'traj_xr:'+dm_to_string(self.traj_xran,separator='&')
       printf,unit,'traj__y:'+dm_to_string(self.traj_y,/int,separator='&')
       printf,unit,'traj_yr:'+dm_to_string(self.traj_yran,separator='&')
       printf,unit,'traj_z1:'+dm_to_string(self.traj_z1,/int,separator='&')
       printf,unit,'trajz1r:'+dm_to_string(self.traj_z1ran,separator='&')
       printf,unit,'traj_z2:'+dm_to_string(self.traj_z2,/int,separator='&')
       printf,unit,'trajz2r:'+dm_to_string(self.traj_z2ran,separator='&')
       printf,unit,'m___jqy:'+dm_to_string(self.mjqy)
       printf,unit,'eief___:'+dm_to_string(self.eief)
       printf,unit,'estaend:'+dm_to_string(self.estartend,separator='&')
       printf,unit,'phxfile:'+self.phxfile
       printf,unit,'userfun:'+self.userf_str
       printf,unit,'userfbf:'+dm_to_string(self.userf_before,/int)
       for i=0,self.n_history-1 do begin
           file_hist = (*(self.file_hist[i]))[0]
           for j=1,n_elements(*(self.file_hist[i]))-1 do file_hist=file_hist+string('A4'xb)+(*(self.file_hist[i]))[j]
           printf,unit,'history:'+file_hist
       endfor
       if keyword_set(session) then begin
          nfile_hist = total(ptr_valid(self.file_hist[13:*]))
          for i=13,13+nfile_hist-1 do begin
              file_hist = (*(self.file_hist[i]))[0]
              for j=1,n_elements(*(self.file_hist[i]))-1 do file_hist=file_hist+string('A4'xb)+(*(self.file_hist[i]))[j]
              printf,unit,(['addfile:','loadfil:'])[i eq 13]+file_hist
          endfor
          for i=0,2 do begin
              if ptr_valid(self.file_hist[10+i]) then begin
                 file_hist = (*(self.file_hist[10+i]))[0]
                 for j=1,n_elements(*(self.file_hist[10+i]))-1 do file_hist=file_hist+string('A4'xb)+(*(self.file_hist[10+i]))[j]
                 printf,unit,'empfil'+dm_to_string(i,/int)+':'+file_hist
              endif
          endfor
       endif
    endelse
    free_lun,unit
end