; $Id: dm_plot_volume.pro,v 1.26 2016/03/31 17:01:38 ymqiu Exp $
;#######################################################################
;
; NAME:
;  dm_plot_volume
;
; PURPOSE:
;  plot the volume
;
; CATEGORY:
;  dcs_mslice
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-6102
;  United States
;  yiming.qiu@nist.gov
;  March, 2025
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

pro dcs_mslice::dm_plot_volume,overplot=overplot
    if (~ self->pd_valid()) then return
    WIDGET_CONTROL,/HOURGLASS
    
    ;select data
    if (~self.errbar) or ((self.samp_typ ge 0) and self.absp_asint) then begin
       self->dm_choose_volumedata,xdat=xdat,ydat=ydat,zdat=zdat,idat=idat,xinfo=xinfo,xtit=xtit,yinfo=yinfo,ytit=ytit,zinfo=zinfo,ztit=ztit,iran=iran,itit=itit,extra_tit=extra_tit,$
             iso3dtype=iso3dtype,error=error 
    endif else begin
       self->dm_choose_volumedata,xdat=xdat,ydat=ydat,zdat=zdat,idat=idat,ierr=ierr,xinfo=xinfo,xtit=xtit,yinfo=yinfo,ytit=ytit,zinfo=zinfo,ztit=ztit,iran=iran,itit=itit,extra_tit=extra_tit,$
             iso3dtype=iso3dtype,error=error
    endelse
    if keyword_set(error) then return
 
    ;extra info in the title
    if (strlen(self.titl_lab) eq 0) or (strlen(extra_tit) eq 0) then sep='' else sep=', '
    title = self.titl_lab+sep+extra_tit
    
    ;plot the data
    isnew = 0b
    if self.useitool then begin
       ok = dialog_message('Itools plotting is not implemented yet. Soooorry!',dialog_parent=self.tlb)
       return
    endif else begin
       self.current = self->searchcurrent(crossplot=crossplot,keep=keep)
       if (~obj_valid(self.current)) or (keyword_set(crossplot) and (~keyword_set(overplot))) or keyword_set(keep) then begin
          self.current = obj_new('dm_plot',xdat,ydat,zdat,idat,ierr=ierr,xtit=xtit,ytit=ytit,ztit=ztit,itit=itit,xsize=(*self.pdim_list)[0,self.pdim_choice],ysize=(*self.pdim_list)[1,self.pdim_choice],$
                /no_copy,parentobj=self,xran=self.vol_xran,yran=self.vol_yran,zran=self.vol_zran,iran=iran,interpolate=self.vol_interp,coltable=self.vol_color,title=title,/hidelegend,path=self.dirs[1],$
                background=(['black','white'])[self.pbgcol_bw],vt_col=self.ppvc_choice,render_method=self.ptrm_choice,tickdir=self.tdir_choice,notooltip=self.pnotooltip,/isolatin1,iso3dtype=iso3dtype,$
                xinfo=xinfo,yinfo=yinfo,zinfo=zinfo,qoffsetthreshold=self.qoffsetthreshold,wtitle='Volume')
          isnew = 1b & crossplot = 0b
       endif else begin
          if keyword_set(overplot) then $
             self.current->add_plot,xdat,ydat,zdat,idat,ierr=ierr,itit=itit,/no_copy,iran=iran,interpolate=self.vol_interp,coltable=self.vol_color $
          else $
             self.current->setproperty,xdat=xdat,ydat=ydat,zdat=zdat,idat=idat,ierr=ierr,xtit=xtit,ytit=ytit,ztit=ztit,itit=itit,/no_copy,xran=self.vol_xran,yran=self.vol_yran,$
                zran=self.vol_zran,iran=iran,interpolate=self.vol_interp,coltable=self.vol_color,title=title,/nodraw,/hidelegend,bgcolor=self.pbgcol_bw,vt_col=self.ppvc_choice,$
                tickdir=self.tdir_choice,xinfo=xinfo,yinfo=yinfo,zinfo=zinfo,qoffsetthreshold=self.qoffsetthreshold,iso3dtype=iso3dtype,wtitle='Volume'
       endelse
       if obj_valid(self.current) then self.current->draw else return
    endelse

    if ~keyword_set(crossplot) then begin
       title = ((strlen(self.titl_lab) eq 0)?xtit+' vs. '+ytit+' vs. '+ztit:title)
       if keyword_set(overplot) and (~isnew) then $
          self->dm_add_plotwindow,type=3,title=title+'[overplot]' $
       else $
          self->dm_add_plotwindow,type=3,title=title
    endif
end