; $Id$
;#######################################################################
;
; NAME:
;  dm_locate_datastrptr
;
; PURPOSE:
;  find the dataStrPtr from a dave pointer
;
; CATEGORY:
;  dave
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-8562
;  United States
;  yiming.qiu@nist.gov
;  Feb, 2005
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

function dm_locate_datastrptr,this
    dataStrPtr=0    ;initialize to a nonpointer value
    tmp=ptr_valid(this)
    ;if this is a pointer
    if tmp eq 1 then begin
       nfield=n_tags(*this)
       if nfield gt 0 then begin
         field=tag_names(*this)
         loc  =where(strupcase(field) eq 'DATASTRPTR',count)
         if count ne 0 then return, (*this).(loc[0]) $
         else begin
          for i=0,nfield-1 do begin
              dataStrPtr=call_function("dm_locate_datastrptr",(*this).(i))
              if ptr_valid(dataStrPtr) then break
          endfor
         endelse
       endif
    endif else begin
       nfield=n_tags(this)
       if nfield gt 0 then begin
         field=tag_names(this)
         for i=0,nfield-1 do begin
          dataStrPtr=call_function("dm_locate_datastrptr",this.(i))
          if ptr_valid(dataStrPtr) then break
         endfor
       endif
    endelse
    return,dataStrPtr
end