; $Id$
;#######################################################################
;
; NAME:
;  dm_load_detpos
;
; PURPOSE:
;  load detector information
;  returns a pointer points to a structure{two_theta:tth,dtwo_theta:dtth,psi:psi,dpsi:dpsi}
;
; CATEGORY:
;  dcs
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-6102
;  United States
;  yiming.qiu@nist.gov
;  March, 2011
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

; returns a pointer points to a structure{two_theta:tth,dtwo_theta:dtth,psi:psi,dpsi:dpsi}
; keywords:
;   dcs:       if set, load dcs  instrument detector info
;   adjust2th: if set, made adjustment to the dcs and wand 2theta to take into account the length of the detector
;   neat:      if set, load neat instrument detector info
;   macs:      if set, load macs instrument detector info
;   wand:      if set, load SNS wand instrument detector info     

function dm_load_detpos,dcs=dcs,adjust2th=adjust2th,macs=macs,neat=neat,wand=wand
    if keyword_set(dcs) then begin  ;load dcs detector info
       tth = [-5.02,   5.02,  -5.51,   5.51,  -6.00,   6.00,  -6.49,   6.49,  -6.98,   6.98,  -7.47,   7.47,  -7.96,   7.96,  -8.45,$
               8.45,  -8.94,   8.94,  -9.43,   9.43,  -9.92,   9.92, -10.01,  10.01, -10.01,  10.01, -10.41,  10.41, -10.81,  10.81,$
             -10.81,  10.81, -10.90,  10.90, -11.39,  11.39, -11.53,  11.53, -11.53,  11.53, -11.88,  11.88, -12.20,  12.20, -12.20,$
              12.20, -12.37,  12.37, -12.84,  12.84, -12.84,  12.84, -12.86,  12.86, -13.35,  13.35, -13.46,  13.46, -13.46,  13.46,$
             -13.84,  13.84, -14.07,  14.07, -14.07,  14.07, -14.33,  14.33, -14.66,  14.66, -14.66,  14.66, -14.82,  14.82, -15.24,$
              15.24, -15.24,  15.24, -15.31,  15.31, -15.80,  15.80, -15.81,  15.81, -15.81,  15.81, -16.29,  16.29, -16.38,  16.38,$
             -16.38,  16.38, -16.78,  16.78, -16.94,  16.94, -16.94,  16.94, -17.27,  17.27, -17.49,  17.49, -17.49,  17.49, -17.76,$
              17.76, -18.04,  18.04, -18.04,  18.04, -18.25,  18.25, -18.58,  18.58, -18.58,  18.58, -18.74,  18.74, -19.12,  19.12,$
             -19.12,  19.12, -19.23,  19.23, -19.66,  19.66, -19.66,  19.66, -19.72,  19.72, -20.19,  20.19, -20.19,  20.19, -20.21,$
              20.21, -20.70,  20.70, -20.72,  20.72, -20.72,  20.72, -21.19,  21.19, -21.25,  21.25, -21.25,  21.25, -21.68,  21.68,$
             -21.78,  21.78, -21.78,  21.78, -22.17,  22.17, -22.31,  22.31, -22.31,  22.31, -22.66,  22.66, -22.83,  22.83, -22.83,$
              22.83, -23.15,  23.15, -23.35,  23.35, -23.35,  23.35, -23.64,  23.64, -23.87,  23.87, -23.87,  23.87, -24.13,  24.13,$
             -24.39,  24.39, -24.39,  24.39, -24.62,  24.62, -24.91,  24.91, -24.91,  24.91, -25.11,  25.11, -25.43,  25.43, -25.43,$
              25.43, -25.60,  25.60, -25.95,  25.95, -25.95,  25.95, -26.09,  26.09, -26.46,  26.46, -26.46,  26.46, -26.58,  26.58,$
             -26.97,  26.97, -26.97,  26.97, -27.07,  27.07, -27.48,  27.48, -27.48,  27.48, -27.56,  27.56, -27.99,  27.99, -27.99,$
              27.99, -28.05,  28.05, -28.50,  28.50, -28.50,  28.50, -28.54,  28.54, -29.01,  29.01, -29.01,  29.01, -29.03,  29.03,$
             -29.52,  29.52, -29.52,  29.52, -29.52,  29.52,  30.03,  30.03,  30.03,  30.54,  30.54,  30.54,  31.05,  31.05,  31.05,$
              31.56,  31.56,  31.56,  32.07,  32.07,  32.07,  32.58,  32.58,  32.58,  33.09,  33.09,  33.09,  33.59,  33.59,  33.59,$
              34.09,  34.09,  34.09,  34.59,  34.59,  34.59,  35.09,  35.09,  35.09,  35.59,  35.59,  35.59,  36.09,  36.09,  36.09,$
              36.59,  36.59,  36.59,  37.09,  37.09,  37.09,  37.59,  37.59,  37.59,  38.09,  38.09,  38.09,  38.59,  38.59,  38.59,$
              39.09,  39.09,  39.09,  39.59,  39.59,  39.59,  40.09,  40.09,  40.09,  40.59,  40.59,  40.59,  41.09,  41.09,  41.09,$
              41.59,  41.59,  41.59,  42.09,  42.09,  42.09,  42.59,  42.59,  42.59,  43.09,  43.09,  43.09,  43.59,  43.59,  43.59,$
              44.09,  44.09,  44.09,  44.59,  44.59,  44.59,  45.09,  45.09,  45.09,  45.59,  45.59,  45.59,  46.09,  46.09,  46.09,$
              46.59,  46.59,  46.59,  47.09,  47.09,  47.09,  47.59,  47.59,  47.59,  48.09,  48.09,  48.09,  48.59,  48.59,  48.59,$
              49.09,  49.09,  49.09,  49.59,  49.59,  49.59,  50.09,  50.09,  50.09,  50.59,  50.59,  50.59,  51.09,  51.09,  51.09,$
              51.59,  51.59,  51.59,  52.09,  52.09,  52.09,  52.59,  52.59,  52.59,  53.09,  53.09,  53.09,  53.59,  53.59,  53.59,$
              54.09,  54.09,  54.09,  54.59,  54.59,  54.59,  55.09,  55.09,  55.09,  55.59,  55.59,  55.59,  56.09,  56.09,  56.09,$
              56.59,  56.59,  56.59,  57.09,  57.09,  57.09,  57.59,  57.59,  57.59,  58.09,  58.09,  58.09,  58.59,  58.59,  58.59,$
              59.09,  59.09,  59.09,  59.59,  59.59,  59.59,  60.09,  60.09,  60.09,  60.59,  60.59,  60.59,  61.09,  61.09,  61.09,$
              61.58,  61.58,  61.58,  62.07,  62.07,  62.07,  62.56,  62.56,  62.56,  63.05,  63.05,  63.05,  63.54,  63.54,  63.54,$
              64.03,  64.03,  64.03,  64.52,  64.52,  64.52,  65.01,  65.01,  65.01,  65.50,  65.50,  65.50,  65.99,  65.99,  65.99,$
              66.48,  66.48,  66.48,  66.97,  66.97,  66.97,  67.46,  67.46,  67.46,  67.95,  67.95,  67.95,  68.44,  68.44,  68.44,$
              68.93,  68.93,  68.93,  69.42,  69.42,  69.42,  69.91,  69.91,  69.91,  70.40,  70.40,  70.40,  70.89,  70.89,  70.89,$
              71.38,  71.38,  71.38,  71.87,  71.87,  71.87,  72.36,  72.36,  72.36,  72.85,  72.85,  72.85,  73.34,  73.34,  73.34,$
              73.83,  73.83,  73.83,  74.32,  74.32,  74.32,  74.81,  74.81,  74.81,  75.30,  75.30,  75.30,  75.79,  75.79,  75.79,$
              76.28,  76.28,  76.28,  76.77,  76.77,  76.77,  77.26,  77.26,  77.26,  77.75,  77.75,  77.75,  78.24,  78.24,  78.24,$
              78.73,  78.73,  78.73,  79.22,  79.22,  79.22,  79.71,  79.71,  79.71,  80.20,  80.20,  80.20,  80.69,  80.69,  80.69,$
              81.18,  81.18,  81.18,  81.67,  81.67,  81.67,  82.16,  82.16,  82.16,  82.65,  82.65,  82.65,  83.14,  83.14,  83.14,$
              83.63,  83.63,  83.63,  84.12,  84.12,  84.12,  84.61,  84.61,  84.61,  85.10,  85.10,  85.10,  85.59,  85.59,  85.59,$
              86.08,  86.08,  86.08,  86.57,  86.57,  86.57,  87.06,  87.06,  87.06,  87.55,  87.55,  87.55,  88.04,  88.04,  88.04,$
              88.53,  88.53,  88.53,  89.02,  89.02,  89.02,  89.51,  89.51,  89.51,  90.00,  90.00,  90.00,  90.49,  90.49,  90.49,$
              90.98,  90.98,  90.98,  91.47,  91.47,  91.47,  91.96,  91.96,  91.96,  92.45,  92.45,  92.45,  92.94,  92.94,  92.94,$
              93.43,  93.43,  93.43,  93.92,  93.92,  93.92,  94.41,  94.41,  94.41,  94.90,  94.90,  94.90,  95.39,  95.39,  95.39,$
              95.88,  95.88,  95.88,  96.37,  96.37,  96.37,  96.86,  96.86,  96.86,  97.35,  97.35,  97.35,  97.84,  97.84,  97.84,$
              98.33,  98.33,  98.33,  98.82,  98.82,  98.82,  99.31,  99.31,  99.31,  99.80,  99.80,  99.80, 100.29, 100.29, 100.29,$
             100.78, 100.78, 100.78, 101.27, 101.27, 101.27, 101.76, 101.76, 101.76, 102.25, 102.25, 102.25, 102.74, 102.74, 102.74,$
             103.23, 103.23, 103.23, 103.72, 103.72, 103.72, 104.21, 104.21, 104.21, 104.70, 104.70, 104.70, 105.19, 105.19, 105.19,$
             105.68, 105.68, 105.68, 106.17, 106.17, 106.17, 106.66, 106.66, 106.66, 107.15, 107.15, 107.15, 107.64, 107.64, 107.64,$
             108.13, 108.13, 108.13, 108.62, 108.62, 108.62, 109.11, 109.11, 109.11, 109.60, 109.60, 109.60, 110.09, 110.09, 110.09,$
             110.58, 110.58, 110.58, 111.07, 111.07, 111.07, 111.56, 111.56, 111.56, 112.05, 112.05, 112.05, 112.54, 112.54, 112.54,$
             113.03, 113.03, 113.03, 113.52, 113.52, 113.52, 114.01, 114.01, 114.01, 114.50, 114.50, 114.50, 114.99, 114.99, 114.99,$
             115.48, 115.48, 115.48, 115.97, 115.97, 115.97, 116.46, 116.46, 116.46, 116.95, 116.95, 116.95, 117.44, 117.44, 117.44,$
             117.93, 117.93, 117.93, 118.42, 118.42, 118.42, 118.91, 118.91, 118.91, 119.41, 119.41, 119.41, 119.91, 119.91, 119.91,$
             120.41, 120.41, 120.41, 120.91, 120.91, 120.91, 121.41, 121.41, 121.41, 121.91, 121.91, 121.91, 122.41, 122.41, 122.41,$
             122.91, 122.91, 122.91, 123.41, 123.41, 123.41, 123.91, 123.91, 123.91, 124.41, 124.41, 124.41, 124.91, 124.91, 124.91,$
             125.41, 125.41, 125.41, 125.91, 125.91, 125.91, 126.41, 126.41, 126.41, 126.91, 126.91, 126.91, 127.41, 127.41, 127.41,$
             127.91, 127.91, 127.91, 128.41, 128.41, 128.41, 128.91, 128.91, 128.91, 129.41, 129.41, 129.41, 129.91, 129.91, 129.91,$
             130.41, 130.41, 130.41, 130.91, 130.91, 130.91, 131.41, 131.41, 131.41, 131.91, 131.91, 131.91, 132.41, 132.41, 132.41,$
             132.91, 132.91, 132.91, 133.41, 133.41, 133.41, 133.91, 133.91, 133.91, 134.41, 134.41, 134.41, 134.91, 134.91, 134.91,$
             135.41, 135.41, 135.41, 135.91, 135.91, 135.91, 136.41, 136.41, 136.41, 136.91, 136.91, 136.91, 137.41, 137.41, 137.41,$
             137.91, 137.91, 137.91, 138.41, 138.41, 138.41, 138.91, 138.91, 138.91, 139.41, 139.41, 139.41, 139.91]
       ntth = n_elements(tth)
       if keyword_set(adjust2th) then begin
          negid    = where(tth lt 0,negcnt)
          dsd      = 4010.0
          hheight  = 10.0+findgen(10)*20.0  ;40cm detector length
          distance = sqrt(dsd^2+hheight^2)
          x        = dsd*cos(abs(tth)*!dtor)
          y        = dsd*sin(abs(tth)*!dtor)
          tth      = acos(x#(fltarr(10)+1)/((fltarr(ntth)+1)#distance))*!radeg
          tth      = total(tth,2)/10
          if negcnt ne 0 then tth[negid] = tth[negid]*(-1.)
       endif
       dtth = fltarr(ntth) & dtth[*] = 0.5
       psi  = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1,$
               1, 1, 0, 0, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0, 0, 0,-1,-1, 1, 1,$
               0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1,$
               1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1,$
               1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,$
              -1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,$
              -1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,$
              -1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,$
              -1,-1, 0, 0, 1, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
              -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1, 0]*7.6285  ;from file "placement of detectors for TOF" or asin(531./4000)/!dtor
       dpsi = fltarr(n_elements(psi))+6.0
    endif
    if keyword_set(neat) then begin
       tth = [13.35,  14.12,  14.88,  15.65,  16.85,  17.62,  18.38,  19.15,  20.35,  21.12,  21.88,  22.65,  23.85,  24.62,  25.38, $
              26.15,  27.75,  28.52,  29.28,  30.05,  31.65,  32.42,  33.18,  33.95,  35.55,  36.32,  37.08,  37.85,  39.45,  40.22, $
              40.98,  41.75,  43.05,  43.82,  44.58,  45.35,  46.55,  47.32,  48.08,  48.85,  50.35,  51.12,  51.88,  52.65,  53.85, $
              54.62,  55.38,  56.15,  57.35,  58.12,  58.88,  59.65,  60.85,  61.62,  62.38,  63.15,  64.25,  65.02,  65.78,  66.55, $
              67.65,  68.42,  69.18,  69.95,  71.45,  72.22,  72.98,  73.75,  74.85,  75.62,  76.38,  77.15,  78.35,  79.12,  79.88, $
              80.65,  81.85,  82.62,  83.38,  84.15,  85.25,  86.02,  86.78,  87.55,  89.05,  89.82,  90.58,  91.35,  92.45,  93.22, $
              93.98,  94.75,  95.85,  96.62,  97.38,  98.15,  99.25, 100.02, 100.78, 101.55, 102.65, 103.42, 104.18, 104.95, 106.05, $
             106.82, 107.58, 108.35, 109.85, 110.62, 111.38, 112.15, 113.35, 114.12, 114.88, 115.65, 116.85, 117.62, 118.38, 119.15, $
             120.35, 121.12, 121.88, 122.65, 123.85, 124.62, 125.38, 126.15, 127.35, 128.12, 128.88, 129.65, 130.85, 131.62, 132.38, $
             133.15, 134.35, 135.12, 135.88, 136.65]
       dtth = fltarr(n_elements(tth))+0.5 & psi = dtth*0.0 & dpsi = psi
    endif
    if keyword_set(macs) then begin
       tth  = findgen(20)*8.0           ;8 degree each channel
       dtth = (fltarr(20)+1.0)*1.0      ;2 degree horizontal divergence
       psi  = fltarr(20)
       dpsi = (fltarr(20)+1.0)*4.0      ;8 degree vertical divergence
    endif
    if keyword_set(wand) then begin
       ntth = 640
       tth  = 11.236+findgen(ntth)*0.2
       dtth = fltarr(ntth)+0.2     
       psi  = fltarr(ntth)
       dpsi = fltarr(ntth)
       if keyword_set(adjust2th) then begin
          dsd      = 710.0
          hheight  = 5.0+findgen(10)*10.0 ;20cm detector length
          distance = sqrt(dsd^2+hheight^2)
          x        = dsd*cos(abs(tth)*!dtor)
          y        = dsd*sin(abs(tth)*!dtor)
          tth      = acos(x#(fltarr(10)+1)/((fltarr(ntth)+1)#distance))*!radeg
          tth      = total(tth,2)/10
       endif
       tth  = -tth   ;use DCS definition
    endif
    if n_elements(tth) ne 0 then $
       detPtr = ptr_new({two_theta:temporary(tth),dtwo_theta:temporary(dtth),psi:temporary(psi),dpsi:temporary(dpsi)}) $
    else $
       detPtr = ptr_new()
    return,temporary(detPtr)
end