; $Id: $
;#######################################################################
;
; NAME:
;  dm_choose_cutdata
;
; PURPOSE:
;  choose cut data
;
; CATEGORY:
;  dcs_mslice
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-6102
;  United States
;  yiming.qiu@nist.gov
;  April, 2023
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

; parameters:
;   None
; keywords:
;   xdat,ydat,yerr: data to be returned
;   a3,a4:          for macs only, only when self.macs_savea4=1b
;   (xy)tit:        label of the data
;   extra_tit:      extra title info
;   extra_legd:     extra legend info
;   weight:         weight for avgsum=-1
pro dcs_mslice::dm_choose_cutdata,xdat=xdat,ydat=ydat,yerr=yerr,a3=a3,a4=a4,xtit=xtit,ytit=ytit,is_E_t=is_E_t,$
    tran_invalid=tran_invalid,extra_tit=extra_tit,extra_legd=extra_legd,error=error,weight=weight,debug=debug
    if keyword_set(debug) then begin
       print,'^^choose cut data...'
       current=systime(/sec)
    endif
    
    extra_tit  = ''
    extra_legd = ''
    
    ;weight
    if ((self.cut_y[0>(self.samp_typ)] eq 0) and (self.bin_avgsum eq -1)) or ((self.instrname eq 'macs') and keyword_set(self.macshistomode) and self.macs_rawintn) then self->dm_choose_trajdata,-4,data=weight
  
    if self.samp_typ eq -1 then begin
       ok_ewid = 0b
       nitem   = n_elements((*self.dataPtr).label)
       tran_invalid = bytarr(nitem-3)
       
       ;xdat
       self->dm_choose_trajdata,self.cut_x[0]+2,data=xdat,title=xtit,is_E=is_E_x,is_hkl=is_hkl,hkl_info=hkl_info
       if is_E_x then begin
          if ~finite(self.cut_step) then begin
             uniq_E = xdat
          endif else begin
             if self.cut_step eq 0 then uniq_E = xdat
          endelse
       endif
       if is_hkl then qoffset = 0.

       ;ydat
       if arg_present(yerr) then $ 
          self->dm_choose_trajdata,((self.cut_y[0] eq 0)?-1:(self.cut_y[0]+1)),data=ydat,error=yerr,title=ytit $
       else $
          self->dm_choose_trajdata,((self.cut_y[0] eq 0)?-1:(self.cut_y[0]+1)),data=ydat,title=ytit
       
       ndat = n_elements(xdat)
       ;thickness
       for i=0,nitem-4 do begin
           is_hkl_t = 0b
           if (total(finite((*self.cutsel_tft)[i,*])) ne 0) then begin
              self->dm_choose_trajdata,(*self.cutsel_t)[i]+2,index=index1,range=reform((*self.cutsel_tft)[i,*]),empty=empty,debug=debug,unit=unit,label=label,is_hkl=is_hkl_t,hkl_info=hkl_info_t
              if empty then begin
                 if n_elements(emptyitem) eq 0 then emptyitem = label $
                 else emptyitem = emptyitem+' and '+label
                 index1 = -1 & tmp = temporary(index1)
                 tran_invalid[i] = 1b
              endif else if n_elements(index1) eq ndat then begin
                 index1 = -1 & tmp = temporary(index1)
              endif else begin
                 if n_elements(index) eq 0 then index = index1 $
                 else begin
                    index = dm_common(index,index1,/no_copy)
                 endelse
              endelse
              if ~tran_invalid[i] then begin
                 extra_legd = self->range_string(extra_legd,label,(*self.cutsel_tft)[i,*],unit)
                 if is_hkl_t and (total(finite((*self.cutsel_tft)[i,*],/nan)) eq 0) and (n_elements(qoffset) ne 0) then begin
                    if (abs((*self.cutsel_tft)[i,1]-(*self.cutsel_tft)[i,0]) le self.qoffsetthreshold) then qoffset = qoffset+hkl_info_t.vaxis*mean((*self.cutsel_tft)[i,*])
                 endif 
              endif
           endif
       endfor
    endif else begin
       is_E_t = bytarr(5)
       tran_invalid = bytarr(5)

       ;ewid
       if self.eint_yn and (self.samp_typ ne 2) and (self.cut_y[self.samp_typ] eq 0) then begin
          self->dm_choose_trajdata,-2,data=ewid
          emax = max((*self.projStrPtr).en,min=emin)
          dE   = emax-emin    ;default energy integration width
       endif
       ok_ewid = (n_elements(ewid) ne 0)

       ;xdat
       self->dm_choose_trajdata,self.cut_x[self.samp_typ],data=xdat,title=xtit,is_E=is_E_x,is_hkl=is_hkl,hkl_info=hkl_info
       if is_E_x then uniq_E = xdat[*,0,0] 
       if is_hkl then qoffset = 0.
       
       ndat = n_elements(xdat)
        
       check_fold = bytarr(10) ;u1,u2,u3,E,T,H,...
       is_fold2 = ((self.samp_typ gt 0) and (self.fold_type eq 1))
       is_u3 = ((self.extravaxis_yn[0]) and (self.instrname ne 'macs') and (self.instrname ne 'wand'))
       check_fold[0] = (is_fold2 and self.view_u1fold and finite((*(self.view_u1foldcenter))[0]))
       check_fold[1] = (is_fold2 and self.view_u2fold and finite((*(self.view_u2foldcenter))[0]))
       check_fold[2] = (is_fold2 and is_u3 and self.view_u3fold and finite((*(self.view_u3foldcenter))[0]))
       fold_center = [(*(self.view_u1foldcenter))[0],(*(self.view_u2foldcenter))[0],(*(self.view_u3foldcenter))[0],fltarr(7)] 
       
       ;thickness
       ;t1
       if total(finite(self.cut_t1ran)) ne 0 then begin
          self->dm_check_thickness,self.cut_t1[self.samp_typ],range=self.cut_t1ran,ndat=ndat,index=index1,is_E=is_E,traninvalid=traninvalid,emptyitem=emptyitem,$
              extra_tit=extra_legd,checkfold=check_fold[self.cut_t1[self.samp_typ]],foldcenter=fold_center[self.cut_t1[self.samp_typ]],qoffset=qoffset,debug=debug
          is_E_t[0] = is_E
          tran_invalid[0] = traninvalid
       endif
       ;t2
       if self.disp_flag[2] and (total(finite(self.cut_t2ran)) ne 0) then begin
          self->dm_check_thickness,self.cut_t2[self.samp_typ],range=self.cut_t2ran,ndat=ndat,index=index2,is_E=is_E,traninvalid=traninvalid,emptyitem=emptyitem,$
              extra_tit=extra_legd,checkfold=check_fold[self.cut_t2[self.samp_typ]],foldcenter=fold_center[self.cut_t2[self.samp_typ]],qoffset=qoffset,debug=debug
          is_E_t[1] = is_E
          tran_invalid[1] = traninvalid
       endif
       ;t3
       if self.disp_flag[3] and (total(finite(self.cut_t3ran)) ne 0) then begin
          self->dm_check_thickness,self.cut_t3[self.samp_typ],range=self.cut_t3ran,ndat=ndat,index=index3,is_E=is_E,traninvalid=traninvalid,emptyitem=emptyitem,$
              extra_tit=extra_legd,checkfold=check_fold[self.cut_t3[self.samp_typ]],foldcenter=fold_center[self.cut_t3[self.samp_typ]],qoffset=qoffset,debug=debug
          is_E_t[2] = is_E
          tran_invalid[2] = traninvalid
       endif
       ;t4
       if self.disp_flag[4] and (total(finite(self.cut_t4ran)) ne 0) then begin
          self->dm_check_thickness,self.cut_t4[self.samp_typ],range=self.cut_t4ran,ndat=ndat,index=index4,is_E=is_E,traninvalid=traninvalid,emptyitem=emptyitem,$
              extra_tit=extra_legd,checkfold=check_fold[self.cut_t4[self.samp_typ]],foldcenter=fold_center[self.cut_t4[self.samp_typ]],qoffset=qoffset,debug=debug
          is_E_t[3] = is_E
          tran_invalid[3] = traninvalid
       endif
       ;t5
       if self.disp_flag[5] and (total(finite(self.cut_t5ran)) ne 0) then begin
          self->dm_check_thickness,self.cut_t5[self.samp_typ],range=self.cut_t5ran,ndat=ndat,index=index5,is_E=is_E,traninvalid=traninvalid,emptyitem=emptyitem,$
              extra_tit=extra_legd,checkfold=check_fold[self.cut_t5[self.samp_typ]],foldcenter=fold_center[self.cut_t5[self.samp_typ]],qoffset=qoffset,debug=debug
          is_E_t[4] = is_E
          tran_invalid[4] = traninvalid
       endif
       
       ;figure out dE
       if ok_ewid then begin 
          if is_E_x then begin
             dE = (finite(self.cut_step)?(abs(self.cut_step)):dE) 
          endif else begin
             tmp_ran = [!values.f_nan,!values.f_nan]
             if is_E_t[0] then tmp_ran = self.cut_t1ran
             if self.disp_flag[2] and is_E_t[1] then tmp_ran = self.cut_t2ran
             if self.disp_flag[3] and is_E_t[2] then tmp_ran = self.cut_t3ran
             if self.disp_flag[4] and is_E_t[3] then tmp_ran = self.cut_t4ran
             if self.disp_flag[5] and is_E_t[4] then tmp_ran = self.cut_t5ran
             if finite(tmp_ran[0],/nan) then tmp_ran[0]=-1e30
             if finite(tmp_ran[1],/nan) then tmp_ran[1]=1e30
             tmp_ran = [min(tmp_ran),max(tmp_ran)]
             if tmp_ran[0] lt emin then tmp_ran[0]=emin
             if tmp_ran[1] gt emax then tmp_ran[1]=emax
             if tmp_ran[1] gt tmp_ran[0] then dE=tmp_ran[1]-tmp_ran[0]
          endelse
          if dE le 0 then dE=1.0
       endif   

       if n_elements(index1) ne 0 then index = temporary(index1)
       if n_elements(index2) ne 0 then begin
          if n_elements(index) ne 0 then index = dm_common(index,index2,/no_copy) $
          else index = temporary(index2)
       endif
       if n_elements(index3) ne 0 then begin
          if n_elements(index) ne 0 then index = dm_common(index,index3,/no_copy) $
          else index = temporary(index3)
       endif
       if n_elements(index4) ne 0 then begin
          if n_elements(index) ne 0 then index = dm_common(index,index4,/no_copy) $
          else index = temporary(index4)
       endif
       if n_elements(index5) ne 0 then begin
          if n_elements(index) ne 0 then index = dm_common(index,index5,/no_copy) $
          else index = temporary(index5)
       endif
       
       ;ydat
       if arg_present(yerr) then $ 
          self->dm_choose_trajdata,self.cut_y[self.samp_typ]-1,data=ydat,error=yerr,title=ytit $
       else $
          self->dm_choose_trajdata,self.cut_y[self.samp_typ]-1,data=ydat,title=ytit
       
       ;choose a3,a4
       if (self.instrname eq 'macs') and self.macs_savea4 then begin
          if arg_present(a3) then self->dm_choose_trajdata,data=a3,/macsa3,debug=debug
          if arg_present(a4) then self->dm_choose_trajdata,data=a4,/macsa4,debug=debug
       endif
       
       ;extra title info
       if ((self.samp_typ eq 2) and (self.instrname ne 'wand')) or ((self.samp_typ eq 3) and $
          ((is_E_t[0] and tran_invalid[0]) or (is_E_t[1] and tran_invalid[1]) or (is_E_t[2] and tran_invalid[2]))) then begin
          case self.e_bin[self.samp_typ] of
             0:  extra_tit = ''
             1:  extra_tit = 'Elastic'
             2:  extra_tit = self->range_string(extra_tit,'E',self.e_range,'meV')
          endcase
       endif
       if (self.instrname eq 'macs') and (self.macsintn_typ ne 0) then begin
          extra_tit = 'Detector='+(['SPEC','DIFF','SPEC+DIFF'])[self.macsintn_typ]
       endif
       
       ;zero error for dcs, macs, and wand data
       if total(finite(self.zero_error,/nan)) eq 0 then zero_error = self.zero_error[0]*self.zero_error[2]
       bin_zeroerror = self.bin_zeroerror*((self.instrname eq 'dcs') or (self.instrname eq 'macs') or (self.instrname eq 'wand'))
    endelse
    
    if n_elements(qoffset) eq 3 then xtit = self->dm_adjust_xyztit(qoffset,hkl_info=hkl_info,title=xtit)
    
    ok_err = (n_elements(yerr) ne 0)
    ok_a3  = (n_elements(a3) ne 0)
    ok_a4  = (n_elements(a4) ne 0)
    ok_wt  = (n_elements(weight) ne 0)

    if n_elements(index) ne 0 then begin
       if index[0] ne -1 then begin
          xdat = xdat[index]
          ydat = ydat[index]
          if ok_err  then yerr = yerr[index]
          if ok_ewid then ewid = ewid[index]
          if ok_a3   then a3   = a3[index]
          if ok_a4   then a4   = a4[index]
          if ok_wt   then weight = weight[index]
       endif else begin
          emptyitem = 'combined thickness'
          tran_invalid[*] = 1b
          extra_legd = ''
       endelse
       index = -1
    endif
    
    ;fold to both sides
    if self.samp_typ ne -1 then begin
       if check_fold[self.cut_x[self.samp_typ]] then begin
          xdat = [xdat,2.0*fold_center[self.cut_x[self.samp_typ]]-xdat]
          ydat = [ydat,ydat]
          if ok_err  then yerr = [yerr,yerr]
          if ok_ewid then ewid = [ewid,ewid]
          if ok_a3   then a3   = [a3,a3]
          if ok_a4   then a4   = [a4,a4]
          if ok_wt   then weight = [weight,weight]
       endif
    endif
    
    if (self.samp_typ ge 0) and (self.instrname eq 'dcs') and (total(self.dcsdetmask[1:3]) ne 0) then begin  ;add mask info for DCS
       if strlen(extra_legd) eq 0 then sep='' else sep=', '
       ind = where(1-self.dcsdetmask[1:3],count)
       if count gt 0 then begin
          extra_legd = extra_legd+sep+(['Lower','Central','Upper'])[ind[0]]
          for i=1,count-1 do extra_legd = extra_legd+'+'+(['Lower','Central','Upper'])[ind[i]]
          extra_legd = extra_legd+' Bank'+(['','s'])[count gt 1]
       endif
    endif
    
    if n_elements(emptyitem) ne 0 then $
       ok = dialog_message(['The specified '+emptyitem+' range covers no data.','The entire possible range is used instead.'],dialog_parent=self.tlb,/center)

    ;xrange
    if total(finite(self.cut_ran)) eq 2 then begin
       index = where((xdat le max(self.cut_ran)) and (xdat ge min(self.cut_ran)),count)
       if (count gt 0) and (count ne n_elements(ydat)) then begin
          xdat = xdat[index]
          ydat = ydat[index]
          if ok_err  then yerr = yerr[index]
          if ok_ewid then ewid = ewid[index]
          if ok_a3   then a3   = a3[index]
          if ok_a4   then a4   = a4[index]
          if ok_wt   then weight = weight[index]
          index = -1
          xstart = min(self.cut_ran)
       endif
    endif else begin
       if finite(self.cut_ran[0]) then begin
          index = where(xdat ge self.cut_ran[0],count)
          if (count gt 0) and (count ne n_elements(ydat)) then begin
             xdat = xdat[index]
             ydat = ydat[index]
             if ok_err  then yerr = yerr[index]
             if ok_ewid then ewid = ewid[index]
             if ok_a3   then a3   = a3[index]
             if ok_a4   then a4   = a4[index]
             if ok_wt   then weight = weight[index]
             index = -1
             xstart = self.cut_ran[0]
          endif
       endif else if finite(self.cut_ran[1]) then begin
          index = where(xdat le self.cut_ran[1],count)
          if (count gt 0) and (count ne n_elements(ydat)) then begin
             xdat = xdat[index]
             ydat = ydat[index]
             if ok_err  then yerr = yerr[index]
             if ok_ewid then ewid = ewid[index]
             if ok_a3   then a3   = a3[index]
             if ok_a4   then a4   = a4[index]
             if ok_wt   then weight = weight[index]
             index = -1
          endif
       endif
    endelse

    if keyword_set(debug) then help,xdat,ydat,ewid   

    rebinned = 0b
    checkfinite = self.ftypecheckmask[0] or (strlen(self.userf_str) ne 0)
    ;rebinning according to the steps
    if finite(self.cut_step) and (self.cut_step ne 0) then begin
       if self.bin_checkstep then error = dm_check_step(xdat,self.cut_step,label=xtit,nmax=1e7,group_leader=self.tlb)
       if keyword_set(error) then return
       if ok_a3 then begin
          tmpx = xdat
          dm_step_bin,self.cut_step,tmpx,ydat=a3,debug=debug,conststep=self.bin_conststep,checkfinite=checkfinite,extlib=self.bin_extlib,xstart=xstart,group_leader=self.tlb
          tmpx = 0
       endif
       if ok_a4 then begin
          tmpx = xdat
          dm_step_bin,self.cut_step,tmpx,ydat=a4,debug=debug,conststep=self.bin_conststep,checkfinite=checkfinite,extlib=self.bin_extlib,xstart=xstart,group_leader=self.tlb
          tmpx = 0
       endif
       dm_step_bin,self.cut_step,xdat,ydat=ydat,yerr=yerr,debug=debug,avgsum=self.bin_avgsum,bintr=self.binthreshold,conststep=self.bin_conststep,ewid=ewid,checkfinite=checkfinite,$
          extlib=self.bin_extlib,xstart=xstart,group_leader=self.tlb,weight=weight,zero_error=zero_error,bin_zeroerror=bin_zeroerror,$
          zoerrestrange=self.bin_statrange[0]*self.bin_statrange[1],estapplyall=self.bin_statrange[2],foundrange=foundrange1
       rebinned = 1b
    endif
    if ~rebinned and is_E_x then begin  ;rebin if x-axis is E
       xmax = max(xdat,min=xmin)
       index = where((uniq_E ge xmin) and (uniq_E le xmax),count)
       if count ne 0 then uniq_E = uniq_E[index]
       if self.instrname eq 'macs' then begin
          uniq_E = round(temporary(uniq_E)*(1000d),/L64)*0.001
          xdat = round(temporary(xdat)*(1000d),/L64)*0.001
       endif
       if ok_a3 then begin
          tmpx = xdat
          dm_step_bin,1e-5,tmpx,ydat=a3,uniq_val=uniq_E,debug=debug,checkfinite=checkfinite,extlib=self.bin_extlib,xstart=xstart,group_leader=self.tlb
          tmpx = 0
       endif
       if ok_a4 then begin
          tmpx = xdat
          dm_step_bin,1e-5,tmpx,ydat=a4,uniq_val=uniq_E,debug=debug,checkfinite=checkfinite,extlib=self.bin_extlib,xstart=xstart,group_leader=self.tlb
          tmpx = 0
       endif
       ok_ewid = 0b & tmp = temporary(ewid)
       dm_step_bin,1e-5,xdat,ydat=ydat,yerr=yerr,uniq_val=uniq_E,debug=debug,avgsum=self.bin_avgsum,bintr=self.binthreshold,ewid=ewid,checkfinite=checkfinite,$
          extlib=self.bin_extlib,xstart=xstart,group_leader=self.tlb,weight=weight,zero_error=zero_error,bin_zeroerror=bin_zeroerror,$
          zoerrestrange=self.bin_statrange[0]*self.bin_statrange[1],estapplyall=self.bin_statrange[2],foundrange=foundrange2
    endif else begin
       if checkfinite then begin
          index = where(finite(ydat),count)
          if (count ne n_elements(ydat)) and (count ne 0) then begin
             xdat = xdat[index]
             ydat = ydat[index]
             if ok_err  then yerr = yerr[index]
             if ok_a3   then a3   = a3[index]
             if ok_a4   then a4   = a4[index]
             if ok_wt   then weight = weight[index]
          endif
       endif
       ;sort unrebinned data
       if ~rebinned then begin
          index = sort(xdat) 
          xdat  = xdat[index]
          ydat  = ydat[index]
          if ok_err  then yerr = yerr[index]
          if ok_a3   then a3   = a3[index]
          if ok_a4   then a4   = a4[index]
          if ok_wt   then weight = weight[index]
       endif
    endelse
    
    foundrange = 0
    if n_elements(foundrange1) ne 0 then foundrange = foundrange1
    if n_elements(foundrange2) ne 0 then foundrange = (foundrange)>(foundrange2)
    if foundrange gt 0 then self.bin_statrange[3:4] = [foundrange,0]
    
    if ok_ewid and rebinned then begin
       ydat = ydat*dE
       if ok_err then yerr = yerr*dE
    endif

    if keyword_set(debug) then print,'^^choose cut data finished in ',systime(/sec)-current,' sec.'
end