; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
pro dcs_getnps,npsptr
;************************************************************************************************
;
compile_opt strictarr
;
for rmode=1,3 do begin
	case rmode of
		1: begin
			;inputfile=file_which("dcs_nps_low.dat",/include_current_dir)
			inputfile=!DAVE_AUXILIARY_DIR+'dcs_nps_low.dat'
                        openr,unit,inputfile,/get_lun
			readf,unit,nvals
			vals1=fltarr(3,nvals)
			readf,unit,vals1
			free_lun,unit
		end
		2: begin
			;inputfile=file_which("dcs_nps_medium.dat",/include_current_dir)
			inputfile=!DAVE_AUXILIARY_DIR+'dcs_nps_medium.dat'
                        openr,unit,inputfile,/get_lun
			readf,unit,nvals
			vals2=fltarr(3,nvals)
			readf,unit,vals2
			free_lun,unit
		end
		3: begin
			;inputfile=file_which("dcs_nps_high.dat",/include_current_dir)
			inputfile=!DAVE_AUXILIARY_DIR+'dcs_nps_high.dat'
                        openr,unit,inputfile,/get_lun
			readf,unit,nvals
			vals3=fltarr(3,nvals)
			readf,unit,vals3
			free_lun,unit
		end
		else:
	endcase
endfor
;
npsptr=ptr_new({vals1:vals1,vals2:vals2,vals3:vals3})
;
end
