; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
function dcs_clean_date,mon,day,year,hour,minute,second
;************************************************************************************************
;
compile_opt strictarr
;
; This function returns a date/time in the form mm/dd/yy hh:mm. Specifically it
; inserts leading zeros as needed.
; Examples of calls:
; dcs_clean_date('12','7','1944','7','15')
; dcs_clean_date('12','7','2004','7','15','1')
cmon=strtrim(mon,2)
if (mon lt 10) then cmon='0'+cmon
cday=strtrim(day,2)
if (day lt 10) then cday='0'+cday
cyear=strmid(strtrim(year,2),2)
chour=strtrim(hour,2)
if (hour lt 10) then chour='0'+chour
cminute=strtrim(minute,2)
if (minute lt 10) then cminute='0'+cminute
cdate=cmon+'/'+cday+'/'+cyear+' '+chour+':'+cminute
if (n_elements(second) gt 0) then begin
	csecond=strtrim(second,2)
	if (second lt 10) then csecond='0'+csecond
	cdate=cdate+':'+csecond
endif
return,cdate
end
