; $Id$
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;
; Written by J.R.D. Copley.
;************************************************************************************************
function dave_expand_expr,incom,longform=longform,shortform=shortform
;************************************************************************************************
;
compile_opt strictarr
;
;
if (not keyword_set(shortform)) then begin
; If necessary, given the long forms of variables (longform),
;	construct corresponding short forms (shortform).
	nvar=n_elements(longform)
	shortform=longform
	for k=0,nvar-1 do begin
		shortform[k]=strmid(longform[k],strpos(longform[k],".",/reverse_search)+1)
	endfor
endif
;
; Given an input command string (incom), generate and return the
; corresponding output command string.
com=strupcase(incom)
outcom=""
while (1) do begin
	pos=stregex(com,"[a-zA-Z][a-zA-Z0-9_]*",length=len)
	if (pos gt 0) then outcom=outcom+strmid(com,0,pos)
	if (pos eq -1) then begin
		outcom=outcom+com
		break
	endif
	var=strmid(com,pos,len)
	k=where(var eq strupcase(shortform),n)
	if (n eq 1) then var=strupcase(longform[k[0]])
	outcom=outcom+var
	com=strmid(com,pos+len)
endwhile
return,outcom
end
