; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
pro dcs_plotdetmask_2thQuit,event
;************************************************************************************************
; Trivial quit routine.
;
compile_opt strictarr
;
widget_control,event.top,/destroy
return
end


;************************************************************************************************
pro dcs_plotdetmask_2thCleanup,tlb
;************************************************************************************************
; Cleanup routine.
;
compile_opt strictarr
;
widget_control,tlb,get_uvalue = pState,/no_copy
tmpmask=*(*pState).mptr
ptr_free,(*pState).mptr
*(*pState).pblist=lonarr((*pState).nhedet)
templist=where(tmpmask eq 0,nblist)
if (nblist gt 0) then (*(*pState).pblist)[0:nblist-1]=templist+1
;
; Revert to color table in existence at start of procedure.
tvlct,(*pState).oldct
;
DEVICE,DECOMPOSED=(*PSTATE).OLD_DECOMP
;
ptr_free,pState
;
return
end


;************************************************************************************************
function detector_numbers,range,rows,angles=angles,banks=banks
;************************************************************************************************
;
compile_opt strictarr
;
; Returns detector numbers within range and in specified banks.
; N.B. detector numbers range from 0 to 912.
;
nhedet=913
;
lotth=range[0] < range[1]
hitth=range[0] > range[1]
banklo=rows[0]
bankmd=rows[1]
bankhi=rows[2]
;
defsysv,'!dave_auxiliary_dir',exists=exists
if (1-exists) then defsysv,'!dave_auxiliary_dir','C:\dave_SF\programs\auxiliary\'
if n_elements(angles) eq 0 or n_elements(banks) eq 0 then $
dcs_getangles,nhedet=nhedet,angles,banks,azim_angles,racks
;
indlo=where(angles gt lotth and angles lt hitth and banks eq -1,countlo)
indmd=where(angles gt lotth and angles lt hitth and banks eq  0,countmd)
indhi=where(angles gt lotth and angles lt hitth and banks eq  1,counthi)
;
index=-1
if (countlo gt 0 and banklo) then index=[index,indlo]
if (countmd gt 0 and bankmd) then index=[index,indmd]
if (counthi gt 0 and bankhi) then index=[index,indhi]
;
ndet=n_elements(index)-1
if (ndet gt 0) then index=index[1:ndet]
index=index[sort(index)]
return,index
end


;************************************************************************************************
pro dcs_plot_histo_2th,x,y,xlo,xhi,nhedet,minang,maxang
;************************************************************************************************
;
compile_opt strictarr
;
np=n_elements(x)
xx=0.5*(x[0:np-2]+x[1:np-1])
xx=reform(transpose([[xx],[xx]]),2*np-2)
xx=[x[0],xx,x[np-1]]
yy=reform(transpose([[y],[y]]),2*np)*1.00
keep=where(xlo le xx and xx le xhi)
nkeep=n_elements(keep)
xx=xx[keep]
yy=yy[keep]
if (keep[0] gt 0) then begin
	xx=[x[keep[0]/2],xx]
	yy=[y[keep[0]/2],yy]
endif
nkeep=n_elements(keep)
if (keep[nkeep-1] lt 2*nhedet-1) then begin
	xx=[xx,x[keep[nkeep-1]/2]]
	yy=[yy,y[keep[nkeep-1]/2]]
endif
np=n_elements(xx)
xmin=!x.crange[0] > minang
xmax=!x.crange[1] < maxang
xx=[xmin,xmin,xx[1:np-2],xmax,xmax]
yy=[0.0,yy,0.0]
polyfill,xx,yy,/line_fill,orientation=45,color=3
polyfill,xx,yy,/line_fill,orientation=135,color=3
end


;************************************************************************************************
pro dcs_plotdetmask_2th_replot,event
;************************************************************************************************
;
compile_opt strictarr
;
widget_control,event.top,get_uvalue=pstate
;
if (event.id ne (*pstate).undozoom) then begin
	(*pstate).xloprev=(*pstate).xlo
	(*pstate).xhiprev=(*pstate).xhi
	(*pstate).yloprev=(*pstate).ylo
	(*pstate).yhiprev=(*pstate).yhi
	widget_control,(*pstate).undozoom,/sensitive
endif
;
; Respond to upper slider.
if (event.id eq (*pstate).mindetnum) then begin
	(*pstate).xmin=event.value
	xlo=(*pstate).xmin
	xhi=(*pstate).xmax
endif
;
; Respond to lower slider.
if (event.id eq (*pstate).maxdetnum) then begin
	(*pstate).xmax=event.value
	xlo=(*pstate).xmin
	xhi=(*pstate).xmax
endif
;
; Respond to "plot all detectors" button.
if (event.id eq (*pstate).alldet) then begin
	xlo=(*pstate).minang
	xhi=(*pstate).maxang
endif
;
; Respond to "plot selected detectors" button.
if (event.id eq (*pstate).somdet) then begin
	xlo=(*pstate).xmin
	xhi=(*pstate).xmax
	print,xlo,xhi
	widget_control,(*pstate).mindetnum,set_value=xlo
	widget_control,(*pstate).maxdetnum,set_value=xhi
endif
;
if (event.id ne (*pstate).undozoom) then begin
	if (xlo gt xhi) then begin
		xtmp=xhi
		xhi=xlo
		xlo=xtmp
		widget_control,(*pstate).mindetnum,set_value=xlo
		widget_control,(*pstate).maxdetnum,set_value=xhi
		(*pstate).xmin=xlo
		(*pstate).xmax=xhi
	endif
;
	if ((*pstate).xzoom) then begin
		ylo=min((*pstate).y)
		yhi=max((*pstate).y)
	endif else begin
		ylo=(*pstate).ymin
		yhi=(*pstate).ymax
	endelse
endif
;
; Respond to "undo zoom" button.
if (event.id eq (*pstate).undozoom) then begin
	xlo=(*pstate).xloprev
	xhi=(*pstate).xhiprev
	ylo=(*pstate).yloprev
	yhi=(*pstate).yhiprev
	if (xlo gt 1 or xhi lt (*pstate).nhedet) then begin
		widget_control,(*pstate).mindetnum,set_value=xlo
		widget_control,(*pstate).maxdetnum,set_value=xhi
	endif
	widget_control,(*pstate).undozoom,sensitive=0
endif
;
; Replot detector sums.
y=(*pstate).y
y2=y*(*(*pstate).mptr)
isort=sort((*pstate).ordering)
y2=y
nums=where(*(*pstate).mptr eq 0,count)
if (count gt 0) then y2[isort[nums]]=0
;
plot,(*pstate).x,y,psym=(*pstate).psym,symsize=(*pstate).symsize,$
	xrange=[xlo,xhi],yrange=[ylo,yhi],color=(*pstate).color1,xstyle=1,$
	xtitle=(*pstate).xtitle,ytitle=(*pstate).ytitle,/NODATA,thick=1
oplot,(*pstate).x,y,psym=(*pstate).psym,symsize=(*pstate).symsize,$
	color=(*pstate).color2,thick=1
dcs_plot_histo_2th,(*pstate).x,y2,xlo,xhi,(*pstate).nhedet,(*pstate).minang,(*pstate).maxang
oplot,(*pstate).x,y2,psym=(*pstate).psym,symsize=(*pstate).symsize,$
	color=(*pstate).color1,thick=1
(*pstate).xlo=xlo
(*pstate).xhi=xhi
;
;widget_control,event.top,set_uvalue=pstate,/no_copy
end


;************************************************************************************************
pro dcs_plotdetmask_2th_cursor,event
;************************************************************************************************
;
compile_opt strictarr
;
widget_control,event.top,get_uvalue=pstate
;
xandy=convert_coord(event.x,event.y,/device,/to_data)
xc=xandy[0]
yc=xandy[1]
;
; Respond to mouse button press: this defines one limit of operation/plot.
if (event.type eq 0) then begin
	case event.press of
		1: begin
			widget_control,(*pstate).mindetnum,set_value=xc
			(*pstate).xmin=xc
			(*pstate).ymin=yc
		end
		4: begin
			(*pstate).xminmsk=xc
		end
		else:
	endcase
endif
;
; Respond to mouse button release: this defines other limit of operation/plot.
if (event.type eq 1) then begin
	case event.release of
		1: begin
			widget_control,(*pstate).maxdetnum,set_value=xc
			(*pstate).xmax=xc
			(*pstate).ymax=yc
		end
		4: begin
			if (xc ge (*pstate).xminmsk) then begin
				(*pstate).xmaxmsk=xc
			endif else begin
				(*pstate).xmaxmsk=(*pstate).xminmsk
				(*pstate).xminmsk=xc
			endelse
			;print,'left mask',(*pstate).xminmsk
			;print,'right mask',(*pstate).xmaxmsk
;			index=where((*pstate).xminmsk ge (*pstate).x[0:(*pstate).nhedet-2] $
;				and (*pstate).xminmsk lt (*pstate).x[1:(*pstate).nhedet-1])
;			minvalu=index > 0
;			index=where((*pstate).xmaxmsk ge (*pstate).x[0:(*pstate).nhedet-2] $
;				and (*pstate).xmaxmsk lt (*pstate).x[1:(*pstate).nhedet-1])
;			maxvalu=index < ((*pstate).nhedet-1)
;			(*(*pstate).mptr)[minvalu:maxvalu]=1-(*pstate).maskem
			range=[(*pstate).xminmsk,(*pstate).xmaxmsk]
			rows=[1,1,1]
			index=detector_numbers(range,rows,angles=(*pstate).angles0,banks=(*pstate).banks0)
			;print,index
			(*(*pstate).mptr)[index]=1-(*pstate).maskem
		end
		else: return
	endcase
;
;	Replot detector sums.
	case event.release of
		1: begin
			(*pstate).xloprev=(*pstate).xlo
			(*pstate).xhiprev=(*pstate).xhi
			(*pstate).yloprev=(*pstate).ylo
			(*pstate).yhiprev=(*pstate).yhi
			widget_control,(*pstate).undozoom,/sensitive
			xlo=(*pstate).xmin<(*pstate).xmax
			xhi=(*pstate).xmin>(*pstate).xmax
			if (xlo eq xhi) then begin
				xlo=(*pstate).minang
				xhi=(*pstate).maxang
			endif
			widget_control,(*pstate).mindetnum,set_value=xlo
			widget_control,(*pstate).maxdetnum,set_value=xhi
			(*pstate).xmin=xlo
			(*pstate).xmax=xhi
			if ((*pstate).xzoom) then begin
				ylo=min((*pstate).y)
				yhi=max((*pstate).y)
			endif else begin
				ylo=(*pstate).ymin<(*pstate).ymax > 0
				yhi=(*pstate).ymin>(*pstate).ymax
				(*pstate).ymin=ylo
				(*pstate).ymax=yhi
			endelse
		end
		4: begin
			xlo=(*pstate).xlo
			xhi=(*pstate).xhi
			ylo=(*pstate).ylo
			yhi=(*pstate).yhi
		end
		else: return
	endcase
;
	y=(*pstate).y
	y2=y*(*(*pstate).mptr)
	isort=sort((*pstate).ordering)
	y2=y
	nums=where(*(*pstate).mptr eq 0,count)
	if (count gt 0) then y2[isort[nums]]=0
;
	plot,(*pstate).x,y,psym=(*pstate).psym,symsize=(*pstate).symsize,$
		xrange=[xlo,xhi],yrange=[ylo,yhi],color=(*pstate).color1,xstyle=1,$
		xtitle=(*pstate).xtitle,ytitle=(*pstate).ytitle,/NODATA,thick=1
	oplot,(*pstate).x,y,psym=(*pstate).psym,symsize=(*pstate).symsize,$
		color=(*pstate).color2,thick=1
	dcs_plot_histo_2th,(*pstate).x,y2,xlo,xhi,(*pstate).nhedet,(*pstate).minang,(*pstate).maxang
	oplot,(*pstate).x,y2,psym=(*pstate).psym,symsize=(*pstate).symsize,$
		color=(*pstate).color1,thick=1
	(*pstate).xlo=xlo
	(*pstate).xhi=xhi
endif
;
; Respond to mouse button movement: update information displayed.
if (event.type eq 2) then begin
	ok=0; "ok" determines whether or not to display information
	if (!x.crange[0] le xc and xc le !x.crange[1] and $
			!y.crange[0] le yc and yc le !y.crange[1] and $
			xc ge (*pstate).minang and xc le (*pstate).maxang) then begin
		index=where(xc ge (*pstate).x[0:(*pstate).nhedet-2] and xc lt (*pstate).x[1:(*pstate).nhedet-1])
		if (index ne -1) then begin; information will be displayed
			index=index[0]
			; find indices of detectors at the lower angle
			index1=where((*pstate).x[0:(*pstate).nhedet-2] eq (*pstate).x[index])
			; find indices of detectors at the upper angle
			index2=where((*pstate).x[1:(*pstate).nhedet-1] eq (*pstate).x[index+1])+1
			xval1=(*pstate).x[index1]
			xval2=(*pstate).x[index2]
			bval1=(*pstate).banks[index1]
			bval2=(*pstate).banks[index2]
			yval1=(*pstate).y[index1]
			yval2=(*pstate).y[index2]
			bsort=sort(bval1)
			bval1=bval1[bsort]
			yval1=yval1[bsort]
			bsort=sort(bval2)
			bval2=bval2[bsort]
			yval2=yval2[bsort]
			yc=0.5*(mean((*pstate).y[index1])+mean((*pstate).y[index2]))
			widget_control,(*pstate).infod,set_value=" 2Theta"+string(xc,format='(f8.2)')
			widget_control,(*pstate).infoi,set_value="Intensity"+string(yc,format='(f8.0)')
			lb=' {'
			rb=' }'
			lb2=' ['
			rb2='] '
			msg1=string(xval1[0],format='(f8.1)')+lb2+string((*pstate).ordering[index1],format='(3i4)')+rb2+$
				lb+string(bval1,format='(3i3)')+rb+string(yval1,format='(3f8.0)')
			msg2=string(xval2[0],format='(f8.1)')+lb2+string((*pstate).ordering[index2],format='(3i4)')+rb2+$
				lb+string(bval2,format='(3i3)')+rb+string(yval2,format='(3f8.0)')
			widget_control,(*pstate).info1,set_value=msg1
			widget_control,(*pstate).info2,set_value=msg2
			ok=1
		endif
	endif
	if (not ok) then begin
		widget_control,(*pstate).infod,set_value=" 2Theta"
		widget_control,(*pstate).infoi,set_value="Intensity"
		widget_control,(*pstate).info1,set_value=""
		widget_control,(*pstate).info2,set_value=""
	endif
endif
;
;widget_control,event.top,set_uvalue=pstate,/no_copy
;
end


;************************************************************************************************
pro dcs_plotdetmask_2th_handler,event
;************************************************************************************************
;
compile_opt strictarr
;
widget_control,event.top,get_uvalue=pstate
;
; Respond to " MASK "/"UNMASK" button.
if (event.id eq (*pstate).infom) then begin
	if ((*pstate).maskem eq 1) then value="UNMASK"
	if ((*pstate).maskem eq 0) then value=" MASK "
	(*pstate).maskem=1-(*pstate).maskem
	widget_control,(*pstate).infom,set_value=value
endif
;
; Respond to " X ZOOM"/"XY ZOOM" button.
if (event.id eq (*pstate).infoz) then begin
	if ((*pstate).xzoom eq 1) then value="XY ZOOM"
	if ((*pstate).xzoom eq 0) then value=" X ZOOM"
	(*pstate).xzoom=1-(*pstate).xzoom
	widget_control,(*pstate).infoz,set_value=value
endif
;
; Respond to "PROCEED" button.
if (event.id eq (*pstate).done) then begin
	wdelete,(*pstate).winvis
	dcs_plotdetmask_2thQuit,event
	return
endif
;
; Respond to "Help" button.
if (event.id eq (*pstate).help) then $
	res=dialog_message(dialog_parent=event.top,(*pstate).helptext2,/information)
;
;widget_control,event.top,set_uvalue=pstate,/no_copy
;
end


;************************************************************************************************
pro dcs_plotdetmask_2th,base,file,detsum0,pblist,helptext2,angles0=angles0
;************************************************************************************************
; This procedure is used to plot detector sums.
;
compile_opt strictarr
;
DEVICE,GET_DECOMPOSED=OLD_DECOMP
DEVICE,DECOMPOSED=0
;
detsum=detsum0
nhedet=n_elements(detsum0) ; Number of detectors.
if n_elements(angles0) eq n_elements(detsum) then begin
   minang=min(angles0,max=maxang)
   minang=minang-1
   maxang=maxang+1
   banks0=intarr(nhedet)
endif else begin
   dcs_getangles,nhedet=nhedet,angles0,banks0,azim_angles,racks
   minang=-30.0
   maxang=140.0
endelse
angles=angles0
banks=banks0
ordering=sort(angles)
angles=angles[ordering]
banks=banks[ordering]
detsum=detsum[ordering]
;

;
; Set up the top level widget.
xoffset=!screensize[0]*0.00
yoffset=!screensize[1]*0.08
xsize=!screensize[0]*0.70
ysize=!screensize[0]*0.50
tlb=widget_base(title="Summed detector counts"+file,/col,/floating,$
	xoffset=xoffset,yoffset=yoffset,xsize=xsize,ysize=ysize,/modal,$
	group_leader=base)
;
; Information base.
infobase=widget_base(tlb,/row)
infod=widget_text(infobase,xsize=14,value=" 2Theta")
infoi=widget_text(infobase,xsize=17,value="Intensity")
info1=widget_text(infobase,xsize=30,value="")
info2=widget_text(infobase,xsize=30,value="")
infobase2=widget_base(tlb,/row)
infoz=widget_button(infobase2,value=" X ZOOM")
infom=widget_button(infobase2,value=" MASK ")
help=widget_button(infobase2,value='HELP')
;
; Plot window.
plotwin=widget_draw(tlb,/motion_events,/button_events,xsize=xsize*1.0,ysize=ysize*0.8,$
	event_pro='dcs_plotdetmask_2th_cursor')
;
; Buttons and sliders.
bbase=widget_base(tlb,/row,/align_center)
;minsliderbase=widget_base(tlb,event_pro='dcs_plotdetmask_2th_replot')
;mindetnum=cw_fslider(bbase,mini=minang,maxi=maxang,value=minang)
;maxsliderbase=widget_base(tlb,event_pro='dcs_plotdetmask_2th_replot')
;maxdetnum=cw_fslider(bbase,mini=minang,maxi=maxang,value=maxang)
mindetnum=widget_slider(bbase,mini=minang,maxi=maxang,value=minang,event_pro='dcs_plotdetmask_2th_replot')
maxdetnum=widget_slider(bbase,mini=minang,maxi=maxang,value=maxang,event_pro='dcs_plotdetmask_2th_replot')
somdet=widget_button(bbase,value='Show selected range of detectors',$
	event_pro='dcs_plotdetmask_2th_replot')
alldet=widget_button(bbase,value='Show all detectors',event_pro='dcs_plotdetmask_2th_replot')
undozoom=widget_button(bbase,value='Undo zoom',event_pro='dcs_plotdetmask_2th_replot',$
	sensitive=0)
done=widget_button(bbase,value='PROCEED')
;
; Realize the widget.
dave_position_tlb,tlb
widget_control,tlb,/realize
;
widget_control,plotwin,get_value=winvis
wshow,winvis,1
wset,winvis
;
; Create the initial plot.
x=angles
tmpmask=bytarr(nhedet)+1
templist=where(*pblist gt 0,nblist)
;
if (nblist gt 0) then tmpmask[(*pblist)[templist]-1]=0
;
y=detsum
xlo=min(x)
xhi=max(x)
ylo=min(y)
yhi=max(y)
psym=10
symsize=0.25
xtitle="Detector angle"
ytitle="Intensity"
;
; Save current color table.
oldct=dcs_getctinfo()
; Use Alan's routine to load 256 colors.
tvlct,!dave_colors.red,!dave_colors.green,!dave_colors.blue
color1=1
color2=2
;
plot,x,detsum,psym=psym,symsize=symsize,xrange=[xlo,xhi],yrange=[ylo,yhi],$
	color=color1,thick=1,xstyle=1,xtitle=xtitle,ytitle=ytitle,/NODATA
oplot,x,detsum,psym=psym,symsize=symsize,color=color2,thick=1

isort=sort(ordering)
y2=detsum
nums=where(tmpmask eq 0,count)
if (count gt 0) then y2[isort[nums]]=0

dcs_plot_histo_2th,x,y2,xlo,xhi,nhedet,minang,maxang
oplot,x,y2,psym=psym,symsize=symsize,color=color1,thick=1
;
; Get set to manage the widget.
mptr=ptr_new(tmpmask,/no_copy)
;
state={x:x,$
	y:y,$
	banks:banks,$
	xmin:minang,$
	xmax:maxang,$
	ymin:ylo,$
	ymax:ylo,$
	infod:infod,$
	infoi:infoi,$
	info1:info1,$
	info2:info2,$
	infom:infom,$
	infoz:infoz,$
	done:done,$
	help:help,$
	helptext2:helptext2,$
	winvis:winvis,$
	alldet:alldet,$
	somdet:somdet,$
	mindetnum:mindetnum,$
	maxdetnum:maxdetnum,$
	nhedet:nhedet,$
	psym:psym,$
	symsize:symsize,$
	xtitle:xtitle,$
	ytitle:ytitle,$
	color1:color1,$
	color2:color2,$
	xlo:xlo,$
	xhi:xhi,$
	ylo:ylo,$
	yhi:yhi,$
	maskem:1,$
	xzoom:1,$
	xminmsk:minang,$
	xmaxmsk:maxang,$
	mptr:mptr,$
	undozoom:undozoom,$
	xloprev:xlo,$
	xhiprev:xhi,$
	yloprev:ylo,$
	yhiprev:yhi,$
	oldct:oldct,$
	minang:minang,$
	maxang:maxang,$
	ordering:ordering,$
	angles0:angles0,$
	banks0:banks0,$
	OLD_DECOMP:OLD_DECOMP,$
	pblist:pblist}
widget_control,tlb,set_uvalue=ptr_new(state,/no_copy)
xmanager,'dcs_plotdetmask_2th',tlb,$
	event_handler='dcs_plotdetmask_2th_handler',$
	cleanup='dcs_plotdetmask_2thCleanup'
;
end
