; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "DAVE Devel"
!define PRODUCT_VERSION "2.6 Beta"
!define PRODUCT_PUBLISHER "NIST Center for Neutron Research"
!define PRODUCT_WEB_SITE "http://www.ncnr.nist.gov/dave"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

SetCompressor lzma

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "auxiliary\dave_icon_a.ico"
!define MUI_UNICON "auxiliary\dave_icon_a.ico"
;!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install-full.ico"
;!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall-full.ico"
;!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "dave_license.txt"
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; Reserve files
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "Setup.exe"
InstallDir "$PROGRAMFILES\NCNR\DAVE2_CVS"
ShowInstDetails show
ShowUnInstDetails show

Section "MainSection" SEC01
  SetShellVarContext all
  SetOutPath "$INSTDIR"
  SetOverwrite ifnewer
  ;File "dave"
  CopyFiles $EXEDIR\* $INSTDIR 50000
SectionEnd

Section -AdditionalIcons
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  ;SetOutPath "$INSTDIR\bin\bin.x86"
  CreateDirectory "$SMPROGRAMS\NCNR\DAVE2 CVS"
  CreateShortCut "$SMPROGRAMS\NCNR\DAVE2 CVS\DAVE Devel.lnk" "$INSTDIR\dave.vbs" "" "$INSTDIR\auxiliary\dave_icon_a.ico"
  CreateShortCut "$SMPROGRAMS\NCNR\DAVE2 CVS\DAVE User Manual.lnk" "$INSTDIR\IDL87\bin\bin.x86\idl_assistant.exe" "-profile $\"$INSTDIR\help\dave_online_help\dave.adp$\" -file $\"$INSTDIR\help\dave_online_help\dave_home.html$\"" "$INSTDIR\auxiliary\dave_icon_a.ico"
  CreateShortCut "$SMPROGRAMS\NCNR\DAVE2 CVS\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url" "" "$INSTDIR\auxiliary\dave_icon_a.ico"
  CreateShortCut "$SMPROGRAMS\NCNR\DAVE2 CVS\Uninstall.lnk" "$INSTDIR\uninst.exe" "" "$INSTDIR\auxiliary\dave_icon_a.ico"
  CreateShortCut "$INSTDIR\DAVE Devel.lnk" "$INSTDIR\dave.vbs" "" "$INSTDIR\auxiliary\dave_icon_a.ico"
  CreateShortCut "$DESKTOP\DAVE Devel.lnk" "$INSTDIR\dave.vbs" "" "$INSTDIR\auxiliary\dave_icon_a.ico"
  ;SetFileAttributes "$DESKTOP\DAVE.lnk" TEMPORARY
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegDWORD ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "NoModify" 1
  WriteRegDWORD ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "NoRepair" 1
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  SetShellVarContext all
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"
  ;Delete "$INSTDIR"

  Delete "$SMPROGRAMS\NCNR\DAVE2 CVS\Uninstall.lnk"
  Delete "$SMPROGRAMS\NCNR\DAVE2 CVS\Website.lnk"
  Delete "$SMPROGRAMS\NCNR\DAVE2 CVS\DAVE Devel.lnk"
  Delete "$DESKTOP\DAVE Devel.lnk"

  RMDir /r "$SMPROGRAMS\NCNR\DAVE2 CVS"
  RMDir "$SMPROGRAMS\NCNR"
  RMDir /r "$INSTDIR"
  RMDir ""

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  SetAutoClose true
SectionEnd
