; $Id$
;###############################################################################
;
; NAME:
;   scale_coord
;
; PURPOSE:
;   Calculate an appropriate scale factor between two vectors.
;
; CATEGORY:
;   Data Browser
;
; AUTHOR:
;   Richard Tumanjong Azuah
;   NIST Center for Neutron Research
;   100 Bureau Drive, Gaithersburg, MD 20899
;   United States
;   azuah@nist.gov; (301) 9755604
;   Dec, 2002
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################



;===============================================================================
; scale_coord
;
; PURPOSE:
;   Calculate an appropriate scale factor between two vectors
;   such that:
;     final_coord[0] = scale0 + scale1*current_coord[0]   and
;     final_coord[1] = scale0 + scale1*current_coord[1]
;
; PARAMETERS:
;   current_coord [in] - current x,y coordinates
;
;   final_coord [in] - desired x,y coordinates
;
; RETURN VALUE
;   returns the required scalefactor as a 2-element vector
;
function scale_coord, current_coord, final_coord


res = size(current_coord)
if ((res[0] ne 1) or (res[1] ne 2)) then return,[0.0,1.0]

if (n_elements(final_coord) eq 0) then final_coord=[0.0,1.0]

res = size(final_coord)
if ((res[0] ne 1) or (res[1] ne 2)) then final_coord=[0.0,1.0]

ini = float(current_coord)
fin = float(final_coord)
scale0 = (fin[0]*ini[1] - fin[1]*ini[0]) / (ini[1] - ini[0]) 
scale1 = (fin[1] - fin[0]) / (ini[1] - ini[0])

return, [scale0,scale1]

end
