; $Id$

function ls_descend,filter=filter,dir=dir,depth=depth

  if n_elements(filter) eq 0 then filter = '*'
  if n_elements(depth) eq 0 then depth = 0
  
  cd,current=tempcurrent
  if n_elements(dir) eq 0 then dir = tempcurrent 
  tempcurrent = dir

  cd,dir
  sep = path_sep()
  files = ['']
  
  
  ;FIND ALL FILES
  ;NOW FIND THE DIRECTORIES AND DESCEND INTO THEM.
  allfiles = file_search(tempcurrent+sep+'*')
  d = file_test(allfiles,/directory)
  whd = where(d ne 0,dcount)
  whf = where(d eq 0,fcount)
  ;print,dcount,fcount
  
  if fcount ne 0 then begin
    flen = strlen(filter)
    if flen gt 1 then begin
      ending = strmid(filter,1,strlen(filter)-1)
    endif
    thefiles = allfiles[whf]
    for i=0,fcount-1 do begin
      thisfile = thefiles[i]
      if strlen(thisfile) gt flen-1 then begin
        thisfileending = strmid(thisfile,flen-2,/reverse)
        if strcmp(thisfileending,ending,/fold_case) gt 0 then begin
          files = [files,thisfile]
        endif
      endif      
    endfor;i
  endif;fcount

  if dcount ne 0 then begin
    mydepth = intarr(dcount)+depth
    dirs = allfiles[whd]
    for i=0,dcount-1 do begin

      ;print,depth
      if depth le 20 then begin
        morefiles = ls_descend(filter=filter,dir=allfiles[whd[i]],depth=mydepth[i]+1)
        files = [files,morefiles]
      endif
    endfor;i
  endif

  if n_elements(files) gt 1 then files = files[1:*]
  
  cd,tempcurrent
  return,files
end;ls_descend

pro test_ls_descend,fn=fn,filter=filter
  dir = dialog_pickfile(/directory,title='Choose a data directory:')
  if dir ne '' then begin
    if n_elements(filter) eq 0 then filter = '*.jpg'
    fn = ls_descend(dir='C:\Documents and Settings\kneller\Desktop\DAVECode061808\dave_devel\programs\modules\TAS',filter =filter)
    print,fn
  endif
end;
