; $Id$
;###############################################################################
;+
; FUNCTION:
;   intVector2CompactString
;
; PURPOSE:
;   Converts an integer vector into a compact string representation of the range 
;   covered by the the integers.
;   For example [2,3,5,6,7,8,11,15] will be converted to '2,3,5-8,11,15' 
;
; CATEGORY:
;   Helper function used by the plot3DOptions class
;
; PARAMETERS
;   intVector - The input integer range
;   
;   str - The output compact string range
;
; KEYWORDS:
;
; RETURN VALUE:
;    1, if successful and 0 otherwise
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; May 2009
;-
;###############################################################################
function intVector2CompactString, int, str

if (n_params() ne 2) then return, 0
if (n_elements(int) le 0) then return, 0

intVector = int[sort(int)]

str = strtrim(string(intVector[0]),2)
len = n_elements(intVector)
if (len eq 1) then return, 1

putDash = 1
for i=1,len - 1 do begin
   sameAsPrevPlus1 = intVector[i] eq (intVector[i-1]+1)
   if (sameAsPrevPlus1) then begin
      if (putDash) then begin
         str += '-'
         putDash = 0
      endif
      last = i eq (len-1)
      if (last || intVector[i] ne (intVector[i+1]-1)) then begin
         str += strtrim(string(intVector[i]),2)
         putDash = 1
      endif
   endif else begin
      str = str + ',' + strtrim(string(intVector[i]),2)
      putDash = 1
   endelse
endfor

return, 1
end 
