; $Id$
;###############################################################################
;
; NAME:
;  HFBS_MAKEPOINTS
;
; PURPOSE:
;  Creates a vector of regularly spaced points.
;
; CATEGORY:
;  DAVE, HFBS, utility
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
function hfbs_makepoints,xlo = xlo,xhi = xhi,npts = npts,dx = dx
; Define the defaults
if n_elements(xlo) eq 0 then xlo = 0.0
if n_elements(xhi) eq 0 then xhi = 1.0
if n_elements(npts) eq 0 then npts = 100
dx = (xhi-xlo)/(npts-1.0)
x = xlo+dx*findgen(npts)
return,x
end