; $Id$
;###############################################################################
;+
; FUNCTION:
;   GetMainDataObjectParent
;
; PURPOSE:
;   Given an IDLitData object, the function return its absolute parent data object.
;   The returned object therefore contains oChild. It is assummed that the object 
;   is part of the iTool framework.
;
; CATEGORY:
;   Miscellaneous
;
; PARAMETERS
;   oInput - The object whose absolute parent is required
;
; KEYWORDS:
;
; RETURN VALUE:
;    If successful, the top-level parent data object which contains oChild.
;    If unsuccessful, a null object
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; December 2008
;-
;###############################################################################
function GetMainDataObjectParent, oInput
void = obj_new()
same = 0
oChild = oInput

if (~obj_valid(oChild)) then return, void

; if it is not an IDLitData object then return the object
; because the logic used here assumes the iTool Framework
if (~obj_isa(oChild, 'IDLitData')) then return, oChild


DavedmID = 'DAVE DATA MANAGER'   ; base ID for a container object residing within the DAVE Data Manager
dmID = 'DATA MANAGER'            ; similarly for the iTool Data Manager
rootID = '/'                     ; base ID for a free-standing container object

while (obj_valid(oChild)) do begin
   same = oChild eq oInput

   idChild = oChild->GetFullIdentifier()   
   isRoot = strcmp(idChild,'/')
   if (isRoot) then return, oChild

   oChild->GetProperty, _parent=oParent
   idParent = oParent->GetFullIdentifier()
   idBase = strupcase(strmid(idParent,11,/reverse_offset))   ; get the last 12 characters of the ID
   isDM = strcmp(idBase,dmID,/fold_case)         ; check whether it is equal to dmID
   idBase = strupcase(strmid(idParent,16,/reverse_offset))   ; get the last 17 characters of the ID
   isDAVEDM = strcmp(idBase,davedmID,/fold_Case) ; check if it is the same as davedmID

   if (isDM || isDaveDM) then $
      return, oChild     ; ==> the child is an absolute parent residing in one of the data managers

   oChild = oParent
endwhile

return, oChild

end