; $Id$
;###############################################################################
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;===============================================================================
; NAME:
;  DAVE_SELSYM
; PURPOSE
;  Creates a plotting symbol from a list of 10 possible symbols.
; SYNTAX:
;  ; Plot a series of filled circles that are scaled up in size
;  ; by a factor of 2.
;  PLOT,FINDGEN(10),PSYM = DAVE_SELSYM(5,SCALE = 2)
; INPUTS:
;   INDEX:	The number corresponding to the desired symbol as listed below
;   		0:	open circle
;   		1:  open triangle
;   		2:  open box
;   		3:  open diamond
;   		4:  open inverted triangle
;   		5:  filled circle
;   		6:  filled triangle
;   		7:  filled box
;   		8:  filled diamond
;   		9:  filled inverted triangle
;   Note that INDEX is cyclic so that if user specifies symbol 10, then
;   the plot will use open circles.  If user specifies symbol 11, then
;   the plot will use open triangles. etc. etc.
;
; KEYWORDS:
;   SCALE:	Size of plotting symbols.  Default is 1.
; USES:
;   dave_plotsym.PRO (this function can be found in the HFBS_UTILITIES directory)
;
;----------------
; Robert M. Dimeo
; NCNR, NIST
; May 2002
;
;===============================================================================
function dave_selsym,index,_Extra = extra
if n_elements(extra) eq 0 then scale = 1.0 else scale = extra.scale
mindex = index mod 10
case mindex of
 0: begin
    numsym = dave_plotsym(/circle,scale = scale)
    end
 1: begin
    numsym = dave_plotsym(/triangle,scale = scale)
    end
 2: begin
    numsym = dave_plotsym(/box,scale = scale)
    end
 3: begin
    numsym = dave_plotsym(/diamond,scale = scale)
    end
 4: begin
    numsym = dave_plotsym(/triangle,angle = 180.0,scale = scale)
    end
 5: begin
    numsym = dave_plotsym(/circle,/fill,scale = scale)
    end
 6: begin
    numsym = dave_plotsym(/triangle,/fill,scale = scale)
    end
 7: begin
    numsym = dave_plotsym(/box,/fill,scale = scale)
    end
 8: begin
    numsym = dave_plotsym(/diamond,/fill,scale = scale)
    end
 9: begin
    numsym = dave_plotsym(/triangle,angle = 180.0,/fill,scale = scale)
    end
endcase
return,numsym
end
