pro DAVE1Setup, error=error

error = 0
; Define useful DAVE1 global variables (defined as system variables)
davesysvars

; after call to davesysvars, !home_dir variable must be defined and pointing to the
; user's home directory. Ensure this home directory exist and the user has read abd write access.
status = file_info(!home_dir)
okay = status.directory && status.read && status.WRITE
if (~okay) then begin
  msg = 'There is a problem with your HOME directory setting.'
  msg = [msg,'The HOME directory is required for DAVE to startup properly!']
  msg = [msg,'It is currently set to: '+!home_dir]
  if (status.directory eq 0) then msg = [msg,'But it does not exist!']
  if (status.read eq 0) then msg = [msg,'You do not have read access!']
  if (status.write eq 0) then msg = [msg,'You do not have write access!']
  msg = [msg,'Please, fix  the above problems and then restart DAVE again']
  void = dialog_message(msg, title='DAVE Initialization Error!',/error)
  
  error = 1
  return
endif

; No matter what, !dave_defaults is defined in the next few lines of code.
if (file_test(!defaults_file)) then begin
    restore,!defaults_file ; restore pdd from file
    if (strcmp(vartype((*pdd).classic),'BYTE')) then begin
      ; if classic field is defined as a byte then we need to redefine
      ; the restored structure because of a bug introduced in IDL 8 
      ; which causes sav files containing a byte variable to be 
      ; incompatible and cannot be read by earlier versions of IDL.
      ; Ensure classic and show_choice fields are defined as integers and not byte
      dave_defs = {classic:1,show_choice:1}
      void = dave_defs_checkout(dave_defs)   ; define remaining fields
      
      ntags = n_tags(*pdd)
      tnames = tag_names(*pdd)
      for i=0,ntags-1 do begin
         ; copy the restored values over to the new structure
         ; except for show_choice which had previously been initialized to 255B
         ; and therefore not a meaningful value for an integer expected to be 0|1
         index = where(tag_names(dave_defs) eq tnames[i], present)
         allowed = ~strcmp(tnames[i],'SHOW_CHOICE')
         if (present && allowed) then dave_defs.(index) = (*pdd).(i)
      endfor
      
    endif else begin
      dave_defs=*pdd              
      void = dave_defs_checkout(dave_defs)
    endelse
    
    ptr_free, pdd
endif else begin
    dave_defs = {datDir:!home_dir,workDir:!home_dir,PDFReader:'', $ ; RTA -change thisDir->!home_dir as default workDir
                 web_browser:'',classic:1,show_choice:1,tree_menu_pointer:ptr_new(/allocate_heap)}
    void = dave_defs_checkout(dave_defs)
endelse

if (strlen(strtrim(dave_defs.web_browser)) eq 0) then $
  dave_defs.web_browser = locate_web_browser()

pdd = ptr_new(dave_defs)   ; Memory leak!!! Need to figure out where to cleanup!
defsysv,'!dave_defaults', pdd 

; store !dave_defaults on disk in file !defaults_file
save,filename=!defaults_file,pdd


end


;===============================================================================
; fdaveSELpdfreader
;
; PURPOSE:
;   Event handler. Let user specify a PDF Reader app. The specified
;   value is stored in a global variable and also saved for future DAVE
;   sessions.
;
; PARAMETERS:
;   event [in] - event structure.
;
pro fdaveSELpdfreader,event

dave_defs=*!dave_defaults
PDFReader=dave_defs.PDFReader
;print,"Current pdfreader is ",PDFReader

; check and then exit if reader's selected reader is okay
readerNotOkay = 'Yes'
if (strtrim(PDFReader,2) ne '') then begin
    message_text = ['Your PDF reader is currently set to:',PDFReader, $
                    'Are you sure you want to change this setting?']
    readerNotOkay = dialog_message(message_text,/question,/default_no, $
                                   title='PDF Reader Setting')
    readerBaseDir = strmid(PDFReader,0,strpos(PDFReader,!delimiter,/reverse_search))
endif
if (readerNotOkay eq 'No') then return ; nothing to do

; let user select select a reader
daveDeSensitizeButtons,event
if n_elements(event.top) gt 0 then begin
    acroread = dialog_pickfile(dialog_parent = event.top,/read, $
                               title="Please select your PDF reader", $
                               path=readerBaseDir, $
                               file = PDFReader)
endif else begin
    acroread = dialog_pickfile(/read, title="Please select your PDF reader", $
                               path=readerBaseDir, $
                               file = PDFReader)
endelse

if (acroread eq '' or acroread eq ' ') then begin
    daveSensitizeButtons,event
    return
endif
dave_defs.PDFReader=acroread
pdd=!dave_defaults
ptr_free,pdd
pdd=ptr_new(dave_defs)



    save,filename=!defaults_file,pdd


defsysv,'!dave_defaults',pdd
print,"New pdfreader is ",(*!dave_defaults).PDFReader
daveSensitizeButtons,event
return
end
;-------------------------------------------------------------------------------



;===============================================================================
; fdaveSELbrowser
;
; PURPOSE:
;   Event handler. Let user specify a web browser. The specified
;   value is stored in a global variable and also saved for future DAVE
;   sessions.
;
; PARAMETERS:
;   event [in] - event structure.
;
pro fdaveSELbrowser,event
; Added this routine: RMD, February 7, 2004
dave_defs=*!dave_defaults
web_browser = dave_defs.web_browser

; check and then exit if reader's selected browser is okay
readerNotOkay = 'Yes'
if (strtrim(web_browser,2) ne '') then begin
    message_text = ['Your web_browser reader is currently set to:',web_browser, $
                    'Are you sure you want to change this setting?']
    readerNotOkay = dialog_message(message_text,/question,/default_no, $
                                   title='Web browser Setting')
    readerBaseDir = strmid(web_browser,0,strpos(web_browser,!delimiter,/reverse_search))
endif
if (readerNotOkay eq 'No') then return ; nothing to do

; let user select select a reader
daveDeSensitizeButtons,event
if n_elements(event.top) gt 0 then begin
    browser = dialog_pickfile(dialog_parent = event.top,/read, $
                              title="Please select your web browser", $
                              path=readerBaseDir, $
                              file = web_browser)
endif else begin
    browser = dialog_pickfile(/read, title="Please select your web_browser", $
                              path=readerBaseDir, $
                              file = web_browser)
endelse

if ((browser eq '') or (browser eq ' ')) then begin
    daveSensitizeButtons,event
    return
endif
dave_defs.web_browser = browser
pdd=!dave_defaults
ptr_free,pdd
pdd=ptr_new(dave_defs)



    save,filename=!defaults_file,pdd


defsysv,'!dave_defaults',pdd
print,"New web browser is ",(*!dave_defaults).web_browser
daveSensitizeButtons,event
return
end
;-------------------------------------------------------------------------------
