; $Id$
;###############################################################################
;
;
;CLASS NAME:
;    cwo_plotrangeloglin
;
;PURPOSE:
;   A GENERAL TOOL FOR HANDLING RANGES AND LOG/LIN CHECKBOXES FOR PLOT CONTROL.
;CATEGORY:
;
;
;SUPERCLASSES:
;   NONE
;
;METHODS:
;    cwo_plotrangeloglin_set_value
;    cwo_plotrangeloglin_get_value
;    cwo_plotrangeloglin_class::getvalues
;    cwo_plotrangeloglin_class::setvalues
;    cwo_plotrangeloglin_class::updateDisplay
;    cwo_plotrangeloglin_event
;    cwo_plotrangeloglin_class::event
;    cwo_plotrangeloglin_class::getproperty
;    cwo_plotrangeloglin_class::
;    cwo_plotrangeloglin_cleanup
;    cwo_plotrangeloglin_class::cleanup
;    cwo_plotrangeloglin_class::init
;    cwo_plotrangeloglin_values__define
;    cwo_plotrangeloglin_class__define
;    cwo_plotrangeloglin
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Thu May 18 14:29:00 2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################



;###############################################################################
;
;NAME:
;        cwo_plotrangeloglin_set_value
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_plotrangeloglin_set_value,id,value
    print,'cwo_plotrangeloglin_set_value'
end;cwo_plotrangeloglin_set_value
;###############################################################################
;
;NAME:
;        cwo_plotrangeloglin_get_value
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_plotrangeloglin_get_value,id
    widget_control,widget_info(id,/child),get_uvalue=obj

    obj->getproperty,xminfield=xminfield,$
                     xmaxfield=xmaxfield,$
                     yminfield=yminfield,$
                     ymaxfield=ymaxfield,$
                     xlogcheckbox=xlogcheckbox,$
                     ylogcheckbox=ylogcheckbox

    widget_control,xminfield,get_value=xmin
    widget_control,xmaxfield,get_value=xmax
    widget_control,yminfield,get_value=ymin
    widget_control,ymaxfield,get_value=ymax
    widget_control,xlogcheckbox,get_value=xlog
    widget_control,ylogcheckbox,get_value=ylog

    cwo_plotrangeloglin_values__define,values

    values.xmin = xmin
    values.xmax = xmax
    values.ymin = ymin
    values.ymax = ymax
    values.xlog = xlog
    values.ylog = ylog

    obj->setproperty,values=values

    return,values

end;cwo_plotrangeloglin_get_value
;###############################################################################
;
;NAME:
;        cwo_plotrangeloglin_class::getvalues
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_plotrangeloglin_class::getvalues, xmin=xmin,ymin=ymin,$
                                         xmax=xmax,ymax=ymax,$
                                         xlog=xlog,ylog=ylog

    xmax = self.values.xmax
    xmin = self.values.xmin
    ymax = self.values.ymax
    ymin = self.values.ymin
    xlog = self.values.xlog
    ylog = self.values.ylog
    return,self.values

end;getvalues
;###############################################################################
;
;NAME:
;        cwo_plotrangeloglin_class::setvalues
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_plotrangeloglin_class::setvalues, xmin=xmin,ymin=ymin,$
                                    xmax=xmax,ymax=ymax,$
                                    xlog=xlog,ylog=ylog

    if n_elements(xlog) eq 1 then self.values.xlog = xlog
    if n_elements(ylog) eq 1 then self.values.ylog = ylog
    if n_elements(xmin) eq 1 then self.values.xmin = xmin
    if n_elements(xmax) eq 1 then self.values.xmax = xmax
    if n_elements(ymin) eq 1 then self.values.ymin = ymin
    if n_elements(ymax) eq 1 then self.values.ymax = ymax
    self->updateDisplay
end;setvalues
;###############################################################################
;
;NAME:
;        cwo_plotrangeloglin_class::updateDisplay
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_plotrangeloglin_class::updateDisplay

    values = self.values
    widget_control,self.xminfield,set_value=values.xmin
    widget_control,self.xmaxfield,set_value=values.xmax
    widget_control,self.yminfield,set_value=values.ymin
    widget_control,self.ymaxfield,set_value=values.ymax
    widget_control,self.xlogcheckbox,set_value=values.xlog
    widget_control,self.ylogcheckbox,set_value=values.ylog


end;updateDisplay

;###############################################################################
;
;NAME:
;        cwo_plotrangeloglin_event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_plotrangeloglin_event,event
    widget_control,widget_info(event.handler,/child),get_uvalue=obj
    event = obj->event(event)
    return,event
end;cwo_plotrangeloglin_event
;###############################################################################
;
;NAME:
;        cwo_plotrangeloglin_class::event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_plotrangeloglin_class::event,event
    print,'cwo_plotrangeloglin_class::event'
    self.values = cwo_plotrangeloglin_get_value(self.tlb)
    new_event = {id:event.handler,top:self.parent,handler:self.parent,values:self.values}
    return,new_event
end;event
;###############################################################################
;
;NAME:
;        cwo_plotrangeloglin_class::getproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_plotrangeloglin_class::getproperty,  tlb=tlb,$
                                        xminfield=xminfield,$
                                        xmaxfield=xmaxfield,$
                                        yminfield=yminfield,$
                                        ymaxfield=ymaxfield,$
                                        xlogcheckbox=xlogcheckbox,$
                                        ylogcheckbox=ylogcheckbox,$
                                        _Extra=extra

    if arg_present(tlb) ne 0 then tlb = self.tlb

    if arg_present(xminfield) ne 0 then xminfield = self.xminfield
    if arg_present(xmaxfield) ne 0 then xmaxfield = self.xmaxfield
    if arg_present(yminfield) ne 0 then yminfield = self.yminfield
    if arg_present(ymaxfield) ne 0 then ymaxfield = self.ymaxfield
    if arg_present(xlogcheckbox) ne 0 then xlogcheckbox = self.xlogcheckbox
    if arg_present(ylogcheckbox) ne 0 then ylogcheckbox = self.ylogcheckbox


end;getproperty
;###############################################################################
;
;NAME:
;        cwo_plotrangeloglin_class::
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_plotrangeloglin_class:: setproperty,  tlb=tlb,$
                                        xminfield=xminfield,$
                                        xmaxfield=xmaxfield,$
                                        yminfield=yminfield,$
                                        ymaxfield=ymaxfield,$
                                        xlogcheckbox=xlogcheckbox,$
                                        ylogcheckbox=ylogcheckbox,$
                                        _Extra=extra


    if n_elements(tlb) ne 0 then self.tlb = tlb
    if n_elements(xminfield) ne 0 then self.xminfield = xminfield
    if n_elements(xmaxfield) ne 0 then self.xmaxfield = xmaxfield
    if n_elements(yminfield) ne 0 then self.yminfield = yminfield
    if n_elements(ymaxfield) ne 0 then self.ymaxfield = ymaxfield

    if n_elements(xlogcheckbox) ne 0 then self.xlogcheckbox = xlogcheckbox
    if n_elements(ylogcheckbox) ne 0 then self.ylogcheckbox = ylogcheckbox

end;getproperty

;###############################################################################
;
;NAME:
;        cwo_plotrangeloglin_cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_plotrangeloglin_cleanup,id
    widget_control,id,get_uvalue=obj
    obj_destroy,obj
end;cwo_plotrangeloglin_cleanup
;###############################################################################
;
;NAME:
;        cwo_plotrangeloglin_class::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_plotrangeloglin_class::cleanup
    print,'cwo_plotrangeloglin_class::cleanup'

end;cwo_plotrangeloglin_class::cleanup

;###############################################################################
;
;NAME:
;        cwo_plotrangeloglin_class::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_plotrangeloglin_class::init,parent,row=row,column=column,$
                                          xmin=xmin,ymin=ymin,$
                                          xmax=xmax,ymax=ymax,$
                                          xlog=xlog,ylog=ylog,$
                                          xoffset=xoffset,yoffset=yoffset,$
                                          frame=frame,$
                                          title=title,$
                                          nolog=nolog,$
                                          xunits=xunits,$
                                          yunits=yunits,$
                                          xlabel=xlabel,$
                                          ylabel=ylabel


    if n_elements(xmin) eq 0 then xmin = 0.0
    if n_elements(xmax) eq 0 then xmax = 1.0
    if n_elements(ymin) eq 0 then ymin = 0.0
    if n_elements(ymax) eq 0 then ymax = 1.0
    if n_elements(xlog) eq 0 then xlog = 0
    if n_elements(ylog) eq 0 then ylog = 0
    if n_elements(title) eq 0 then title = ''
    if n_elements(frame) eq 0 then frame = 0
    if n_elements(nolog) eq 0 then nolog = 0

    if n_elements(xunits) eq 0 then xunits = ''
    if n_elements(yunits) eq 0 then yunits = ''
    if n_elements(xlabel) eq 0 then xlabel = 'x'
    if n_elements(ylabel) eq 0 then ylabel = 'y'




    if n_elements(row)    eq 0 then row   = 0
    if n_elements(column) eq 0 then column= 0
    if column eq 0 and row eq 0 then column = 1

    self.parent = parent

    self.tlb = widget_base(parent,$;column=column,row=row,$
                                  frame=frame,$
                                  event_func='cwo_plotrangeloglin_event',$
                                  pro_set_value='cwo_plotrangeloglin_set_value',$
                                  func_get_value='cwo_plotrangeloglin_get_value',$
                                  uvalue=uvalue,uname=uname,kill_notify=kill_notify,$
                                  xoffset=xoffset,yoffset=yoffset)



    if title eq '' then begin
        yoffsetzero = 1
        label = widget_label(self.tlb,value=title,$
                                    kill_notify='cwo_plotrangeloglin_cleanup',$
                                    uvalue=self,scr_ysize=1,scr_xsize=1)
    endif else begin
        yoffsetzero = 27
        label = widget_label(self.tlb,value=title,$
                                    kill_notify='cwo_plotrangeloglin_cleanup',$
                                    uvalue=self)
    endelse


    row1 = widget_base(self.tlb,/row,$
                            xoffset=0,yoffset=yoffsetzero)
    self.xminfield = cw_field(row1,title=xlabel+'min'+'['+xunits+']',xsize=9,$
                                        /floating,value=xmin,$
                                        /return_events)
    self.xmaxfield = cw_field(row1,title=xlabel+'max'+'['+xunits+']',xsize=9,$
                                        /floating,value=xmax,$
                                        /return_events)
    row2 = widget_base(self.tlb,/row,xoffset=0,yoffset=27+yoffsetzero)
    self.yminfield = cw_field(row2,title=ylabel+'min'+'['+yunits+']',xsize=9,/floating,$
                                        value=ymin,$
                                        /return_events)
    self.ymaxfield = cw_field(row2,title=ylabel+'max'+'['+yunits+']',xsize=9,/floating,$
                                        value=ymax,$
                                        /return_events)

    if nolog eq 0 then begin
        row3offset = (!version.os eq 'Win32') ? 47 : 67
        row3 = widget_base(self.tlb,/row,xoffset=0,yoffset=row3offset+yoffsetzero)
    endif else begin
        ;CREATE UNREALIZED BASE SO THE WIDGETS ARE STILL AVAILABLE
        ;FOR PROGRAM BUT NOT THE USER.
        row3 = widget_base(/row,xoffset=0,yoffset=47+yoffsetzero)
    endelse

        self.xlogcheckbox = cw_bgroup(row3,'x log',/nonexclusive,/col)
        self.ylogcheckbox = cw_bgroup(row3,'y log',/nonexclusive,/col)

    return,1
end;init

;###############################################################################
;
;NAME:
;        cwo_plotrangeloglin_values__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_plotrangeloglin_values__define,struct

    struct = {cwo_plotrangeloglin_values,$
                xmin:0.0d,$
                xmax:0.0d,$
                ymin:0.0d,$
                ymax:0.0d,$
                xlog:0,$
                ylog:0}

end;cwo_plotrangeloglin_values

;###############################################################################
;
;NAME:
;        cwo_plotrangeloglin_class__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_plotrangeloglin_class__define,class

    cwo_plotrangeloglin_values__define,values

    class = {cwo_plotrangeloglin_class,$
                parent:0L,$
                tlb:0L,$
                xminfield:0L,$
                xmaxfield:0L,$
                yminfield:0L,$
                ymaxfield:0L,$
                xlogcheckbox:0L,$
                ylogcheckbox:0L,$
                values:values,$
                xunits:'',$
                yunits:'',$
                xlabel:'',$
                ylabel:''}

end;cwo_plotrangeloglin_class__define

;###############################################################################
;
;NAME:
;        cwo_plotrangeloglin
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_plotrangeloglin,parent,$
                             obj=obj,$
                             row=row,$
                             column=column,$
                             xoffset=xoffset,$
                             yoffset=yoffset,$
                             frame=frame,$
                             title=title,$
                             nolog=nolog,$
                             xunits=xunits,$
                             yunits=yunits,$
                             xlabel=xlabel,$
                             ylabel=ylabel,$
                             _Extra=extra

    if n_elements(parent) eq 1 then begin

        obj = obj_new('cwo_plotrangeloglin_class',parent,row=row,column=column,$
                                            xoffset=xoffset,yoffset=yoffset,$
                                            frame=frame,title=title,nolog=nolog,$
                                            xunits=xunits,$
                                            yunits=yunits,$
                                            xlabel=xlabel,$
                                            ylabel=ylabel)
        obj->getproperty,tlb=tlb
        return,tlb
    endif else begin
        print,'parent NOT SPECIFIED FOR cwo_plotrangeloglin'
        return,0L
    endelse

end;cwo_plotrangeloglin
