; $Id$
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
function convert_bmp,filename
if n_params() eq 0 then filename = 'c:\rsi\idl56\resource\bitmaps\hscn.bmp'
x = read_bmp(filename,r,g,b)
xsize = size(x)
if xsize[1] eq 16 and xsize[2] eq 16 then xred = x else $
	xred = congrid(x,16,16)
array = reform([[r[xred]],[g[xred]],[b[xred]]],16,16,3)
return,array
end
