; $Id$
;###############################################################################
;+
; FUNCTION:
;   compactString2IntVector
;
; PURPOSE:
;   Converts a range of integers specified as a compact string to an integer vector.
;   For example '2,3,5-8,11,15' will be converted to [2,3,5,6,7,8,11,15]
;
; CATEGORY:
;   Helper function used by the plot3DOptions class
;
; PARAMETERS
;   str - The input string range
;   
;   intVector - The output integer vector
;
; KEYWORDS:
;
; RETURN VALUE:
;    1, if successful and 0 otherwise
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; May 2009
;-
;###############################################################################
function compactString2IntVector, str, intVector

if (n_params() ne 2) then return, 0
if (n_elements(str) ne 1) then return, 0

tokens = strsplit(str,',',/extract)
ntok = (size(tokens))[1]
intVector = -1
index = 0

for j = 0,ntok-1 do begin
    tok1 = strsplit(tokens[j],'-',/extract)
    if ((size(tok1))[1] eq 1) then begin
        i = fix(tok1[0])
        res = where(intVector eq i, isNotaNewValue)
        if (isNotaNewValue) then continue
        intVector = (index eq 0)? i : [intVector,i]
        index = index + 1
    endif else begin
        for i = fix(tok1[0]),fix(tok1[1]) do begin
            res = where(intVector eq i, isNotaNewValue)
            if (isNotaNewValue) then continue
            intVector = (index eq 0)? i : [intVector,i]
            index = index + 1
        endfor
    endelse       
endfor

return, 1
end

