/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.icon.EmptyIcon;
import org.jdesktop.swingx.plaf.TaskPaneUI;

public class BasicTaskPaneUI
extends TaskPaneUI {
    private static FocusListener focusListener = new RepaintOnFocus();
    protected static int TITLE_HEIGHT = 25;
    protected static int ROUND_HEIGHT = 5;
    protected JXTaskPane group;
    protected boolean mouseOver;
    protected MouseInputListener mouseListener;
    protected PropertyChangeListener propertyListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTaskPaneUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.group = (JXTaskPane)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        this.group.setOpaque(true);
        this.group.setBorder(this.createPaneBorder());
        ((JComponent)this.group.getContentPane()).setBorder(this.createContentPaneBorder());
        LookAndFeel.installColorsAndFont(this.group, "TaskPane.background", "TaskPane.foreground", "TaskPane.font");
        LookAndFeel.installColorsAndFont((JComponent)this.group.getContentPane(), "TaskPane.background", "TaskPane.foreground", "TaskPane.font");
    }

    protected void installListeners() {
        this.mouseListener = this.createMouseInputListener();
        this.group.addMouseMotionListener(this.mouseListener);
        this.group.addMouseListener(this.mouseListener);
        this.group.addFocusListener(focusListener);
        this.propertyListener = this.createPropertyListener();
        this.group.addPropertyChangeListener(this.propertyListener);
    }

    protected void installKeyboardActions() {
        ActionMap actionMap;
        InputMap inputMap = (InputMap)UIManager.get("TaskPane.focusInputMap");
        if (inputMap != null) {
            SwingUtilities.replaceUIInputMap(this.group, 0, inputMap);
        }
        if ((actionMap = this.getActionMap()) != null) {
            SwingUtilities.replaceUIActionMap(this.group, actionMap);
        }
    }

    ActionMap getActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("toggleExpanded", new ToggleExpandedAction());
        return actionMapUIResource;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        super.uninstallUI(jComponent);
    }

    protected void uninstallListeners() {
        this.group.removeMouseListener(this.mouseListener);
        this.group.removeMouseMotionListener(this.mouseListener);
        this.group.removeFocusListener(focusListener);
        this.group.removePropertyChangeListener(this.propertyListener);
    }

    protected MouseInputListener createMouseInputListener() {
        return new ToggleListener();
    }

    protected PropertyChangeListener createPropertyListener() {
        return new ChangeListener();
    }

    protected boolean isInBorder(MouseEvent mouseEvent) {
        return mouseEvent.getY() < this.getTitleHeight();
    }

    protected final int getTitleHeight() {
        return TITLE_HEIGHT;
    }

    protected Border createPaneBorder() {
        return new PaneBorder();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Component component = this.group.getComponent(0);
        if (!(component instanceof JXCollapsiblePane)) {
            return super.getPreferredSize(jComponent);
        }
        JXCollapsiblePane jXCollapsiblePane = (JXCollapsiblePane)component;
        Dimension dimension = jXCollapsiblePane.getPreferredSize();
        Border border = this.group.getBorder();
        if (border instanceof PaneBorder) {
            Dimension dimension2 = ((PaneBorder)border).getPreferredSize(this.group);
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height += dimension2.height;
        } else {
            dimension.height += this.getTitleHeight();
        }
        return dimension;
    }

    protected Border createContentPaneBorder() {
        Color color = UIManager.getColor("TaskPane.borderColor");
        return new CompoundBorder(new ContentPaneBorder(color), BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    public Component createAction(Action action) {
        JXHyperlink jXHyperlink = new JXHyperlink(action);
        jXHyperlink.setOpaque(false);
        jXHyperlink.setBorder(null);
        jXHyperlink.setBorderPainted(false);
        jXHyperlink.setFocusPainted(true);
        jXHyperlink.setForeground(UIManager.getColor("TaskPane.titleForeground"));
        return jXHyperlink;
    }

    protected void ensureVisible() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BasicTaskPaneUI.this.group.scrollRectToVisible(new Rectangle(BasicTaskPaneUI.this.group.getWidth(), BasicTaskPaneUI.this.group.getHeight()));
            }
        });
    }

    protected class PaneBorder
    implements Border {
        protected Color borderColor = UIManager.getColor("TaskPane.borderColor");
        protected Color titleForeground = UIManager.getColor("TaskPane.titleForeground");
        protected Color specialTitleBackground = UIManager.getColor("TaskPane.specialTitleBackground");
        protected Color specialTitleForeground = UIManager.getColor("TaskPane.specialTitleForeground");
        protected Color titleBackgroundGradientStart = UIManager.getColor("TaskPane.titleBackgroundGradientStart");
        protected Color titleBackgroundGradientEnd = UIManager.getColor("TaskPane.titleBackgroundGradientEnd");
        protected Color titleOver = UIManager.getColor("TaskPane.titleOver");
        protected Color specialTitleOver;
        protected JLabel label;

        public PaneBorder() {
            if (this.titleOver == null) {
                this.titleOver = this.specialTitleBackground.brighter();
            }
            this.specialTitleOver = UIManager.getColor("TaskPane.specialTitleOver");
            if (this.specialTitleOver == null) {
                this.specialTitleOver = this.specialTitleBackground.brighter();
            }
            this.label = new JLabel();
            this.label.setOpaque(false);
            this.label.setIconTextGap(8);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(BasicTaskPaneUI.this.getTitleHeight(), 0, 0, 0);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Dimension getPreferredSize(JXTaskPane jXTaskPane) {
            this.configureLabel(jXTaskPane);
            Dimension dimension = this.label.getPreferredSize();
            dimension.width += 3;
            dimension.width += TITLE_HEIGHT;
            dimension.width += 3;
            dimension.height = BasicTaskPaneUI.this.getTitleHeight();
            return dimension;
        }

        protected void paintTitleBackground(JXTaskPane jXTaskPane, Graphics graphics) {
            if (jXTaskPane.isSpecial()) {
                graphics.setColor(this.specialTitleBackground);
            } else {
                graphics.setColor(this.titleBackgroundGradientStart);
            }
            graphics.fillRect(0, 0, jXTaskPane.getWidth(), BasicTaskPaneUI.this.getTitleHeight() - 1);
        }

        protected void paintTitle(JXTaskPane jXTaskPane, Graphics graphics, Color color, int n, int n2, int n3, int n4) {
            this.configureLabel(jXTaskPane);
            this.label.setForeground(color);
            graphics.translate(n, n2);
            this.label.setBounds(0, 0, n3, n4);
            this.label.paint(graphics);
            graphics.translate(-n, -n2);
        }

        protected void configureLabel(JXTaskPane jXTaskPane) {
            this.label.applyComponentOrientation(jXTaskPane.getComponentOrientation());
            this.label.setFont(jXTaskPane.getFont());
            this.label.setText(jXTaskPane.getTitle());
            this.label.setIcon(jXTaskPane.getIcon() == null ? new EmptyIcon() : jXTaskPane.getIcon());
        }

        protected void paintExpandedControls(JXTaskPane jXTaskPane, Graphics graphics, int n, int n2, int n3, int n4) {
        }

        protected Color getPaintColor(JXTaskPane jXTaskPane) {
            Color color = this.isMouseOverBorder() ? (BasicTaskPaneUI.this.mouseOver ? (jXTaskPane.isSpecial() ? this.specialTitleOver : this.titleOver) : (jXTaskPane.isSpecial() ? this.specialTitleForeground : this.titleForeground)) : (jXTaskPane.isSpecial() ? this.specialTitleForeground : this.titleForeground);
            return color;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JXTaskPane jXTaskPane = (JXTaskPane)component;
            int n5 = TITLE_HEIGHT - 2 * ROUND_HEIGHT;
            int n6 = jXTaskPane.getWidth() - TITLE_HEIGHT;
            int n7 = ROUND_HEIGHT - 1;
            int n8 = 3;
            int n9 = 0;
            int n10 = jXTaskPane.getWidth() - BasicTaskPaneUI.this.getTitleHeight() - 3;
            int n11 = BasicTaskPaneUI.this.getTitleHeight();
            if (!jXTaskPane.getComponentOrientation().isLeftToRight()) {
                n6 = jXTaskPane.getWidth() - n6 - n5;
                n8 = jXTaskPane.getWidth() - n8 - n10;
            }
            this.paintTitleBackground(jXTaskPane, graphics);
            this.paintExpandedControls(jXTaskPane, graphics, n6, n7, n5, n5);
            Color color = this.getPaintColor(jXTaskPane);
            if (jXTaskPane.hasFocus()) {
                this.paintFocus(graphics, color, 3, 3, n3 - 6, BasicTaskPaneUI.this.getTitleHeight() - 6);
            }
            this.paintTitle(jXTaskPane, graphics, color, n8, n9, n10, n11);
        }

        protected void paintRectAroundControls(JXTaskPane jXTaskPane, Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2) {
            if (BasicTaskPaneUI.this.mouseOver) {
                int n5 = n + n3;
                int n6 = n2 + n4;
                graphics.setColor(color);
                graphics.drawLine(n, n2, n5, n2);
                graphics.drawLine(n, n2, n, n6);
                graphics.setColor(color2);
                graphics.drawLine(n5, n2, n5, n6);
                graphics.drawLine(n, n6, n5, n6);
            }
        }

        protected void paintOvalAroundControls(JXTaskPane jXTaskPane, Graphics graphics, int n, int n2, int n3, int n4) {
            if (jXTaskPane.isSpecial()) {
                graphics.setColor(this.specialTitleBackground.brighter());
                graphics.drawOval(n, n2, n3, n4);
            } else {
                graphics.setColor(this.titleBackgroundGradientStart);
                graphics.fillOval(n, n2, n3, n4);
                graphics.setColor(this.titleBackgroundGradientEnd.darker());
                graphics.drawOval(n, n2, n3, n3);
            }
        }

        protected void paintChevronControls(JXTaskPane jXTaskPane, Graphics graphics, int n, int n2, int n3, int n4) {
            ChevronIcon chevronIcon = jXTaskPane.isExpanded() ? new ChevronIcon(true) : new ChevronIcon(false);
            int n5 = n + n3 / 2 - chevronIcon.getIconWidth() / 2;
            int n6 = n2 + (n4 / 2 - chevronIcon.getIconHeight());
            chevronIcon.paintIcon(jXTaskPane, graphics, n5, n6);
            chevronIcon.paintIcon(jXTaskPane, graphics, n5, n6 + chevronIcon.getIconHeight() + 1);
        }

        protected void paintFocus(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
            graphics.setColor(color);
            BasicGraphicsUtils.drawDashedRect(graphics, n, n2, n3, n4);
        }

        protected boolean isMouseOverBorder() {
            return false;
        }
    }

    protected static class ContentPaneBorder
    implements Border {
        Color color;

        public ContentPaneBorder(Color color) {
            this.color = color;
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 1, 1, 1);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(this.color);
            graphics.drawLine(n, n2, n, n2 + n4 - 1);
            graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        }
    }

    protected static class ChevronIcon
    implements Icon {
        boolean up = true;

        public ChevronIcon(boolean bl) {
            this.up = bl;
        }

        public int getIconHeight() {
            return 3;
        }

        public int getIconWidth() {
            return 6;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.up) {
                graphics.drawLine(n + 3, n2, n, n2 + 3);
                graphics.drawLine(n + 3, n2, n + 6, n2 + 3);
            } else {
                graphics.drawLine(n, n2, n + 3, n2 + 3);
                graphics.drawLine(n + 3, n2 + 3, n + 6, n2);
            }
        }
    }

    class ToggleExpandedAction
    extends AbstractAction {
        public ToggleExpandedAction() {
            super("toggleExpanded");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicTaskPaneUI.this.group.setExpanded(!BasicTaskPaneUI.this.group.isExpanded());
        }

        public boolean isEnabled() {
            return BasicTaskPaneUI.this.group.isVisible();
        }
    }

    class ToggleListener
    extends MouseInputAdapter {
        ToggleListener() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (BasicTaskPaneUI.this.isInBorder(mouseEvent)) {
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            } else {
                BasicTaskPaneUI.this.mouseOver = false;
                BasicTaskPaneUI.this.group.repaint();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
            BasicTaskPaneUI.this.mouseOver = false;
            BasicTaskPaneUI.this.group.repaint();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (BasicTaskPaneUI.this.isInBorder(mouseEvent)) {
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                BasicTaskPaneUI.this.mouseOver = true;
                BasicTaskPaneUI.this.group.repaint();
            } else {
                mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
                BasicTaskPaneUI.this.mouseOver = false;
                BasicTaskPaneUI.this.group.repaint();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (BasicTaskPaneUI.this.isInBorder(mouseEvent)) {
                BasicTaskPaneUI.this.group.setExpanded(!BasicTaskPaneUI.this.group.isExpanded());
            }
        }
    }

    class ChangeListener
    implements PropertyChangeListener {
        ChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (("expanded".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue()) && !BasicTaskPaneUI.this.group.isAnimated() || "animationState".equals(propertyChangeEvent.getPropertyName()) && "expanded".equals(propertyChangeEvent.getNewValue())) && BasicTaskPaneUI.this.group.isScrollOnExpand()) {
                BasicTaskPaneUI.this.ensureVisible();
            }
        }
    }

    static class RepaintOnFocus
    implements FocusListener {
        RepaintOnFocus() {
        }

        public void focusGained(FocusEvent focusEvent) {
            focusEvent.getComponent().repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            focusEvent.getComponent().repaint();
        }
    }
}

